/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.io.ConsoleKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.runner.Classpath;
import org.jetbrains.kotlin.runner.ExpressionRunner;
import org.jetbrains.kotlin.runner.JarRunner;
import org.jetbrains.kotlin.runner.MainClassRunner;
import org.jetbrains.kotlin.runner.ReplRunner;
import org.jetbrains.kotlin.runner.Runner;
import org.jetbrains.kotlin.runner.RunnerException;
import org.jetbrains.kotlin.runner.ScriptRunner;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u001d\u0004)!Q*Y5o\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'B\u0002:v]:,'OC\u0002B]fT1bS(U\u0019&su\fS(N\u000b*!a)\u001b7f\u0015\u0011Q\u0017M^1\u000b\u0005%|'\u0002B7bS:TA!\u0019:hg*)\u0011I\u001d:bs*11\u000b\u001e:j]\u001eTA!\u00168ji*!A.\u00198h\u0015E\u0001(/\u001b8u+N\fw-Z!oI\u0016C\u0018\u000e\u001e\u0006\u0014aJLg\u000e\u001e,feNLwN\\!oI\u0016C\u0018\u000e\u001e\u0006\u0004eVtgM\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0007\u0011\r\u0001\u0002\u0001\u0007\u0001\u000b\u0005A\u0019!B\u0002\u0005\u0006!\u0015A\u0002A\u0003\u0002\u0011\u0011)!\u0001b\u0002\t\n\u0015\u0019A\u0001\u0002E\u0004\u0019\u0001)!\u0001\u0002\u0003\t\b\u0015\u0019AQ\u0001\u0005\u0007\u0019\u0001)1\u0001\"\u0002\t\u000e1\u0001Qa\u0001C\u0003\u0011\u001da\u0001!\u0002\u0002\u0005\b!=QA\u0001\u0003\b\u0011\u001b!1-\u0001\u0007\u00033\r)\u0011\u0001C\u0002\u0019\u00075bA!\u0019\u0003\u0019\u0007\u0005\u001aQ!\u0001E\u00051\u0013)6\u0001B\u0003\u0004\t\rI\u0011\u0001C\u0003.7\u0011\u001d\u0001$BO\r\t\u0001AY!\u0004\u0005\u0006\u0003!-\u0011\u0002B\u0005\u0004\u000b\u0005Aa\u0001\u0007\u0004\u0019\fA\u001b\u0001!I\u0002\u0006\u0003!5\u0001TB)\u0004\r\u0011)\u0011\"\u0001\u0003\u0001\u001b\tAy\u0001$\u0001.\u0016\u0011\t\u0001\u0004C\u0011\u0004\u000b\u0005Ai\u0001'\u0004R\u0007\r!\u0001\"C\u0001\u0005\u00015VA!\u0001M\tC\r)\u0011\u0001#\u0004\u0019\u000eE\u001b1\u0001\"\u0005\n\u0003\u0011\u0001Qf\u0007\u0003\u00021%iJ\u0002\u0002\u0001\t\f5AQ!\u0001E\u0006\u0013\u0011I1!B\u0001\t\ra1\u00014\u0002)\u0004\u0001\u0005\u001aQ!\u0001E\u00071\u001b\t6A\u0002\u0003\n\u0013\u0005!\u0001!\u0004\u0002\t\u00101\u0005Q\u0007\u0001"})
public final class Main {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final File KOTLIN_HOME;
    public static final Main INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(Main.class);
        new Main();
    }

    private final void run(String[] args) {
        Object i;
        Classpath classpath = new Classpath();
        Runner runner = null;
        boolean collectingArguments = false;
        ArrayList<String> arguments = CollectionsKt.arrayListOf(new String[0]);
        classpath.add(".");
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        while (i.element < ((Object[])args).length) {
            String arg = args[i.element];
            if (collectingArguments) {
                arguments.add(arg);
                int n = i.element++;
                continue;
            }
            Function0<String> next$ = new Function0<String>((Ref.IntRef)i, args, arg){
                final /* synthetic */ Ref.IntRef $i;
                final /* synthetic */ String[] $args;
                final /* synthetic */ String $arg;

                @NotNull
                public final String invoke() {
                    Ref.IntRef intRef = this.$i;
                    ++intRef.element;
                    if (intRef.element == ((Object[])this.$args).length) {
                        throw (Throwable)new RunnerException("argument expected to " + this.$arg);
                    }
                    return this.$args[this.$i.element];
                }
                {
                    this.$i = intRef;
                    this.$args = stringArray;
                    this.$arg = string;
                    super(0);
                }
            };
            if (Intrinsics.areEqual("-help", arg) || Intrinsics.areEqual("-h", arg)) {
                this.printUsageAndExit();
            } else if (Intrinsics.areEqual("-version", arg)) {
                this.printVersionAndExit();
            } else if (Intrinsics.areEqual("-classpath", arg) || Intrinsics.areEqual("-cp", arg)) {
                classpath.add((String)next$.invoke());
            } else if (Intrinsics.areEqual("-expression", arg) || Intrinsics.areEqual("-e", arg)) {
                runner = new ExpressionRunner((String)next$.invoke());
                collectingArguments = true;
            } else {
                if (StringsKt.startsWith$default(arg, "-", false, 2)) {
                    throw (Throwable)new RunnerException("unsupported argument: " + arg);
                }
                if (StringsKt.endsWith$default(arg, ".jar", false, 2)) {
                    runner = new JarRunner(arg);
                    collectingArguments = true;
                } else if (StringsKt.endsWith$default(arg, ".kts", false, 2)) {
                    runner = new ScriptRunner(arg);
                    collectingArguments = true;
                } else {
                    runner = new MainClassRunner(arg);
                    collectingArguments = true;
                }
            }
            int n = i.element++;
        }
        classpath.add(KOTLIN_HOME.toString() + "/lib/kotlin-runtime.jar");
        classpath.add(KOTLIN_HOME.toString() + "/lib/kotlin-reflect.jar");
        if (runner == null) {
            runner = new ReplRunner();
        }
        runner.run(classpath, (List<? extends String>)arguments);
        i = null;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        try {
            INSTANCE$.run(args);
        }
        catch (RunnerException e) {
            System.err.println("error: " + e.getMessage());
            System.exit(1);
        }
    }

    private final void printUsageAndExit() {
        ConsoleKt.println("kotlin: run Kotlin programs, scripts or REPL.\n\nUsage: kotlin <options> <command> <arguments>\nwhere command may be one of:\n  foo.Bar                    Runs the 'main' function from the class with the given qualified name\n  app.jar                    Runs the given JAR file as 'java -jar' would do\n                             (-classpath argument is ignored and no Kotlin runtime is added to the classpath)\n" + "and possible options include:\n  -classpath (-cp) <path>    Paths where to find user class files\n  -Dname=value               Set a system JVM property\n  -J<option>                 Pass an option directly to JVM\n  -version                   Display Kotlin version\n  -help (-h)                 Print a synopsis of options\n");
        System.exit(0);
    }

    private final void printVersionAndExit() {
        String string;
        try {
            string = new Scanner(new File(KOTLIN_HOME, "build.txt")).nextLine();
        }
        catch (FileNotFoundException e) {
            throw (Throwable)new RunnerException("no build.txt was found at home=" + KOTLIN_HOME);
        }
        String version = string;
        ConsoleKt.println("Kotlin version " + version + " (JRE " + System.getProperty("java.runtime.version") + ")");
        System.exit(0);
    }

    Main() {
        INSTANCE$ = this;
        String home = System.getProperty("kotlin.home");
        if (home == null) {
            System.err.println("error: no kotlin.home system property was passed");
            System.exit(1);
        }
        KOTLIN_HOME = new File(home);
    }
}

