/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public class MissingForBodyFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        String braces;
        PsiForStatement forStatement = MissingForBodyFixer.getForStatementParent(psiElement);
        if (forStatement == null) {
            return;
        }
        Document doc = editor.getDocument();
        PsiStatement body = forStatement.getBody();
        if (body instanceof PsiBlockStatement) {
            return;
        }
        if (body != null && MissingForBodyFixer.startLine(doc, (PsiElement)body) == MissingForBodyFixer.startLine(doc, (PsiElement)forStatement)) {
            return;
        }
        PsiJavaToken eltToInsertAfter = forStatement.getRParenth();
        String text = braces = "{\n}";
        if (eltToInsertAfter == null) {
            eltToInsertAfter = forStatement;
            text = ")" + text;
        }
        int offset = eltToInsertAfter.getTextRange().getEndOffset();
        doc.insertString(offset, (CharSequence)text);
        editor.getCaretModel().moveToOffset(offset + text.length() - braces.length());
    }

    @Nullable
    private static PsiForStatement getForStatementParent(PsiElement psiElement) {
        PsiForStatement statement = (PsiForStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiForStatement.class);
        if (statement == null) {
            return null;
        }
        PsiStatement init = statement.getInitialization();
        PsiStatement update = statement.getUpdate();
        PsiExpression check = statement.getCondition();
        return MissingForBodyFixer.isValidChild((PsiElement)init, psiElement) || MissingForBodyFixer.isValidChild((PsiElement)update, psiElement) || MissingForBodyFixer.isValidChild((PsiElement)check, psiElement) ? statement : null;
    }

    private static boolean isValidChild(PsiElement ancestor, PsiElement psiElement) {
        if (ancestor != null && PsiTreeUtil.isAncestor((PsiElement)ancestor, (PsiElement)psiElement, (boolean)false)) {
            return !PsiTreeUtil.hasErrorElements((PsiElement)ancestor);
        }
        return false;
    }

    private static int startLine(Document doc, PsiElement psiElement) {
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

