/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.ElementSignatureProvider;
import com.intellij.codeInsight.folding.impl.GenericElementSignatureProvider;
import com.intellij.lang.Language;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingPolicy {
    private static final GenericElementSignatureProvider GENERIC_PROVIDER = new GenericElementSignatureProvider();

    private FoldingPolicy() {
    }

    public static boolean isCollapseByDefault(PsiElement element) {
        Language lang = element.getLanguage();
        FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(lang);
        return foldingBuilder != null && foldingBuilder.isCollapsedByDefault(element.getNode());
    }

    @Nullable
    public static String getSignature(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/folding/impl/FoldingPolicy", "getSignature"));
        }
        for (ElementSignatureProvider provider : (ElementSignatureProvider[])Extensions.getExtensions(ElementSignatureProvider.EP_NAME)) {
            String signature = provider.getSignature(element);
            if (signature == null) continue;
            return signature;
        }
        return GENERIC_PROVIDER.getSignature(element);
    }

    @Nullable
    public static PsiElement restoreBySignature(@NotNull PsiFile file, @NotNull String signature) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/folding/impl/FoldingPolicy", "restoreBySignature"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/codeInsight/folding/impl/FoldingPolicy", "restoreBySignature"));
        }
        return FoldingPolicy.restoreBySignature(file, signature, null);
    }

    @Nullable
    public static PsiElement restoreBySignature(@NotNull PsiFile file, @NotNull String signature, @Nullable StringBuilder processingInfoStorage) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/folding/impl/FoldingPolicy", "restoreBySignature"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/codeInsight/folding/impl/FoldingPolicy", "restoreBySignature"));
        }
        for (ElementSignatureProvider provider : (ElementSignatureProvider[])Extensions.getExtensions(ElementSignatureProvider.EP_NAME)) {
            PsiElement result = provider.restoreBySignature(file, signature, processingInfoStorage);
            if (result == null) continue;
            return result;
        }
        return GENERIC_PROVIDER.restoreBySignature(file, signature, processingInfoStorage);
    }
}

