/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.ElementLocationUtil;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ImplementationTextSelectioner;
import com.intellij.codeInsight.hint.LanguageImplementationTextSelectioner;
import com.intellij.find.FindUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.usages.UsageView;
import com.intellij.util.DocumentUtil;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplementationViewComponent
extends JPanel {
    @NonNls
    private static final String TEXT_PAGE_KEY = "Text";
    @NonNls
    private static final String BINARY_PAGE_KEY = "Binary";
    private static final Logger LOG = Logger.getInstance((String)("#" + ImplementationViewComponent.class.getName()));
    private PsiElement[] myElements;
    private int myIndex;
    private final Editor myEditor;
    private final JPanel myViewingPanel;
    private final JLabel myLocationLabel;
    private final JLabel myCountLabel;
    private final CardLayout myBinarySwitch;
    private final JPanel myBinaryPanel;
    private ComboBox myFileChooser;
    private FileEditor myNonTextEditor;
    private FileEditorProvider myCurrentNonTextEditorProvider;
    private JBPopup myHint;
    private String myTitle;
    private final ActionToolbar myToolbar;
    private JLabel myLabel;

    public void setHint(JBPopup hint, @NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/codeInsight/hint/ImplementationViewComponent", "setHint"));
        }
        this.myHint = hint;
        this.myTitle = title;
    }

    public boolean hasElementsToShow() {
        return this.myElements != null && this.myElements.length > 0;
    }

    public ImplementationViewComponent(PsiElement[] elements, final int index) {
        super(new BorderLayout());
        final Project project = elements.length > 0 ? elements[0].getProject() : null;
        EditorFactory factory = EditorFactory.getInstance();
        Document doc = factory.createDocument((CharSequence)"");
        doc.setReadOnly(true);
        this.myEditor = factory.createEditor(doc, project);
        ((EditorEx)this.myEditor).setBackgroundColor(EditorFragmentComponent.getBackgroundColor(this.myEditor));
        EditorSettings settings = this.myEditor.getSettings();
        settings.setAdditionalLinesCount(1);
        settings.setAdditionalColumnsCount(1);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setLineNumbersShown(false);
        settings.setFoldingOutlineShown(false);
        this.myBinarySwitch = new CardLayout();
        this.myViewingPanel = new JPanel(this.myBinarySwitch);
        this.myEditor.setBorder(null);
        ((EditorEx)this.myEditor).getScrollPane().setViewportBorder((Border)JBScrollPane.createIndentBorder());
        this.myViewingPanel.add((Component)this.myEditor.getComponent(), TEXT_PAGE_KEY);
        this.myBinaryPanel = new JPanel(new BorderLayout());
        this.myViewingPanel.add((Component)this.myBinaryPanel, BINARY_PAGE_KEY);
        this.add((Component)this.myViewingPanel, "Center");
        this.myToolbar = this.createToolbar();
        this.myLocationLabel = new JLabel();
        this.myCountLabel = new JLabel();
        final JPanel header = new JPanel(new BorderLayout(2, 0));
        header.setBorder(BorderFactory.createCompoundBorder(IdeBorderFactory.createBorder((int)8), IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)5)));
        final JPanel toolbarPanel = new JPanel(new GridBagLayout());
        final GridBagConstraints gc = new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0);
        toolbarPanel.add((Component)this.myToolbar.getComponent(), gc);
        this.setPreferredSize((Dimension)JBUI.size((int)600, (int)400));
        ImplementationViewComponent.update(elements, new PairFunction<PsiElement[], List<FileDescriptor>, Boolean>(){

            public Boolean fun(PsiElement[] psiElements, List<FileDescriptor> fileDescriptors) {
                EditorHighlighter highlighter;
                if (psiElements.length == 0) {
                    return false;
                }
                ImplementationViewComponent.access$002(ImplementationViewComponent.this, psiElements);
                ImplementationViewComponent.this.myIndex = index < ImplementationViewComponent.this.myElements.length ? index : 0;
                PsiFile psiFile = ImplementationViewComponent.getContainingFile(ImplementationViewComponent.this.myElements[ImplementationViewComponent.this.myIndex]);
                VirtualFile virtualFile = psiFile.getVirtualFile();
                if (virtualFile != null) {
                    highlighter = HighlighterFactory.createHighlighter((Project)project, (VirtualFile)virtualFile);
                } else {
                    String fileName = psiFile.getName();
                    highlighter = HighlighterFactory.createHighlighter((Project)project, (String)fileName);
                }
                ((EditorEx)ImplementationViewComponent.this.myEditor).setHighlighter(highlighter);
                gc.fill = 2;
                gc.weightx = 1.0;
                ImplementationViewComponent.this.myLabel = new JLabel();
                ImplementationViewComponent.this.myFileChooser = new ComboBox((Object[])fileDescriptors.toArray(new FileDescriptor[fileDescriptors.size()]), 250);
                ImplementationViewComponent.this.myFileChooser.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int index = ImplementationViewComponent.this.myFileChooser.getSelectedIndex();
                        if (ImplementationViewComponent.this.myIndex != index) {
                            ImplementationViewComponent.this.myIndex = index;
                            ImplementationViewComponent.this.updateControls();
                        }
                    }
                });
                toolbarPanel.add((Component)ImplementationViewComponent.this.myFileChooser, gc);
                if (ImplementationViewComponent.this.myElements.length > 1) {
                    ImplementationViewComponent.this.updateRenderer(project);
                    ImplementationViewComponent.this.myLabel.setVisible(false);
                } else {
                    ImplementationViewComponent.this.myFileChooser.setVisible(false);
                    ImplementationViewComponent.this.myCountLabel.setVisible(false);
                    VirtualFile file = psiFile.getVirtualFile();
                    if (file != null) {
                        ImplementationViewComponent.this.myLabel.setIcon(ImplementationViewComponent.getIconForFile(psiFile));
                        ImplementationViewComponent.this.myLabel.setForeground(FileStatusManager.getInstance((Project)project).getStatus(file).getColor());
                        ImplementationViewComponent.this.myLabel.setText(file.getPresentableName());
                        ImplementationViewComponent.this.myLabel.setBorder(new CompoundBorder((Border)IdeBorderFactory.createRoundedBorder(), IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)5)));
                    }
                    toolbarPanel.add((Component)ImplementationViewComponent.this.myLabel, gc);
                }
                gc.fill = 0;
                gc.weightx = 0.0;
                toolbarPanel.add((Component)ImplementationViewComponent.this.myCountLabel, gc);
                header.add((Component)toolbarPanel, "Center");
                header.add((Component)ImplementationViewComponent.this.myLocationLabel, "East");
                ImplementationViewComponent.this.add((Component)header, "North");
                ImplementationViewComponent.this.updateControls();
                return true;
            }
        });
    }

    private void updateRenderer(final Project project) {
        this.myFileChooser.setRenderer((ListCellRenderer)new ListCellRendererWrapper<FileDescriptor>(){

            public void customize(JList list, FileDescriptor value, int index, boolean selected, boolean hasFocus) {
                PsiFile file = value.myFile;
                this.setIcon(ImplementationViewComponent.getIconForFile(file));
                VirtualFile vFile = file.getVirtualFile();
                this.setForeground(FileStatusManager.getInstance((Project)project).getStatus(vFile).getColor());
                this.setText(value.getPresentableName(vFile));
            }
        });
    }

    public String[] getVisibleFiles() {
        ComboBoxModel model = this.myFileChooser.getModel();
        String[] result = new String[model.getSize()];
        for (int i = 0; i < model.getSize(); ++i) {
            FileDescriptor o = (FileDescriptor)model.getElementAt(i);
            result[i] = o.getPresentableName(o.myFile.getVirtualFile());
        }
        return result;
    }

    public void update(@NotNull PsiElement[] elements, final int index) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/hint/ImplementationViewComponent", "update"));
        }
        ImplementationViewComponent.update(elements, new PairFunction<PsiElement[], List<FileDescriptor>, Boolean>(){

            public Boolean fun(PsiElement[] psiElements, List<FileDescriptor> fileDescriptors) {
                EditorHighlighter highlighter;
                if (psiElements.length == 0) {
                    return false;
                }
                Project project = psiElements[0].getProject();
                ImplementationViewComponent.access$002(ImplementationViewComponent.this, psiElements);
                ImplementationViewComponent.this.myIndex = index < ImplementationViewComponent.this.myElements.length ? index : 0;
                PsiFile psiFile = ImplementationViewComponent.getContainingFile(ImplementationViewComponent.this.myElements[ImplementationViewComponent.this.myIndex]);
                VirtualFile virtualFile = psiFile.getVirtualFile();
                if (virtualFile != null) {
                    highlighter = HighlighterFactory.createHighlighter((Project)project, (VirtualFile)virtualFile);
                } else {
                    String fileName = psiFile.getName();
                    highlighter = HighlighterFactory.createHighlighter((Project)project, (String)fileName);
                }
                ((EditorEx)ImplementationViewComponent.this.myEditor).setHighlighter(highlighter);
                if (ImplementationViewComponent.this.myElements.length > 1) {
                    ImplementationViewComponent.this.myFileChooser.setVisible(true);
                    ImplementationViewComponent.this.myCountLabel.setVisible(true);
                    ImplementationViewComponent.this.myLabel.setVisible(false);
                    ImplementationViewComponent.this.myFileChooser.setModel(new DefaultComboBoxModel<FileDescriptor>(fileDescriptors.toArray(new FileDescriptor[fileDescriptors.size()])));
                    ImplementationViewComponent.this.updateRenderer(project);
                } else {
                    ImplementationViewComponent.this.myFileChooser.setVisible(false);
                    ImplementationViewComponent.this.myCountLabel.setVisible(false);
                    VirtualFile file = psiFile.getVirtualFile();
                    if (file != null) {
                        ImplementationViewComponent.this.myLabel.setIcon(ImplementationViewComponent.getIconForFile(psiFile));
                        ImplementationViewComponent.this.myLabel.setForeground(FileStatusManager.getInstance((Project)project).getStatus(file).getColor());
                        ImplementationViewComponent.this.myLabel.setText(file.getPresentableName());
                        ImplementationViewComponent.this.myLabel.setBorder(new CompoundBorder((Border)IdeBorderFactory.createRoundedBorder(), IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)5)));
                        ImplementationViewComponent.this.myLabel.setVisible(true);
                    }
                }
                ImplementationViewComponent.this.updateControls();
                ImplementationViewComponent.this.revalidate();
                ImplementationViewComponent.this.repaint();
                return true;
            }
        });
    }

    private static void update(@NotNull PsiElement[] elements, @NotNull PairFunction<PsiElement[], List<FileDescriptor>, Boolean> fun) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/hint/ImplementationViewComponent", "update"));
        }
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/codeInsight/hint/ImplementationViewComponent", "update"));
        }
        ArrayList<PsiElement> candidates = new ArrayList<PsiElement>(elements.length);
        ArrayList<FileDescriptor> files = new ArrayList<FileDescriptor>(elements.length);
        HashSet<String> names = new HashSet<String>();
        for (PsiElement element : elements) {
            if (element instanceof PsiNamedElement) {
                names.add(((PsiNamedElement)element).getName());
            }
            if (names.size() > 1) break;
        }
        for (PsiElement element : elements) {
            PsiFile file = ImplementationViewComponent.getContainingFile(element);
            if (file == null) continue;
            if (names.size() > 1) {
                files.add(new FileDescriptor(file, element));
            } else {
                PsiElement parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)element);
                if (parent == file) {
                    files.add(new FileDescriptor(file, element));
                } else {
                    files.add(new FileDescriptor(file, parent));
                }
            }
            candidates.add(element);
        }
        fun.fun((Object)PsiUtilCore.toPsiElementArray(candidates), files);
    }

    private static Icon getIconForFile(PsiFile psiFile) {
        return psiFile.getNavigationElement().getIcon(0);
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myElements.length > 1 ? this.myFileChooser : this.myEditor.getContentComponent();
    }

    private void updateControls() {
        this.updateLabels();
        this.updateCombo();
        this.updateEditorText();
        this.myToolbar.updateActionsImmediately();
    }

    private void updateCombo() {
        if (this.myFileChooser != null && this.myFileChooser.isVisible()) {
            this.myFileChooser.setSelectedIndex(this.myIndex);
        }
    }

    private void updateEditorText() {
        FileEditorProvider[] providers;
        VirtualFile vFile;
        this.disposeNonTextEditor();
        PsiElement foundElement = this.myElements[this.myIndex];
        PsiElement elt = foundElement.getNavigationElement();
        LOG.assertTrue(elt != null, (Object)foundElement);
        Project project = foundElement.getProject();
        PsiFile psiFile = ImplementationViewComponent.getContainingFile(elt);
        VirtualFile virtualFile = vFile = psiFile != null ? psiFile.getVirtualFile() : null;
        if (vFile == null) {
            return;
        }
        for (FileEditorProvider provider : providers = FileEditorProviderManager.getInstance().getProviders(project, vFile)) {
            if (provider instanceof TextEditorProvider) {
                this.updateTextElement(elt);
                this.myBinarySwitch.show(this.myViewingPanel, TEXT_PAGE_KEY);
                break;
            }
            if (!provider.accept(project, vFile)) continue;
            this.myCurrentNonTextEditorProvider = provider;
            this.myNonTextEditor = this.myCurrentNonTextEditorProvider.createEditor(project, vFile);
            this.myBinaryPanel.removeAll();
            this.myBinaryPanel.add(this.myNonTextEditor.getComponent());
            this.myBinarySwitch.show(this.myViewingPanel, BINARY_PAGE_KEY);
            break;
        }
    }

    private void disposeNonTextEditor() {
        if (this.myNonTextEditor != null) {
            this.myCurrentNonTextEditorProvider.disposeEditor(this.myNonTextEditor);
            this.myNonTextEditor = null;
            this.myCurrentNonTextEditorProvider = null;
        }
    }

    private void updateTextElement(PsiElement elt) {
        final String newText = ImplementationViewComponent.getNewText(elt);
        if (newText == null || Comparing.strEqual((String)newText, (String)this.myEditor.getDocument().getText())) {
            return;
        }
        DocumentUtil.writeInRunUndoTransparentAction(new Runnable(){

            @Override
            public void run() {
                Document fragmentDoc = ImplementationViewComponent.this.myEditor.getDocument();
                fragmentDoc.setReadOnly(false);
                fragmentDoc.replaceString(0, fragmentDoc.getTextLength(), (CharSequence)newText);
                fragmentDoc.setReadOnly(true);
                ImplementationViewComponent.this.myEditor.getCaretModel().moveToOffset(0);
                ImplementationViewComponent.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        });
    }

    @Nullable
    public static String getNewText(PsiElement elt) {
        Project project = elt.getProject();
        PsiFile psiFile = ImplementationViewComponent.getContainingFile(elt);
        Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (doc == null) {
            return null;
        }
        if (elt.getTextRange() == null) {
            return null;
        }
        ImplementationTextSelectioner implementationTextSelectioner = (ImplementationTextSelectioner)LanguageImplementationTextSelectioner.INSTANCE.forLanguage(elt.getLanguage());
        int start = implementationTextSelectioner.getTextStartOffset(elt);
        int end = implementationTextSelectioner.getTextEndOffset(elt);
        int lineStart = doc.getLineStartOffset(doc.getLineNumber(start));
        int lineEnd = end < doc.getTextLength() ? doc.getLineEndOffset(doc.getLineNumber(end)) : doc.getTextLength();
        return doc.getCharsSequence().subSequence(lineStart, lineEnd).toString();
    }

    private static PsiFile getContainingFile(PsiElement elt) {
        PsiFile psiFile = elt.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        return psiFile.getOriginalFile();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (!ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
            return;
        }
        EditorFactory.getInstance().releaseEditor(this.myEditor);
        this.disposeNonTextEditor();
    }

    private void updateLabels() {
        ElementLocationUtil.customizeElementLabel(this.myElements[this.myIndex], this.myLocationLabel);
        this.myCountLabel.setText(CodeInsightBundle.message((String)"n.of.m", (Object[])new Object[]{this.myIndex + 1, this.myElements.length}));
    }

    private ActionToolbar createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        BackAction back = new BackAction();
        back.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(37, 0)), this);
        group.add((AnAction)back);
        ForwardAction forward = new ForwardAction();
        forward.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(39, 0)), this);
        group.add((AnAction)forward);
        EditSourceActionBase edit = new EditSourceAction();
        edit.registerCustomShortcutSet((ShortcutSet)new CompositeShortcutSet(new ShortcutSet[]{CommonShortcuts.getEditSource(), CommonShortcuts.ENTER}), this);
        group.add((AnAction)edit);
        edit = new ShowSourceAction();
        edit.registerCustomShortcutSet((ShortcutSet)new CompositeShortcutSet(new ShortcutSet[]{CommonShortcuts.getViewSource(), CommonShortcuts.CTRL_ENTER}), this);
        group.add((AnAction)edit);
        return ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
    }

    private void goBack() {
        --this.myIndex;
        this.updateControls();
    }

    private void goForward() {
        ++this.myIndex;
        this.updateControls();
    }

    public int getIndex() {
        return this.myIndex;
    }

    public PsiElement[] getElements() {
        return this.myElements;
    }

    public UsageView showInUsageView() {
        return FindUtil.showInUsageView(null, this.collectNonBinaryElements(), this.myTitle, this.myEditor.getProject());
    }

    private PsiElement[] collectNonBinaryElements() {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement element : this.myElements) {
            if (element instanceof PsiBinaryFile) continue;
            result.add(element);
        }
        return PsiUtilCore.toPsiElementArray(result);
    }

    static /* synthetic */ PsiElement[] access$002(ImplementationViewComponent x0, PsiElement[] x1) {
        x0.myElements = x1;
        return x1;
    }

    private class EditSourceActionBase
    extends AnAction {
        private final boolean myFocusEditor;

        public EditSourceActionBase(boolean focusEditor, Icon icon, String text) {
            super(text, null, icon);
            this.myFocusEditor = focusEditor;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(ImplementationViewComponent.this.myFileChooser == null || !ImplementationViewComponent.this.myFileChooser.isPopupVisible());
        }

        public void actionPerformed(AnActionEvent e) {
            PsiElement element = ImplementationViewComponent.this.myElements[ImplementationViewComponent.this.myIndex];
            PsiElement navigationElement = element.getNavigationElement();
            PsiFile file = ImplementationViewComponent.getContainingFile(navigationElement);
            if (file == null) {
                return;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            Project project = element.getProject();
            FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project);
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile, navigationElement.getTextOffset());
            fileEditorManager.openTextEditor(descriptor, this.myFocusEditor);
        }
    }

    private class ShowSourceAction
    extends EditSourceActionBase
    implements HintManagerImpl.ActionToIgnore {
        public ShowSourceAction() {
            super(false, AllIcons.Actions.Preview, CodeInsightBundle.message((String)"quick.definition.show.source", (Object[])new Object[0]));
        }
    }

    private class EditSourceAction
    extends EditSourceActionBase {
        public EditSourceAction() {
            super(true, AllIcons.Actions.EditSource, CodeInsightBundle.message((String)"quick.definition.edit.source", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            super.actionPerformed(e);
            if (ImplementationViewComponent.this.myHint.isVisible()) {
                ImplementationViewComponent.this.myHint.cancel();
            }
        }
    }

    private class ForwardAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        public ForwardAction() {
            super(CodeInsightBundle.message((String)"quick.definition.forward", (Object[])new Object[0]), null, AllIcons.Actions.Forward);
        }

        public void actionPerformed(AnActionEvent e) {
            ImplementationViewComponent.this.goForward();
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(ImplementationViewComponent.this.myElements != null && ImplementationViewComponent.this.myIndex < ImplementationViewComponent.this.myElements.length - 1);
        }
    }

    private class BackAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        public BackAction() {
            super(CodeInsightBundle.message((String)"quick.definition.back", (Object[])new Object[0]), null, AllIcons.Actions.Back);
        }

        public void actionPerformed(AnActionEvent e) {
            ImplementationViewComponent.this.goBack();
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(ImplementationViewComponent.this.myIndex > 0);
        }
    }

    private static class FileDescriptor {
        public final PsiFile myFile;
        public final String myElementPresentation;
        private final String myLocationString;

        public FileDescriptor(PsiFile file, PsiElement element) {
            ItemPresentation presentation;
            this.myFile = file;
            ItemPresentation itemPresentation = presentation = element instanceof NavigationItem ? ((NavigationItem)element).getPresentation() : null;
            if (presentation != null) {
                this.myElementPresentation = presentation.getPresentableText();
                this.myLocationString = presentation.getLocationString();
            } else {
                this.myElementPresentation = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : null;
                this.myLocationString = null;
            }
        }

        public String getPresentableName(VirtualFile vFile) {
            String presentableName = vFile.getPresentableName();
            if (this.myElementPresentation == null) {
                return presentableName;
            }
            if (Comparing.strEqual((String)vFile.getName(), (String)(this.myElementPresentation + "." + vFile.getExtension()))) {
                return presentableName + (!StringUtil.isEmptyOrSpaces((String)this.myLocationString) ? " " + this.myLocationString : "");
            }
            return presentableName + " (" + this.myElementPresentation + ")";
        }
    }
}

