/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateListPanel;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.Convertor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveTemplateTree
extends CheckboxTree
implements DataProvider,
CopyProvider,
PasteProvider {
    private final TemplateListPanel myConfigurable;

    LiveTemplateTree(CheckboxTree.CheckboxTreeCellRenderer renderer, CheckedTreeNode root, TemplateListPanel configurable) {
        super(renderer, root);
        this.myConfigurable = configurable;
    }

    protected void onNodeStateChanged(CheckedTreeNode node) {
        Object obj = node.getUserObject();
        if (obj instanceof TemplateImpl) {
            ((TemplateImpl)obj).setDeactivated(!node.isChecked());
        }
    }

    @Override
    protected void installSpeedSearch() {
        new TreeSpeedSearch((Tree)this, new Convertor<TreePath, String>(){

            public String convert(TreePath o) {
                Object object = ((DefaultMutableTreeNode)o.getLastPathComponent()).getUserObject();
                if (object instanceof TemplateGroup) {
                    return ((TemplateGroup)((Object)object)).getName();
                }
                if (object instanceof TemplateImpl) {
                    TemplateImpl template = (TemplateImpl)object;
                    return StringUtil.notNullize((String)template.getGroupName()) + " " + StringUtil.notNullize((String)template.getKey()) + " " + StringUtil.notNullize((String)template.getDescription()) + " " + template.getTemplateText();
                }
                return "";
            }
        }, true);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/template/impl/LiveTemplateTree", "performCopy"));
        }
        Set<TemplateImpl> templates = this.myConfigurable.getSelectedTemplates().keySet();
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(StringUtil.join(templates, (Function)new Function<TemplateImpl, String>(){

            public String fun(TemplateImpl template) {
                TemplateContext zeroContext = new TemplateContext();
                for (TemplateContextType type : (TemplateContextType[])TemplateContextType.EP_NAME.getExtensions()) {
                    zeroContext.setEnabled(type, false);
                }
                return JDOMUtil.writeElement((Element)TemplateSettings.serializeTemplate(template, zeroContext));
            }
        }, (String)SystemProperties.getLineSeparator())));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/template/impl/LiveTemplateTree", "isCopyEnabled"));
        }
        return !this.myConfigurable.getSelectedTemplates().isEmpty();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/template/impl/LiveTemplateTree", "isCopyVisible"));
        }
        return this.isCopyEnabled(dataContext);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/template/impl/LiveTemplateTree", "isPastePossible"));
        }
        if (this.myConfigurable.getSingleSelectedGroup() == null) {
            return false;
        }
        String s = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        return s != null && s.startsWith("<template ");
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/template/impl/LiveTemplateTree", "isPasteEnabled"));
        }
        return this.isPastePossible(dataContext);
    }

    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/template/impl/LiveTemplateTree", "performPaste"));
        }
        TemplateGroup group = this.myConfigurable.getSingleSelectedGroup();
        assert (group != null);
        String buffer = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        assert (buffer != null);
        try {
            for (Element templateElement : JDOMUtil.load((Reader)new StringReader("<root>" + buffer + "</root>")).getChildren("template")) {
                this.myConfigurable.addTemplate(TemplateSettings.readTemplateFromElement(group.getName(), templateElement, ((Object)((Object)this)).getClass().getClassLoader()));
            }
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

