/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Factory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PostfixTemplatesSettings", storages={@Storage(file="$APP_CONFIG$/postfixTemplates.xml")})
public class PostfixTemplatesSettings
implements PersistentStateComponent<Element>,
ExportableComponent {
    public static final Factory<Set<String>> SET_FACTORY = new Factory<Set<String>>(){

        public Set<String> create() {
            return ContainerUtil.newHashSet();
        }
    };
    private Map<String, Set<String>> myLangToDisabledTemplates = ContainerUtil.newHashMap();
    private boolean postfixTemplatesEnabled = true;
    private boolean templatesCompletionEnabled = true;
    private int myShortcut = 9;
    @Deprecated
    @NotNull
    private Map<String, Boolean> myTemplatesState = ContainerUtil.newHashMap();

    @Deprecated
    @NotNull
    public Map<String, Boolean> getTemplatesState() {
        Map<String, Boolean> map = this.myTemplatesState;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings", "getTemplatesState"));
        }
        return map;
    }

    @Deprecated
    public void setTemplatesState(@NotNull Map<String, Boolean> templatesState) {
        if (templatesState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templatesState", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings", "setTemplatesState"));
        }
        this.myTemplatesState = templatesState;
    }

    public boolean isTemplateEnabled(@NotNull PostfixTemplate template, @NotNull PostfixTemplateProvider provider) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings", "isTemplateEnabled"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings", "isTemplateEnabled"));
        }
        String langForProvider = PostfixTemplatesUtils.getLangForProvider(provider);
        return this.isTemplateEnabled(template, langForProvider);
    }

    public boolean isTemplateEnabled(PostfixTemplate template, @NotNull String strictLangForProvider) {
        if (strictLangForProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strictLangForProvider", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings", "isTemplateEnabled"));
        }
        Set<String> result = this.myLangToDisabledTemplates.get(strictLangForProvider);
        return result == null || !result.contains(template.getKey());
    }

    public void disableTemplate(@NotNull PostfixTemplate template, @NotNull PostfixTemplateProvider provider) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings", "disableTemplate"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings", "disableTemplate"));
        }
        String langForProvider = PostfixTemplatesUtils.getLangForProvider(provider);
        this.disableTemplate(template, langForProvider);
    }

    public void disableTemplate(PostfixTemplate template, String langForProvider) {
        Set state = (Set)ContainerUtil.getOrCreate(this.myLangToDisabledTemplates, (Object)langForProvider, SET_FACTORY);
        state.add(template.getKey());
    }

    public boolean isPostfixTemplatesEnabled() {
        return this.postfixTemplatesEnabled;
    }

    public void setPostfixTemplatesEnabled(boolean postfixTemplatesEnabled) {
        this.postfixTemplatesEnabled = postfixTemplatesEnabled;
    }

    public boolean isTemplatesCompletionEnabled() {
        return this.templatesCompletionEnabled;
    }

    public void setTemplatesCompletionEnabled(boolean templatesCompletionEnabled) {
        this.templatesCompletionEnabled = templatesCompletionEnabled;
    }

    @MapAnnotation(entryTagName="disabled-postfix-templates", keyAttributeName="lang", surroundWithTag=false)
    @NotNull
    public Map<String, Set<String>> getLangDisabledTemplates() {
        Map<String, Set<String>> map = this.myLangToDisabledTemplates;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings", "getLangDisabledTemplates"));
        }
        return map;
    }

    public void setLangDisabledTemplates(@NotNull Map<String, Set<String>> templatesState) {
        if (templatesState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templatesState", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings", "setLangDisabledTemplates"));
        }
        this.myLangToDisabledTemplates = templatesState;
    }

    public int getShortcut() {
        return this.myShortcut;
    }

    public void setShortcut(int shortcut) {
        this.myShortcut = shortcut;
    }

    @Nullable
    public static PostfixTemplatesSettings getInstance() {
        return (PostfixTemplatesSettings)ServiceManager.getService(PostfixTemplatesSettings.class);
    }

    @Nullable
    public Element getState() {
        return XmlSerializer.serialize((Object)this, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
    }

    public void loadState(Element settings) {
        XmlSerializer.deserializeInto((Object)this, (Element)settings);
        if (!this.myTemplatesState.isEmpty()) {
            this.myLangToDisabledTemplates.put("JAVA", ContainerUtil.newHashSet(this.myTemplatesState.keySet()));
            this.myTemplatesState.clear();
        }
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((String)"postfixCompletion.xml")};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        if ("Postfix Completion" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings", "getPresentableName"));
        }
        return "Postfix Completion";
    }
}

