/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OfflineProblemDescriptorNode
extends ProblemDescriptionNode {
    OfflineProblemDescriptorNode(@NotNull OfflineProblemDescriptor descriptor, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull InspectionToolPresentation presentation) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "<init>"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "<init>"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "<init>"));
        }
        super(descriptor, toolWrapper, presentation);
    }

    private static PsiElement[] getElementsIntersectingRange(PsiFile file, int startOffset, int endOffset) {
        FileViewProvider viewProvider = file.getViewProvider();
        LinkedHashSet<PsiElement> result = new LinkedHashSet<PsiElement>();
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!HighlightingLevelManager.getInstance(file.getProject()).shouldInspect((PsiElement)psiRoot)) continue;
            result.addAll(CollectHighlightsUtil.getElementsInRange((PsiElement)psiRoot, startOffset, endOffset, true));
        }
        return PsiUtilCore.toPsiElementArray(result);
    }

    @Override
    @Nullable
    public RefEntity getElement() {
        if (this.userObject instanceof CommonProblemDescriptor) {
            return this.myElement;
        }
        if (this.userObject == null) {
            return null;
        }
        this.myElement = ((OfflineProblemDescriptor)this.userObject).getRefElement(this.myPresentation.getContext().getRefManager());
        return this.myElement;
    }

    @Override
    @Nullable
    public CommonProblemDescriptor getDescriptor() {
        if (this.userObject == null) {
            return null;
        }
        if (this.userObject instanceof CommonProblemDescriptor) {
            return (CommonProblemDescriptor)this.userObject;
        }
        final InspectionManager inspectionManager = InspectionManager.getInstance((Project)this.myPresentation.getContext().getProject());
        final OfflineProblemDescriptor offlineProblemDescriptor = (OfflineProblemDescriptor)this.userObject;
        RefEntity element = this.getElement();
        if (this.myToolWrapper instanceof LocalInspectionToolWrapper) {
            ProblemDescriptor descriptor;
            PsiElement psiElement;
            if (element instanceof RefElement && (psiElement = ((RefElement)element).getElement()) != null && (descriptor = (ProblemDescriptor)ProgressManager.getInstance().runProcess((Computable)new Computable<ProblemDescriptor>(){

                public ProblemDescriptor compute() {
                    return OfflineProblemDescriptorNode.this.runLocalTool(psiElement, inspectionManager, offlineProblemDescriptor);
                }
            }, (ProgressIndicator)new DaemonProgressIndicator())) != null) {
                return descriptor;
            }
            this.setUserObject(null);
            return null;
        }
        List hints = offlineProblemDescriptor.getHints();
        if (element instanceof RefElement) {
            PsiElement psiElement = ((RefElement)element).getElement();
            if (psiElement == null) {
                return null;
            }
            ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor(psiElement, offlineProblemDescriptor.getDescription(), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false);
            LocalQuickFix[] quickFixes = this.getFixes((CommonProblemDescriptor)descriptor, hints);
            if (quickFixes != null) {
                descriptor = inspectionManager.createProblemDescriptor(psiElement, offlineProblemDescriptor.getDescription(), false, quickFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
            this.setUserObject(descriptor);
            return descriptor;
        }
        CommonProblemDescriptor descriptor = inspectionManager.createProblemDescriptor(offlineProblemDescriptor.getDescription(), new QuickFix[]{null});
        LocalQuickFix[] quickFixes = this.getFixes(descriptor, hints);
        if (quickFixes != null) {
            descriptor = inspectionManager.createProblemDescriptor(offlineProblemDescriptor.getDescription(), (QuickFix[])quickFixes);
        }
        this.setUserObject(descriptor);
        return descriptor;
    }

    private ProblemDescriptor runLocalTool(@NotNull PsiElement psiElement, @NotNull InspectionManager inspectionManager, @NotNull OfflineProblemDescriptor offlineProblemDescriptor) {
        PsiElement[] elementsInRange;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "runLocalTool"));
        }
        if (inspectionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionManager", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "runLocalTool"));
        }
        if (offlineProblemDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offlineProblemDescriptor", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "runLocalTool"));
        }
        PsiFile containingFile = psiElement.getContainingFile();
        ProblemsHolder holder = new ProblemsHolder(inspectionManager, containingFile, false);
        LocalInspectionTool localTool = (LocalInspectionTool)((LocalInspectionToolWrapper)this.myToolWrapper).getTool();
        int startOffset = psiElement.getTextRange().getStartOffset();
        int endOffset = psiElement.getTextRange().getEndOffset();
        LocalInspectionToolSession session = new LocalInspectionToolSession(containingFile, startOffset, endOffset);
        PsiElementVisitor visitor = localTool.buildVisitor(holder, false, session);
        localTool.inspectionStarted(session, false);
        for (PsiElement element : elementsInRange = OfflineProblemDescriptorNode.getElementsIntersectingRange(containingFile, startOffset, endOffset)) {
            element.accept(visitor);
        }
        localTool.inspectionFinished(session, holder);
        if (holder.hasResults()) {
            List list = holder.getResults();
            int idx = offlineProblemDescriptor.getProblemIndex();
            int curIdx = 0;
            for (ProblemDescriptor descriptor : list) {
                PsiNamedElement member = localTool.getProblemElement(descriptor.getPsiElement());
                if (!(psiElement instanceof PsiFile) && (member == null || !member.equals(psiElement))) continue;
                if (curIdx == idx) {
                    this.setUserObject(descriptor);
                    return descriptor;
                }
                ++curIdx;
            }
        }
        return null;
    }

    @Nullable
    private LocalQuickFix[] getFixes(@NotNull CommonProblemDescriptor descriptor, List<String> hints) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "getFixes"));
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>(hints == null ? 1 : hints.size());
        if (hints == null) {
            this.addFix(descriptor, fixes, null);
        } else {
            for (String hint : hints) {
                this.addFix(descriptor, fixes, hint);
            }
        }
        return fixes.isEmpty() ? null : fixes.toArray(new LocalQuickFix[fixes.size()]);
    }

    private void addFix(@NotNull CommonProblemDescriptor descriptor, List<LocalQuickFix> fixes, String hint) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/offlineViewer/OfflineProblemDescriptorNode", "addFix"));
        }
        IntentionAction intentionAction = this.myPresentation.findQuickFixes(descriptor, hint);
        if (intentionAction instanceof QuickFixWrapper) {
            fixes.add(((QuickFixWrapper)intentionAction).getFix());
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public FileStatus getNodeStatus() {
        return FileStatus.NOT_CHANGED;
    }

    @Override
    public String toString() {
        if (this.userObject instanceof OfflineProblemDescriptor) {
            return ((OfflineProblemDescriptor)this.userObject).getDescription();
        }
        return super.toString();
    }
}

