/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StoragePathMacros;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import kotlin.StringsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0015\f)\u0001b)\u001b7f\u0005\u0006\u001cX\rZ*u_J\fw-\u001a\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b%\r|gNZ5hkJ\fG/[8o'R|'/\u001a\u0006\u001216dW\t\\3nK:$8\u000b^8sC\u001e,'B\u0002\u001fj]&$hH\u0003\u0003gS2,'\u0002\u0002$jY\u0016TAA[1wC*\u0011\u0011n\u001c\u0006\tM&dWm\u00159fG*11\u000b\u001e:j]\u001eTaa[8uY&t'b\u0004:p_R,E.Z7f]Rt\u0015-\\3\u000b!A\fG\u000f['bGJ|W*\u00198bO\u0016\u0014(\u0002\b+sC\u000e\\\u0017N\\4QCRDW*Y2s_N+(m\u001d;jiV$xN\u001d\u0006\b_B,g.\u00199j\u0015)\u0019w.\u001c9p]\u0016tGo\u001d\u0006\fe>\fW.\u001b8h)f\u0004XMC\u0006S_\u0006l\u0017N\\4UsB,'\u0002\u00039s_ZLG-\u001a:\u000b\u001dM#(/Z1n!J|g/\u001b3fe*!A.\u00198h\u0015U\u0011Gn\\2l'\u00064\u0018N\\4UQ\u0016\u001cuN\u001c;f]RTqAQ8pY\u0016\fgNC\tdC\u000eDW\r\u001a,jeR,\u0018\r\u001c$jY\u0016T1BV5siV\fGNR5mK*\u0019aOZ:\u000b\u000fq\u001aX\r^\u0017@})9q-\u001a;GS2,'bB:fi\u001aKG.\u001a\u0006\u000fSN,6/\u001a-nYB\u0013x\u000e\\8h\u0015E9W\r^%t+N,\u0007,\u001c7Qe>dwn\u001a\u0006\u000eY&tWmU3qCJ\fGo\u001c:\u000b\u001b1Kg.Z*fa\u0006\u0014\u0018\r^8s\u0015\u0011)H/\u001b7\u000b#\r\u0014X-\u0019;f'\u00064XmU3tg&|gN\u0003\u0004ti\u0006$Xm\u001d\u0006\t'R\fG/Z'ba*ya)\u001b7f'\u00064XmU3tg&|gN\u0003\u0011GS2,')Y:fIN#xN]1hK\u00122\u0015\u000e\\3TCZ,7+Z:tS>t'BD4fiZK'\u000f^;bY\u001aKG.\u001a\u0006\u000eY>\fG\rT8dC2$\u0015\r^1\u000b\u000f\u0015cW-\\3oi*\u0019qN]4\u000b\t)$w.\u001c\u0006\u0015aJ|7-Z:t%\u0016\fG-\u0012=dKB$\u0018n\u001c8\u000b\u0003\u0015T\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\tUs\u0017\u000e\u001e\u0006\fm&\u0014H/^1m\r&dWMC\bj_\u001aKG.Z%g\u0007\"\fgnZ3e\u0015!!xn\u0015;sS:<\u0007Q\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0019A!\u0001\u0005\u0001\u0019\u0001)1\u0001B\u0001\t\u00051\u0001Q!\u0001\u0005\u0005\u000b\t!)\u0001#\u0003\u0006\u0007\u0011\u0019\u0001r\u0001\u0007\u0001\u000b\u0005Aa!B\u0002\u0005\t!-A\u0002A\u0003\u0003\t\u0003A\u0001\"\u0002\u0002\u0005\u000b!EQa\u0001C\u0006\u0011\u001fa\u0001!B\u0002\u0005\f!MA\u0002A\u0003\u0004\t\u0005A)\u0002\u0004\u0001\u0006\u0005\u0011\u0019\u0001rA\u0003\u0003\t\u000bA1\"\u0002\u0002\u0005\u0011!-QA\u0001C\u0006\u0011\u001f)!\u0001b\u0003\t\u0014\u0015\u0011A!\u0001E\u000b\u000b\r!A\u0001\u0003\u0007\r\u0001\u0015\u0011A!\u0002E\u000e\u000b\r!1\u0002C\u0007\r\u0001\u0015\u0011Aa\u0003\u0005\u000e\u000b\t!\t\u0001c\t\u0006\u0007\u0011e\u0001\"\u0005\u0007\u0001\u000b\t!I\u0002C\t\u0006\u0007\u0011\t\u0001b\u0005\u0007\u0001\u000b\r!\u0019\u0001c\n\r\u0001\u0015\u0011A!\u0001\u0005\u0015\u000b\t!\u0011\u0001C\n\u0006\u0003!1RA\u0001\u0003\u0011\u0011[)1\u0001\"\t\t,1\u0001QA\u0001C\u0011\u0011W)1\u0001\u0002\u0005\t11\u0001Qa\u0001\u0003\u0005\u0011ca\u0001!\u0002\u0002\u0005\u0011!ABa\u0003G\u00023\r)\u0011\u0001\u0003\u0002\u0019\u0005u\u00059#\f\u0007\u0005\u00034A:\"I\u0002\u0006\u0003!U\u0001TC+\u0004\t\u0015\u0019AqC\u0005\u0002\t\u0003is\u0002ba\r13\tC!B\u0001\t\u00181\u0005\u0001t\u0003\u0013\u0002Q\u0005)6\u0001B\u0003\u0004\t3I\u0011\u0001\u0003\u0007.B\u0011\u001dM\u0002G\u0002\u001e\u0010\u0011\u0001\u0001BD\u0007\u0004\u000b\u0005A9\u0001g\u0002Q\u0007\u0001\t3!B\u0001\t\ba\u001dAe\u0001\u0015\"+\u000eqQa\u0001\u0003\u0004\u0013\u0005Ay!D\u0002\u0005\u001e%\t\u0001rB\t\u0006\t=I\u0011\u0001\u0002\u0001\u000e\u0003!=Q\u0006\u0005\u0003k)a}\u0011eA\u0003\u0002\u0011+A*\"V\u0002\t\u000b\r!y\"C\u0001\u0005\u00025\u0019A\u0001E\u0005\u0002\t\u0003iS\u0002Ba\r1C\tC!B\u0001\t\u001b1\u0005\u0001$D+\u0004\t\u0015\u0019A\u0011E\u0005\u0002\u00117iS\u0003\u0002\u0006\u0019%u=A\u0001\u0001E\u0013\u001b\r)\u0011\u0001\u0003\b\u0019\u001dA\u001b\u0001!I\u0002\u0006\u0003!u\u0001TD)\u0004\u000b\u0011\u0011\u0012\"\u0001\u0005\u0010\u001b\u0005Ay\"l\u0006\u0005\u0007a%\u0012\u0005B\u0003\u0002\u0011/a\t\u0001g\u0006R\u0007\r!I#C\u0001\t\u00195^AA\u0003\r\u0016C\u0011)\u0011\u0001C\t\r\u0002a\t\u0012kA\u0002\u0005+%\t\u00012E\u0017\u0017\t\u0005Ar#(\u0005\u0005\u0001!=R\u0002B\u0003\u0002\u0011Ia\t\u0001\u0007\nQ\u0007\u0001\t3!B\u0001\t&a\u0015\u0012kA\u0003\u0005/%\tA\u0001A\u0007\u0002\u0011Mi\u001b\u0005B\u0002\u0019\u001fuEA\u0001\u0001\u0005\u001a\u001b\u0011)\u0011\u0001c\u0006\r\u0002a]\u0001k\u0001\u0001\u001e\u0012\u0011\u0001\u00012G\u0007\u0005\u000b\u0005A9\u0001$\u0001\u0019\bA\u001b\t!I\u0002\u0006\u0003!\u0015\u0002TE)\u0004\u000f\u0011y\u0011\"\u0001\u0003\u0001\u001b\u0005AA\"D\u0001\t\u00105VAa\u0003\r\u001bC\r)\u0011\u0001#\u0003\u0019\nE\u001b1\u0001\u0002\u000e\n\u0003!EQW4\u0001\u0006\u001b\u0004!1\u001d\u0001M\u0003;\u001f!\u0001\u0001C\u0002\u000e\u0007\u0015\t\u0001r\u0001M\u0004!\u000e\u0001Qt\u0002\u0003\u0001\u0011\u0015i1!B\u0001\t\na%\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001RB\u0007\u0004\u000b\u0005AI\u0001'\u0003Q\u0007\u0005i\n\u0002B\u0001\t\u000f5!Q!\u0001\u0005\u0007\u0019\u0003Ab\u0001UB\u0002;#!\u0011\u0001C\u0005\u000e\t\u0015\t\u0001R\u0002G\u00011\u001b\u00016AAO\t\t\u0005A!\"\u0004\u0003\u0006\u0003!9A\u0012\u0001\r\b!\u000e\u0015\u0011eA\u0003\u0002\u0011\u0007A\u001a!U\u0002\u0010\t\u000bI\u0011\u0001\u0002\u0001\u000e\u0003!=Q\"\u0001E\t\u001b\u0005A\t\"D\u0001\t\u00135\t\u00012C\u0007\u0002\u0011)\u0001"})
public class FileBasedStorage
extends XmlElementStorage {
    public static final /* synthetic */ KClass $kotlinClass;
    private volatile VirtualFile cachedVirtualFile;
    private LineSeparator lineSeparator;
    private boolean blockSavingTheContent;
    @NotNull
    private volatile File file;
    private final boolean isUseXmlProlog = false;

    static {
        $kotlinClass = Reflection.createKotlinClass(FileBasedStorage.class);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    private final void setFile(File file) {
        this.file = file;
    }

    protected boolean getIsUseXmlProlog() {
        return this.isUseXmlProlog;
    }

    public final void setFile(@Nullable VirtualFile virtualFile, @Nullable File ioFileIfChanged) {
        this.cachedVirtualFile = virtualFile;
        if (ioFileIfChanged != null) {
            this.file = ioFileIfChanged;
        }
    }

    @Override
    @NotNull
    protected FileSaveSession createSaveSession(@NotNull StateMap states) {
        Intrinsics.checkParameterIsNotNull((Object)states, (String)"states");
        return new FileSaveSession(states, this);
    }

    @Nullable
    public final VirtualFile getVirtualFile() {
        VirtualFile result = this.cachedVirtualFile;
        if (result == null) {
            this.cachedVirtualFile = result = LocalFileSystem.getInstance().findFileByIoFile(this.file);
        }
        return this.cachedVirtualFile;
    }

    @Override
    @Nullable
    protected Element loadLocalData() {
        block6: {
            this.blockSavingTheContent = false;
            try {
                VirtualFile file = this.getVirtualFile();
                if (file == null || file.isDirectory() || !file.isValid()) {
                    if (ComponentStoreImplKt.getLOG().isDebugEnabled()) {
                        ComponentStoreImplKt.getLOG().debug("Document was not loaded for " + this.getFileSpec() + " file is " + (file == null ? "null" : "directory"));
                    }
                    break block6;
                }
                if (file.getLength() == 0L) {
                    this.processReadException(null);
                    break block6;
                }
                CharBuffer charBuffer = CharsetToolkit.UTF8_CHARSET.decode(ByteBuffer.wrap(file.contentsToByteArray()));
                CharSequence charSequence = charBuffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"charBuffer");
                this.lineSeparator = FileBasedStorageKt.detectLineSeparators(charSequence, this.getIsUseXmlProlog() ? (LineSeparator)null : LineSeparator.LF);
                return JDOMUtil.loadDocument((CharSequence)charBuffer).detachRootElement();
            }
            catch (JDOMException e) {
                this.processReadException((Exception)((Object)e));
            }
            catch (IOException e) {
                this.processReadException(e);
            }
        }
        return null;
    }

    private final void processReadException(Exception e) {
        boolean contentTruncated = e == null;
        boolean bl = this.blockSavingTheContent = !contentTruncated && (FileBasedStorageKt.isProjectOrModuleFile(this.getFileSpec()) || Intrinsics.areEqual((Object)this.getFileSpec(), (Object)StoragePathMacros.WORKSPACE_FILE));
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            String string;
            if (e != null) {
                ComponentStoreImplKt.getLOG().info((Throwable)e);
            }
            StringBuilder stringBuilder = new StringBuilder().append("Cannot load settings from file '").append(this.file).append("': ");
            if (contentTruncated) {
                string = "content truncated";
            } else {
                Exception exception = e;
                if (exception == null) {
                    Intrinsics.throwNpe();
                }
                string = exception.getMessage();
            }
            new Notification(Notifications.SYSTEM_MESSAGES_GROUP_ID, "Load Settings", stringBuilder.append(string).append("\n").append(this.blockSavingTheContent ? "Please correct the file content" : "File content will be recreated").toString(), NotificationType.WARNING).notify((Project)null);
        }
    }

    @NotNull
    public String toString() {
        return FileUtilKt.getSystemIndependentPath(this.file);
    }

    public FileBasedStorage(@NotNull File file, @NotNull String fileSpec, @NotNull String rootElementName, @Nullable TrackingPathMacroSubstitutor pathMacroManager, @Nullable RoamingType roamingType, @Nullable StreamProvider provider) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)rootElementName, (String)"rootElementName");
        super(fileSpec, rootElementName, pathMacroManager, roamingType, provider);
        this.file = file;
        if (ApplicationManager.getApplication().isUnitTestMode() && StringsKt.startsWith$default((String)file.getPath(), (char)'$', (boolean)false, (int)2)) {
            throw (Throwable)((Object)new AssertionError((Object)("It seems like some macros were not expanded for path: " + file)));
        }
    }

    public /* synthetic */ FileBasedStorage(File file, String string, String string2, TrackingPathMacroSubstitutor trackingPathMacroSubstitutor, RoamingType roamingType, StreamProvider streamProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            trackingPathMacroSubstitutor = null;
        }
        if ((n & 0x10) != 0) {
            roamingType = null;
        }
        if ((n & 0x20) != 0) {
            streamProvider = null;
        }
        this(file, string, string2, trackingPathMacroSubstitutor, roamingType, streamProvider);
    }

    public static final /* synthetic */ void access$setBlockSavingTheContent$0(FileBasedStorage $this, boolean bl) {
        $this.blockSavingTheContent = bl;
    }

    public static final /* synthetic */ void access$setFile$2(FileBasedStorage $this, @NotNull File file) {
        $this.file = file;
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getCachedVirtualFile$3(FileBasedStorage $this) {
        return $this.cachedVirtualFile;
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"^\u0004)ya)\u001b7f'\u00064XmU3tg&|gN\u0003\tGS2,')Y:fIN#xN]1hK*\u00191m\\7\u000b\u0011%tG/\u001a7mS*T!cY8oM&<WO]1uS>t7\u000b^8sK*a\u0002,\u001c7FY\u0016lWM\u001c;Ti>\u0014\u0018mZ3TCZ,7+Z:tS>t'\"\u0005-nY\u0016cW-\\3oiN#xN]1hK*1A(\u001b8jizR1b\u001d;pe\u0006<W\rR1uC*A1\u000b^1uK6\u000b\u0007OC\u0004ti>\u0014\u0018mZ3\u000b\tM\fg/\u001a\u0006\u0005+:LGO\u0003\u0004l_Rd\u0017N\u001c\u0006\fg\u00064X\rT8dC2d\u0017PC\u0004fY\u0016lWM\u001c;\u000b\u000f\u0015cW-\\3oi*\u0019qN]4\u000b\t)$w.\u001c5\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)1\u0001B\u0001\t\u00021\u0001Qa\u0001C\u0002\u0011\u0001a\u0001!B\u0002\u0005\u0003!\u0019A\u0002A\u0003\u0004\t\u000bA)\u0001\u0004\u0001\u0006\u0007\u0011\t\u0001\u0012\u0002\u0007\u0001\u000b\t!\u0011\u0001#\u0003\u0006\u0005\u0011\t\u0001\u0012A\u0003\u0002\u0011\u001b)1\u0001B\u0003\t\r1\u0001Q!\u0001E\t\u000b\t!a\u0001C\u0005\u0006\u0007\u00115\u0001\u0002\u0003\u0007\u0001\u000b\t!i\u0001\u0003\u0005\u0005\u00151\u0011\u0011\u0004C\u0003\u0002\u0011\rIA!C\u0002\u0006\u0003!\r\u00014\u0001\r\u0004[+!1\u0002g\u0003\"\u0007\u0015\t\u00012\u0002M\u0006#\u000e\u0019A1B\u0005\u0002\t\u0001ic\u0003\u0002\u0006\u0019\u000fuEA\u0001\u0001E\b\u001b\u0011)\u0011\u0001C\u0004\r\u0002a9\u0001k\u0001\u0001\"\u0007\u0015\t\u00012\u0002M\u0006#\u000e)AaB\u0005\u0002\t\u0001i\u0011\u0001c\u00046C\u0015\u0001Ca9\u0001\u0019\bu=A\u0001\u0001\u0005\u0005\u001b\r)\u0011\u0001c\u0002\u0019\bA\u001b\u0001!h\u0004\u0005\u0001!)QbA\u0003\u0002\u0011\u0007A\u001a\u0001UB\u0001C\r)\u0011\u0001\u0003\u0002\u0019\u0005E\u001bq\u0001b\u0002\n\u0003\u0011\u0001Q\"\u0001\u0005\u0005\u001b\u0005AI\u0001"})
    protected static class FileSaveSession
    extends XmlElementStorage.XmlElementStorageSaveSession<FileBasedStorage> {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(FileSaveSession.class);
        }

        @Override
        public void save() {
            if (!((FileBasedStorage)this.getStorage()).blockSavingTheContent) {
                super.save();
            }
        }

        @Override
        protected void saveLocally(@Nullable Element element) {
            if (((FileBasedStorage)this.getStorage()).lineSeparator == null) {
                LineSeparator lineSeparator;
                FileBasedStorage fileBasedStorage = (FileBasedStorage)this.getStorage();
                if (((FileBasedStorage)this.getStorage()).getIsUseXmlProlog()) {
                    lineSeparator = LineSeparator.LF;
                } else {
                    LineSeparator lineSeparator2 = LineSeparator.getSystemLineSeparator();
                    lineSeparator = lineSeparator2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)lineSeparator2, (String)"LineSeparator.getSystemLineSeparator()");
                }
                fileBasedStorage.lineSeparator = lineSeparator;
            }
            VirtualFile virtualFile = ((FileBasedStorage)this.getStorage()).getVirtualFile();
            if (element == null) {
                FileBasedStorageKt.deleteFile(((FileBasedStorage)this.getStorage()).file, this, virtualFile);
                ((FileBasedStorage)this.getStorage()).cachedVirtualFile = null;
            } else {
                LineSeparator lineSeparator;
                FileBasedStorage fileBasedStorage = (FileBasedStorage)this.getStorage();
                File file = ((FileBasedStorage)this.getStorage()).file;
                if (((FileBasedStorage)this.getStorage()).getIsUseXmlProlog()) {
                    lineSeparator = ((FileBasedStorage)this.getStorage()).lineSeparator;
                    if (lineSeparator == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    lineSeparator = LineSeparator.LF;
                }
                fileBasedStorage.cachedVirtualFile = FileBasedStorageKt.writeFile(file, this, virtualFile, element, lineSeparator, ((FileBasedStorage)this.getStorage()).getIsUseXmlProlog());
            }
        }

        public FileSaveSession(@NotNull StateMap storageData, @NotNull FileBasedStorage storage2) {
            Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
            Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
            super(storageData, (XmlElementStorage)storage2);
        }
    }
}

