/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.DefaultProjectStoreImpl;
import com.intellij.configurationStore.ProjectStoreImplKt;
import com.intellij.configurationStore.StateLoadPolicy;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.ide.highlighter.ProjectFileType;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StoragePathMacros;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import java.io.File;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u007f\n)\u0001\u0002K]8kK\u000e$8\u000b^8sK\n\u000b7/\u001a\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b%\r|gNZ5hkJ\fG/[8o'R|'/\u001a\u0006\u0013\u0007>l\u0007o\u001c8f]R\u001cFo\u001c:f\u00136\u0004HNC\u0007J!J|'.Z2u'R|'/\u001a\u0006\b_B,g.\u00199j\u0015)\u0019w.\u001c9p]\u0016tGo\u001d\u0006\u0005S6\u0004HN\u0003\u0004ti>\u0014Xm\u001d\u0006\u0007y%t\u0017\u000e\u001e \u000b\u000fA\u0014xN[3di*Y\u0001K]8kK\u000e$\u0018*\u001c9m\u0015)aw.\u00193Q_2L7-\u001f\u0006\u0010'R\fG/\u001a'pC\u0012\u0004v\u000e\\5ds*iq-\u001a;M_\u0006$\u0007k\u001c7jGfTQb]3u\u0019>\fG\rU8mS\u000eL(BC4fiB\u0013xN[3di*11o\u00195f[\u0016TQb\u0015;pe\u0006<WmU2iK6,'\"C4fiN\u001b\u0007.Z7f\u0015%\u0019X\r^*dQ\u0016lWM\u0003\bti>\u0014\u0018mZ3NC:\fw-\u001a:\u000b/M#\u0018\r^3Ti>\u0014\u0018mZ3NC:\fw-\u001a:J[Bd'\"E4fiN#xN]1hK6\u000bg.Y4fe*i1\r\\3beN#xN]1hKNTA!\u00168ji*11n\u001c;mS:T!cZ3u!J|'.Z2u\u0005\u0006\u001cX\rU1uQ*11\u000b\u001e:j]\u001eTAA[1wC*!A.\u00198h\u0015I9W\r\u001e)s_*,7\r\u001e$jY\u0016\u0004\u0016\r\u001e5\u000b!\u001d,Go\u0015;pe\u0006<WmU2iK6,'\u0002F4fi^{'o[:qC\u000e,g)\u001b7f!\u0006$\bNC\fjg>\u0003H/[7jg\u0016$Vm\u001d;M_\u0006$7\u000b]3fI*9!i\\8mK\u0006t'b\u00067pC\u0012\u0004&o\u001c6fGR4%o\\7UK6\u0004H.\u0019;f\u00159!WMZ1vYR\u0004&o\u001c6fGRTq\u0001\u0015:pU\u0016\u001cGO\u0003\rtKR|\u0005\u000f^5nSN,G+Z:u\u0019>\fGm\u00159fK\u0012TQA^1mk\u0016Tqa]3u!\u0006$\bN\u0003\u0005gS2,\u0007+\u0019;i\u0015)\u0011XM\u001a:fg\"4fm\u001d\u0006\u001fkN,w\n\u001c3X_J\\7\u000f]1dK\u000e{g\u000e^3oi&3W\t_5tiNt\u001cA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\r!\u0011\u0001\u0003\u0001\r\u0001\u0015\u0019A!\u0001\u0005\u0003\u0019\u0001)!\u0001\"\u0001\t\u0007\u0015\u0011AQ\u0001E\u0004\u000b\t!1\u0001\u0003\u0003\u0006\u0005\u0011\u001d\u0001\u0012B\u0003\u0004\t\u0011A)\u0001\u0004\u0001\u0006\u0005\u0011\u0015\u00012B\u0003\u0003\t\u0015AA!B\u0002\u0005\f!1A\u0002A\u0003\u0003\t\u0017Aa!B\u0002\u0005\u0003!9A\u0002A\u0003\u0003\t\u0005Aq!B\u0002\u0005\u0007!MA\u0002A\u0003\u0003\t\rA\u0019\"B\u0002\u0005\u0003!]A\u0002A\u0003\u0003\t\u0005A9\"B\u0001\t\u001c\u0015\u0019AA\u0003\u0005\u000e\u0019\u0001)1\u0001\u0002\u0006\t\u001e1\u0001Q!\u0001\u0005\u0010\u000b\t!9\u0002c\b\u0006\u0005\u0011a\u0001RD\u0003\u0004\t)A!\u0003\u0004\u0001\u0006\u0007\u0011)\u0001r\u0005\u0007\u0001\u000b\t!Q\u0001c\n\u0005'1\r\u0011dA\u0003\u0002\u0011\tA\"!G\u0002\u0006\u0003!%\u0001\u0014B\u0017\u0017\t\rg\u0001TB\u0011\u0004\u000b\u0005Aq\u0001G\u0004V\u00079)1\u0001\"\u0004\n\u0003!=Qb\u0001C\b\u0013\u0005Ay!E\u0003\u0005\u0011%\tA\u0001A\u0007\u0002\u0011\u001fi\u0003\u0003\u00022\u00051\u0017\t3!B\u0001\t\ra1Qk\u0001\u0005\u0006\u0007\u0011-\u0011\"\u0001E\u0007\u001b\r!\t\"C\u0001\t\u000e52Ba1\u0007\u0019\u0013\u0005\u001aQ!\u0001\u0005\t1!)6AD\u0003\u0004\t%I\u0011\u0001#\u0005\u000e\u0007\u0011Q\u0011\"\u0001E\t#\u0015!)\"C\u0001\u0005\u00015\t\u0001\u0012C\u0017\r\tM$\u0001dC\u0011\u0004\u000b\u0005A\u0011\u0002G\u0005V\u0007\u0011i1\u0001\u0002\u0007\n\u0003!MQV\u0003\u0003\u000413\t3!B\u0001\t\u0016aU\u0011kA\u0002\u0005\u001a%\tA\u0001AW\u000b\t\rAb\"I\u0002\u0006\u0003!Y\u0001dC)\u0004\u0007\u0011q\u0011\"\u0001E\r[+!1\u0002\u0007\t\"\u0007\u0015\t\u0001b\u0003\r\f#\u000e\u0019A\u0001E\u0005\u0002\u00113i+\u0002B\u0002\u0019\"\u0005\u001aQ!\u0001\u0005\t1!\t6a\u0001C\u0011\u0013\u0005A\t\",\u0006\u0005\u0007a\t\u0012eA\u0003\u0002\u0011-A2\"U\u0002\u0004\tEI\u0011\u0001#\u0007.\u0016\u0011\u0019\u00014E\u0011\u0004\u000b\u0005AQ\u0002G\u0007R\u0007\r!\u0019#C\u0001\u0005\u00025*Ba\u0001M\u0013;\u001f!\u0001\u0001C\n\u000e\u0007\u0015\t\u00012\u0004M\u000e!\u000e\u0001\u0011eA\u0003\u0002\u0011+A*\"U\u0002\u0006\tKI\u0011\u0001\u0002\u0001\u000e\u0003!qQ&\u0006\u0003\u00041Qiz\u0001\u0002\u0001\t*5\u0019Q!\u0001\u0005\u000e15\u00016\u0001A\u0011\u0004\u000b\u0005A)\u0002'\u0006R\u0007\u0015!A#C\u0001\u0005\u00015\tA\u0011A\u0017+\t\tAR#h\u0004\u0005\u0001!-RbA\u0003\u0002\u0011-A2\u0002U\u0002\u0001;\u001f!\u0001\u0001\u0003\f\u000e\u0007\u0015\t\u0001\"\u0004\r\u000e!\u000e\u0005Qt\u0002\u0003\u0001\u0011[i1!B\u0001\t\u001bai\u0001kA\u0001\"\u0007\u0015\t\u0001R\u0003M\u000b#\u000eIA!F\u0005\u0002\t\u0001i\u0011\u0001#\u0007\u000e\u0003\u0011\u0005Q\"\u0001C\u0001k[)Y\u0003Br\u00011\u0015iz\u0001\u0002\u0001\t\f5\u0019Q!\u0001\u0005\u00071\u0019\u00016\u0001A\u0011\u0004\u000b\u0005A\u0019\u0001g\u0001R\u0007\u0015!Q!C\u0001\u0005\u00015\t\u0001R\u0002"})
public abstract class ProjectStoreBase
extends ComponentStoreImpl
implements IProjectStore {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private StorageScheme scheme;
    @NotNull
    private StateLoadPolicy loadPolicy;
    @NotNull
    private final ProjectImpl project;

    static {
        $kotlinClass = Reflection.createKotlinClass(ProjectStoreBase.class);
    }

    @NotNull
    public final StorageScheme getScheme() {
        return this.scheme;
    }

    public final void setScheme(@NotNull StorageScheme storageScheme) {
        Intrinsics.checkParameterIsNotNull((Object)storageScheme, (String)"<set-?>");
        this.scheme = storageScheme;
    }

    @Override
    @NotNull
    public final StateLoadPolicy getLoadPolicy() {
        return this.loadPolicy;
    }

    public final void setLoadPolicy(@NotNull StateLoadPolicy stateLoadPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stateLoadPolicy), (String)"<set-?>");
        this.loadPolicy = stateLoadPolicy;
    }

    @Override
    public final boolean isOptimiseTestLoadSpeed() {
        return Intrinsics.areEqual((Object)((Object)this.loadPolicy), (Object)((Object)StateLoadPolicy.LOAD)) ^ true;
    }

    @Override
    @NotNull
    public final StorageScheme getStorageScheme() {
        return this.scheme;
    }

    @Override
    @NotNull
    public abstract StateStorageManagerImpl getStorageManager();

    @Override
    public final void setOptimiseTestLoadSpeed(boolean value) {
        this.loadPolicy = value ? StateLoadPolicy.NOT_LOAD : StateLoadPolicy.LOAD;
    }

    @Override
    @NotNull
    public String getProjectFilePath() {
        return this.getStorageManager().expandMacro(StoragePathMacros.PROJECT_FILE);
    }

    @Override
    @NotNull
    public final String getWorkspaceFilePath() {
        return this.getStorageManager().expandMacro(StoragePathMacros.WORKSPACE_FILE);
    }

    @Override
    public final void clearStorages() {
        this.getStorageManager().clearStorages();
    }

    @Override
    public final void loadProjectFromTemplate(@NotNull Project defaultProject) {
        Intrinsics.checkParameterIsNotNull((Object)defaultProject, (String)"defaultProject");
        defaultProject.save();
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)defaultProject);
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.DefaultProjectStoreImpl");
        }
        Element element = ((DefaultProjectStoreImpl)iComponentStore).getStateCopy();
        if (element != null) {
            StateStorage stateStorage = StateStorageManagerImpl.getOrCreateStorage$default(this.getStorageManager(), StoragePathMacros.PROJECT_FILE, null, null, null, 14);
            if (stateStorage == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.XmlElementStorage");
            }
            ((XmlElementStorage)stateStorage).setDefaultState(element);
        }
    }

    @Override
    @NotNull
    public final String getProjectBasePath() {
        String path = PathUtilRt.getParentPath((String)this.getProjectFilePath());
        return Intrinsics.areEqual((Object)this.scheme, (Object)StorageScheme.DEFAULT) ? path : PathUtilRt.getParentPath((String)path);
    }

    protected final void setPath(@NotNull String filePath, boolean refreshVfs, boolean useOldWorkspaceContentIfExists) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        StateStorageManagerImpl storageManager2 = this.getStorageManager();
        LocalFileSystem fs = LocalFileSystem.getInstance();
        if (FileUtilRt.extensionEquals((String)filePath, (String)ProjectFileType.DEFAULT_EXTENSION)) {
            this.scheme = StorageScheme.DEFAULT;
            storageManager2.addMacro(StoragePathMacros.PROJECT_FILE, filePath);
            String workspacePath = ProjectStoreImplKt.composeWsPath(filePath);
            storageManager2.addMacro(StoragePathMacros.WORKSPACE_FILE, workspacePath);
            if (refreshVfs) {
                ActionsKt.invokeAndWaitIfNeed((Function0<? extends Unit>)((Function0)new Function0<Unit>(fs, filePath, workspacePath){
                    final /* synthetic */ LocalFileSystem $fs;
                    final /* synthetic */ String $filePath;
                    final /* synthetic */ String $workspacePath;

                    public final void invoke() {
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{this.$fs.refreshAndFindFileByPath(this.$filePath), this.$fs.refreshAndFindFileByPath(this.$workspacePath)});
                    }
                    {
                        this.$fs = localFileSystem;
                        this.$filePath = string;
                        this.$workspacePath = string2;
                        super(0);
                    }
                }));
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.setOptimiseTestLoadSpeed(!new File(filePath).exists());
            }
        } else {
            File workspace;
            String string;
            this.scheme = StorageScheme.DIRECTORY_BASED;
            File file = new File(filePath);
            boolean isDir = !useOldWorkspaceContentIfExists || file.isDirectory();
            StringBuilder stringBuilder = new StringBuilder();
            if (isDir) {
                string = filePath;
            } else {
                String string2 = PathUtilRt.getParentPath((String)filePath);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathUtilRt.getParentPath(filePath)");
            }
            String configDir = stringBuilder.append(string).append("/").append(Project.DIRECTORY_STORE_FOLDER).toString();
            storageManager2.addMacro(StoragePathMacros.PROJECT_CONFIG_DIR, configDir);
            storageManager2.addMacro(StoragePathMacros.PROJECT_FILE, configDir + "/misc.xml");
            storageManager2.addMacro(StoragePathMacros.WORKSPACE_FILE, configDir + "/workspace.xml");
            if (!isDir && !(workspace = new File(this.getWorkspaceFilePath())).exists()) {
                ProjectStoreImplKt.useOldWorkspaceContent(filePath, workspace);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.setOptimiseTestLoadSpeed(!file.exists());
            }
            if (refreshVfs) {
                ActionsKt.invokeAndWaitIfNeed((Function0<? extends Unit>)((Function0)new Function0<Unit>(fs, configDir){
                    final /* synthetic */ LocalFileSystem $fs;
                    final /* synthetic */ String $configDir;

                    public final void invoke() {
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{this.$fs.refreshAndFindFileByPath(this.$configDir)});
                    }
                    {
                        this.$fs = localFileSystem;
                        this.$configDir = string;
                        super(0);
                    }
                }));
            }
        }
    }

    @Override
    @NotNull
    protected final ProjectImpl getProject() {
        return this.project;
    }

    public ProjectStoreBase(@NotNull ProjectImpl project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.scheme = StorageScheme.DEFAULT;
        this.loadPolicy = StateLoadPolicy.LOAD;
    }
}

