/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.SchemeManagerFactoryBase;
import com.intellij.configurationStore.SchemeManagerFactoryImplKt;
import com.intellij.configurationStore.SchemeManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.File;
import java.util.List;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"C\f)A2k\u00195f[\u0016l\u0015M\\1hKJ4\u0015m\u0019;pef\u0014\u0015m]3\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015I\u0019wN\u001c4jOV\u0014\u0018\r^5p]N#xN]3\u000b+M\u001b\u0007.Z7fg6\u000bg.Y4fe\u001a\u000b7\r^8ss*9q\u000e]3oCBL'bB8qi&|gn\u001d\u0006\u0018'\u0016$H/\u001b8hgN\u000bg/\u001b8h\u0007>l\u0007o\u001c8f]RT!bY8na>tWM\u001c;t\u0015\u0019a\u0014N\\5u})\u00012m\\7q_:,g\u000e^'b]\u0006<WM\u001d\u0006\u0011\u0007>l\u0007o\u001c8f]Rl\u0015M\\1hKJT1cZ3u\u0007>l\u0007o\u001c8f]Rl\u0015M\\1hKJT\u0001\"\\1oC\u001e,'o\u001d\u0006\f\u001bV$\u0018M\u00197f\u0019&\u001cHO\u0003\u0004l_Rd\u0017N\u001c\u0006\u0012'\u000eDW-\\3NC:\fw-\u001a:J[Bd'BB*dQ\u0016lWM\u0003\u000bFqR,'O\\1mSj\f'\r\\3TG\",W.\u001a\u0006\u0018W>$H.\u001b8/UZlg\u0006\u00157bi\u001a|'/\u001c+za\u0016TqAT8u\u001dVdGNC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0005\u0019&\u001cHO\u0003\u0003kCZ\f'\u0002B;uS2T\u0011b\u00195fG.\u0004\u0016\r\u001e5\u000b\u0019=\u0014\u0018nZ5oC2\u0004\u0016\r\u001e5\u000b\rM#(/\u001b8h\u0015\u0011a\u0017M\\4\u000b\u0003QS\u0011!\u0012\u0006\u0015GJ,\u0017\r^3TG\",W.Z:NC:\fw-\u001a:\u000b\u001b\u0011L'/Z2u_JLh*Y7f\u0015%\u0001(o\\2fgN|'OC\bTG\",W.\u001a)s_\u000e,7o]8s\u0015-\u0011x.Y7j]\u001e$\u0016\u0010]3\u000b\u0017I{\u0017-\\5oORK\b/\u001a\u0006\u000f'\u000eDW-\\3t\u001b\u0006t\u0017mZ3s\u0015)\u0001\u0018\r\u001e5U_\u001aKG.\u001a\u0006\u0005a\u0006$\bN\u0003\bti>\u0014\u0018mZ3NC:\fw-\u001a:\u000b'M#\u0018\r^3Ti>\u0014\u0018mZ3NC:\fw-\u001a:\u000b\t%l\u0007\u000f\u001c\u0006\u0007gR|'/Z:\u000b\t\u0019KG.\u001a\u0006\u0003S>Tq\u0001\u001d:pG\u0016\u001c8OC\u0005Gk:\u001cG/[8oc)!QK\\5u\u0015\rQg/\u001c\u0006\nMVt7\r^5p]NTAa]1wK*y\u0012\t\u001d9mS\u000e\fG/[8o'\u000eDW-\\3NC:\fw-\u001a:GC\u000e$xN]=\u000b7A\u0013xN[3diN\u001b\u0007.Z7f\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:zU\u000bQ!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0004\t\u0005A\u0001\u0001\u0004\u0001\u0006\u0005\u0011\u0005\u0001RA\u0003\u0003\t\tA1!B\u0002\u0005\u0006!\u0011A\u0002A\u0003\u0003\t\tAA!B\u0002\u0005\b!\u001dA\u0002A\u0003\u0004\t\u000fAY\u0001\u0004\u0001\u0006\u0005\u0011\u001d\u00012B\u0003\u0002\u0011\u001f)1\u0001b\u0003\t\u000f1\u0001Qa\u0001\u0003\u0002\u0011!a\u0001!B\u0002\u0005\u0006!EA\u0002A\u0003\u0004\t\u000bA\u0011\u0002\u0004\u0001\u0006\u0003!UQA\u0001\u0003\t\u0011-)!\u0001\"\u0005\t\u0018\u0015\u0019A!\u0003\u0005\u000b\u0019\u0001)1\u0001b\u0003\t\u00191\u0001Q!\u0001E\r\u000b\t!)\u0002C\u0007\u0006\u0005\u0011Y\u0001\u0002D\u0003\u0004\t\u0017Ai\u0002\u0004\u0001\u0006\u0005\u0011U\u0001bD\u0003\u0003\t3Ai\"B\u0002\u0005\u0006!\u0011B\u0002A\u0003\u0004\t\u000fA1\u0003\u0004\u0001\u0006\u0007\u0011\u0015\u0001r\u0005\u0007\u0001\u000b\t!)\u0001c\n\u0006\u0005\u0011\u0015\u0001BE\u0003\u0003\t\u000fA1#\u0002\u0002\u0005\b!1RA\u0001C\u0011\u0011[)1\u0001B\t\t,1\u0001QA\u0001C\u000b\u0011_)1\u0001\u0002\n\t/1\u0001QA\u0001\u0003\u0013\u0011])!\u0001B\t\t,\u0015\u0019A1\u0002E\u0019\u0019\u0001)1\u0001b\u0003\t31\u0001QA\u0001C\u0006\u0011g)!\u0001B\u000b\t5\u0015\u0011A1\u0006E\u0019\tma\u0019!G\u0002\u0006\u0003!\u0019\u0001dA\r\u0004\u000b\u0005AA\u0001\u0007\u0003\u001e\u0003m]R\u0006\u0004\u0003t\ta)\u0011eA\u0003\u0002\u0011\u0013AJ!V\u0002\u0005\u001b\r!a!C\u0001\t\u000b5&\u000e\u0001B1\u00051\u001b\t3\u001aA\u0003\u0002\u0011\u0019Ia$C\u000f\u0006\u0003!5\u0011\u0002B\u0005\u0004\u000b\u0005Aq\u0001G\u0004\n\t%\u0019Q!\u0001E\b1\u001f\u0001\u001a\"\u0006\b\u0006\u0003!5\u0011\u0002B\u0005\u0004\u000b\u0005Aq\u0001G\u0004\n\t%\u0019Q!\u0001E\b1\u001fa\t\u0001'\u0004\u0019\u000eAMQ\u0013J\u0003\u0002\u0011)Ia$C\u000f\u0006\u0003!5\u0011\u0002B\u0005\u0004\u000b\u0005Aq\u0001G\u0004\n\t%\u0019Q!\u0001E\b1\u001f\u0001\u001a\"\u0006\b\u0006\u0003!5\u0011\u0002B\u0005\u0004\u000b\u0005Aq\u0001G\u0004\n\t%\u0019Q!\u0001E\b1\u001fa\t\u0001'\u0004\u0019\u000eaQ\u0011kA\u0001\u0005\u0014a1\u0011kA\u0001\u0005\u0014U\u001bA!B\u0002\u0005\u000e%\t\u0001rC\u0017\u0016\t-AZ\"h\u0004\u0005\u0001!qQbA\u0003\u0002\u00111AB\u0002U\u0002\u0001C\r)\u0011\u0001\u0003\u0007\u0019\u0019E\u001bQ\u0001b\u0007\n\u0003!iQ\"\u0001\u0005\u000e[)\u0007AaA\t\u0007\t\u0001Ay\"F\u0002\u0006\u0003!9\u0001dB\t\u0007\t\u0003A\u0001#F\u0002\u0006\u0003!=\u0001t\u0002M\u0011;\u001f!\u0001\u0001C\t\u000e\u0007\u0015\t\u0001\u0002\u0004\r\r!\u000e\u0001Q4\u0004\u0003\u0001\u0011Gi\u0011\"B\u0001\t\u001c%)\u0011\u0002B\u0003\u0003\t\u0003A\t\u0001(\u0001\u0019\u001cA\u001b\t!h\u0004\u0005\u0001!\u0015RbA\u0003\u0002\u00119Ab\u0002U\u0002\u0002C=)\u0011\u0001#\b\n\u000b%!QA\u0001C\u0001\u0011\u0001a\u0002!C\u0003\n\t\u0015\u0011A\u0011\u0001E\u00019\u0003Aj\"U\u0002\n\tCI\u0011\u0001C\b\u000e\u0003!iQ\"\u0001E\u0010\u001b\u0005A\u0001#l\u0010\u0005'a!Rt\u0002\u0003\u0001\u0011Si1!B\u0001\t\u0019aa\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\"F\u0007\u0004\u000b\u0005A\u0019\u0003g\tQ\u0007\u0003\t3!B\u0001\t&a\u0015\u0012kA\u0004\u0005)%\t\u0001bE\u0007\u0002\u00115i\u0011\u0001c\n.S\u0011\u0019\u0001\u0004GO\u001c\t\u0001A\u0019#D\f\u0006\u0003!!\u0012BD\u0005\u000e\u000b\u0005Ai!\u0003\u0003\n\u0007\u0015\t\u0001b\u0002\r\b\u0013\u0011I1!B\u0001\t\u0010a=\u0001TB\u0005\u0005\u0013\r)\u0011\u0001#\u000b\u0019*a!\u0002k\u0001\u0001\"\u0007\u0015\t\u0001\u0012\u0006M\u0015#\u000e)A\u0001G\u0005\u0002\t\u0001i\u0011\u0001\u0003\f.\u0016\u0011\u0019\u0001TG\u0011\u0004\u000b\u0005AI\u0003'\u000bR\u0007\r!)$C\u0001\u0005\u0001UbQa\u0003\u0003b\u0002a%\u0011eA\u0003\u0002\u0011\u0007A\u001a!U\u0002\u0004\t\u0013I\u0011\u0001\u0002\u0001"})
public abstract class SchemeManagerFactoryBase
extends SchemesManagerFactory
implements SettingsSavingComponent {
    public static final /* synthetic */ KClass $kotlinClass;
    private final List<SchemeManagerImpl<Scheme, ExternalizableScheme>> managers = ContainerUtil.createLockFreeCopyOnWriteList();

    static {
        $kotlinClass = Reflection.createKotlinClass(SchemeManagerFactoryBase.class);
    }

    @NotNull
    public abstract ComponentManager getComponentManager();

    @NotNull
    public final <T extends Scheme, E extends ExternalizableScheme> SchemesManager<T, E> createSchemesManager(@NotNull String directoryName, @NotNull SchemeProcessor<E> processor, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)directoryName, (String)"directoryName");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        StateStorageManager storageManager2 = ServiceKt.getStateStore(this.getComponentManager()).getStateStorageManager();
        String path = this.checkPath(directoryName);
        StateStorageManager stateStorageManager = storageManager2;
        if (!(stateStorageManager instanceof StateStorageManagerImpl)) {
            stateStorageManager = null;
        }
        StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
        StreamProvider streamProvider = stateStorageManagerImpl != null ? stateStorageManagerImpl.getStreamProvider() : null;
        StateStorageManager stateStorageManager2 = storageManager2;
        Intrinsics.checkExpressionValueIsNotNull((Object)stateStorageManager2, (String)"storageManager");
        SchemeManagerImpl manager = new SchemeManagerImpl(path, processor, streamProvider, this.pathToFile(path, stateStorageManager2), roamingType, (Disposable)this.getComponentManager());
        this.managers.add(manager);
        return manager;
    }

    @NotNull
    public String checkPath(@NotNull String originalPath) {
        Intrinsics.checkParameterIsNotNull((Object)originalPath, (String)"originalPath");
        checkPath.1 error$ = checkPath.1.INSTANCE$;
        if (StringsKt.contains$default((String)originalPath, (char)'\\', (boolean)false, (int)2)) {
            error$.invoke("Path must be system-independent, use forward slash instead of backslash");
        } else if (StringsKt.isEmpty((String)originalPath)) {
            error$.invoke("Path must not be empty");
        }
        return originalPath;
    }

    @NotNull
    public abstract File pathToFile(@NotNull String var1, @NotNull StateStorageManager var2);

    public final void process(@NotNull Function1<? super SchemeManagerImpl<Scheme, ExternalizableScheme>, ? extends Unit> processor) {
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        for (SchemeManagerImpl<Scheme, ExternalizableScheme> manager : this.managers) {
            try {
                SchemeManagerImpl<Scheme, ExternalizableScheme> schemeManagerImpl = manager;
                Intrinsics.checkExpressionValueIsNotNull(schemeManagerImpl, (String)"manager");
                processor.invoke(schemeManagerImpl);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().error("Cannot reload settings for " + ((Object)manager).getClass().getName(), e);
            }
        }
    }

    public final void save() {
        SmartList errors = new SmartList();
        for (SchemeManagerImpl<Scheme, ExternalizableScheme> registeredManager : this.managers) {
            try {
                registeredManager.save((List)errors);
            }
            catch (Throwable e) {
                errors.add((Object)e);
            }
        }
        CompoundRuntimeException.throwIfNotEmpty((List)((List)errors));
    }

    private SchemeManagerFactoryBase() {
    }

    public /* synthetic */ SchemeManagerFactoryBase(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"9\u0006)y\u0012\t\u001d9mS\u000e\fG/[8o'\u000eDW-\\3NC:\fw-\u001a:GC\u000e$xN]=\u000b1M\u001b\u0007.Z7f\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z\u0005\u0006\u001cXMC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0013G>tg-[4ve\u0006$\u0018n\u001c8Ti>\u0014XM\u0003\u0004=S:LGO\u0010\u0006\u0011G>l\u0007o\u001c8f]Rl\u0015M\\1hKJT\u0001cQ8na>tWM\u001c;NC:\fw-\u001a:\u000b\u000f=\u0004XM\\1qS*Q1m\\7q_:,g\u000e^:\u000b'\u001d,GoQ8na>tWM\u001c;NC:\fw-\u001a:\u000b\u0013\rDWmY6QCRD'\u0002D8sS\u001eLg.\u00197QCRD'BB*ue&twM\u0003\u0004l_Rd\u0017N\u001c\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'B\u00039bi\"$vNR5mK*!\u0001/\u0019;i\u00159\u0019Ho\u001c:bO\u0016l\u0015M\\1hKJT1c\u0015;bi\u0016\u001cFo\u001c:bO\u0016l\u0015M\\1hKJTA![7qY*11\u000f^8sKNTAAR5mK*\u0011\u0011n\u001cC\u0002\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011Qa\u0001\u0003\u0002\u0011\u0003a\u0001!B\u0002\u0005\u0004!\u0001A\u0002A\u0003\u0003\t\u0003AA!\u0002\u0002\u0005\u0006!%Qa\u0001\u0003\u0004\u0011\u000fa\u0001!\u0002\u0002\u0005\u0007!\u001dQ!\u0001\u0005\b\u000b\r!I\u0001#\u0004\r\u0001\u0015\t\u0001rB\u0003\u0003\t\u0017A\u0001\"\u0002\u0002\u0005\r!5QA\u0001\u0003\u0004\u0011+)!\u0001B\u0004\t\u0017\u0015\u0019Aq\u0002\u0005\u000b\u0019\u0001)!\u0001b\u0003\t\u0019\u0015\u0019A\u0011\u0003E\f\u0019\u0001)!\u0001\"\u0005\t\u0018\u0015\u0011Aq\u0002\u0005\u000b\t\u0005a!!G\u0002\u0006\u0003!\r\u00014A\u0017\u000e\t-$\u0001dA\u0011\u0004\u000b\u0005A9\u0001g\u0002%WU\u001bA!D\u0002\u0005\u000b%\t\u0001\u0002B\u0017\u0016\t-AZ!h\u0004\u0005\u0001!1QbA\u0003\u0002\u0011\u0015AR\u0001U\u0002\u0001C\r)\u0011\u0001C\u0003\u0019\u000bE\u001bQ\u0001b\u0003\n\u0003!5Q\"\u0001E\u0007[\u007f!1\u0002'\u0005\u001e\u0010\u0011\u0001\u0001\"C\u0007\u0004\u000b\u0005AQ\u0001G\u0003Q\u0007\u0001iz\u0001\u0002\u0001\t\u00145\u0019Q!\u0001\u0005\t1!\u00016\u0011A\u0011\u0004\u000b\u0005A\u0011\u0002G\u0005R\u0007\u001d!\t\"C\u0001\t\u00145\t\u0001RB\u0007\u0002\u0011))D\"B\u0006\u0005G\u0004A*!I\u0002\u0006\u0003!\u0011\u0001DA)\u0004\u0007\u0011\u0015\u0011\"\u0001\u0003\u0001"})
    private static final class ApplicationSchemeManagerFactory
    extends SchemeManagerFactoryBase {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(ApplicationSchemeManagerFactory.class);
        }

        @Override
        @NotNull
        public ComponentManager getComponentManager() {
            ComponentManager componentManager = (ComponentManager)ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentManager, (String)"ApplicationManager.getApplication()");
            return componentManager;
        }

        @Override
        @NotNull
        public String checkPath(@NotNull String originalPath) {
            Intrinsics.checkParameterIsNotNull((Object)originalPath, (String)"originalPath");
            String path = super.checkPath(originalPath);
            if (StringsKt.startsWith$default((String)path, (String)SchemeManagerFactoryImplKt.getROOT_CONFIG(), (boolean)false, (int)2)) {
                path = StringsKt.substring((String)path, (int)(SchemeManagerFactoryImplKt.getROOT_CONFIG().length() + 1));
                String message = "Path must not contains ROOT_CONFIG macro, corrected: " + path;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                ComponentStoreImplKt.getLOG().warn(message);
            }
            return path;
        }

        @Override
        @NotNull
        public File pathToFile(@NotNull String path, @NotNull StateStorageManager storageManager2) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)storageManager2, (String)"storageManager");
            return new File(storageManager2.expandMacros(SchemeManagerFactoryImplKt.getROOT_CONFIG() + "/" + path));
        }

        public ApplicationSchemeManagerFactory() {
            super(null);
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u001c\u0006)Y\u0002K]8kK\u000e$8k\u00195f[\u0016l\u0015M\\1hKJ4\u0015m\u0019;pefT\u0001dU2iK6,W*\u00198bO\u0016\u0014h)Y2u_JL()Y:f\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*\u00112m\u001c8gS\u001e,(/\u0019;j_:\u001cFo\u001c:f\u0015\u0019a\u0014N\\5u})9\u0001O]8kK\u000e$(b\u0002)s_*,7\r\u001e\u0006\b_B,g.\u00199j\u0015A\u0019w.\u001c9p]\u0016tG/T1oC\u001e,'OC\nhKR\u001cu.\u001c9p]\u0016tG/T1oC\u001e,'O\u0003\u0006qCRDGk\u001c$jY\u0016TA\u0001]1uQ*11\u000b\u001e:j]\u001eTaa[8uY&t'BD:u_J\fw-Z'b]\u0006<WM\u001d\u0006\u0014'R\fG/Z*u_J\fw-Z'b]\u0006<WM\u001d\u0006\u000bG>l\u0007o\u001c8f]R\u001c(\u0002B5na2Taa\u001d;pe\u0016\u001c(\u0002\u0002$jY\u0016TAA[1wC*\u0011\u0011n\u001c\u0006\u0005Y\u0006twMc\u0001\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)1\u0001B\u0001\t\u00021\u0001Qa\u0001C\u0002\u0011\u0001a\u0001!\u0002\u0002\u0005\u0002!!QA\u0001C\u0003\u0011\r)1\u0001B\u0002\t\b1\u0001QA\u0001\u0003\u0004\u0011\u000f)\u0011\u0001C\u0004\u0006\u0007\u0011%\u0001R\u0002\u0007\u0001\u000b\t!)\u0001#\u0005\u0006\u0005\u0011-\u0001\"C\u0003\u0003\t\u0019A\u0019\"B\u0002\u0005\u000e!AA\u0002A\u0003\u0002\u0011+)!\u0001b\u0004\t\u0017\u0015\u0019A\u0001\u0003\u0005\u000b\u0019\u0001)!\u0001\u0002\u0005\t\u0015\u0015\u0011Aq\u0002E\f\u000b\t!\u0019\u0002#\u0004\u0006\u0005\u00115\u0001\u0002\u0003\u0003\u0002\u0019\tI2!B\u0001\t\u0004a\rQ\u0006\u0005\u0003l\ta%\u0011eA\u0003\u0002\u0011\u000fA:!V\u0002\t\u000b\r!I!C\u0001\t\t5\u0019A!B\u0005\u0002\u0011\u0011iC\u0002B1\u00051\r\t3!B\u0001\t\ba\u001dQk\u0001\u0003\u0006\u0007\u0011\u0019\u0011\"\u0001\u0005\u0005[\u007f!1\u0002g\u0003\u001e\u0010\u0011\u0001\u0001BB\u0007\u0004\u000b\u0005AQ\u0001G\u0003Q\u0007\u0001iz\u0001\u0002\u0001\t\u00105\u0019Q!\u0001\u0005\b1\u001d\u00016\u0011A\u0011\u0004\u000b\u0005A\t\u0002'\u0005R\u0007\u001d!Y!C\u0001\t\u00135\t\u0001BC\u0007\u0002\u0011+)l#b\u000b\u0005G\u0004A*!h\u0004\u0005\u0001!\u0019QbA\u0003\u0002\u0011\u000fA:\u0001U\u0002\u0001C\r)\u0011\u0001\u0003\u0002\u0019\u0005E\u001bQ\u0001\"\u0002\n\u0003\u0011\u0001Q\"\u0001\u0005\u0005"})
    private static final class ProjectSchemeManagerFactory
    extends SchemeManagerFactoryBase {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final Project componentManager;
        private final Project project;

        static {
            $kotlinClass = Reflection.createKotlinClass(ProjectSchemeManagerFactory.class);
        }

        @NotNull
        public Project getComponentManager() {
            return this.componentManager;
        }

        @Override
        @NotNull
        public File pathToFile(@NotNull String path, @NotNull StateStorageManager storageManager2) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)storageManager2, (String)"storageManager");
            return new File(this.project.getBasePath(), ProjectUtil.isDirectoryBased(this.project) ? Project.DIRECTORY_STORE_FOLDER + "/" + path : "." + path);
        }

        public ProjectSchemeManagerFactory(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            super(null);
            this.componentManager = this.project = project;
        }
    }
}

