/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.Patches;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.HashSet;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.EventSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SuspendContextImpl
extends XSuspendContext
implements SuspendContext {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.SuspendContextImpl");
    private final DebugProcessImpl myDebugProcess;
    private final int mySuspendPolicy;
    private ThreadReferenceProxyImpl myThread;
    boolean myIsVotedForResume;
    protected int myVotesToVote;
    protected Set<ThreadReferenceProxyImpl> myResumedThreads;
    private final EventSet myEventSet;
    private volatile boolean myIsResumed;
    public ConcurrentLinkedQueue<SuspendContextCommandImpl> myPostponedCommands;
    public volatile boolean myInProgress;
    private final HashSet<ObjectReference> myKeptReferences;
    private EvaluationContextImpl myEvaluationContext;
    private JavaExecutionStack myActiveExecutionStack;
    private static final Comparator<JavaExecutionStack> THREADS_COMPARATOR = new Comparator<JavaExecutionStack>(){

        @Override
        public int compare(JavaExecutionStack th1, JavaExecutionStack th2) {
            int res = Comparing.compare((boolean)th2.getThreadProxy().isSuspended(), (boolean)th1.getThreadProxy().isSuspended());
            if (res == 0) {
                return th1.getDisplayName().compareToIgnoreCase(th2.getDisplayName());
            }
            return res;
        }
    };

    SuspendContextImpl(@NotNull DebugProcessImpl debugProcess, int suspendPolicy, int eventVotes, EventSet set) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/engine/SuspendContextImpl", "<init>"));
        }
        this.myIsVotedForResume = true;
        this.myPostponedCommands = new ConcurrentLinkedQueue();
        this.myKeptReferences = new HashSet();
        this.myEvaluationContext = null;
        this.myDebugProcess = debugProcess;
        this.mySuspendPolicy = suspendPolicy;
        this.myVotesToVote = eventVotes;
        this.myEventSet = set;
    }

    public void setThread(ThreadReference thread) {
        this.assertNotResumed();
        ThreadReferenceProxyImpl threadProxy = this.myDebugProcess.getVirtualMachineProxy().getThreadReferenceProxy(thread);
        LOG.assertTrue(this.myThread == null || this.myThread == threadProxy);
        this.myThread = threadProxy;
    }

    protected abstract void resumeImpl();

    protected void resume() {
        this.assertNotResumed();
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG) {
                for (ObjectReference objectReference : this.myKeptReferences) {
                    DebuggerUtilsEx.enableCollection(objectReference);
                }
                this.myKeptReferences.clear();
            }
            SuspendContextCommandImpl cmd = this.pollPostponedCommand();
            while (cmd != null) {
                cmd.notifyCancelled();
                cmd = this.pollPostponedCommand();
            }
            this.resumeImpl();
        }
        finally {
            this.myIsResumed = true;
        }
    }

    private void assertNotResumed() {
        if (this.myIsResumed && this.myDebugProcess.isAttached()) {
            LOG.error("Cannot access SuspendContext. SuspendContext is resumed.");
        }
    }

    @Nullable
    public EventSet getEventSet() {
        this.assertNotResumed();
        return this.myEventSet;
    }

    @NotNull
    public DebugProcessImpl getDebugProcess() {
        this.assertNotResumed();
        DebugProcessImpl debugProcessImpl = this.myDebugProcess;
        if (debugProcessImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/SuspendContextImpl", "getDebugProcess"));
        }
        return debugProcessImpl;
    }

    public DebugProcessImpl getDebugProcessNoAssert() {
        return this.myDebugProcess;
    }

    public StackFrameProxyImpl getFrameProxy() {
        this.assertNotResumed();
        try {
            return this.myThread != null && this.myThread.frameCount() > 0 ? this.myThread.frame(0) : null;
        }
        catch (EvaluateException ignored) {
            return null;
        }
    }

    @Nullable
    public ThreadReferenceProxyImpl getThread() {
        return this.myThread;
    }

    public int getSuspendPolicy() {
        return this.mySuspendPolicy;
    }

    public void doNotResumeHack() {
        this.assertNotResumed();
        this.myVotesToVote = 1000000000;
    }

    public boolean isExplicitlyResumed(@Nullable ThreadReferenceProxyImpl thread) {
        return this.myResumedThreads != null && this.myResumedThreads.contains(thread);
    }

    public boolean suspends(ThreadReferenceProxyImpl thread) {
        this.assertNotResumed();
        if (this.isEvaluating()) {
            return false;
        }
        switch (this.getSuspendPolicy()) {
            case 2: {
                return !this.isExplicitlyResumed(thread);
            }
            case 1: {
                return thread == this.getThread();
            }
        }
        return false;
    }

    public boolean isEvaluating() {
        this.assertNotResumed();
        return this.myEvaluationContext != null;
    }

    public EvaluationContextImpl getEvaluationContext() {
        return this.myEvaluationContext;
    }

    public boolean isResumed() {
        return this.myIsResumed;
    }

    public void setIsEvaluating(EvaluationContextImpl evaluationContext) {
        this.assertNotResumed();
        this.myEvaluationContext = evaluationContext;
    }

    public String toString() {
        if (this.myEventSet != null) {
            return this.myEventSet.toString();
        }
        return this.myThread != null ? this.myThread.toString() : DebuggerBundle.message((String)"string.null.context", (Object[])new Object[0]);
    }

    public void keep(ObjectReference reference) {
        boolean added;
        if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG && (added = this.myKeptReferences.add((Object)reference))) {
            DebuggerUtilsEx.disableCollection(reference);
        }
    }

    public final void postponeCommand(SuspendContextCommandImpl command) {
        if (!this.isResumed()) {
            command.hold();
            this.myPostponedCommands.add(command);
        } else {
            command.notifyCancelled();
        }
    }

    public final SuspendContextCommandImpl pollPostponedCommand() {
        return this.myPostponedCommands.poll();
    }

    @Nullable
    public JavaExecutionStack getActiveExecutionStack() {
        return this.myActiveExecutionStack;
    }

    public void initExecutionStacks(ThreadReferenceProxyImpl activeThread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myThread == null) {
            this.myThread = activeThread;
        }
        if (activeThread != null) {
            this.myActiveExecutionStack = new JavaExecutionStack(activeThread, this.myDebugProcess, this.myThread == activeThread);
            this.myActiveExecutionStack.initTopFrame();
        }
    }

    public void computeExecutionStacks(final XSuspendContext.XExecutionStackContainer container) {
        this.myDebugProcess.getManagerThread().schedule(new SuspendContextCommandImpl(this){

            @Override
            public void contextAction() throws Exception {
                ArrayList<JavaExecutionStack> res = new ArrayList<JavaExecutionStack>();
                Collection<ThreadReferenceProxyImpl> threads = SuspendContextImpl.this.getDebugProcess().getVirtualMachineProxy().allThreads();
                JavaExecutionStack currentStack = null;
                for (ThreadReferenceProxyImpl thread : threads) {
                    boolean current = thread == SuspendContextImpl.this.myThread;
                    JavaExecutionStack stack = new JavaExecutionStack(thread, SuspendContextImpl.this.myDebugProcess, current);
                    if (!current) {
                        res.add(stack);
                        continue;
                    }
                    currentStack = stack;
                }
                Collections.sort(res, THREADS_COMPARATOR);
                if (currentStack != null) {
                    res.add(0, currentStack);
                }
                container.addExecutionStack(res, true);
            }
        });
    }
}

