/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;

public class BlockStatementEvaluator
implements Evaluator {
    protected Evaluator[] myStatements;

    public BlockStatementEvaluator(Evaluator[] statements) {
        this.myStatements = statements;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Object result = context.getSuspendContext().getDebugProcess().getVirtualMachineProxy().mirrorOfVoid();
        for (Evaluator statement : this.myStatements) {
            result = statement.evaluate(context);
        }
        return result;
    }

    @Override
    public Modifier getModifier() {
        return this.myStatements.length > 0 ? this.myStatements[this.myStatements.length - 1].getModifier() : null;
    }
}

