/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions.impl;

import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetEditorSettingsAction
extends ActionGroup
implements DumbAware {
    @NotNull
    private final TextDiffSettingsHolder.TextDiffSettings myTextSettings;
    @NotNull
    private final List<? extends Editor> myEditors;
    @NotNull
    private final EditorSettingToggleAction[] myActions;

    public SetEditorSettingsAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull List<? extends Editor> editors) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/actions/impl/SetEditorSettingsAction", "<init>"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/actions/impl/SetEditorSettingsAction", "<init>"));
        }
        super("Editor Settings", null, AllIcons.General.SecondaryGroup);
        this.setPopup(true);
        this.myTextSettings = settings;
        this.myEditors = editors;
        for (Editor editor : this.myEditors) {
            ((EditorGutterComponentEx)editor.getGutter()).setGutterPopupGroup(this);
        }
        this.myActions = new EditorSettingToggleAction[]{new EditorSettingToggleAction("EditorToggleShowWhitespaces"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isShowWhitespaces();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setShowWhiteSpaces(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsAction$1", "apply"));
                }
                if (editor.getSettings().isWhitespacesShown() != value) {
                    editor.getSettings().setWhitespacesShown(value);
                    editor.getComponent().repaint();
                }
            }
        }, new EditorSettingToggleAction("EditorToggleShowLineNumbers"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isShowLineNumbers();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setShowLineNumbers(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsAction$2", "apply"));
                }
                if (editor.getSettings().isLineNumbersShown() != value) {
                    editor.getSettings().setLineNumbersShown(value);
                    editor.getComponent().repaint();
                }
            }
        }, new EditorSettingToggleAction("EditorToggleShowIndentLines"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isShowIndentLines();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setShowIndentLines(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsAction$3", "apply"));
                }
                if (editor.getSettings().isIndentGuidesShown() != value) {
                    editor.getSettings().setIndentGuidesShown(value);
                    editor.getComponent().repaint();
                }
            }
        }, new EditorSettingToggleAction("EditorToggleUseSoftWraps"){
            private boolean myForcedSoftWrap;

            @Override
            public boolean isSelected() {
                return this.myForcedSoftWrap || SetEditorSettingsAction.this.myTextSettings.isUseSoftWraps();
            }

            @Override
            public void setSelected(boolean state) {
                this.myForcedSoftWrap = false;
                SetEditorSettingsAction.this.myTextSettings.setUseSoftWraps(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsAction$4", "apply"));
                }
                if (editor.getSettings().isUseSoftWraps() != value) {
                    editor.getSettings().setUseSoftWraps(value);
                }
            }

            @Override
            public void applyDefaults(@NotNull List<? extends Editor> editors) {
                if (editors == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/actions/impl/SetEditorSettingsAction$4", "applyDefaults"));
                }
                for (Editor editor : editors) {
                    if (editor == null || editor.getUserData(EditorImpl.FORCED_SOFT_WRAPS) == null) continue;
                    this.myForcedSoftWrap = true;
                }
                super.applyDefaults(editors);
            }
        }};
    }

    public void applyDefaults() {
        for (EditorSettingToggleAction action : this.myActions) {
            action.applyDefaults(this.myEditors);
        }
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        ArrayList<Object> result = new ArrayList<Object>();
        ContainerUtil.addAll(result, (Object[])this.myActions);
        result.add(Separator.getInstance());
        result.add(ActionManager.getInstance().getAction("Diff.EditorGutterPopupMenu"));
        AnAction[] anActionArray = (AnAction[])ContainerUtil.toArray(result, (Object[])new AnAction[result.size()]);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/impl/SetEditorSettingsAction", "getChildren"));
        }
        return anActionArray;
    }

    private abstract class EditorSettingToggleAction
    extends ToggleAction
    implements DumbAware {
        private EditorSettingToggleAction(String actionId) {
            if (actionId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorSettingToggleAction", "<init>"));
            }
            EmptyAction.setupAction((AnAction)this, (String)actionId, null);
        }

        public boolean isSelected(AnActionEvent e) {
            return this.isSelected();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.setSelected(state);
            for (Editor editor : SetEditorSettingsAction.this.myEditors) {
                if (editor == null) continue;
                this.apply(editor, state);
            }
        }

        public abstract boolean isSelected();

        public abstract void setSelected(boolean var1);

        public abstract void apply(@NotNull Editor var1, boolean var2);

        public void applyDefaults(@NotNull List<? extends Editor> editors) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorSettingToggleAction", "applyDefaults"));
            }
            for (Editor editor : editors) {
                if (editor == null) continue;
                this.apply(editor, this.isSelected());
            }
        }
    }
}

