/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.binary.ThreesideBinaryDiffViewer;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryMergeTool
implements MergeTool {
    public static final BinaryMergeTool INSTANCE = new BinaryMergeTool();

    @NotNull
    public MergeTool.MergeViewer createComponent(@NotNull MergeContext context, @NotNull MergeRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/BinaryMergeTool", "createComponent"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/BinaryMergeTool", "createComponent"));
        }
        BinaryMergeViewer binaryMergeViewer = new BinaryMergeViewer(context, (ThreesideMergeRequest)request);
        if (binaryMergeViewer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/BinaryMergeTool", "createComponent"));
        }
        return binaryMergeViewer;
    }

    public boolean canShow(@NotNull MergeContext context, @NotNull MergeRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/BinaryMergeTool", "canShow"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/BinaryMergeTool", "canShow"));
        }
        if (!(request instanceof ThreesideMergeRequest)) {
            return false;
        }
        MergeUtil.ProxyDiffContext diffContext = new MergeUtil.ProxyDiffContext(context);
        for (DiffContent diffContent : ((ThreesideMergeRequest)request).getContents()) {
            if (BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE.canShowContent(diffContent, diffContext)) continue;
            return false;
        }
        return true;
    }

    public static class BinaryMergeViewer
    implements MergeTool.MergeViewer {
        @NotNull
        private final MergeContext myMergeContext;
        @NotNull
        private final ThreesideMergeRequest myMergeRequest;
        @NotNull
        private final DiffContext myDiffContext;
        @NotNull
        private final ContentDiffRequest myDiffRequest;
        @NotNull
        private final MyThreesideViewer myViewer;

        public BinaryMergeViewer(@NotNull MergeContext context, @NotNull ThreesideMergeRequest request) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "<init>"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "<init>"));
            }
            this.myMergeContext = context;
            this.myMergeRequest = request;
            this.myDiffContext = new MergeUtil.ProxyDiffContext(this.myMergeContext);
            this.myDiffRequest = new SimpleDiffRequest(this.myMergeRequest.getTitle(), BinaryMergeViewer.getDiffContents(this.myMergeRequest), BinaryMergeViewer.getDiffContentTitles(this.myMergeRequest));
            this.myViewer = new MyThreesideViewer(this.myDiffContext, (DiffRequest)this.myDiffRequest);
        }

        @NotNull
        private static List<DiffContent> getDiffContents(@NotNull ThreesideMergeRequest mergeRequest) {
            if (mergeRequest == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeRequest", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "getDiffContents"));
            }
            ArrayList arrayList = ContainerUtil.newArrayList((Iterable)mergeRequest.getContents());
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "getDiffContents"));
            }
            return arrayList;
        }

        @NotNull
        private static List<String> getDiffContentTitles(@NotNull ThreesideMergeRequest mergeRequest) {
            if (mergeRequest == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeRequest", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "getDiffContentTitles"));
            }
            List<String> list = MergeUtil.notNullizeContentTitles(mergeRequest.getContentTitles());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "getDiffContentTitles"));
            }
            return list;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myViewer.getComponent();
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "getComponent"));
            }
            return jComponent;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myViewer.getPreferredFocusedComponent();
        }

        @NotNull
        public MergeTool.ToolbarComponents init() {
            MergeTool.ToolbarComponents components = new MergeTool.ToolbarComponents();
            FrameDiffTool.ToolbarComponents init = this.myViewer.init();
            components.statusPanel = init.statusPanel;
            components.toolbarActions = init.toolbarActions;
            components.closeHandler = new BooleanGetter(){

                public boolean get() {
                    return MergeUtil.showExitWithoutApplyingChangesDialog(BinaryMergeViewer.this, (MergeRequest)BinaryMergeViewer.this.myMergeRequest, BinaryMergeViewer.this.myMergeContext);
                }
            };
            MergeTool.ToolbarComponents toolbarComponents = components;
            if (toolbarComponents == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "init"));
            }
            return toolbarComponents;
        }

        @Nullable
        public Action getResolveAction(final @NotNull MergeResult result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "getResolveAction"));
            }
            if (result == MergeResult.RESOLVED) {
                return null;
            }
            String caption = MergeUtil.getResolveActionTitle(result, (MergeRequest)this.myMergeRequest, this.myMergeContext);
            return new AbstractAction(caption){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (result == MergeResult.CANCEL && !MergeUtil.showExitWithoutApplyingChangesDialog(BinaryMergeViewer.this, (MergeRequest)BinaryMergeViewer.this.myMergeRequest, BinaryMergeViewer.this.myMergeContext)) {
                        return;
                    }
                    BinaryMergeViewer.this.myMergeContext.finishMerge(result);
                }
            };
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myViewer);
        }

        @NotNull
        public MyThreesideViewer getViewer() {
            MyThreesideViewer myThreesideViewer = this.myViewer;
            if (myThreesideViewer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer", "getViewer"));
            }
            return myThreesideViewer;
        }

        private static class MyThreesideViewer
        extends ThreesideBinaryDiffViewer {
            public MyThreesideViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer$MyThreesideViewer", "<init>"));
                }
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/BinaryMergeTool$BinaryMergeViewer$MyThreesideViewer", "<init>"));
                }
                super(context, request);
            }

            @Override
            public void rediff(boolean trySync) {
            }
        }
    }
}

