/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestStateStorage
implements Disposable {
    private static final File TEST_HISTORY_PATH = new File(PathManager.getSystemPath(), "testHistory");
    private final File myFile;
    private static final Logger LOG = Logger.getInstance(TestStateStorage.class);
    @Nullable
    private PersistentHashMap<String, Record> myMap;
    private volatile ScheduledFuture<?> myMapFlusher;

    public static File getTestHistoryRoot(Project project) {
        return new File(TEST_HISTORY_PATH, project.getLocationHash());
    }

    public static TestStateStorage getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/TestStateStorage", "getInstance"));
        }
        return (TestStateStorage)ServiceManager.getService((Project)project, TestStateStorage.class);
    }

    public TestStateStorage(Project project) {
        this.myFile = new File(TestStateStorage.getTestHistoryRoot(project).getPath() + "/testStateMap");
        FileUtilRt.createParentDirs((File)this.myFile);
        try {
            this.myMap = this.initializeMap();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        this.myMapFlusher = FlushingDaemon.everyFiveSeconds(new Runnable(){

            @Override
            public void run() {
                TestStateStorage.this.flushMap();
            }
        });
        Disposer.register((Disposable)project, (Disposable)this);
    }

    protected PersistentHashMap<String, Record> initializeMap() throws IOException {
        return (PersistentHashMap)IOUtil.openCleanOrResetBroken(TestStateStorage.getComputable(this.myFile), (File)this.myFile);
    }

    private synchronized void flushMap() {
        if (this.myMapFlusher == null) {
            return;
        }
        if (this.myMap != null && this.myMap.isDirty()) {
            this.myMap.force();
        }
    }

    @NotNull
    private static ThrowableComputable<PersistentHashMap<String, Record>, IOException> getComputable(final File file) {
        ThrowableComputable<PersistentHashMap<String, Record>, IOException> throwableComputable = new ThrowableComputable<PersistentHashMap<String, Record>, IOException>(){

            public PersistentHashMap<String, Record> compute() throws IOException {
                return new PersistentHashMap(file, (KeyDescriptor)new EnumeratorStringDescriptor(), (DataExternalizer)new DataExternalizer<Record>(){

                    public void save(@NotNull DataOutput out, Record value) throws IOException {
                        if (out == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/execution/TestStateStorage$2$1", "save"));
                        }
                        out.writeInt(value.magnitude);
                        out.writeLong(value.date.getTime());
                    }

                    public Record read(@NotNull DataInput in) throws IOException {
                        if (in == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/execution/TestStateStorage$2$1", "read"));
                        }
                        return new Record(in.readInt(), new Date(in.readLong()));
                    }
                });
            }
        };
        if (throwableComputable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/TestStateStorage", "getComputable"));
        }
        return throwableComputable;
    }

    @Nullable
    public synchronized Record getState(String testUrl) {
        try {
            return this.myMap == null ? null : (Record)this.myMap.get((Object)testUrl);
        }
        catch (IOException e) {
            this.thingsWentWrongLetsReinitialize(e);
            return null;
        }
    }

    public synchronized void writeState(@NotNull String testUrl, Record record) {
        if (testUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testUrl", "com/intellij/execution/TestStateStorage", "writeState"));
        }
        if (this.myMap == null) {
            return;
        }
        try {
            this.myMap.put((Object)testUrl, (Object)record);
        }
        catch (IOException e) {
            this.thingsWentWrongLetsReinitialize(e);
        }
    }

    public synchronized void dispose() {
        this.myMapFlusher.cancel(false);
        this.myMapFlusher = null;
        if (this.myMap == null) {
            return;
        }
        try {
            this.myMap.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void thingsWentWrongLetsReinitialize(IOException e) {
        try {
            if (this.myMap != null) {
                try {
                    this.myMap.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                IOUtil.deleteAllFilesStartingWith((File)this.myFile);
            }
            this.myMap = this.initializeMap();
            LOG.error("Repaired after crash", (Throwable)e);
        }
        catch (IOException e1) {
            LOG.error("Cannot repair", (Throwable)e1);
            this.myMap = null;
        }
    }

    public static class Record {
        public final int magnitude;
        public final Date date;

        public Record(int magnitude, Date date) {
            this.magnitude = magnitude;
            this.date = date;
        }
    }
}

