/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.execution.ui.AlternativeJREPanel;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.util.JreVersionDetector;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationConfigurable
extends SettingsEditor<ApplicationConfiguration>
implements PanelWithAnchor {
    private CommonJavaParametersPanel myCommonProgramParameters;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myMainClass;
    private LabeledComponent<ModulesComboBox> myModule;
    private JPanel myWholePanel;
    private final ConfigurationModuleSelector myModuleSelector;
    private AlternativeJREPanel myAlternativeJREPanel;
    private JCheckBox myShowSwingInspectorCheckbox;
    private final JreVersionDetector myVersionDetector;
    private final Project myProject;
    private JComponent myAnchor;

    public ApplicationConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myModuleSelector = new ConfigurationModuleSelector(project, (ModulesComboBox)((Object)this.myModule.getComponent()));
        this.myCommonProgramParameters.setModuleContext(this.myModuleSelector.getModule());
        ((ModulesComboBox)((Object)this.myModule.getComponent())).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationConfigurable.this.myCommonProgramParameters.setModuleContext(ApplicationConfigurable.this.myModuleSelector.getModule());
            }
        });
        ClassBrowser.createApplicationClassBrowser(project, this.myModuleSelector).setField(this.getMainClassField());
        this.myVersionDetector = new JreVersionDetector();
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myMainClass, this.myCommonProgramParameters, this.myAlternativeJREPanel, this.myModule});
    }

    public void applyEditorTo(ApplicationConfiguration configuration) throws ConfigurationException {
        this.myCommonProgramParameters.applyTo(configuration);
        this.myModuleSelector.applyTo(configuration);
        String className = this.getMainClassField().getText();
        PsiClass aClass = this.myModuleSelector.findClass(className);
        configuration.MAIN_CLASS_NAME = aClass != null ? JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass) : className;
        configuration.ALTERNATIVE_JRE_PATH = this.myAlternativeJREPanel.getPath();
        configuration.ALTERNATIVE_JRE_PATH_ENABLED = this.myAlternativeJREPanel.isPathEnabled();
        configuration.ENABLE_SWING_INSPECTOR = (this.myVersionDetector.isJre50Configured(configuration) || this.myVersionDetector.isModuleJre50Configured(configuration)) && this.myShowSwingInspectorCheckbox.isSelected();
        this.updateShowSwingInspector(configuration);
    }

    public void resetEditorFrom(ApplicationConfiguration configuration) {
        this.myCommonProgramParameters.reset(configuration);
        this.myModuleSelector.reset(configuration);
        this.getMainClassField().setText(configuration.MAIN_CLASS_NAME != null ? configuration.MAIN_CLASS_NAME.replaceAll("\\$", "\\.") : "");
        this.myAlternativeJREPanel.init(configuration.ALTERNATIVE_JRE_PATH, configuration.ALTERNATIVE_JRE_PATH_ENABLED);
        this.updateShowSwingInspector(configuration);
    }

    private void updateShowSwingInspector(ApplicationConfiguration configuration) {
        if (this.myVersionDetector.isJre50Configured(configuration) || this.myVersionDetector.isModuleJre50Configured(configuration)) {
            this.myShowSwingInspectorCheckbox.setEnabled(true);
            this.myShowSwingInspectorCheckbox.setSelected(configuration.ENABLE_SWING_INSPECTOR);
            this.myShowSwingInspectorCheckbox.setText(ExecutionBundle.message((String)"show.swing.inspector", (Object[])new Object[0]));
        } else {
            this.myShowSwingInspectorCheckbox.setEnabled(false);
            this.myShowSwingInspectorCheckbox.setSelected(false);
            this.myShowSwingInspectorCheckbox.setText(ExecutionBundle.message((String)"show.swing.inspector.disabled", (Object[])new Object[0]));
        }
    }

    public EditorTextFieldWithBrowseButton getMainClassField() {
        return (EditorTextFieldWithBrowseButton)((Object)this.myMainClass.getComponent());
    }

    public CommonJavaParametersPanel getCommonProgramParameters() {
        return this.myCommonProgramParameters;
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/application/ApplicationConfigurable", "createEditor"));
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myMainClass = new LabeledComponent();
        this.myMainClass.setComponent((JComponent)((Object)new EditorTextFieldWithBrowseButton(this.myProject, true, new JavaCodeFragment.VisibilityChecker(){

            public JavaCodeFragment.VisibilityChecker.Visibility isDeclarationVisible(PsiElement declaration, PsiElement place) {
                PsiClass aClass;
                if (declaration instanceof PsiClass && (ConfigurationUtil.MAIN_CLASS.value((Object)(aClass = (PsiClass)declaration)) && PsiMethodUtil.findMainMethod((PsiClass)aClass) != null || place.getParent() != null && ApplicationConfigurable.this.myModuleSelector.findClass(((PsiClass)declaration).getQualifiedName()) != null)) {
                    return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
                }
                return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
            }
        })));
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myMainClass.setAnchor(anchor);
        this.myCommonProgramParameters.setAnchor(anchor);
        this.myAlternativeJREPanel.setAnchor(anchor);
        this.myModule.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        AlternativeJREPanel alternativeJREPanel;
        LabeledComponent labeledComponent;
        CommonJavaParametersPanel commonJavaParametersPanel;
        JPanel jPanel;
        this.createUIComponents();
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCommonProgramParameters = commonJavaParametersPanel = new CommonJavaParametersPanel();
        jPanel.add((Component)commonJavaParametersPanel, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        LabeledComponent<EditorTextFieldWithBrowseButton> labeledComponent2 = this.myMainClass;
        labeledComponent2.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("application.configuration.main.class.label"));
        labeledComponent2.setLabelLocation("West");
        jPanel.add((Component)labeledComponent2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, new Dimension(-1, 20), null));
        this.myModule = labeledComponent = new LabeledComponent();
        labeledComponent.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("application.configuration.use.classpath.and.jdk.of.module.label"));
        labeledComponent.setLabelLocation("West");
        labeledComponent.setComponentClass("com.intellij.application.options.ModulesComboBox");
        jPanel.add((Component)labeledComponent, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myAlternativeJREPanel = alternativeJREPanel = new AlternativeJREPanel();
        jPanel.add((Component)alternativeJREPanel, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myShowSwingInspectorCheckbox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ExecutionBundle").getString("show.swing.inspector"));
        jPanel.add((Component)jCheckBox, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

