/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.google.common.collect.ImmutableMap;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EnvironmentVariablesData {
    public static final EnvironmentVariablesData DEFAULT = new EnvironmentVariablesData((Map<String, String>)ImmutableMap.of(), true);
    @NonNls
    private static final String ENVS = "envs";
    @NonNls
    private static final String PASS_PARENT_ENVS = "pass-parent-envs";
    @NonNls
    private static final String ENV = "env";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String VALUE = "value";
    private final ImmutableMap<String, String> myEnvs;
    private final boolean myPassParentEnvs;

    private EnvironmentVariablesData(@NotNull Map<String, String> envs, boolean passParentEnvs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ENVS, "com/intellij/execution/configuration/EnvironmentVariablesData", "<init>"));
        }
        this.myEnvs = ImmutableMap.copyOf(envs);
        this.myPassParentEnvs = passParentEnvs;
    }

    @NotNull
    public Map<String, String> getEnvs() {
        ImmutableMap<String, String> immutableMap = this.myEnvs;
        if (immutableMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configuration/EnvironmentVariablesData", "getEnvs"));
        }
        return immutableMap;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentVariablesData data = (EnvironmentVariablesData)o;
        return this.myPassParentEnvs == data.myPassParentEnvs && this.myEnvs.equals(data.myEnvs);
    }

    public int hashCode() {
        int result = this.myEnvs.hashCode();
        result = 31 * result + (this.myPassParentEnvs ? 1 : 0);
        return result;
    }

    @NotNull
    public static EnvironmentVariablesData readExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/configuration/EnvironmentVariablesData", "readExternal"));
        }
        Element envsElement = element.getChild(ENVS);
        if (envsElement == null) {
            EnvironmentVariablesData environmentVariablesData = DEFAULT;
            if (environmentVariablesData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configuration/EnvironmentVariablesData", "readExternal"));
            }
            return environmentVariablesData;
        }
        Object envs = ImmutableMap.of();
        String passParentEnvsStr = envsElement.getAttributeValue(PASS_PARENT_ENVS);
        boolean passParentEnvs = passParentEnvsStr == null || Boolean.parseBoolean(passParentEnvsStr);
        for (Element envElement : envsElement.getChildren(ENV)) {
            String envName = envElement.getAttributeValue(NAME);
            String envValue = envElement.getAttributeValue(VALUE);
            if (envName == null || envValue == null) continue;
            if (envs.isEmpty()) {
                envs = ContainerUtil.newLinkedHashMap();
            }
            envs.put(envName, envValue);
        }
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.create((Map<String, String>)envs, passParentEnvs);
        if (environmentVariablesData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configuration/EnvironmentVariablesData", "readExternal"));
        }
        return environmentVariablesData;
    }

    public void writeExternal(@NotNull Element parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/execution/configuration/EnvironmentVariablesData", "writeExternal"));
        }
        Element envsElement = new Element(ENVS);
        if (!this.myPassParentEnvs) {
            envsElement.setAttribute(PASS_PARENT_ENVS, Boolean.FALSE.toString());
        }
        for (Map.Entry entry : this.myEnvs.entrySet()) {
            Element envElement = new Element(ENV);
            envElement.setAttribute(NAME, (String)entry.getKey());
            envElement.setAttribute(VALUE, (String)entry.getValue());
            envsElement.addContent(envElement);
        }
        parent.addContent(envsElement);
    }

    public void configureCommandLine(@NotNull GeneralCommandLine commandLine, boolean shellParentEnvs) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/configuration/EnvironmentVariablesData", "configureCommandLine"));
        }
        if (this.myPassParentEnvs) {
            commandLine.withParentEnvironmentType(shellParentEnvs ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.SYSTEM);
        } else {
            commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.NONE);
        }
        commandLine.withEnvironment(this.myEnvs);
    }

    @NotNull
    public static EnvironmentVariablesData create(@NotNull Map<String, String> envs, boolean passParentEnvs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ENVS, "com/intellij/execution/configuration/EnvironmentVariablesData", "create"));
        }
        if (passParentEnvs && envs.isEmpty()) {
            EnvironmentVariablesData environmentVariablesData = DEFAULT;
            if (environmentVariablesData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configuration/EnvironmentVariablesData", "create"));
            }
            return environmentVariablesData;
        }
        EnvironmentVariablesData environmentVariablesData = new EnvironmentVariablesData(envs, passParentEnvs);
        if (environmentVariablesData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configuration/EnvironmentVariablesData", "create"));
        }
        return environmentVariablesData;
    }
}

