/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.JavaScratchRunConfigurationExtension;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaScratchCompilationSupport
implements ProjectComponent,
CompileTask {
    public JavaScratchCompilationSupport(Project project, CompilerManager compileManager) {
        compileManager.addAfterTask((CompileTask)this);
    }

    public boolean execute(CompileContext context) {
        final Project project = context.getProject();
        RunConfiguration configuration = CompileStepBeforeRun.getRunConfiguration(context);
        if (!(configuration instanceof ModuleBasedConfiguration)) {
            return true;
        }
        final String scratchUrl = JavaScratchRunConfigurationExtension.getScratchFileUrl(configuration);
        if (scratchUrl == null) {
            return true;
        }
        Module configModule = ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule();
        if (configModule == null) {
            context.addMessage(CompilerMessageCategory.ERROR, "A module must be specified for the run configuration", scratchUrl, -1, -1);
            return true;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)configModule);
        Sdk targetSdk = moduleRootManager.getSdk();
        if (targetSdk == null) {
            context.addMessage(CompilerMessageCategory.ERROR, "Cannot find associated SDK for run configuration module \"" + configModule.getName() + "\".\nPlease check project settings.", scratchUrl, -1, -1);
            return true;
        }
        if (!(targetSdk.getSdkType() instanceof JavaSdkType)) {
            context.addMessage(CompilerMessageCategory.ERROR, "Expected Java SDK for run configuration module \"" + configModule.getName() + "\".\nPlease check project settings.", scratchUrl, -1, -1);
            return true;
        }
        File outputDir = JavaScratchRunConfigurationExtension.getScratchOutputDirectory(project);
        if (outputDir == null) {
            return true;
        }
        FileUtil.delete((File)outputDir);
        try {
            File scratchFile;
            File srcFile = scratchFile = new File(VirtualFileManager.extractPath((String)scratchUrl));
            if (!StringUtil.endsWith((CharSequence)srcFile.getName(), (CharSequence)".java")) {
                File srcDir = JavaScratchRunConfigurationExtension.getScratchTempDirectory(project);
                if (srcDir == null) {
                    return true;
                }
                FileUtil.delete((File)srcDir);
                String srcFileName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        PsiFile psiFile;
                        VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(scratchUrl);
                        if (vFile != null && (psiFile = PsiManager.getInstance((Project)project).findFile(vFile)) instanceof PsiJavaFile) {
                            String name = null;
                            for (PsiClass aClass : ((PsiJavaFile)psiFile).getClasses()) {
                                if (name == null) {
                                    name = aClass.getName();
                                    if (!JavaScratchCompilationSupport.isPublic(aClass)) continue;
                                    break;
                                }
                                if (!JavaScratchCompilationSupport.isPublic(aClass)) continue;
                                name = aClass.getName();
                                break;
                            }
                            if (name != null) {
                                return name;
                            }
                        }
                        return FileUtil.getNameWithoutExtension((File)scratchFile);
                    }
                });
                srcFile = new File(srcDir, srcFileName + ".java");
                FileUtil.copy((File)scratchFile, (File)srcFile);
            }
            Set<File> files = Collections.singleton(srcFile);
            LinkedHashSet<File> cp = new LinkedHashSet<File>();
            for (Object s : moduleRootManager.orderEntries().compileOnly().recursively().exportedOnly().withoutSdk().getPathsList().getPathList()) {
                cp.add(new File((String)s));
            }
            ArrayList<File> platformCp = new ArrayList<File>();
            for (String s : moduleRootManager.orderEntries().compileOnly().sdkOnly().getPathsList().getPathList()) {
                platformCp.add(new File(s));
            }
            ArrayList<String> options = new ArrayList<String>();
            options.add("-g");
            JavaSdkVersion sdkVersion = JavaSdk.getInstance().getVersion(targetSdk);
            if (sdkVersion != null) {
                String langLevel = "1." + Integer.valueOf(3 + sdkVersion.getMaxLanguageLevel().ordinal());
                options.add("-source");
                options.add(langLevel);
                options.add("-target");
                options.add(langLevel);
            }
            options.add("-proc:none");
            Collection result = CompilerManager.getInstance((Project)project).compileJavaCode(options, platformCp, cp, Collections.emptyList(), files, outputDir);
            for (ClassObject classObject : result) {
                byte[] bytes = classObject.getContent();
                if (bytes == null) continue;
                FileUtil.writeToFile((File)new File(classObject.getPath()), (byte[])bytes);
            }
        }
        catch (CompilationException e) {
            for (CompilationException.Message m : e.getMessages()) {
                context.addMessage(m.getCategory(), m.getText(), scratchUrl, m.getLine(), m.getColumn());
            }
        }
        catch (IOException e) {
            context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), scratchUrl, -1, -1);
        }
        return true;
    }

    private static boolean isPublic(PsiClass aClass) {
        PsiModifierList modifiers = aClass.getModifierList();
        return modifiers != null && modifiers.hasModifierProperty("public");
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        if ("JavaScratchCompilationSupport" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/JavaScratchCompilationSupport", "getComponentName"));
        }
        return "JavaScratchCompilationSupport";
    }
}

