/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiMethodUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClassBrowser
extends BrowseModuleValueActionListener {
    private final String myTitle;

    public ClassBrowser(Project project, String title) {
        super(project);
        this.myTitle = title;
    }

    @Override
    @Nullable
    protected String showDialog() {
        ClassFilter.ClassFilterWithScope classFilter;
        try {
            classFilter = this.getFilter();
        }
        catch (NoFilterException e) {
            MessagesEx.MessageInfo info = e.getMessageInfo();
            info.showNow();
            return null;
        }
        TreeClassChooser dialog = this.createClassChooser(classFilter);
        this.configureDialog(dialog);
        dialog.showDialog();
        PsiClass psiClass = dialog.getSelected();
        if (psiClass == null) {
            return null;
        }
        this.onClassChoosen(psiClass);
        return psiClass.getQualifiedName();
    }

    protected TreeClassChooser createClassChooser(ClassFilter.ClassFilterWithScope classFilter) {
        return TreeClassChooserFactory.getInstance((Project)this.getProject()).createWithInnerClassesScopeChooser(this.myTitle, classFilter.getScope(), (ClassFilter)classFilter, null);
    }

    protected abstract ClassFilter.ClassFilterWithScope getFilter() throws NoFilterException;

    protected void onClassChoosen(PsiClass psiClass) {
    }

    private void configureDialog(TreeClassChooser dialog) {
        String className = this.getText();
        PsiClass psiClass = this.findClass(className);
        if (psiClass == null) {
            return;
        }
        PsiDirectory directory = psiClass.getContainingFile().getContainingDirectory();
        if (directory != null) {
            dialog.selectDirectory(directory);
        }
        dialog.select(psiClass);
    }

    protected abstract PsiClass findClass(String var1);

    public static ClassBrowser createApplicationClassBrowser(Project project, ConfigurationModuleSelector moduleSelector) {
        final ClassFilter applicationClass = new ClassFilter(){

            public boolean isAccepted(PsiClass aClass) {
                return ConfigurationUtil.MAIN_CLASS.value((Object)aClass) && this.findMainMethod(aClass) != null;
            }

            @Nullable
            private PsiMethod findMainMethod(final PsiClass aClass) {
                return (PsiMethod)new ReadAction<PsiMethod>(){

                    protected void run(@NotNull Result<PsiMethod> result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/execution/ui/ClassBrowser$1$1", "run"));
                        }
                        result.setResult((Object)PsiMethodUtil.findMainMethod((PsiClass)aClass));
                    }
                }.execute().getResultObject();
            }
        };
        return new MainClassBrowser(project, moduleSelector, ExecutionBundle.message((String)"choose.main.class.dialog.title", (Object[])new Object[0])){

            @Override
            protected ClassFilter createFilter(Module module) {
                return applicationClass;
            }
        };
    }

    public static ClassBrowser createAppletClassBrowser(final Project project, final ConfigurationModuleSelector moduleSelector) {
        final String title = ExecutionBundle.message((String)"choose.applet.class.dialog.title", (Object[])new Object[0]);
        return new MainClassBrowser(project, moduleSelector, title){

            @Override
            protected TreeClassChooser createClassChooser(ClassFilter.ClassFilterWithScope classFilter) {
                Module module = moduleSelector.getModule();
                GlobalSearchScope scope = module == null ? GlobalSearchScope.allScope((Project)this.myProject) : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
                PsiClass appletClass = JavaPsiFacade.getInstance((Project)project).findClass("java.applet.Applet", scope);
                return TreeClassChooserFactory.getInstance((Project)this.getProject()).createInheritanceClassChooser(title, classFilter.getScope(), appletClass, false, false, ConfigurationUtil.PUBLIC_INSTANTIATABLE_CLASS);
            }
        };
    }

    public static class NoFilterException
    extends Exception {
        private final MessagesEx.MessageInfo myMessageInfo;

        public NoFilterException(MessagesEx.MessageInfo messageInfo) {
            super(messageInfo.getMessage());
            this.myMessageInfo = messageInfo;
        }

        public MessagesEx.MessageInfo getMessageInfo() {
            return this.myMessageInfo;
        }

        public static NoFilterException noJUnitInModule(Module module) {
            return new NoFilterException(new MessagesEx.MessageInfo(module.getProject(), ExecutionBundle.message((String)"junit.not.found.in.module.error.message", (Object[])new Object[]{module.getName()}), ExecutionBundle.message((String)"cannot.browse.test.inheritors.dialog.title", (Object[])new Object[0])));
        }

        public static NoFilterException moduleDoesntExist(ConfigurationModuleSelector moduleSelector) {
            Project project = moduleSelector.getProject();
            String moduleName = moduleSelector.getModuleName();
            return new NoFilterException(new MessagesEx.MessageInfo(project, moduleName.isEmpty() ? "No module selected" : ExecutionBundle.message((String)"module.does.not.exists", (Object[])new Object[]{moduleName, project.getName()}), ExecutionBundle.message((String)"cannot.browse.test.inheritors.dialog.title", (Object[])new Object[0])));
        }
    }

    private static abstract class MainClassBrowser
    extends ClassBrowser {
        protected final Project myProject;
        private final ConfigurationModuleSelector myModuleSelector;

        public MainClassBrowser(Project project, ConfigurationModuleSelector moduleSelector, String title) {
            super(project, title);
            this.myProject = project;
            this.myModuleSelector = moduleSelector;
        }

        @Override
        protected PsiClass findClass(String className) {
            return this.myModuleSelector.findClass(className);
        }

        @Override
        protected ClassFilter.ClassFilterWithScope getFilter() throws NoFilterException {
            Module module = this.myModuleSelector.getModule();
            final GlobalSearchScope scope = module == null ? GlobalSearchScope.allScope((Project)this.myProject) : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            final ClassFilter filter = this.createFilter(module);
            return new ClassFilter.ClassFilterWithScope(){

                public GlobalSearchScope getScope() {
                    return scope;
                }

                public boolean isAccepted(PsiClass aClass) {
                    return filter == null || filter.isAccepted(aClass);
                }
            };
        }

        protected ClassFilter createFilter(Module module) {
            return null;
        }
    }
}

