/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindSettings;
import com.intellij.find.editorHeaderActions.EditorHeaderToggleAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;

public class ToggleWholeWordsOnlyAction
extends EditorHeaderToggleAction {
    public ToggleWholeWordsOnlyAction() {
        super("Wo&rds");
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        EditorSearchSession session = (EditorSearchSession)e.getData(EditorSearchSession.SESSION_KEY);
        e.getPresentation().setEnabled(session != null && !session.getFindModel().isRegularExpressions());
        e.getPresentation().setVisible(session != null && !session.getFindModel().isMultiline());
    }

    @Override
    protected boolean isSelected(@NotNull EditorSearchSession session) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/find/editorHeaderActions/ToggleWholeWordsOnlyAction", "isSelected"));
        }
        return session.getFindModel().isWholeWordsOnly();
    }

    @Override
    protected void setSelected(@NotNull EditorSearchSession session, boolean selected) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/find/editorHeaderActions/ToggleWholeWordsOnlyAction", "setSelected"));
        }
        FindSettings.getInstance().setLocalWholeWordsOnly(selected);
        session.getFindModel().setWholeWordsOnly(selected);
    }
}

