/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findInProject;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.FindUtil;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.replaceInProject.ReplaceInProjectManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class FindInProjectManager {
    private final Project myProject;
    private volatile boolean myIsFindInProgress = false;

    public static FindInProjectManager getInstance(Project project) {
        return (FindInProjectManager)ServiceManager.getService((Project)project, FindInProjectManager.class);
    }

    public FindInProjectManager(Project project) {
        this.myProject = project;
    }

    public void findInProject(@NotNull DataContext dataContext) {
        boolean isOpenInNewTabEnabled;
        boolean toOpenInNewTab;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/find/findInProject/FindInProjectManager", "findInProject"));
        }
        Content selectedContent = com.intellij.usageView.UsageViewManager.getInstance((Project)this.myProject).getSelectedContent(true);
        if (selectedContent != null && selectedContent.isPinned()) {
            toOpenInNewTab = true;
            isOpenInNewTabEnabled = false;
        } else {
            toOpenInNewTab = FindSettings.getInstance().isShowResultsInSeparateView();
            isOpenInNewTabEnabled = com.intellij.usageView.UsageViewManager.getInstance((Project)this.myProject).getReusableContentsCount() > 0;
        }
        FindManager findManager = FindManager.getInstance((Project)this.myProject);
        final FindModel findModel = findManager.getFindInProjectModel().clone();
        findModel.setReplaceState(false);
        findModel.setOpenInNewTabVisible(true);
        findModel.setOpenInNewTabEnabled(isOpenInNewTabEnabled);
        findModel.setOpenInNewTab(toOpenInNewTab);
        FindInProjectUtil.setDirectoryName(findModel, dataContext);
        String text = (String)PlatformDataKeys.PREDEFINED_TEXT.getData(dataContext);
        if (text != null) {
            FindModel.initStringToFindNoMultiline((FindModel)findModel, (String)text);
        } else {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            FindUtil.initStringToFindWithSelection(findModel, editor);
        }
        findManager.showFindDialog(findModel, new Runnable(){

            @Override
            public void run() {
                findModel.setOpenInNewTabVisible(false);
                if (isOpenInNewTabEnabled) {
                    FindSettings.getInstance().setShowResultsInSeparateView(findModel.isOpenInNewTab());
                }
                FindInProjectManager.this.startFindInProject(findModel);
            }
        });
        findModel.setOpenInNewTabVisible(false);
    }

    public void startFindInProject(@NotNull FindModel findModel) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/findInProject/FindInProjectManager", "startFindInProject"));
        }
        if (findModel.getDirectoryName() != null && FindInProjectUtil.getDirectory(findModel) == null) {
            return;
        }
        UsageViewManager manager = UsageViewManager.getInstance((Project)this.myProject);
        if (manager == null) {
            return;
        }
        FindManager findManager = FindManager.getInstance((Project)this.myProject);
        findManager.getFindInProjectModel().copyFrom(findModel);
        final FindModel findModelCopy = findModel.clone();
        UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(FindSettings.getInstance().isShowResultsInSeparateView(), findModelCopy);
        boolean showPanelIfOnlyOneUsage = !FindSettings.getInstance().isSkipResultsWithOneUsage();
        final FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(this.myProject, showPanelIfOnlyOneUsage, presentation);
        FindInProjectUtil.StringUsageTarget usageTarget = new FindInProjectUtil.StringUsageTarget(this.myProject, findModel);
        ((FindManagerImpl)FindManager.getInstance((Project)this.myProject)).getFindUsagesManager().addToHistory(usageTarget);
        manager.searchAndShowUsages(new UsageTarget[]{usageTarget}, (Factory)new Factory<UsageSearcher>(){

            public UsageSearcher create() {
                return new UsageSearcher(){

                    public void generate(final @NotNull Processor<Usage> processor) {
                        if (processor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findInProject/FindInProjectManager$2$1", "generate"));
                        }
                        FindInProjectManager.this.myIsFindInProgress = true;
                        try {
                            Processor<UsageInfo> consumer = new Processor<UsageInfo>(){

                                public boolean process(UsageInfo info) {
                                    Usage usage = (Usage)UsageInfo2UsageAdapter.CONVERTER.fun((Object)info);
                                    usage.getPresentation().getIcon();
                                    return processor.process((Object)usage);
                                }
                            };
                            FindInProjectUtil.findUsages(findModelCopy, FindInProjectManager.this.myProject, consumer, processPresentation);
                        }
                        finally {
                            FindInProjectManager.this.myIsFindInProgress = false;
                        }
                    }
                };
            }
        }, processPresentation, presentation, null);
    }

    public boolean isWorkInProgress() {
        return this.myIsFindInProgress;
    }

    public boolean isEnabled() {
        return !this.myIsFindInProgress && !ReplaceInProjectManager.getInstance(this.myProject).isWorkInProgress();
    }
}

