/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class MacIntelliJBorderPainter {
    private static final Icon L = DarculaLaf.loadIcon("macBorderLeft.png");
    private static final Icon R = DarculaLaf.loadIcon("macBorderRight.png");
    private static final Icon T = DarculaLaf.loadIcon("macBorderTop.png");
    private static final Icon B = DarculaLaf.loadIcon("macBorderBottom.png");
    private static final Icon TL = DarculaLaf.loadIcon("macBorderTopLeft.png");
    private static final Icon TR = DarculaLaf.loadIcon("macBorderTopRight.png");
    private static final Icon BL = DarculaLaf.loadIcon("macBorderBottomLeft.png");
    private static final Icon BR = DarculaLaf.loadIcon("macBorderBottomRight.png");

    public static void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int yOffset;
        int xOffset;
        g = g.create(x, y, width, height);
        TL.paintIcon(c, g, x, y);
        BL.paintIcon(c, g, x, y + height - BL.getIconHeight());
        TR.paintIcon(c, g, x + width - TR.getIconWidth(), y);
        BR.paintIcon(c, g, x + width - BR.getIconWidth(), y + height - BR.getIconHeight());
        int stop2 = x + width - TR.getIconWidth();
        int top = y;
        int bottom = y + height - B.getIconHeight();
        g.setClip(xOffset, y, width - L.getIconWidth() - R.getIconWidth(), height);
        for (xOffset = x + TL.getIconWidth(); xOffset < stop2; xOffset += T.getIconWidth()) {
            T.paintIcon(c, g, xOffset, top);
            B.paintIcon(c, g, xOffset, bottom);
        }
        int left = x;
        int right = x + width - R.getIconWidth();
        stop2 = y + height - B.getIconHeight();
        g.setClip(x, yOffset, width, height - T.getIconHeight() - B.getIconHeight());
        for (yOffset = y + T.getIconHeight(); yOffset < stop2; yOffset += L.getIconHeight()) {
            L.paintIcon(c, g, left, yOffset);
            R.paintIcon(c, g, right, yOffset);
        }
        g.dispose();
    }
}

