/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.DataManager;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.ActionFromOptionDescriptorProvider;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoActionItemProvider
implements ChooseByNameItemProvider {
    private static final TObjectHashingStrategy<AnAction> ACTION_OBJECT_HASHING_STRATEGY = new TObjectHashingStrategy<AnAction>(){

        public int computeHashCode(AnAction object) {
            return object.getClass().hashCode();
        }

        public boolean equals(AnAction o1, AnAction o2) {
            return Comparing.equal(o1.getClass(), o2.getClass());
        }
    };
    private final ActionManager myActionManager = ActionManager.getInstance();
    protected final SearchableOptionsRegistrar myIndex = SearchableOptionsRegistrar.getInstance();
    private final GotoActionModel myModel;

    public GotoActionItemProvider(GotoActionModel model) {
        this.myModel = model;
    }

    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameBase base, @NotNull String[] names, @NotNull String pattern) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/ide/util/gotoByName/GotoActionItemProvider", "filterNames"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/ide/util/gotoByName/GotoActionItemProvider", "filterNames"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/GotoActionItemProvider", "filterNames"));
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionItemProvider", "filterNames"));
        }
        return list;
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator cancelled, final @NotNull Processor<Object> consumer) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/ide/util/gotoByName/GotoActionItemProvider", "filterElements"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/GotoActionItemProvider", "filterElements"));
        }
        if (cancelled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancelled", "com/intellij/ide/util/gotoByName/GotoActionItemProvider", "filterElements"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/ide/util/gotoByName/GotoActionItemProvider", "filterElements"));
        }
        return this.filterElements(pattern, everywhere, new Processor<GotoActionModel.MatchedValue>(){

            public boolean process(GotoActionModel.MatchedValue value) {
                return consumer.process((Object)value);
            }
        });
    }

    public boolean filterElements(String pattern, boolean everywhere, Processor<GotoActionModel.MatchedValue> consumer) {
        DataContext dataContext = DataManager.getInstance().getDataContext(this.myModel.getContextComponent());
        if (!this.processAbbreviations(pattern, consumer, dataContext)) {
            return false;
        }
        if (!this.processIntentions(pattern, consumer, dataContext)) {
            return false;
        }
        if (!this.processActions(pattern, everywhere, consumer, dataContext)) {
            return false;
        }
        if (!GotoActionItemProvider.processTopHits(pattern, consumer, dataContext)) {
            return false;
        }
        return this.processOptions(pattern, consumer, dataContext);
    }

    private boolean processAbbreviations(final String pattern, Processor<GotoActionModel.MatchedValue> consumer, DataContext context) {
        List actions = AbbreviationManager.getInstance().findActions(pattern);
        if (actions.isEmpty()) {
            return true;
        }
        ArrayList wrappers = ContainerUtil.newArrayListWithCapacity((int)actions.size());
        for (String actionId : actions) {
            AnAction action = this.myActionManager.getAction(actionId);
            wrappers.add(new GotoActionModel.ActionWrapper(action, this.myModel.myActionGroups.get(action), GotoActionModel.MatchMode.NAME, context));
        }
        return ContainerUtil.process((List)ContainerUtil.map((Collection)wrappers, (Function)new Function<GotoActionModel.ActionWrapper, GotoActionModel.MatchedValue>(){

            public GotoActionModel.MatchedValue fun(@NotNull GotoActionModel.ActionWrapper w) {
                if (w == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "w", "com/intellij/ide/util/gotoByName/GotoActionItemProvider$3", "fun"));
                }
                return new GotoActionModel.MatchedValue(w, pattern){

                    @Override
                    @Nullable
                    public String getValueText() {
                        return this.pattern;
                    }
                };
            }
        }), consumer);
    }

    private static boolean processTopHits(String pattern, Processor<GotoActionModel.MatchedValue> consumer, DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        CollectConsumer collector = new CollectConsumer();
        for (SearchTopHitProvider provider : (SearchTopHitProvider[])SearchTopHitProvider.EP_NAME.getExtensions()) {
            if (provider instanceof OptionsTopHitProvider.CoveredByToggleActions || provider instanceof OptionsTopHitProvider && !((OptionsTopHitProvider)provider).isEnabled(project)) continue;
            if (provider instanceof OptionsTopHitProvider && !StringUtil.startsWith((CharSequence)pattern, (CharSequence)"#")) {
                String prefix = "#" + ((OptionsTopHitProvider)provider).getId() + " ";
                provider.consumeTopHits(prefix + pattern, (Consumer)collector, project);
            }
            provider.consumeTopHits(pattern, (Consumer)collector, project);
        }
        Collection result = collector.getResult();
        ArrayList<Comparable> c = new ArrayList<Comparable>();
        for (Object o : result) {
            if (!(o instanceof Comparable)) continue;
            c.add((Comparable)o);
        }
        return GotoActionItemProvider.processItems(pattern, c, consumer);
    }

    private boolean processOptions(String pattern, Processor<GotoActionModel.MatchedValue> consumer, DataContext dataContext) {
        ArrayList options = ContainerUtil.newArrayList();
        Set words = this.myIndex.getProcessedWords(pattern);
        Set<OptionDescription> optionDescriptions = null;
        String actionManagerName = this.myActionManager.getComponentName();
        for (String word : words) {
            Set<OptionDescription> descriptions = ((SearchableOptionsRegistrarImpl)this.myIndex).getAcceptableDescriptions(word);
            if (descriptions != null) {
                Iterator<OptionDescription> iterator = descriptions.iterator();
                while (iterator.hasNext()) {
                    OptionDescription description = iterator.next();
                    if (!actionManagerName.equals(description.getPath())) continue;
                    iterator.remove();
                }
                if (descriptions.isEmpty()) continue;
                if (optionDescriptions == null) {
                    optionDescriptions = descriptions;
                    continue;
                }
                optionDescriptions.retainAll(descriptions);
                continue;
            }
            optionDescriptions = null;
            break;
        }
        if (optionDescriptions != null && !optionDescriptions.isEmpty()) {
            HashSet<String> currentHits = new HashSet<String>();
            Iterator iterator = optionDescriptions.iterator();
            while (iterator.hasNext()) {
                OptionDescription description = (OptionDescription)iterator.next();
                String hit = description.getHit();
                if (hit != null && currentHits.add(hit.trim())) continue;
                iterator.remove();
            }
            for (OptionDescription description : optionDescriptions) {
                for (ActionFromOptionDescriptorProvider converter : (ActionFromOptionDescriptorProvider[])ActionFromOptionDescriptorProvider.EP.getExtensions()) {
                    AnAction action = converter.provide(description);
                    if (action != null) {
                        options.add(new GotoActionModel.ActionWrapper(action, null, GotoActionModel.MatchMode.NAME, dataContext));
                    }
                    options.add(description);
                }
            }
        }
        return GotoActionItemProvider.processItems(pattern, options, consumer);
    }

    private boolean processActions(String pattern, boolean everywhere, Processor<GotoActionModel.MatchedValue> consumer, DataContext dataContext) {
        THashSet actions = new THashSet(ACTION_OBJECT_HASHING_STRATEGY);
        if (everywhere) {
            for (String id : ((ActionManagerImpl)this.myActionManager).getActionIds()) {
                ProgressManager.checkCanceled();
                ContainerUtil.addIfNotNull((Collection)actions, (Object)this.myActionManager.getAction(id));
            }
        } else {
            actions.addAll(this.myModel.myActionGroups.keySet());
        }
        ArrayList actionWrappers = ContainerUtil.newArrayList();
        for (AnAction action : actions) {
            ProgressManager.checkCanceled();
            GotoActionModel.MatchMode mode = this.myModel.actionMatches(pattern, action);
            if (mode == GotoActionModel.MatchMode.NONE) continue;
            actionWrappers.add(new GotoActionModel.ActionWrapper(action, this.myModel.myActionGroups.get(action), mode, dataContext));
        }
        return GotoActionItemProvider.processItems(pattern, actionWrappers, consumer);
    }

    private boolean processIntentions(String pattern, Processor<GotoActionModel.MatchedValue> consumer, DataContext dataContext) {
        ArrayList intentions = ContainerUtil.newArrayList();
        for (String intentionText : this.myModel.myIntentions.keySet()) {
            ApplyIntentionAction intentionAction = this.myModel.myIntentions.get(intentionText);
            if (this.myModel.actionMatches(pattern, intentionAction) == GotoActionModel.MatchMode.NONE) continue;
            intentions.add(new GotoActionModel.ActionWrapper(intentionAction, intentionText, GotoActionModel.MatchMode.INTENTION, dataContext));
        }
        return GotoActionItemProvider.processItems(pattern, intentions, consumer);
    }

    private static boolean processItems(final String pattern, Collection<? extends Comparable> items, Processor<GotoActionModel.MatchedValue> consumer) {
        List matched = ContainerUtil.map(items, (Function)new Function<Comparable, GotoActionModel.MatchedValue>(){

            public GotoActionModel.MatchedValue fun(Comparable comparable) {
                return new GotoActionModel.MatchedValue(comparable, pattern);
            }
        });
        Collections.sort(matched);
        return ContainerUtil.process((List)matched, consumer);
    }
}

