/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.CommonBundle;
import com.intellij.idea.Main;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.DefaultLogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.net.NetUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.MessageDecoder;

public final class SocketLock {
    private static final Logger LOG = Logger.getInstance(SocketLock.class);
    @NonNls
    private static final String ACTIVATE_COMMAND = "activate ";
    private final String configPath;
    private final String systemPath;
    private final AtomicReference<Consumer<List<String>>> activateListener;
    private BuiltInServer server;

    public SocketLock(@NotNull String configPath, @NotNull String systemPath) {
        if (configPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/idea/SocketLock", "<init>"));
        }
        if (systemPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemPath", "com/intellij/idea/SocketLock", "<init>"));
        }
        this.activateListener = new AtomicReference();
        this.configPath = SocketLock.canonicalPath(configPath);
        this.systemPath = SocketLock.canonicalPath(systemPath);
    }

    public void setExternalInstanceListener(@Nullable Consumer<List<String>> consumer) {
        this.activateListener.set(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispose() {
        BuiltInServer server;
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: destroyProcess()");
        }
        boolean doRemovePortMarker = (server = this.server) != null;
        try {
            if (server != null) {
                Disposer.dispose((Disposable)server);
            }
            if (!doRemovePortMarker) return;
        }
        catch (Throwable throwable) {
            if (!doRemovePortMarker) throw throwable;
            try {
                SocketLock.executeAndClose(new Executor<Void>(){

                    @Override
                    public Void execute(@NotNull List<Closeable> closeables) throws IOException {
                        if (closeables == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closeables", "com/intellij/idea/SocketLock$1", "execute"));
                        }
                        File config = new File(SocketLock.this.configPath);
                        File system = new File(SocketLock.this.systemPath);
                        SocketLock.lockPortMarker(config, closeables);
                        SocketLock.lockPortMarker(system, closeables);
                        FileUtil.delete((File)new File(config, "port"));
                        FileUtil.delete((File)new File(system, "port"));
                        return null;
                    }
                });
                throw throwable;
            }
            catch (Throwable e) {
                SocketLock.logError(e);
            }
            throw throwable;
        }
        try {
            SocketLock.executeAndClose(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        catch (Throwable e) {
            SocketLock.logError(e);
        }
    }

    @Nullable
    public BuiltInServer getServer() {
        return this.server;
    }

    private static void lockPortMarker(@NotNull File parent, @NotNull List<Closeable> list) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/idea/SocketLock", "lockPortMarker"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/idea/SocketLock", "lockPortMarker"));
        }
        FileUtilRt.createDirectory((File)parent);
        FileOutputStream stream = new FileOutputStream(new File(parent, "port.lock"), true);
        list.add(stream);
    }

    private static void addExistingPort(@NotNull File portMarker, @NotNull String path, @NotNull MultiMap<Integer, String> portToPath) {
        if (portMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "portMarker", "com/intellij/idea/SocketLock", "addExistingPort"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/idea/SocketLock", "addExistingPort"));
        }
        if (portToPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "portToPath", "com/intellij/idea/SocketLock", "addExistingPort"));
        }
        if (portMarker.exists()) {
            try {
                portToPath.putValue((Object)Integer.parseInt(FileUtilRt.loadFile((File)portMarker)), (Object)path);
            }
            catch (Throwable e) {
                LOG.debug(e);
            }
        }
    }

    @Nullable
    public ActivateStatus lock() {
        return this.lock(ArrayUtil.EMPTY_STRING_ARRAY);
    }

    @Nullable
    public ActivateStatus lock(final @NotNull String[] args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/idea/SocketLock", "lock"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: lock(configPath='" + this.configPath + "', systemPath='" + this.systemPath + "')");
        }
        try {
            final File config = new File(this.configPath);
            final File system = new File(this.systemPath);
            final File portMarkerC = new File(config, "port");
            final File portMarkerS = new File(system, "port");
            return SocketLock.executeAndClose(new Executor<ActivateStatus>(){

                @Override
                public ActivateStatus execute(@NotNull List<Closeable> closeables) throws Throwable {
                    if (closeables == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closeables", "com/intellij/idea/SocketLock$2", "execute"));
                    }
                    SocketLock.lockPortMarker(config, closeables);
                    SocketLock.lockPortMarker(system, closeables);
                    MultiMap portToPath = MultiMap.createSmart();
                    SocketLock.addExistingPort(portMarkerC, SocketLock.this.configPath, (MultiMap<Integer, String>)portToPath);
                    SocketLock.addExistingPort(portMarkerS, SocketLock.this.systemPath, (MultiMap<Integer, String>)portToPath);
                    if (!portToPath.isEmpty()) {
                        for (Map.Entry entry : portToPath.entrySet()) {
                            ActivateStatus status = SocketLock.tryActivate((Integer)entry.getKey(), (Collection)entry.getValue(), args);
                            if (status == ActivateStatus.NO_INSTANCE) continue;
                            return status;
                        }
                    }
                    final String[] lockedPaths = new String[]{SocketLock.this.configPath, SocketLock.this.systemPath};
                    SocketLock.this.server = BuiltInServer.start(1, 6942, 50, false, new NotNullProducer<ChannelHandler>(){

                        @NotNull
                        public ChannelHandler produce() {
                            MyChannelInboundHandler myChannelInboundHandler = new MyChannelInboundHandler(lockedPaths, SocketLock.this.activateListener);
                            if (myChannelInboundHandler == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock$2$1", "produce"));
                            }
                            return myChannelInboundHandler;
                        }
                    });
                    byte[] portBytes = Integer.toString(SocketLock.this.server.getPort()).getBytes(CharsetToolkit.UTF8_CHARSET);
                    FileUtil.writeToFile((File)portMarkerC, (byte[])portBytes);
                    FileUtil.writeToFile((File)portMarkerS, (byte[])portBytes);
                    return ActivateStatus.NO_INSTANCE;
                }
            });
        }
        catch (Throwable e) {
            SocketLock.logError(e);
            if (Main.isHeadless()) {
                Main.showMessage((String)"Cannot lock system folders", (Throwable)e);
            } else {
                String pathToLogFile = PathManager.getLogPath() + "/idea.log file".replace('/', File.separatorChar);
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), CommonBundle.message((String)"cannot.start.other.instance.is.running.error.message", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), pathToLogFile}), CommonBundle.message((String)"title.warning", (Object[])new Object[0]), 2);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T executeAndClose(@NotNull Executor<T> executor) throws Throwable {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/idea/SocketLock", "executeAndClose"));
        }
        ArrayList<Closeable> closeables = new ArrayList<Closeable>();
        try {
            T t = executor.execute(closeables);
            return t;
        }
        finally {
            for (Closeable closeable : closeables) {
                try {
                    closeable.close();
                }
                catch (Throwable e) {
                    SocketLock.logError(e);
                }
            }
        }
    }

    private static void logError(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/idea/SocketLock", "logError"));
        }
        if (LOG instanceof DefaultLogger) {
            LOG.warn(e);
        } else {
            LOG.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private static ActivateStatus tryActivate(int portNumber, @NotNull Collection<String> paths, @NotNull String[] args) {
        block32: {
            if (paths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/idea/SocketLock", "tryActivate"));
            }
            if (args == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/idea/SocketLock", "tryActivate"));
            }
            Socket socket = null;
            try {
                socket = new Socket(NetUtils.getLoopbackAddress(), portNumber);
                socket.setSoTimeout(300);
                boolean result = false;
                DataInputStream in = new DataInputStream(socket.getInputStream());
                try {
                    while (true) {
                        String path;
                        if (!paths.contains(path = in.readUTF())) {
                            continue;
                        }
                        result = true;
                    }
                }
                catch (IOException ignored) {
                    block33: {
                        ActivateStatus activateStatus;
                        block31: {
                            block34: {
                                block29: {
                                    ActivateStatus activateStatus2;
                                    block30: {
                                        if (!result) break block33;
                                        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                                        out.writeUTF(ACTIVATE_COMMAND + new File(".").getAbsolutePath() + "\u0000" + StringUtil.join((String[])args, (String)"\u0000"));
                                        out.flush();
                                        String response = in.readUTF();
                                        if (!response.equals("ok")) break block29;
                                        activateStatus2 = ActivateStatus.ACTIVATED;
                                        if (socket == null) break block30;
                                        try {
                                            socket.close();
                                        }
                                        catch (IOException e) {
                                            LOG.debug((Throwable)e);
                                        }
                                    }
                                    ActivateStatus activateStatus3 = activateStatus2;
                                    if (activateStatus3 == null) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "tryActivate"));
                                    }
                                    return activateStatus3;
                                }
                                break block34;
                                catch (IOException e) {
                                    LOG.info((Throwable)e);
                                }
                            }
                            activateStatus = ActivateStatus.CANNOT_ACTIVATE;
                            if (socket == null) break block31;
                            try {
                                socket.close();
                            }
                            catch (IOException e) {
                                LOG.debug((Throwable)e);
                            }
                        }
                        ActivateStatus activateStatus4 = activateStatus;
                        if (activateStatus4 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "tryActivate"));
                        }
                        return activateStatus4;
                    }
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException e) {
                            LOG.debug((Throwable)e);
                        }
                    }
                    break block32;
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                    }
                }
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                    }
                }
            }
        }
        ActivateStatus activateStatus = ActivateStatus.NO_INSTANCE;
        if (activateStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "tryActivate"));
        }
        return activateStatus;
    }

    @NotNull
    private static String canonicalPath(@NotNull String configPath) {
        String string;
        if (configPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/idea/SocketLock", "canonicalPath"));
        }
        try {
            string = new File(configPath).getCanonicalPath();
        }
        catch (IOException ignore) {
            String string2 = configPath;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "canonicalPath"));
            }
            return string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "canonicalPath"));
        }
        return string;
    }

    private static class MyChannelInboundHandler
    extends MessageDecoder {
        private final String[] lockedPaths;
        private State state;
        private final AtomicReference<Consumer<List<String>>> activateListener;

        public MyChannelInboundHandler(@NotNull String[] lockedPaths, @NotNull AtomicReference<Consumer<List<String>>> activateListener) {
            if (lockedPaths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lockedPaths", "com/intellij/idea/SocketLock$MyChannelInboundHandler", "<init>"));
            }
            if (activateListener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activateListener", "com/intellij/idea/SocketLock$MyChannelInboundHandler", "<init>"));
            }
            this.state = State.HEADER;
            this.lockedPaths = lockedPaths;
            this.activateListener = activateListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelActive(ChannelHandlerContext context) throws Exception {
            ByteBuf buffer = context.alloc().ioBuffer(1024);
            boolean success = false;
            try {
                ByteBufOutputStream out = new ByteBufOutputStream(buffer);
                for (String path : this.lockedPaths) {
                    if (path == null) continue;
                    out.writeUTF(path);
                }
                out.close();
                success = true;
            }
            finally {
                if (!success) {
                    buffer.release();
                }
            }
            context.writeAndFlush((Object)buffer);
        }

        @Override
        protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) throws Exception {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/idea/SocketLock$MyChannelInboundHandler", "messageReceived"));
            }
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/idea/SocketLock$MyChannelInboundHandler", "messageReceived"));
            }
            while (true) {
                switch (this.state) {
                    case HEADER: {
                        ByteBuf buffer = this.getBufferIfSufficient(input, 2, context);
                        if (buffer == null) {
                            return;
                        }
                        this.contentLength = buffer.readUnsignedShort();
                        this.state = State.CONTENT;
                        break;
                    }
                    case CONTENT: {
                        CharSequence command = this.readChars(input);
                        if (command == null) {
                            return;
                        }
                        if (StringUtil.startsWith((CharSequence)command, (CharSequence)SocketLock.ACTIVATE_COMMAND)) {
                            List args = StringUtil.split((String)command.subSequence(SocketLock.ACTIVATE_COMMAND.length(), command.length()).toString(), (String)"\u0000");
                            Consumer<List<String>> listener = this.activateListener.get();
                            if (listener != null) {
                                listener.consume((Object)args);
                            }
                            ByteBuf buffer = context.alloc().ioBuffer(4);
                            ByteBufOutputStream out = new ByteBufOutputStream(buffer);
                            out.writeUTF("ok");
                            out.close();
                            context.writeAndFlush((Object)buffer);
                        }
                        context.close();
                    }
                }
            }
        }

        private static enum State {
            HEADER,
            CONTENT;

        }
    }

    private static interface Executor<T> {
        public T execute(@NotNull List<Closeable> var1) throws Throwable;
    }

    public static enum ActivateStatus {
        ACTIVATED,
        NO_INSTANCE,
        CANNOT_ACTIVATE;

    }
}

