/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.EditorLinePainter;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.softwrap.mapping.IncrementalCacheUpdateEvent;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareDocumentParsingListenerAdapter;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.TIntArrayList;
import java.awt.Dimension;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class EditorSizeManager
implements PrioritizedDocumentListener,
Disposable,
FoldingListener {
    private static final int UNKNOWN_WIDTH = Integer.MAX_VALUE;
    private final EditorView myView;
    private final EditorImpl myEditor;
    private final DocumentEx myDocument;
    private final TIntArrayList myLineWidths = new TIntArrayList();
    private int myWidthInPixels;
    private int myMaxLineWithExtensionWidth;
    private int myWidestLineWithExtension;
    private boolean myApproximateWidthCalculated;
    private final SoftWrapAwareDocumentParsingListenerAdapter mySoftWrapChangeListener = new SoftWrapAwareDocumentParsingListenerAdapter(){

        @Override
        public void onRecalculationEnd(@NotNull IncrementalCacheUpdateEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/view/EditorSizeManager$1", "onRecalculationEnd"));
            }
            EditorSizeManager.this.onSoftWrapRecalculationEnd(event);
        }
    };
    private int foldingChangeStartOffset = Integer.MAX_VALUE;
    private int foldingChangeEndOffset = Integer.MIN_VALUE;

    EditorSizeManager(EditorView view) {
        this.myView = view;
        this.myEditor = view.getEditor();
        this.myDocument = this.myEditor.getDocument();
        this.myDocument.addDocumentListener(this, this);
        this.myEditor.getFoldingModel().addListener(this, this);
        this.myEditor.getSoftWrapModel().getApplianceManager().addListener(this.mySoftWrapChangeListener);
    }

    public void dispose() {
        this.myEditor.getSoftWrapModel().getApplianceManager().removeListener(this.mySoftWrapChangeListener);
    }

    @Override
    public int getPriority() {
        return 75;
    }

    public void beforeDocumentChange(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.invalidateRange(event.getOffset(), event.getOffset() + event.getNewLength());
    }

    @Override
    public void onFoldRegionStateChange(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/openapi/editor/impl/view/EditorSizeManager", "onFoldRegionStateChange"));
        }
        if (region.isValid()) {
            this.foldingChangeStartOffset = Math.min(this.foldingChangeStartOffset, region.getStartOffset());
            this.foldingChangeEndOffset = Math.max(this.foldingChangeEndOffset, region.getEndOffset());
        }
    }

    @Override
    public void onFoldProcessingEnd() {
        if (this.foldingChangeStartOffset <= this.foldingChangeEndOffset) {
            this.invalidateRange(this.foldingChangeStartOffset, this.foldingChangeEndOffset);
        }
        this.foldingChangeStartOffset = Integer.MAX_VALUE;
        this.foldingChangeEndOffset = Integer.MIN_VALUE;
    }

    private void onSoftWrapRecalculationEnd(IncrementalCacheUpdateEvent event) {
        this.invalidateRange(event.getStartOffset(), event.getActualEndOffset());
    }

    Dimension getPreferredSize() {
        int width = this.getPreferredWidth();
        if (!this.myDocument.isInBulkUpdate()) {
            for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
                if (!caret.isUpToDate()) continue;
                int caretX = this.myView.visualPositionToXY((VisualPosition)caret.getVisualPosition()).x;
                width = Math.max(caretX, width);
            }
        }
        return new Dimension(width += this.myEditor.getSettings().getAdditionalColumnsCount() * this.myView.getPlainSpaceWidth(), this.myEditor.getPreferredHeight());
    }

    private int getPreferredWidth() {
        if (this.myWidthInPixels < 0) {
            this.myWidthInPixels = this.calculatePreferredWidth();
        }
        this.validateMaxLineWithExtension();
        return Math.max(this.myWidthInPixels, this.myMaxLineWithExtensionWidth);
    }

    private void validateMaxLineWithExtension() {
        if (this.myMaxLineWithExtensionWidth > 0) {
            Project project = this.myEditor.getProject();
            VirtualFile virtualFile = this.myEditor.getVirtualFile();
            if (project != null && virtualFile != null) {
                for (EditorLinePainter painter : (EditorLinePainter[])EditorLinePainter.EP_NAME.getExtensions()) {
                    Collection<LineExtensionInfo> extensions = painter.getLineExtensions(project, virtualFile, this.myWidestLineWithExtension);
                    if (extensions == null || extensions.isEmpty()) continue;
                    return;
                }
            }
            this.myMaxLineWithExtensionWidth = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int calculatePreferredWidth() {
        int lineCount = this.myLineWidths.size();
        int maxWidth = 0;
        for (int i = 0; i < lineCount; ++i) {
            int width = this.myLineWidths.get(i);
            if (width == Integer.MAX_VALUE) {
                this.myApproximateWidthCalculated = false;
                this.myView.getTextLayoutCache().enableQuickLayouts(true);
                try {
                    width = this.myView.getMaxWidthInLineRange(i, i);
                }
                finally {
                    this.myView.getTextLayoutCache().enableQuickLayouts(false);
                }
                if (this.myApproximateWidthCalculated) {
                    width = -width;
                }
                this.myLineWidths.set(i, width);
            }
            maxWidth = Math.max(maxWidth, Math.abs(width));
        }
        return maxWidth;
    }

    void reset() {
        this.invalidateRange(0, this.myDocument.getTextLength());
    }

    void invalidateRange(int startOffset, int endOffset) {
        this.myWidthInPixels = -1;
        int startVisualLine = this.myView.offsetToVisualLine(startOffset, false);
        int endVisualLine = this.myView.offsetToVisualLine(endOffset, true);
        int lineDiff = this.myEditor.getVisibleLineCount() - this.myLineWidths.size();
        if (lineDiff > 0) {
            int[] newEntries = new int[lineDiff];
            this.myLineWidths.insert(startVisualLine, newEntries);
        } else if (lineDiff < 0) {
            this.myLineWidths.remove(startVisualLine, -lineDiff);
        }
        for (int i = startVisualLine; i <= endVisualLine && i < this.myLineWidths.size(); ++i) {
            this.myLineWidths.set(i, Integer.MAX_VALUE);
        }
    }

    int getMaxLineWithExtensionWidth() {
        return this.myMaxLineWithExtensionWidth;
    }

    void setMaxLineWithExtensionWidth(int lineNumber, int width) {
        this.myWidestLineWithExtension = lineNumber;
        this.myMaxLineWithExtensionWidth = width;
    }

    void quickLineLayoutCreated() {
        this.myApproximateWidthCalculated = true;
    }

    void lineLayoutCreated(int logicalLine) {
        int startVisualLine = this.myView.offsetToVisualLine(this.myDocument.getLineStartOffset(logicalLine), false);
        int endVisualLine = this.myView.offsetToVisualLine(this.myDocument.getLineEndOffset(logicalLine), false);
        boolean sizeInvalidated = false;
        for (int i = startVisualLine; i <= endVisualLine; ++i) {
            if (this.myLineWidths.get(i) >= 0) continue;
            this.myLineWidths.set(i, Integer.MAX_VALUE);
            sizeInvalidated = true;
        }
        if (sizeInvalidated) {
            this.myWidthInPixels = -1;
            this.myEditor.getContentComponent().revalidate();
        }
    }
}

