/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.bidi.BidiRegionsSeparator;
import com.intellij.openapi.editor.bidi.LanguageBidiRegionsSeparator;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.editor.impl.view.LineFragment;
import com.intellij.openapi.editor.impl.view.TabFragment;
import com.intellij.openapi.editor.impl.view.TextFragment;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LineLayout {
    private final BidiRun[] myBidiRunsInLogicalOrder;
    private final BidiRun[] myBidiRunsInVisualOrder;
    private final float myWidth;

    LineLayout(EditorView view, int lineLength) {
        this(LineLayout.createDummyFragment(view, lineLength), false);
    }

    LineLayout(@NotNull EditorView view, int startOffset, int endOffset, @NotNull FontRenderContext fontRenderContext) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "<init>"));
        }
        if (fontRenderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontRenderContext", "com/intellij/openapi/editor/impl/view/LineLayout", "<init>"));
        }
        this(LineLayout.createFragments(view, startOffset, endOffset, fontRenderContext), false);
    }

    LineLayout(@NotNull EditorView view, @NotNull CharSequence text, @JdkConstants.FontStyle int fontStyle, @NotNull FontRenderContext fontRenderContext) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/view/LineLayout", "<init>"));
        }
        if (fontRenderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontRenderContext", "com/intellij/openapi/editor/impl/view/LineLayout", "<init>"));
        }
        this(LineLayout.createFragments(view, text, fontStyle, fontRenderContext), true);
    }

    private LineLayout(@NotNull List<BidiRun> runs, boolean calculateWidth) {
        if (runs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runs", "com/intellij/openapi/editor/impl/view/LineLayout", "<init>"));
        }
        this.myBidiRunsInLogicalOrder = runs.toArray(new BidiRun[runs.size()]);
        this.myBidiRunsInVisualOrder = (BidiRun[])this.myBidiRunsInLogicalOrder.clone();
        LineLayout.reorderRunsVisually(this.myBidiRunsInVisualOrder);
        int logicalColumn = 0;
        for (BidiRun run2 : runs) {
            logicalColumn = run2.createIndices(logicalColumn);
        }
        this.myWidth = calculateWidth ? this.calculateWidth() : -1.0f;
    }

    private static void reorderRunsVisually(BidiRun[] bidiRunsInLogicalOrder) {
        if (bidiRunsInLogicalOrder.length > 1) {
            byte[] levels = new byte[bidiRunsInLogicalOrder.length];
            for (int i = 0; i < bidiRunsInLogicalOrder.length; ++i) {
                levels[i] = bidiRunsInLogicalOrder[i].level;
            }
            Bidi.reorderVisually(levels, 0, bidiRunsInLogicalOrder, 0, levels.length);
        }
    }

    private static List<BidiRun> createFragments(@NotNull EditorView view, int lineStartOffset, int lineEndOffset, @NotNull FontRenderContext fontRenderContext) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        if (fontRenderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontRenderContext", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        if (lineEndOffset <= lineStartOffset) {
            return Collections.emptyList();
        }
        EditorImpl editor = view.getEditor();
        FontPreferences fontPreferences = editor.getColorsScheme().getFontPreferences();
        char[] chars = CharArrayUtil.fromSequence((CharSequence)editor.getDocument().getImmutableCharSequence(), (int)lineStartOffset, (int)lineEndOffset);
        List<BidiRun> runs = LineLayout.createRuns(editor, chars, lineStartOffset);
        for (BidiRun run2 : runs) {
            IterationState it = new IterationState(editor, lineStartOffset + run2.startOffset, lineStartOffset + run2.endOffset, false, false, false, false);
            while (!it.atEnd()) {
                LineLayout.addFragments(run2, chars, it.getStartOffset() - lineStartOffset, it.getEndOffset() - lineStartOffset, it.getMergedAttributes().getFontType(), fontPreferences, fontRenderContext, view.getTabFragment());
                it.advance();
            }
            assert (!run2.fragments.isEmpty());
        }
        return runs;
    }

    private static List<BidiRun> createFragments(@NotNull EditorView view, @NotNull CharSequence text, @JdkConstants.FontStyle int fontStyle, @NotNull FontRenderContext fontRenderContext) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        if (fontRenderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontRenderContext", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        if (text.length() == 0) {
            return Collections.emptyList();
        }
        EditorImpl editor = view.getEditor();
        FontPreferences fontPreferences = editor.getColorsScheme().getFontPreferences();
        char[] chars = CharArrayUtil.fromSequence((CharSequence)text);
        List<BidiRun> runs = LineLayout.createRuns(editor, chars, -1);
        for (BidiRun run2 : runs) {
            LineLayout.addFragments(run2, chars, run2.startOffset, run2.endOffset, fontStyle, fontPreferences, fontRenderContext, null);
            assert (!run2.fragments.isEmpty());
        }
        return runs;
    }

    private static List<BidiRun> createDummyFragment(@NotNull EditorView view, int lineLength) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "createDummyFragment"));
        }
        BidiRun run2 = new BidiRun(0, 0, lineLength);
        run2.fragments.add(new DummyLineFragment(lineLength, view.getMaxCharWidth()));
        return Collections.singletonList(run2);
    }

    private static List<BidiRun> createRuns(EditorImpl editor, char[] text, int startOffsetInEditor) {
        int textLength = text.length;
        if (editor.myDisableRtl) {
            return Collections.singletonList(new BidiRun(0, 0, textLength));
        }
        ArrayList<BidiRun> runs = new ArrayList<BidiRun>();
        if (startOffsetInEditor >= 0) {
            int lastOffset = startOffsetInEditor;
            IElementType lastToken = null;
            HighlighterIterator iterator = editor.getHighlighter().createIterator(startOffsetInEditor);
            int endOffsetInEditor = startOffsetInEditor + textLength;
            while (!iterator.atEnd() && iterator.getStart() < endOffsetInEditor) {
                IElementType currentToken = iterator.getTokenType();
                if (LineLayout.distinctTokens(lastToken, currentToken)) {
                    int tokenStart = Math.max(iterator.getStart(), startOffsetInEditor);
                    LineLayout.addRuns(runs, text, lastOffset - startOffsetInEditor, tokenStart - startOffsetInEditor);
                    lastToken = currentToken;
                    lastOffset = tokenStart;
                }
                iterator.advance();
            }
            LineLayout.addRuns(runs, text, lastOffset - startOffsetInEditor, endOffsetInEditor - startOffsetInEditor);
        } else {
            LineLayout.addRuns(runs, text, 0, textLength);
        }
        return runs;
    }

    private static boolean distinctTokens(@Nullable IElementType token1, @Nullable IElementType token2) {
        if (token1 == token2) {
            return false;
        }
        if (token1 == null || token2 == null) {
            return true;
        }
        if (!token1.getLanguage().is(token2.getLanguage())) {
            return true;
        }
        BidiRegionsSeparator separator = (BidiRegionsSeparator)LanguageBidiRegionsSeparator.INSTANCE.forLanguage(token1.getLanguage());
        return separator.createBorderBetweenTokens(token1, token2);
    }

    private static void addRuns(List<BidiRun> runs, char[] text, int start, int end) {
        if (start >= end) {
            return;
        }
        Bidi bidi = new Bidi(text, start, null, 0, end - start, -2);
        int runCount = bidi.getRunCount();
        for (int i = 0; i < runCount; ++i) {
            LineLayout.addOrMergeRun(runs, new BidiRun((byte)bidi.getRunLevel(i), start + bidi.getRunStart(i), start + bidi.getRunLimit(i)));
        }
    }

    private static void addOrMergeRun(List<BidiRun> runs, BidiRun run2) {
        int size = runs.size();
        if (size > 0 && runs.get(size - 1).level == 0 && run2.level == 0) {
            BidiRun lastRun = runs.remove(size - 1);
            assert (lastRun.endOffset == run2.startOffset);
            runs.add(new BidiRun(0, lastRun.startOffset, run2.endOffset));
        } else {
            runs.add(run2);
        }
    }

    private static void addFragments(BidiRun run2, char[] text, int start, int end, int fontStyle, FontPreferences fontPreferences, FontRenderContext fontRenderContext, @Nullable TabFragment tabFragment) {
        Font currentFont = null;
        int currentIndex = start;
        for (int i = start; i < end; ++i) {
            char c = text[i];
            if (c == '\t' && tabFragment != null) {
                assert (run2.level == 0);
                LineLayout.addTextFragmentIfNeeded(run2, text, currentIndex, i, currentFont, fontRenderContext, run2.isRtl());
                run2.fragments.add(tabFragment);
                currentFont = null;
                currentIndex = i + 1;
                continue;
            }
            Font font = ComplementaryFontsRegistry.getFontAbleToDisplay(c, fontStyle, fontPreferences).getFont();
            if (font.equals(currentFont)) continue;
            LineLayout.addTextFragmentIfNeeded(run2, text, currentIndex, i, currentFont, fontRenderContext, run2.isRtl());
            currentFont = font;
            currentIndex = i;
        }
        LineLayout.addTextFragmentIfNeeded(run2, text, currentIndex, end, currentFont, fontRenderContext, run2.isRtl());
    }

    private static void addTextFragmentIfNeeded(BidiRun run2, char[] chars, int from, int to, Font font, FontRenderContext fontRenderContext, boolean isRtl) {
        if (to > from) {
            assert (font != null);
            run2.fragments.add(new TextFragment(chars, from, to, isRtl, font, fontRenderContext));
        }
    }

    private float calculateWidth() {
        float x = 0.0f;
        for (VisualFragment fragment : this.getFragmentsInVisualOrder(x)) {
            x = fragment.getEndX();
        }
        return x;
    }

    float getWidth() {
        if (this.myWidth < 0.0f) {
            throw new RuntimeException("This LineLayout instance doesn't have precalculated width");
        }
        return this.myWidth;
    }

    int offsetToLogicalColumn(int offset) {
        if (offset <= 0) {
            return 0;
        }
        for (BidiRun run2 : this.myBidiRunsInLogicalOrder) {
            if (offset > run2.endOffset) continue;
            return run2.offsetToLogicalColumn(offset);
        }
        return this.myBidiRunsInLogicalOrder.length == 0 ? 0 : this.myBidiRunsInLogicalOrder[this.myBidiRunsInLogicalOrder.length - 1].endLogicalColumn;
    }

    int logicalColumnToOffset(int logicalColumn) {
        if (logicalColumn <= 0) {
            return 0;
        }
        for (BidiRun run2 : this.myBidiRunsInLogicalOrder) {
            if (logicalColumn > run2.endLogicalColumn) continue;
            return run2.logicalColumnToOffset(logicalColumn);
        }
        return this.myBidiRunsInLogicalOrder.length == 0 ? 0 : this.myBidiRunsInLogicalOrder[this.myBidiRunsInLogicalOrder.length - 1].endOffset;
    }

    Iterable<VisualFragment> getFragmentsInVisualOrder(final float startX) {
        return new Iterable<VisualFragment>(){

            @Override
            public Iterator<VisualFragment> iterator() {
                return new VisualOrderIterator(startX, 0, 0, 0, LineLayout.this.myBidiRunsInVisualOrder);
            }
        };
    }

    Iterable<VisualFragment> getFragmentsInVisualOrder(final float startX, final int startVisualColumn, final int startOffset, int endOffset) {
        BidiRun[] runs;
        assert (startOffset <= endOffset);
        int startLogicalColumn = 0;
        if (startOffset == endOffset) {
            runs = new BidiRun[]{};
        } else {
            ArrayList<BidiRun> runList = new ArrayList<BidiRun>();
            for (BidiRun run2 : this.myBidiRunsInLogicalOrder) {
                if (run2.endOffset <= startOffset) continue;
                if (run2.startOffset >= endOffset) break;
                runList.add(run2.subRun(startOffset, endOffset));
                if (run2.startOffset > startOffset) continue;
                startLogicalColumn = run2.offsetToLogicalColumn(startOffset);
            }
            runs = runList.toArray(new BidiRun[runList.size()]);
            LineLayout.reorderRunsVisually(runs);
        }
        final int finalStartLogicalColumn = startLogicalColumn;
        return new Iterable<VisualFragment>(){

            @Override
            public Iterator<VisualFragment> iterator() {
                return new VisualOrderIterator(startX, startVisualColumn, finalStartLogicalColumn, startOffset, runs);
            }
        };
    }

    boolean isLtr() {
        return this.myBidiRunsInLogicalOrder.length == 0 || this.myBidiRunsInLogicalOrder.length == 1 && !this.myBidiRunsInLogicalOrder[0].isRtl();
    }

    boolean isRtlLocation(int offset, boolean leanForward) {
        if (offset == 0 && !leanForward) {
            return false;
        }
        for (BidiRun run2 : this.myBidiRunsInLogicalOrder) {
            if (offset >= run2.endOffset && (offset != run2.endOffset || leanForward)) continue;
            return run2.isRtl();
        }
        return false;
    }

    int findNearestDirectionBoundary(int offset, boolean lookForward) {
        if (lookForward) {
            byte originLevel = -1;
            for (BidiRun run2 : this.myBidiRunsInLogicalOrder) {
                if (originLevel >= 0) {
                    if (run2.level == originLevel) continue;
                    return run2.startOffset;
                }
                if (run2.endOffset <= offset) continue;
                originLevel = run2.level;
            }
            return originLevel > 0 ? this.myBidiRunsInLogicalOrder[this.myBidiRunsInLogicalOrder.length - 1].endOffset : -1;
        }
        byte originLevel = -1;
        for (int i = this.myBidiRunsInLogicalOrder.length - 1; i >= 0; --i) {
            BidiRun run3 = this.myBidiRunsInLogicalOrder[i];
            if (originLevel >= 0) {
                if (run3.level == originLevel) continue;
                return run3.endOffset;
            }
            if (run3.startOffset >= offset) continue;
            originLevel = run3.level;
        }
        return originLevel > 0 ? 0 : -1;
    }

    public static class DummyLineFragment
    implements LineFragment {
        private final int myLength;
        private final float myCharWidth;

        public DummyLineFragment(int length, float charWidth) {
            this.myLength = length;
            this.myCharWidth = charWidth;
        }

        @Override
        public int getLength() {
            return this.myLength;
        }

        @Override
        public int getLogicalColumnCount(int startColumn) {
            return this.myLength;
        }

        @Override
        public int getVisualColumnCount(float startX) {
            return this.myLength;
        }

        @Override
        public int offsetToLogicalColumn(int startColumn, int offset) {
            return startColumn + offset;
        }

        @Override
        public int logicalColumnToOffset(int startColumn, int column) {
            return column - startColumn;
        }

        @Override
        public int logicalToVisualColumn(float startX, int startColumn, int column) {
            return column;
        }

        @Override
        public int visualToLogicalColumn(float startX, int startColumn, int column) {
            return column;
        }

        @Override
        public float visualColumnToX(float startX, int column) {
            return (float)column * this.myCharWidth;
        }

        @Override
        public int[] xToVisualColumn(float startX, float x) {
            float relX = x - startX;
            int column = Math.max(0, Math.min(this.myLength, Math.round(relX / this.myCharWidth)));
            return new int[]{column, relX <= (float)column * this.myCharWidth ? 0 : 1};
        }

        @Override
        public float offsetToX(float startX, int startOffset, int offset) {
            return (float)offset * this.myCharWidth;
        }

        @Override
        public void draw(Graphics2D g, float x, float y, int startColumn, int endColumn) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public LineFragment subFragment(int startOffset, int endOffset) {
            DummyLineFragment dummyLineFragment = new DummyLineFragment(endOffset - startOffset, this.myCharWidth);
            if (dummyLineFragment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/LineLayout$DummyLineFragment", "subFragment"));
            }
            return dummyLineFragment;
        }
    }

    static class VisualFragment {
        private LineFragment delegate;
        private int startOffset;
        private int startLogicalColumn;
        private int startVisualColumn;
        private float startX;
        private boolean isRtl;

        VisualFragment() {
        }

        boolean isRtl() {
            return this.isRtl;
        }

        int getMinOffset() {
            return this.isRtl ? this.startOffset - this.getLength() : this.startOffset;
        }

        int getMaxOffset() {
            return this.isRtl ? this.startOffset : this.startOffset + this.getLength();
        }

        int getStartOffset() {
            return this.startOffset;
        }

        int getEndOffset() {
            return this.isRtl ? this.startOffset - this.getLength() : this.startOffset + this.getLength();
        }

        int getLength() {
            return this.delegate.getLength();
        }

        int getStartLogicalColumn() {
            return this.startLogicalColumn;
        }

        int getEndLogicalColumn() {
            return this.isRtl ? this.startLogicalColumn - this.getLogicalColumnCount() : this.startLogicalColumn + this.getLogicalColumnCount();
        }

        int getMinLogicalColumn() {
            return this.isRtl ? this.startLogicalColumn - this.getLogicalColumnCount() : this.startLogicalColumn;
        }

        int getMaxLogicalColumn() {
            return this.isRtl ? this.startLogicalColumn : this.startLogicalColumn + this.getLogicalColumnCount();
        }

        int getStartVisualColumn() {
            return this.startVisualColumn;
        }

        int getEndVisualColumn() {
            return this.startVisualColumn + this.getVisualColumnCount();
        }

        int getLogicalColumnCount() {
            return this.isRtl ? this.getLength() : this.delegate.getLogicalColumnCount(this.getMinLogicalColumn());
        }

        int getVisualColumnCount() {
            return this.delegate.getVisualColumnCount(this.startX);
        }

        float getStartX() {
            return this.startX;
        }

        float getEndX() {
            return this.delegate.offsetToX(this.startX, 0, this.getLength());
        }

        float getWidth() {
            return this.getEndX() - this.getStartX();
        }

        int logicalToVisualColumn(int column) {
            return this.startVisualColumn + this.delegate.logicalToVisualColumn(this.startX, this.getMinLogicalColumn(), this.isRtl ? this.startLogicalColumn - column : column - this.startLogicalColumn);
        }

        int visualToLogicalColumn(int column) {
            int relativeLogicalColumn = this.delegate.visualToLogicalColumn(this.startX, this.getMinLogicalColumn(), column - this.startVisualColumn);
            return this.isRtl ? this.startLogicalColumn - relativeLogicalColumn : this.startLogicalColumn + relativeLogicalColumn;
        }

        float offsetToX(int offset) {
            return this.delegate.offsetToX(this.startX, 0, this.getRelativeOffset(offset));
        }

        float offsetToX(float startX, int startOffset, int offset) {
            return this.delegate.offsetToX(startX, this.getRelativeOffset(startOffset), this.getRelativeOffset(offset));
        }

        int[] xToVisualColumn(float x) {
            int[] column = this.delegate.xToVisualColumn(this.startX, x);
            column[0] = column[0] + this.startVisualColumn;
            return column;
        }

        float visualColumnToX(int column) {
            return this.delegate.visualColumnToX(this.startX, column - this.startVisualColumn);
        }

        void draw(Graphics2D g, float x, float y) {
            this.delegate.draw(g, x, y, 0, this.getLength());
        }

        void draw(Graphics2D g, float x, float y, int startRelativeColumn, int endRelativeColumn) {
            this.delegate.draw(g, x, y, startRelativeColumn, endRelativeColumn);
        }

        private int getRelativeOffset(int offset) {
            return this.isRtl ? this.startOffset - offset : offset - this.startOffset;
        }
    }

    private static class VisualOrderIterator
    implements Iterator<VisualFragment> {
        private BidiRun[] myRuns;
        private int myRunIndex = 0;
        private int myFragmentIndex = 0;
        private int myOffsetInsideRun = 0;
        private VisualFragment myFragment = new VisualFragment();

        private VisualOrderIterator(float startX, int startVisualColumn, int startLogicalColumn, int startOffset, BidiRun[] runsInVisualOrder) {
            this.myRuns = runsInVisualOrder;
            this.myFragment.startX = startX;
            this.myFragment.startVisualColumn = startVisualColumn;
            this.myFragment.startLogicalColumn = startLogicalColumn;
            this.myFragment.startOffset = startOffset;
        }

        @Override
        public boolean hasNext() {
            return this.myRunIndex < this.myRuns.length && this.myFragmentIndex < this.myRuns[this.myRunIndex].fragments.size();
        }

        @Override
        public VisualFragment next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BidiRun run2 = this.myRuns[this.myRunIndex];
            if (this.myRunIndex == 0 && this.myFragmentIndex == 0) {
                VisualFragment visualFragment = this.myFragment;
                visualFragment.startLogicalColumn = visualFragment.startLogicalColumn + ((run2.isRtl() ? run2.endOffset : run2.startOffset) - this.myFragment.startOffset);
            } else {
                this.myFragment.startLogicalColumn = this.myFragment.getEndLogicalColumn();
                if (this.myFragmentIndex == 0) {
                    VisualFragment visualFragment = this.myFragment;
                    visualFragment.startLogicalColumn = visualFragment.startLogicalColumn + ((run2.isRtl() ? run2.endOffset : run2.startOffset) - this.myFragment.getEndOffset());
                }
                this.myFragment.startVisualColumn = this.myFragment.getEndVisualColumn();
                this.myFragment.startX = this.myFragment.getEndX();
            }
            this.myFragment.isRtl = run2.isRtl();
            this.myFragment.delegate = (LineFragment)run2.fragments.get(run2.isRtl() ? run2.fragments.size() - 1 - this.myFragmentIndex : this.myFragmentIndex);
            this.myFragment.startOffset = run2.isRtl() ? run2.endOffset - this.myOffsetInsideRun : run2.startOffset + this.myOffsetInsideRun;
            this.myOffsetInsideRun += this.myFragment.getLength();
            ++this.myFragmentIndex;
            if (this.myFragmentIndex >= run2.fragments.size()) {
                this.myFragmentIndex = 0;
                this.myOffsetInsideRun = 0;
                ++this.myRunIndex;
            }
            return this.myFragment;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class BidiRun {
        private final byte level;
        private final int startOffset;
        private final int endOffset;
        private final List<LineFragment> fragments = new ArrayList<LineFragment>();
        private static final int INDEX_FREQUENCY = 100;
        private int startLogicalColumn;
        private int endLogicalColumn;
        private int[] offsetIndex;
        private int[] logicalColumnIndex;

        private BidiRun(byte level, int startOffset, int endOffset) {
            this.level = level;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        private boolean isRtl() {
            return (this.level & 1) != 0;
        }

        private BidiRun subRun(int targetStartOffset, int targetEndOffset) {
            assert (targetStartOffset < this.endOffset);
            assert (targetEndOffset > this.startOffset);
            if (targetStartOffset <= this.startOffset && targetEndOffset >= this.endOffset) {
                return this;
            }
            int start = Math.max(this.startOffset, targetStartOffset);
            int end = Math.min(this.endOffset, targetEndOffset);
            BidiRun run2 = new BidiRun(this.level, start, end);
            int offset = this.startOffset;
            int startFragment = 0;
            if (this.offsetIndex != null) {
                int pos = Arrays.binarySearch(this.offsetIndex, start);
                if (pos < 0) {
                    pos = -pos - 2;
                }
                if (pos >= 0) {
                    startFragment = (pos + 1) * 100;
                    offset = this.offsetIndex[pos];
                }
            }
            for (int i = startFragment; i < this.fragments.size(); ++i) {
                LineFragment fragment = this.fragments.get(i);
                if (end <= offset) break;
                int endOffset = offset + fragment.getLength();
                if (start < endOffset) {
                    run2.fragments.add(fragment.subFragment(Math.max(start, offset) - offset, Math.min(end, endOffset) - offset));
                }
                offset = endOffset;
            }
            return run2;
        }

        private int logicalColumnToOffset(int logicalColumn) {
            if (logicalColumn <= this.startLogicalColumn) {
                return this.startOffset;
            }
            if (logicalColumn >= this.endLogicalColumn) {
                return this.endOffset;
            }
            int currentOffset = this.startOffset;
            int currentLogicalColumn = this.startLogicalColumn;
            int startFragment = 0;
            if (this.offsetIndex != null) {
                int pos = Arrays.binarySearch(this.logicalColumnIndex == null ? this.offsetIndex : this.logicalColumnIndex, logicalColumn);
                if (pos >= 0) {
                    return this.offsetIndex[pos];
                }
                int beforeInsertPosition = -pos - 2;
                int n = currentOffset = beforeInsertPosition < 0 ? this.startOffset : this.offsetIndex[beforeInsertPosition];
                currentLogicalColumn = beforeInsertPosition < 0 ? this.startLogicalColumn : (this.logicalColumnIndex == null ? currentOffset : this.logicalColumnIndex[beforeInsertPosition]);
                startFragment = 100 * (beforeInsertPosition + 1);
            }
            for (int i = startFragment; i < this.fragments.size(); ++i) {
                LineFragment fragment = this.fragments.get(i);
                int endLogicalColumn = currentLogicalColumn + fragment.getLogicalColumnCount(currentLogicalColumn);
                if (logicalColumn <= endLogicalColumn) {
                    return currentOffset + fragment.logicalColumnToOffset(currentLogicalColumn, logicalColumn);
                }
                currentOffset += fragment.getLength();
                currentLogicalColumn = endLogicalColumn;
            }
            throw new IllegalStateException();
        }

        private int offsetToLogicalColumn(int offset) {
            if (offset <= this.startOffset) {
                return this.startLogicalColumn;
            }
            if (offset >= this.endOffset) {
                return this.endLogicalColumn;
            }
            int currentOffset = this.startOffset;
            int currentLogicalColumn = this.startLogicalColumn;
            int startFragment = 0;
            if (this.offsetIndex != null) {
                int pos = Arrays.binarySearch(this.offsetIndex, offset);
                if (pos >= 0) {
                    return this.logicalColumnIndex == null ? offset : this.logicalColumnIndex[pos];
                }
                int beforeInsertPosition = -pos - 2;
                int n = currentOffset = beforeInsertPosition < 0 ? this.startOffset : this.offsetIndex[beforeInsertPosition];
                currentLogicalColumn = beforeInsertPosition < 0 ? this.startLogicalColumn : (this.logicalColumnIndex == null ? currentOffset : this.logicalColumnIndex[beforeInsertPosition]);
                startFragment = 100 * (beforeInsertPosition + 1);
            }
            for (int i = startFragment; i < this.fragments.size(); ++i) {
                LineFragment fragment = this.fragments.get(i);
                int endOffset = currentOffset + fragment.getLength();
                if (offset <= endOffset) {
                    return fragment.offsetToLogicalColumn(currentLogicalColumn, offset - currentOffset);
                }
                currentOffset = endOffset;
                currentLogicalColumn += fragment.getLogicalColumnCount(currentLogicalColumn);
            }
            throw new IllegalStateException();
        }

        private int createIndices(int startLogicalColumn) {
            this.startLogicalColumn = this.endLogicalColumn = startLogicalColumn;
            int indexSize = (this.fragments.size() - 1) / 100;
            if (indexSize > 0) {
                this.offsetIndex = new int[indexSize];
            }
            int i = 0;
            int offset = this.startOffset;
            for (LineFragment fragment : this.fragments) {
                if (this.offsetIndex != null && i > 0 && i % 100 == 0) {
                    int pos = i / 100 - 1;
                    this.offsetIndex[pos] = offset;
                    if (this.logicalColumnIndex == null && offset != this.endLogicalColumn) {
                        this.logicalColumnIndex = new int[indexSize];
                        System.arraycopy(this.offsetIndex, 0, this.logicalColumnIndex, 0, pos);
                    }
                    if (this.logicalColumnIndex != null) {
                        this.logicalColumnIndex[pos] = this.endLogicalColumn;
                    }
                }
                ++i;
                offset += fragment.getLength();
                this.endLogicalColumn += fragment.getLogicalColumnCount(this.endLogicalColumn);
            }
            return this.endLogicalColumn;
        }
    }
}

