/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.LineLayout;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

class TextLayoutCache
implements PrioritizedDocumentListener,
Disposable {
    private final EditorView myView;
    private final Document myDocument;
    private ArrayList<LineLayout> myLines = new ArrayList();
    private int myDocumentChangeOldEndLine;
    private boolean myQuickLayoutsEnabled;

    TextLayoutCache(EditorView view) {
        this.myView = view;
        this.myDocument = view.getEditor().getDocument();
        this.myDocument.addDocumentListener((DocumentListener)this, (Disposable)this);
    }

    @Override
    public int getPriority() {
        return 70;
    }

    public void beforeDocumentChange(DocumentEvent event) {
        this.myDocumentChangeOldEndLine = this.getAdjustedLineNumber(event.getOffset() + event.getOldLength());
    }

    public void documentChanged(DocumentEvent event) {
        int startLine = this.myDocument.getLineNumber(event.getOffset());
        int newEndLine = this.getAdjustedLineNumber(event.getOffset() + event.getNewLength());
        this.invalidateLines(startLine, this.myDocumentChangeOldEndLine, newEndLine);
    }

    public void dispose() {
        this.myLines = null;
    }

    private int getAdjustedLineNumber(int offset) {
        return this.myDocument.getTextLength() == 0 ? -1 : this.myDocument.getLineNumber(offset);
    }

    void resetToDocumentSize() {
        this.checkDisposed();
        this.invalidateLines(0, this.myLines.size() - 1, this.myDocument.getLineCount() - 1);
    }

    void invalidateLines(int startLine, int oldEndLine, int newEndLine) {
        this.checkDisposed();
        int endLine = Math.min(oldEndLine, newEndLine);
        for (int line = startLine; line <= endLine; ++line) {
            this.myLines.set(line, null);
        }
        if (oldEndLine < newEndLine) {
            this.myLines.addAll(oldEndLine + 1, Collections.nCopies(newEndLine - oldEndLine, null));
        } else if (oldEndLine > newEndLine) {
            this.myLines.subList(newEndLine + 1, oldEndLine + 1).clear();
        }
    }

    @NotNull
    LineLayout getLineLayout(int line) {
        this.checkDisposed();
        LineLayout result = this.myLines.get(line);
        if (result == null) {
            int lineStart = this.myDocument.getLineStartOffset(line);
            int lineEnd = this.myDocument.getLineEndOffset(line);
            if (this.myQuickLayoutsEnabled) {
                result = new LineLayout(this.myView, lineEnd - lineStart);
                this.myView.getSizeManager().quickLineLayoutCreated();
            } else {
                result = new LineLayout(this.myView, lineStart, lineEnd, this.myView.getFontRenderContext());
                this.myLines.set(line, result);
                this.myView.getSizeManager().lineLayoutCreated(line);
            }
        }
        LineLayout lineLayout = result;
        if (lineLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/TextLayoutCache", "getLineLayout"));
        }
        return lineLayout;
    }

    void enableQuickLayouts(boolean enabled) {
        this.myQuickLayoutsEnabled = enabled;
    }

    private void checkDisposed() {
        if (this.myLines == null) {
            throw new IllegalStateException("Editor is already disposed");
        }
    }
}

