/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ArtifactExternalDependenciesImporter;
import com.intellij.openapi.externalSystem.service.project.ArtifactExternalDependenciesImporterImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.ManifestFileProvider;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.DefaultManifestFileProvider;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIdeModifiableModelsProvider
implements IdeModifiableModelsProvider {
    @NotNull
    protected final Project myProject;
    private ModifiableModuleModel myModifiableModuleModel;
    private Map<Module, ModifiableRootModel> myModifiableRootModels;
    private Map<Module, ModifiableFacetModel> myModifiableFacetModels;
    private Map<Library, Library.ModifiableModel> myModifiableLibraryModels;
    private ModifiableArtifactModel myModifiableArtifactModel;
    private MyPackagingElementResolvingContext myPackagingElementResolvingContext;
    private final ArtifactExternalDependenciesImporter myArtifactExternalDependenciesImporter;

    public AbstractIdeModifiableModelsProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "<init>"));
        }
        this.myModifiableRootModels = new THashMap();
        this.myModifiableFacetModels = new THashMap();
        this.myModifiableLibraryModels = new IdentityHashMap<Library, Library.ModifiableModel>();
        this.myProject = project;
        this.myArtifactExternalDependenciesImporter = new ArtifactExternalDependenciesImporterImpl();
    }

    protected abstract ModifiableArtifactModel doGetModifiableArtifactModel();

    protected abstract ModifiableModuleModel doGetModifiableModuleModel();

    protected abstract ModifiableRootModel doGetModifiableRootModel(Module var1);

    protected abstract ModifiableFacetModel doGetModifiableFacetModel(Module var1);

    protected abstract Library.ModifiableModel doGetModifiableLibraryModel(Library var1);

    @NotNull
    public abstract LibraryTable.ModifiableModel getModifiableProjectLibrariesModel();

    @NotNull
    public Module[] getModules() {
        Module[] moduleArray = this.myModifiableModuleModel == null ? ModuleManager.getInstance((Project)this.myProject).getModules() : this.getModifiableModuleModel().getModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getModules"));
        }
        return moduleArray;
    }

    @NotNull
    public Module[] getModules(final @NotNull ProjectData projectData) {
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getModules"));
        }
        List modules = ContainerUtil.filter((Object[])this.getModules(), (Condition)new Condition<Module>(){

            public boolean value(Module module) {
                return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData.getOwner(), (Module)module) && StringUtil.equals((CharSequence)projectData.getLinkedExternalProjectPath(), (CharSequence)ExternalSystemApiUtil.getExternalRootProjectPath((Module)module));
            }
        });
        Module[] moduleArray = (Module[])ContainerUtil.toArray((List)modules, (Object[])new Module[modules.size()]);
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getModules"));
        }
        return moduleArray;
    }

    protected void processExternalArtifactDependencies() {
        this.myArtifactExternalDependenciesImporter.applyChanges(this.getModifiableArtifactModel(), this.getPackagingElementResolvingContext());
    }

    public PackagingElementResolvingContext getPackagingElementResolvingContext() {
        if (this.myPackagingElementResolvingContext == null) {
            this.myPackagingElementResolvingContext = new MyPackagingElementResolvingContext();
        }
        return this.myPackagingElementResolvingContext;
    }

    @NotNull
    public OrderEntry[] getOrderEntries(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getOrderEntries"));
        }
        OrderEntry[] orderEntryArray = this.getRootModel(module, false).getOrderEntries();
        if (orderEntryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getOrderEntries"));
        }
        return orderEntryArray;
    }

    @NotNull
    public Module newModule(@NotNull String filePath, String moduleTypeId) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "newModule"));
        }
        Module module = this.getModifiableModuleModel().newModule(filePath, moduleTypeId);
        module.setOption("type", moduleTypeId);
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "newModule"));
        }
        return module2;
    }

    @Nullable
    public Module findIdeModule(@NotNull ModuleData module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "findIdeModule"));
        }
        Module ideModule = this.findIdeModule(module.getInternalName());
        return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)module.getOwner(), (Module)ideModule) ? ideModule : null;
    }

    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName) {
        if (ideModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModuleName", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "findIdeModule"));
        }
        for (Module module : this.getModules()) {
            if (!ideModuleName.equals(module.getName())) continue;
            return module;
        }
        return null;
    }

    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData) {
        if (libraryData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryData", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "findIdeLibrary"));
        }
        LibraryTable.ModifiableModel libraryTable = this.getModifiableProjectLibrariesModel();
        for (Library ideLibrary : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated((Library)ideLibrary, (LibraryData)libraryData)) continue;
            return ideLibrary;
        }
        return null;
    }

    @Nullable
    public ModuleOrderEntry findIdeModuleDependency(@NotNull ModuleDependencyData dependency, @NotNull Module module) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "findIdeModuleDependency"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "findIdeModuleDependency"));
        }
        for (OrderEntry entry : this.getRootModel(module, false).getOrderEntries()) {
            if (!(entry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry candidate = (ModuleOrderEntry)entry;
            if (!dependency.getInternalName().equals(candidate.getModuleName()) || !dependency.getScope().equals((Object)candidate.getScope())) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    public OrderEntry findIdeModuleOrderEntry(LibraryDependencyData data2) {
        Module ownerIdeModule = this.findIdeModule(data2.getOwnerModule());
        if (ownerIdeModule == null) {
            return null;
        }
        for (OrderEntry entry : this.getOrderEntries(ownerIdeModule)) {
            if (entry instanceof LibraryOrderEntry && ((LibraryOrderEntry)entry).isModuleLevel() && data2.getLevel() != LibraryLevel.MODULE || !data2.getInternalName().equals(entry.getPresentableName())) continue;
            return entry;
        }
        return null;
    }

    @NotNull
    public VirtualFile[] getContentRoots(Module module) {
        VirtualFile[] virtualFileArray = this.getRootModel(module, false).getContentRoots();
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getContentRoots"));
        }
        return virtualFileArray;
    }

    @NotNull
    public ModifiableModuleModel getModifiableModuleModel() {
        if (this.myModifiableModuleModel == null) {
            this.myModifiableModuleModel = this.doGetModifiableModuleModel();
        }
        ModifiableModuleModel modifiableModuleModel = this.myModifiableModuleModel;
        if (modifiableModuleModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getModifiableModuleModel"));
        }
        return modifiableModuleModel;
    }

    @NotNull
    public ModifiableRootModel getModifiableRootModel(Module module) {
        ModifiableRootModel modifiableRootModel = (ModifiableRootModel)this.getRootModel(module, true);
        if (modifiableRootModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getModifiableRootModel"));
        }
        return modifiableRootModel;
    }

    @NotNull
    private ModuleRootModel getRootModel(Module module, boolean modifiableModelNeeded) {
        ModifiableRootModel result = this.myModifiableRootModels.get(module);
        if (result == null) {
            if (!modifiableModelNeeded) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                if (moduleRootManager == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getRootModel"));
                }
                return moduleRootManager;
            }
            result = this.doGetModifiableRootModel(module);
            this.myModifiableRootModels.put(module, result);
        }
        ModifiableRootModel modifiableRootModel = result;
        if (modifiableRootModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getRootModel"));
        }
        return modifiableRootModel;
    }

    @NotNull
    public ModifiableFacetModel getModifiableFacetModel(Module module) {
        ModifiableFacetModel result = this.myModifiableFacetModels.get(module);
        if (result == null) {
            result = this.doGetModifiableFacetModel(module);
            this.myModifiableFacetModels.put(module, result);
        }
        ModifiableFacetModel modifiableFacetModel = result;
        if (modifiableFacetModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getModifiableFacetModel"));
        }
        return modifiableFacetModel;
    }

    @NotNull
    public ModifiableArtifactModel getModifiableArtifactModel() {
        if (this.myModifiableArtifactModel == null) {
            this.myModifiableArtifactModel = this.doGetModifiableArtifactModel();
        }
        ModifiableArtifactModel modifiableArtifactModel = this.myModifiableArtifactModel;
        if (modifiableArtifactModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getModifiableArtifactModel"));
        }
        return modifiableArtifactModel;
    }

    @NotNull
    public Library[] getAllLibraries() {
        Library[] libraryArray = this.getModifiableProjectLibrariesModel().getLibraries();
        if (libraryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getAllLibraries"));
        }
        return libraryArray;
    }

    @Nullable
    public Library getLibraryByName(String name) {
        return this.getModifiableProjectLibrariesModel().getLibraryByName(name);
    }

    public Library createLibrary(String name) {
        return this.getModifiableProjectLibrariesModel().createLibrary(name);
    }

    public void removeLibrary(Library library) {
        this.getModifiableProjectLibrariesModel().removeLibrary(library);
    }

    public Library.ModifiableModel getModifiableLibraryModel(Library library) {
        Library.ModifiableModel result = this.myModifiableLibraryModels.get(library);
        if (result == null) {
            result = this.doGetModifiableLibraryModel(library);
            this.myModifiableLibraryModels.put(library, result);
        }
        return result;
    }

    @NotNull
    public String[] getLibraryUrls(@NotNull Library library, @NotNull OrderRootType type) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getLibraryUrls"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getLibraryUrls"));
        }
        Library.ModifiableModel model = this.myModifiableLibraryModels.get(library);
        if (model != null) {
            String[] stringArray = model.getUrls(type);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getLibraryUrls"));
            }
            return stringArray;
        }
        String[] stringArray = library.getUrls(type);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getLibraryUrls"));
        }
        return stringArray;
    }

    public ModalityState getModalityStateForQuestionDialogs() {
        return ModalityState.NON_MODAL;
    }

    public ArtifactExternalDependenciesImporter getArtifactExternalDependenciesImporter() {
        return this.myArtifactExternalDependenciesImporter;
    }

    public void commit() {
        ((ProjectRootManagerEx)ProjectRootManager.getInstance((Project)this.myProject)).mergeRootsChangesDuring(new Runnable(){

            @Override
            public void run() {
                AbstractIdeModifiableModelsProvider.this.processExternalArtifactDependencies();
                for (Library.ModifiableModel each : AbstractIdeModifiableModelsProvider.this.myModifiableLibraryModels.values()) {
                    each.commit();
                }
                AbstractIdeModifiableModelsProvider.this.getModifiableProjectLibrariesModel().commit();
                Collection rootModels = AbstractIdeModifiableModelsProvider.this.myModifiableRootModels.values();
                ModifiableRootModel[] rootModels1 = rootModels.toArray(new ModifiableRootModel[rootModels.size()]);
                for (ModifiableRootModel model : rootModels1) {
                    assert (!model.isDisposed()) : "Already disposed: " + model;
                }
                if (AbstractIdeModifiableModelsProvider.this.myModifiableModuleModel != null) {
                    ModifiableModelCommitter.multiCommit(rootModels1, AbstractIdeModifiableModelsProvider.this.myModifiableModuleModel);
                } else {
                    for (ModifiableRootModel model : rootModels1) {
                        model.commit();
                    }
                }
                for (Map.Entry entry : AbstractIdeModifiableModelsProvider.this.myModifiableFacetModels.entrySet()) {
                    if (((Module)entry.getKey()).isDisposed()) continue;
                    ((ModifiableFacetModel)entry.getValue()).commit();
                }
                if (AbstractIdeModifiableModelsProvider.this.myModifiableArtifactModel != null) {
                    AbstractIdeModifiableModelsProvider.this.myModifiableArtifactModel.commit();
                }
            }
        });
    }

    public void dispose() {
        for (ModifiableRootModel modifiableRootModel : this.myModifiableRootModels.values()) {
            if (modifiableRootModel.isDisposed()) continue;
            modifiableRootModel.dispose();
        }
        Disposer.dispose((Disposable)this.getModifiableProjectLibrariesModel());
        for (Library.ModifiableModel modifiableModel : this.myModifiableLibraryModels.values()) {
            Disposer.dispose((Disposable)modifiableModel);
        }
        if (this.myModifiableModuleModel != null) {
            this.myModifiableModuleModel.dispose();
        }
        if (this.myModifiableArtifactModel != null) {
            this.myModifiableArtifactModel.dispose();
        }
        this.myModifiableRootModels.clear();
        this.myModifiableFacetModels.clear();
        this.myModifiableLibraryModels.clear();
    }

    private class MyFacetsProvider
    implements FacetsProvider {
        private MyFacetsProvider() {
        }

        @NotNull
        public Facet[] getAllFacets(Module module) {
            Facet[] facetArray = AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module).getAllFacets();
            if (facetArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyFacetsProvider", "getAllFacets"));
            }
            return facetArray;
        }

        @NotNull
        public <F extends Facet> Collection<F> getFacetsByType(Module module, FacetTypeId<F> type) {
            Collection collection = AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module).getFacetsByType(type);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyFacetsProvider", "getFacetsByType"));
            }
            return collection;
        }

        public <F extends Facet> F findFacet(Module module, FacetTypeId<F> type, String name) {
            return (F)AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module).findFacet(type, name);
        }
    }

    private class MyModulesProvider
    implements ModulesProvider {
        private MyModulesProvider() {
        }

        @NotNull
        public Module[] getModules() {
            Module[] moduleArray = AbstractIdeModifiableModelsProvider.this.getModules();
            if (moduleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyModulesProvider", "getModules"));
            }
            return moduleArray;
        }

        public Module getModule(String name) {
            return AbstractIdeModifiableModelsProvider.this.findIdeModule(name);
        }

        public ModuleRootModel getRootModel(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyModulesProvider", "getRootModel"));
            }
            return AbstractIdeModifiableModelsProvider.this.getModifiableRootModel(module);
        }

        public FacetModel getFacetModel(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyModulesProvider", "getFacetModel"));
            }
            return AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module);
        }
    }

    private class MyPackagingElementResolvingContext
    implements PackagingElementResolvingContext {
        private final ModulesProvider myModulesProvider;
        private final MyFacetsProvider myFacetsProvider;
        private final ManifestFileProvider myManifestFileProvider;

        private MyPackagingElementResolvingContext() {
            this.myModulesProvider = new MyModulesProvider();
            this.myFacetsProvider = new MyFacetsProvider();
            this.myManifestFileProvider = new DefaultManifestFileProvider(this);
        }

        @NotNull
        public Project getProject() {
            Project project = AbstractIdeModifiableModelsProvider.this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "getProject"));
            }
            return project;
        }

        @NotNull
        public ArtifactModel getArtifactModel() {
            ModifiableArtifactModel modifiableArtifactModel = AbstractIdeModifiableModelsProvider.this.getModifiableArtifactModel();
            if (modifiableArtifactModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "getArtifactModel"));
            }
            return modifiableArtifactModel;
        }

        @NotNull
        public ModulesProvider getModulesProvider() {
            ModulesProvider modulesProvider = this.myModulesProvider;
            if (modulesProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "getModulesProvider"));
            }
            return modulesProvider;
        }

        @NotNull
        public FacetsProvider getFacetsProvider() {
            MyFacetsProvider myFacetsProvider = this.myFacetsProvider;
            if (myFacetsProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "getFacetsProvider"));
            }
            return myFacetsProvider;
        }

        public Library findLibrary(@NotNull String level, @NotNull String libraryName) {
            if (level == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "findLibrary"));
            }
            if (libraryName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "findLibrary"));
            }
            if (level.equals("project")) {
                return AbstractIdeModifiableModelsProvider.this.getLibraryByName(libraryName);
            }
            LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, AbstractIdeModifiableModelsProvider.this.myProject);
            return table != null ? table.getLibraryByName(libraryName) : null;
        }

        @NotNull
        public ManifestFileProvider getManifestFileProvider() {
            ManifestFileProvider manifestFileProvider = this.myManifestFileProvider;
            if (manifestFileProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "getManifestFileProvider"));
            }
            return manifestFileProvider;
        }
    }
}

