/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.settings;

import com.intellij.openapi.externalSystem.service.settings.ExternalSystemSettingsControlCustomizer;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBCheckBox;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalProjectSettingsControl<S extends ExternalProjectSettings>
implements ExternalSystemSettingsControl<S> {
    @Nullable
    private Project myProject;
    @NotNull
    private S myInitialSettings;
    @Nullable
    private JBCheckBox myUseAutoImportBox;
    @Nullable
    private JBCheckBox myCreateEmptyContentRootDirectoriesBox;
    @NotNull
    private ExternalSystemSettingsControlCustomizer myCustomizer;

    protected AbstractExternalProjectSettingsControl(@NotNull S initialSettings) {
        if (initialSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialSettings", "com/intellij/openapi/externalSystem/service/settings/AbstractExternalProjectSettingsControl", "<init>"));
        }
        this(null, initialSettings, null);
    }

    protected AbstractExternalProjectSettingsControl(@Nullable Project project, @NotNull S initialSettings, @Nullable ExternalSystemSettingsControlCustomizer controlCustomizer) {
        if (initialSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialSettings", "com/intellij/openapi/externalSystem/service/settings/AbstractExternalProjectSettingsControl", "<init>"));
        }
        this.myProject = project;
        this.myInitialSettings = initialSettings;
        this.myCustomizer = controlCustomizer == null ? new ExternalSystemSettingsControlCustomizer() : controlCustomizer;
    }

    @NotNull
    public S getInitialSettings() {
        S s = this.myInitialSettings;
        if (s == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/settings/AbstractExternalProjectSettingsControl", "getInitialSettings"));
        }
        return s;
    }

    @Override
    public void fillUi(@NotNull PaintAwarePanel canvas, int indentLevel) {
        if (canvas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canvas", "com/intellij/openapi/externalSystem/service/settings/AbstractExternalProjectSettingsControl", "fillUi"));
        }
        if (!this.myCustomizer.isUseAutoImportBoxHidden()) {
            this.myUseAutoImportBox = new JBCheckBox(ExternalSystemBundle.message((String)"settings.label.use.auto.import", (Object[])new Object[0]));
            canvas.add((Component)this.myUseAutoImportBox, ExternalSystemUiUtil.getFillLineConstraints(indentLevel));
        }
        if (!this.myCustomizer.isCreateEmptyContentRootDirectoriesBoxHidden()) {
            this.myCreateEmptyContentRootDirectoriesBox = new JBCheckBox(ExternalSystemBundle.message((String)"settings.label.create.empty.content.root.directories", (Object[])new Object[0]));
            canvas.add((Component)this.myCreateEmptyContentRootDirectoriesBox, ExternalSystemUiUtil.getFillLineConstraints(indentLevel));
        }
        this.fillExtraControls(canvas, indentLevel);
    }

    protected abstract void fillExtraControls(@NotNull PaintAwarePanel var1, int var2);

    @Override
    public boolean isModified() {
        boolean result = false;
        if (!this.myCustomizer.isUseAutoImportBoxHidden() && this.myUseAutoImportBox != null) {
            boolean bl = result = this.myUseAutoImportBox.isSelected() != this.getInitialSettings().isUseAutoImport();
        }
        if (!this.myCustomizer.isCreateEmptyContentRootDirectoriesBoxHidden() && this.myCreateEmptyContentRootDirectoriesBox != null) {
            result = result || this.myCreateEmptyContentRootDirectoriesBox.isSelected() != this.getInitialSettings().isCreateEmptyContentRootDirectories();
        }
        return result || this.isExtraSettingModified();
    }

    protected abstract boolean isExtraSettingModified();

    @Override
    public void reset() {
        this.reset(false);
    }

    public void reset(boolean isDefaultModuleCreation) {
        if (!this.myCustomizer.isUseAutoImportBoxHidden() && this.myUseAutoImportBox != null) {
            this.myUseAutoImportBox.setSelected(this.getInitialSettings().isUseAutoImport());
        }
        if (!this.myCustomizer.isCreateEmptyContentRootDirectoriesBoxHidden() && this.myCreateEmptyContentRootDirectoriesBox != null) {
            this.myCreateEmptyContentRootDirectoriesBox.setSelected(this.getInitialSettings().isCreateEmptyContentRootDirectories());
        }
        this.resetExtraSettings(isDefaultModuleCreation);
    }

    protected abstract void resetExtraSettings(boolean var1);

    @Override
    public void apply(@NotNull S settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/service/settings/AbstractExternalProjectSettingsControl", "apply"));
        }
        if (!this.myCustomizer.isUseAutoImportBoxHidden() && this.myUseAutoImportBox != null) {
            settings.setUseAutoImport(this.myUseAutoImportBox.isSelected());
        }
        if (!this.myCustomizer.isCreateEmptyContentRootDirectoriesBoxHidden() && this.myCreateEmptyContentRootDirectoriesBox != null) {
            settings.setCreateEmptyContentRootDirectories(this.myCreateEmptyContentRootDirectoriesBox.isSelected());
        }
        if (this.myInitialSettings.getExternalProjectPath() != null) {
            settings.setExternalProjectPath(this.myInitialSettings.getExternalProjectPath());
        }
        this.applyExtraSettings(settings);
    }

    protected abstract void applyExtraSettings(@NotNull S var1);

    @Override
    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi(this);
    }

    @Override
    public void showUi(boolean show) {
        ExternalSystemUiUtil.showUi(this, show);
    }

    public void updateInitialSettings() {
        if (!this.myCustomizer.isUseAutoImportBoxHidden() && this.myUseAutoImportBox != null) {
            this.myInitialSettings.setUseAutoImport(this.myUseAutoImportBox.isSelected());
        }
        if (!this.myCustomizer.isCreateEmptyContentRootDirectoriesBoxHidden() && this.myCreateEmptyContentRootDirectoriesBox != null) {
            this.myInitialSettings.setCreateEmptyContentRootDirectories(this.myCreateEmptyContentRootDirectoriesBox.isSelected());
        }
        this.updateInitialExtraSettings();
    }

    protected void updateInitialExtraSettings() {
    }

    public void setCurrentProject(@Nullable Project project) {
        this.myProject = project;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }
}

