/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorHistoryManager
extends AbstractProjectComponent
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.EditorHistoryManager");
    private Element myElement;
    private final List<HistoryEntry> myEntriesList = new ArrayList<HistoryEntry>();

    public static EditorHistoryManager getInstance(Project project) {
        return (EditorHistoryManager)((Object)project.getComponent(EditorHistoryManager.class));
    }

    EditorHistoryManager(Project project, UISettings uiSettings) {
        super(project);
        uiSettings.addUISettingsListener((UISettingsListener)new MyUISettingsListener(), (Disposable)project);
    }

    public void projectOpened() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER, (Object)new MyEditorManagerBeforeListener());
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyEditorManagerListener());
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(){

            public void run() {
                if (EditorHistoryManager.this.myElement != null) {
                    List children = EditorHistoryManager.this.myElement.getChildren("entry");
                    EditorHistoryManager.this.myElement = null;
                    for (Element e : children) {
                        try {
                            EditorHistoryManager.this.addEntry(new HistoryEntry(EditorHistoryManager.this.myProject, e));
                        }
                        catch (InvalidDataException invalidDataException) {
                        }
                        catch (ProcessCanceledException processCanceledException) {
                        }
                        catch (Exception anyException) {
                            LOG.error((Throwable)anyException);
                        }
                    }
                    EditorHistoryManager.this.trimToSize();
                }
            }
        });
    }

    private synchronized void addEntry(HistoryEntry entry) {
        this.myEntriesList.add(entry);
    }

    private synchronized void removeEntry(HistoryEntry entry) {
        this.myEntriesList.remove(entry);
    }

    @NotNull
    public String getComponentName() {
        if ("editorHistoryManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager", "getComponentName"));
        }
        return "editorHistoryManager";
    }

    private void fileOpenedImpl(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager", "fileOpenedImpl"));
        }
        this.fileOpenedImpl(file, null, null);
    }

    private void fileOpenedImpl(@NotNull VirtualFile file, @Nullable FileEditor fallbackEditor, @Nullable FileEditorProvider fallbackProvider) {
        FileEditor selectedEditor;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager", "fileOpenedImpl"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (VirtualFileManager.getInstance().findFileByUrl(file.getUrl()) == null) {
            return;
        }
        FileEditorManagerEx editorManager = FileEditorManagerEx.getInstanceEx(this.myProject);
        Pair<FileEditor[], FileEditorProvider[]> editorsWithProviders = editorManager.getEditorsWithProviders(file);
        Object[] editors = (FileEditor[])editorsWithProviders.getFirst();
        FileEditorProvider[] oldProviders = (FileEditorProvider[])editorsWithProviders.getSecond();
        if (editors.length <= 0 && fallbackEditor != null) {
            editors = new FileEditor[]{fallbackEditor};
        }
        if (oldProviders.length <= 0 && fallbackProvider != null) {
            oldProviders = new FileEditorProvider[]{fallbackProvider};
        }
        if (editors.length <= 0) {
            LOG.error("No editors for file " + file.getPresentableUrl());
        }
        if ((selectedEditor = editorManager.getSelectedEditor(file)) == null) {
            selectedEditor = fallbackEditor;
        }
        LOG.assertTrue(selectedEditor != null);
        int selectedProviderIndex = ArrayUtilRt.find((Object[])editors, (Object)selectedEditor);
        LOG.assertTrue(selectedProviderIndex != -1, (Object)("Can't find " + selectedEditor + " among " + Arrays.asList(editors)));
        HistoryEntry entry = this.getEntry(file);
        if (entry != null) {
            this.removeEntry(entry);
            this.addEntry(entry);
        } else {
            FileEditorState[] states = new FileEditorState[editors.length];
            FileEditorProvider[] providers = new FileEditorProvider[editors.length];
            for (int i = states.length - 1; i >= 0; --i) {
                FileEditorProvider provider = oldProviders[i];
                LOG.assertTrue(provider != null);
                providers[i] = provider;
                states[i] = editors[i].getState(FileEditorStateLevel.FULL);
            }
            this.addEntry(new HistoryEntry(file, providers, states, providers[selectedProviderIndex]));
            this.trimToSize();
        }
    }

    public void updateHistoryEntry(@Nullable VirtualFile file, boolean changeEntryOrderOnly) {
        this.updateHistoryEntry(file, null, null, changeEntryOrderOnly);
    }

    private void updateHistoryEntry(@Nullable VirtualFile file, @Nullable FileEditor fallbackEditor, @Nullable FileEditorProvider fallbackProvider, boolean changeEntryOrderOnly) {
        Pair<FileEditor, FileEditorProvider> selectedEditorWithProvider;
        if (file == null) {
            return;
        }
        FileEditorManagerEx editorManager = FileEditorManagerEx.getInstanceEx(this.myProject);
        Pair<FileEditor[], FileEditorProvider[]> editorsWithProviders = editorManager.getEditorsWithProviders(file);
        FileEditor[] editors = (FileEditor[])editorsWithProviders.getFirst();
        FileEditorProvider[] providers = (FileEditorProvider[])editorsWithProviders.getSecond();
        if (editors.length <= 0 && fallbackEditor != null) {
            editors = new FileEditor[]{fallbackEditor};
            providers = new FileEditorProvider[]{fallbackProvider};
        }
        if (editors.length == 0) {
            return;
        }
        HistoryEntry entry = this.getEntry(file);
        if (entry == null) {
            if (file.isValid()) {
                this.fileOpenedImpl(file, fallbackEditor, fallbackProvider);
            }
            return;
        }
        if (!changeEntryOrderOnly) {
            for (int i = editors.length - 1; i >= 0; --i) {
                FileEditor editor = editors[i];
                FileEditorProvider provider = providers[i];
                if (!editor.isValid()) continue;
                FileEditorState oldState = entry.getState(provider);
                FileEditorState newState = editor.getState(FileEditorStateLevel.FULL);
                if (newState.equals(oldState)) continue;
                entry.putState(provider, newState);
            }
        }
        if ((selectedEditorWithProvider = editorManager.getSelectedEditorWithProvider(file)) != null) {
            entry.mySelectedProvider = (FileEditorProvider)selectedEditorWithProvider.getSecond();
            LOG.assertTrue(entry.mySelectedProvider != null);
            if (changeEntryOrderOnly) {
                this.removeEntry(entry);
                this.addEntry(entry);
            }
        }
    }

    private synchronized void validateEntries() {
        for (int i = this.myEntriesList.size() - 1; i >= 0; --i) {
            HistoryEntry entry = this.myEntriesList.get(i);
            if (entry.myFile.isValid()) continue;
            this.myEntriesList.remove(i);
        }
    }

    public synchronized VirtualFile[] getFiles() {
        this.validateEntries();
        VirtualFile[] result = new VirtualFile[this.myEntriesList.size()];
        for (int i = this.myEntriesList.size() - 1; i >= 0; --i) {
            result[i] = this.myEntriesList.get((int)i).myFile;
        }
        return result;
    }

    public LinkedHashSet<VirtualFile> getFileSet() {
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        for (VirtualFile file : this.getFiles()) {
            result.remove(file);
            result.add(file);
        }
        return result;
    }

    public synchronized boolean hasBeenOpen(@NotNull VirtualFile f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager", "hasBeenOpen"));
        }
        for (HistoryEntry each : this.myEntriesList) {
            if (!Comparing.equal((Object)each.myFile, (Object)f)) continue;
            return true;
        }
        return false;
    }

    public synchronized void removeFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager", "removeFile"));
        }
        HistoryEntry entry = this.getEntry(file);
        if (entry != null) {
            this.removeEntry(entry);
        }
    }

    public FileEditorState getState(@NotNull VirtualFile file, FileEditorProvider provider) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager", "getState"));
        }
        this.validateEntries();
        HistoryEntry entry = this.getEntry(file);
        return entry != null ? entry.getState(provider) : null;
    }

    public FileEditorProvider getSelectedProvider(VirtualFile file) {
        this.validateEntries();
        HistoryEntry entry = this.getEntry(file);
        return entry != null ? entry.mySelectedProvider : null;
    }

    private synchronized HistoryEntry getEntry(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager", "getEntry"));
        }
        this.validateEntries();
        for (int i = this.myEntriesList.size() - 1; i >= 0; --i) {
            HistoryEntry entry = this.myEntriesList.get(i);
            if (!file.equals(entry.myFile)) continue;
            return entry;
        }
        return null;
    }

    private synchronized void trimToSize() {
        int limit = UISettings.getInstance().RECENT_FILES_LIMIT + 1;
        while (this.myEntriesList.size() > limit) {
            this.myEntriesList.remove(0);
        }
    }

    public void readExternal(Element element) {
        this.myElement = element.clone();
    }

    public synchronized void writeExternal(Element element) {
        VirtualFile[] openFiles = FileEditorManager.getInstance((Project)this.myProject).getOpenFiles();
        for (int i = openFiles.length - 1; i >= 0; --i) {
            VirtualFile file = openFiles[i];
            if (this.getEntry(file) == null) continue;
            this.updateHistoryEntry(file, false);
        }
        for (HistoryEntry entry : this.myEntriesList) {
            entry.writeExternal(element, this.myProject);
        }
    }

    private final class MyUISettingsListener
    implements UISettingsListener {
        private MyUISettingsListener() {
        }

        public void uiSettingsChanged(UISettings source) {
            EditorHistoryManager.this.trimToSize();
        }
    }

    private final class MyEditorManagerBeforeListener
    extends FileEditorManagerListener.Before.Adapter {
        private MyEditorManagerBeforeListener() {
        }

        public void beforeFileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager$MyEditorManagerBeforeListener", "beforeFileClosed"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager$MyEditorManagerBeforeListener", "beforeFileClosed"));
            }
            EditorHistoryManager.this.updateHistoryEntry(file, false);
        }
    }

    private final class MyEditorManagerListener
    extends FileEditorManagerAdapter {
        private MyEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager$MyEditorManagerListener", "fileOpened"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager$MyEditorManagerListener", "fileOpened"));
            }
            EditorHistoryManager.this.fileOpenedImpl(file);
        }

        public void selectionChanged(final @NotNull FileEditorManagerEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager$MyEditorManagerListener", "selectionChanged"));
            }
            PsiDocumentManager.getInstance((Project)EditorHistoryManager.this.myProject).performWhenAllCommitted(new Runnable(){

                @Override
                public void run() {
                    EditorHistoryManager.this.updateHistoryEntry(event.getOldFile(), event.getOldEditor(), event.getOldProvider(), false);
                    EditorHistoryManager.this.updateHistoryEntry(event.getNewFile(), true);
                }
            });
        }
    }
}

