/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.UniqueNameBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UniqueVFilePathBuilderImpl
extends UniqueVFilePathBuilder {
    private static final Key<CachedValue<ConcurrentMap<String, UniqueNameBuilder<VirtualFile>>>> ourShortNameBuilderCacheKey = Key.create((String)"project's.short.file.name.builder");
    private static final Key<CachedValue<ConcurrentMap<String, UniqueNameBuilder<VirtualFile>>>> ourShortNameOpenedBuilderCacheKey = Key.create((String)"project's.short.file.name.opened.builder");
    private static final UniqueNameBuilder<VirtualFile> ourEmptyBuilder = new UniqueNameBuilder(null, null, -1);

    @NotNull
    public String getUniqueVirtualFilePath(Project project, VirtualFile file) {
        String string = UniqueVFilePathBuilderImpl.getUniqueVirtualFilePath(project, file, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/UniqueVFilePathBuilderImpl", "getUniqueVirtualFilePath"));
        }
        return string;
    }

    @NotNull
    public String getUniqueVirtualFilePathWithinOpenedFileEditors(Project project, VirtualFile vFile) {
        String string = UniqueVFilePathBuilderImpl.getUniqueVirtualFilePath(project, vFile, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/UniqueVFilePathBuilderImpl", "getUniqueVirtualFilePathWithinOpenedFileEditors"));
        }
        return string;
    }

    private static String getUniqueVirtualFilePath(Project project, VirtualFile file, boolean skipNonOpenedFiles) {
        String fileName;
        ConcurrentMap valueMap;
        UniqueNameBuilder<VirtualFile> uniqueNameBuilderForShortName;
        Key<CachedValue<ConcurrentMap<String, UniqueNameBuilder<VirtualFile>>>> key = skipNonOpenedFiles ? ourShortNameOpenedBuilderCacheKey : ourShortNameBuilderCacheKey;
        CachedValue data = (CachedValue)project.getUserData(key);
        if (data == null) {
            data = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<ConcurrentMap<String, UniqueNameBuilder<VirtualFile>>>(){

                @Nullable
                public CachedValueProvider.Result<ConcurrentMap<String, UniqueNameBuilder<VirtualFile>>> compute() {
                    return new CachedValueProvider.Result((Object)ContainerUtil.createConcurrentSoftValueMap(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, FileEditorManagerImpl.OPEN_FILE_SET_MODIFICATION_COUNT});
                }
            }, false);
            project.putUserData(key, (Object)data);
        }
        if ((uniqueNameBuilderForShortName = (UniqueNameBuilder<VirtualFile>)(valueMap = (ConcurrentMap)data.getValue()).get(fileName = file.getName())) == null) {
            UniqueNameBuilder<VirtualFile> builder = UniqueVFilePathBuilderImpl.filesWithTheSameName(fileName, project, skipNonOpenedFiles, ProjectScope.getProjectScope((Project)project));
            valueMap.put(fileName, builder != null ? builder : ourEmptyBuilder);
            uniqueNameBuilderForShortName = builder;
        } else if (uniqueNameBuilderForShortName == ourEmptyBuilder) {
            uniqueNameBuilderForShortName = null;
        }
        if (uniqueNameBuilderForShortName != null && uniqueNameBuilderForShortName.contains((Object)file)) {
            if (file instanceof VirtualFilePathWrapper) {
                return ((VirtualFilePathWrapper)file).getPresentablePath();
            }
            return UniqueVFilePathBuilderImpl.getEditorTabText(file, uniqueNameBuilderForShortName, UISettings.getInstance().HIDE_KNOWN_EXTENSION_IN_TABS);
        }
        return file.getPresentableName();
    }

    @Nullable
    private static UniqueNameBuilder<VirtualFile> filesWithTheSameName(String fileName, Project project, boolean skipNonOpenedFiles, GlobalSearchScope scope) {
        THashSet filesWithSameName = skipNonOpenedFiles ? Collections.emptySet() : FilenameIndex.getVirtualFilesByName(project, fileName, scope);
        THashSet setOfFilesWithTheSameName = new THashSet(filesWithSameName);
        for (VirtualFile openFile : FileEditorManager.getInstance((Project)project).getOpenFiles()) {
            if (!openFile.getName().equals(fileName)) continue;
            setOfFilesWithTheSameName.add((Object)openFile);
        }
        for (VirtualFile recentlyEditedFile : EditorHistoryManager.getInstance(project).getFiles()) {
            if (!recentlyEditedFile.getName().equals(fileName)) continue;
            setOfFilesWithTheSameName.add((Object)recentlyEditedFile);
        }
        filesWithSameName = setOfFilesWithTheSameName;
        if (filesWithSameName.size() > 1) {
            String path = project.getBasePath();
            path = path == null ? "" : FileUtil.toSystemIndependentName((String)path);
            UniqueNameBuilder builder = new UniqueNameBuilder(path, File.separator, 25);
            for (VirtualFile virtualFile : filesWithSameName) {
                builder.addPath((Object)virtualFile, virtualFile.getPath());
            }
            return builder;
        }
        return null;
    }

    public static <T> String getEditorTabText(T key, UniqueNameBuilder<T> builder, boolean hideKnownExtensionInTabs) {
        String withoutExtension;
        String result = builder.getShortPath(key);
        if (hideKnownExtensionInTabs && StringUtil.isNotEmpty((String)(withoutExtension = FileUtil.getNameWithoutExtension((String)result))) && !withoutExtension.endsWith(builder.getSeparator())) {
            return withoutExtension;
        }
        return result;
    }
}

