/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.TransferToPooledThreadQueue;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.UserBinaryFileType;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.fileTypes.ex.CustomFileTypeFactory;
import com.intellij.openapi.fileTypes.ex.ExternalizableFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.fileTypes.impl.IgnoredFileCache;
import com.intellij.openapi.fileTypes.impl.IgnoredPatternSet;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentPackedBitsArray;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FileTypeManager", storages={@Storage(file="$APP_CONFIG$/filetypes.xml")}, additionalExportFile="filetypes")
public class FileTypeManagerImpl
extends FileTypeManagerEx
implements PersistentStateComponent<Element>,
ApplicationComponent,
Disposable {
    private static final Logger LOG = Logger.getInstance(FileTypeManagerImpl.class);
    private static final int VERSION = 15;
    private static final Key<FileType> FILE_TYPE_KEY = Key.create((String)"FILE_TYPE_KEY");
    static final Key<FileType> DETECTED_FROM_CONTENT_FILE_TYPE_KEY = Key.create((String)"DETECTED_FROM_CONTENT_FILE_TYPE_KEY");
    private static final int DETECT_BUFFER_SIZE = 8192;
    private static final String DEFAULT_IGNORED = "*.hprof;*.pyc;*.pyo;*.rbc;*~;.DS_Store;.git;.hg;.svn;.tox;CVS;RCS;SCCS;__pycache__;_svn;rcs;vssver.scc;vssver2.scc;";
    private static boolean RE_DETECT_ASYNC;
    private final Set<FileType> myDefaultTypes = new THashSet();
    private FileTypeIdentifiableByVirtualFile[] mySpecialFileTypes = FileTypeIdentifiableByVirtualFile.EMPTY_ARRAY;
    private FileTypeAssocTable<FileType> myPatternsTable = new FileTypeAssocTable();
    private final IgnoredPatternSet myIgnoredPatterns = new IgnoredPatternSet();
    private final IgnoredFileCache myIgnoredFileCache = new IgnoredFileCache(this.myIgnoredPatterns);
    private final FileTypeAssocTable<FileType> myInitialAssociations = new FileTypeAssocTable();
    private final Map<FileNameMatcher, String> myUnresolvedMappings = new THashMap();
    private final Map<FileNameMatcher, Trinity<String, String, Boolean>> myUnresolvedRemovedMappings = new THashMap();
    private final Map<FileNameMatcher, Pair<FileType, Boolean>> myRemovedMappings = new THashMap();
    @NonNls
    private static final String ELEMENT_FILETYPE = "filetype";
    @NonNls
    private static final String ELEMENT_IGNORE_FILES = "ignoreFiles";
    @NonNls
    private static final String ATTRIBUTE_LIST = "list";
    @NonNls
    private static final String ATTRIBUTE_VERSION = "version";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private final MessageBus myMessageBus;
    private final Map<String, StandardFileType> myStandardFileTypes = new LinkedHashMap<String, StandardFileType>();
    @NonNls
    private static final String[] FILE_TYPES_WITH_PREDEFINED_EXTENSIONS;
    private final SchemesManager<FileType, AbstractFileType> mySchemesManager;
    @NonNls
    static final String FILE_SPEC = "filetypes";
    private static final byte AUTO_DETECTED_AS_TEXT_MASK = 1;
    private static final byte AUTO_DETECTED_AS_BINARY_MASK = 2;
    private static final byte AUTO_DETECT_WAS_RUN_MASK = 4;
    private static final byte ATTRIBUTES_WERE_LOADED_MASK = 8;
    private final ConcurrentPackedBitsArray packedFlags = new ConcurrentPackedBitsArray(4);
    private final AtomicInteger counterAutoDetect = new AtomicInteger();
    private final AtomicLong elapsedAutoDetect = new AtomicLong();
    boolean toLog;
    private final TransferToPooledThreadQueue<Collection<VirtualFile>> reDetectQueue = new TransferToPooledThreadQueue<Collection<VirtualFile>>("File type re-detect", Conditions.alwaysFalse(), -1, new Processor<Collection<VirtualFile>>(){

        public boolean process(Collection<VirtualFile> files) {
            FileTypeManagerImpl.this.reDetect(files);
            return true;
        }
    });
    private volatile FileAttribute autoDetectedAttribute;
    private final AtomicInteger fileTypeChangedCount;
    private final Map<FileTypeListener, MessageBusConnection> myAdapters = new HashMap<FileTypeListener, MessageBusConnection>();

    public FileTypeManagerImpl(MessageBus bus, SchemesManagerFactory schemesManagerFactory, PropertiesComponent propertiesComponent) {
        int fileTypeChangedCounter = StringUtilRt.parseInt((String)propertiesComponent.getValue("fileTypeChangedCounter"), (int)0);
        this.fileTypeChangedCount = new AtomicInteger(fileTypeChangedCounter);
        this.autoDetectedAttribute = new FileAttribute("AUTO_DETECTION_CACHE_ATTRIBUTE", fileTypeChangedCounter, true);
        this.myMessageBus = bus;
        this.mySchemesManager = schemesManagerFactory.create(FILE_SPEC, (SchemeProcessor)new SchemeProcessor<AbstractFileType>(){

            @NotNull
            public AbstractFileType readScheme(@NotNull Element element, boolean duringLoad) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "readScheme"));
                }
                if (!duringLoad) {
                    FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                }
                AbstractFileType type = (AbstractFileType)FileTypeManagerImpl.this.loadFileType(element, false);
                if (!duringLoad) {
                    FileTypeManagerImpl.this.fireFileTypesChanged();
                }
                AbstractFileType abstractFileType = type;
                if (abstractFileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "readScheme"));
                }
                return abstractFileType;
            }

            @NotNull
            public SchemeProcessor.State getState(@NotNull AbstractFileType fileType) {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "getState"));
                }
                if (!FileTypeManagerImpl.shouldSave(fileType)) {
                    SchemeProcessor.State state = SchemeProcessor.State.NON_PERSISTENT;
                    if (state == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "getState"));
                    }
                    return state;
                }
                if (!FileTypeManagerImpl.this.myDefaultTypes.contains(fileType)) {
                    SchemeProcessor.State state = SchemeProcessor.State.POSSIBLY_CHANGED;
                    if (state == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "getState"));
                    }
                    return state;
                }
                SchemeProcessor.State state = fileType.isModified() ? SchemeProcessor.State.POSSIBLY_CHANGED : SchemeProcessor.State.NON_PERSISTENT;
                if (state == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "getState"));
                }
                return state;
            }

            public Element writeScheme(@NotNull AbstractFileType fileType) {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "writeScheme"));
                }
                Element root = new Element(FileTypeManagerImpl.ELEMENT_FILETYPE);
                root.setAttribute("binary", String.valueOf(fileType.isBinary()));
                if (!StringUtil.isEmpty((String)fileType.getDefaultExtension())) {
                    root.setAttribute("default_extension", fileType.getDefaultExtension());
                }
                root.setAttribute(FileTypeManagerImpl.ATTRIBUTE_DESCRIPTION, fileType.getDescription());
                root.setAttribute(FileTypeManagerImpl.ATTRIBUTE_NAME, fileType.getName());
                fileType.writeExternal(root);
                Element map = new Element("extensionMap");
                FileTypeManagerImpl.this.writeExtensionsMap(map, fileType, false);
                if (!map.getChildren().isEmpty()) {
                    root.addContent(map);
                }
                return root;
            }

            public void onSchemeDeleted(@NotNull AbstractFileType scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1", "onSchemeDeleted"));
                }
                FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                FileTypeManagerImpl.this.myPatternsTable.removeAllAssociations((Object)scheme);
                FileTypeManagerImpl.this.fireFileTypesChanged();
            }
        });
        bus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$2", "after"));
                }
                Set files = ContainerUtil.map2Set(events, (Function)new Function<VFileEvent, VirtualFile>(){

                    public VirtualFile fun(VFileEvent event) {
                        VirtualFile filtered;
                        VirtualFile file = event instanceof VFileCreateEvent ? null : event.getFile();
                        VirtualFile virtualFile = filtered = file != null && FileTypeManagerImpl.this.wasAutoDetectedBefore(file) && FileTypeManagerImpl.isDetectable(file) ? file : null;
                        if (FileTypeManagerImpl.this.toLog()) {
                            FileTypeManagerImpl.log("F: handled " + event + "; filtered file: " + filtered + " (file: " + file + "; wasAutoDetectedBefore(file): " + (file == null ? null : Boolean.valueOf(FileTypeManagerImpl.this.wasAutoDetectedBefore(file))) + "; isDetectable(file): " + (file == null ? null : Boolean.valueOf(FileTypeManagerImpl.isDetectable(file))) + "; file.getLength(): " + (file == null ? null : Long.valueOf(file.getLength())) + "; file.isValid(): " + (file == null ? null : Boolean.valueOf(file.isValid())) + "; file.is(VFileProperty.SPECIAL): " + (file == null ? null : Boolean.valueOf(file.is(VFileProperty.SPECIAL))) + "; packedFlags.get(id): " + (!(file instanceof VirtualFileWithId) ? null : Long.valueOf(FileTypeManagerImpl.this.packedFlags.get(((VirtualFileWithId)file).getId()))) + "; file.getFileSystem():" + (file == null ? null : file.getFileSystem()) + ")");
                        }
                        return filtered;
                    }
                });
                files.remove(null);
                if (FileTypeManagerImpl.this.toLog()) {
                    FileTypeManagerImpl.log("F: VFS events: " + events + "; files: " + files);
                }
                if (!files.isEmpty() && RE_DETECT_ASYNC) {
                    if (FileTypeManagerImpl.this.toLog()) {
                        FileTypeManagerImpl.log("F: queued to redetect: " + files);
                    }
                    FileTypeManagerImpl.this.reDetectQueue.offerIfAbsent(files);
                }
            }
        });
        this.myIgnoredPatterns.setIgnoreMasks(DEFAULT_IGNORED);
        this.initStandardFileTypes();
    }

    @VisibleForTesting
    void initStandardFileTypes() {
        block10: {
            FileTypeConsumer consumer = new FileTypeConsumer(){

                public void consume(@NotNull FileType fileType) {
                    if (fileType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$3", "consume"));
                    }
                    this.register(fileType, FileTypeManagerImpl.parse(fileType.getDefaultExtension()));
                }

                public void consume(@NotNull FileType fileType, String extensions) {
                    if (fileType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$3", "consume"));
                    }
                    this.register(fileType, FileTypeManagerImpl.parse(extensions));
                }

                public void consume(@NotNull FileType fileType, FileNameMatcher ... matchers) {
                    if (fileType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$3", "consume"));
                    }
                    if (matchers == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchers", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$3", "consume"));
                    }
                    this.register(fileType, new ArrayList<FileNameMatcher>(Arrays.asList(matchers)));
                }

                public FileType getStandardFileTypeByName(@NotNull String name) {
                    if (name == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FileTypeManagerImpl.ATTRIBUTE_NAME, "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$3", "getStandardFileTypeByName"));
                    }
                    StandardFileType type = (StandardFileType)FileTypeManagerImpl.this.myStandardFileTypes.get(name);
                    return type != null ? type.fileType : null;
                }

                private void register(@NotNull FileType fileType, @NotNull List<FileNameMatcher> fileNameMatchers) {
                    if (fileType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$3", "register"));
                    }
                    if (fileNameMatchers == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameMatchers", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$3", "register"));
                    }
                    StandardFileType type = (StandardFileType)FileTypeManagerImpl.this.myStandardFileTypes.get(fileType.getName());
                    if (type != null) {
                        type.matchers.addAll(fileNameMatchers);
                    } else {
                        FileTypeManagerImpl.this.myStandardFileTypes.put(fileType.getName(), new StandardFileType(fileType, fileNameMatchers));
                    }
                }
            };
            for (FileTypeFactory factory : (FileTypeFactory[])FileTypeFactory.FILE_TYPE_FACTORY_EP.getExtensions()) {
                try {
                    factory.createFileTypes(consumer);
                }
                catch (Throwable e) {
                    PluginManager.handleComponentError(e, factory.getClass().getName(), null);
                }
            }
            for (StandardFileType pair : this.myStandardFileTypes.values()) {
                this.registerFileTypeWithoutNotification(pair.fileType, pair.matchers, true);
            }
            if (PlatformUtils.isDatabaseIDE() || PlatformUtils.isCidr()) {
                return;
            }
            try {
                URL defaultFileTypesUrl = FileTypeManagerImpl.class.getResource("/defaultFileTypes.xml");
                if (defaultFileTypesUrl == null) break block10;
                Element defaultFileTypesElement = JDOMUtil.load((InputStream)URLUtil.openStream((URL)defaultFileTypesUrl));
                for (Element e : defaultFileTypesElement.getChildren()) {
                    if (FILE_SPEC.equals(e.getName())) {
                        for (Element element : e.getChildren(ELEMENT_FILETYPE)) {
                            this.loadFileType(element, true);
                        }
                        continue;
                    }
                    if (!"extensionMap".equals(e.getName())) continue;
                    this.readGlobalMappings(e);
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private boolean toLog() {
        return this.toLog;
    }

    private static void log(String message) {
        System.out.println(message);
    }

    public void drainReDetectQueue() {
        this.reDetectQueue.waitFor();
    }

    @NotNull
    Collection<VirtualFile> dumpReDetectQueue() {
        List list = ContainerUtil.flatten((Iterable)this.reDetectQueue.dump());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "dumpReDetectQueue"));
        }
        return list;
    }

    static void reDetectAsync(boolean enable) {
        RE_DETECT_ASYNC = enable;
    }

    private void reDetect(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "reDetect"));
        }
        final ArrayList<VirtualFile> changed = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            FileType after;
            boolean shouldRedetect;
            boolean bl = shouldRedetect = this.wasAutoDetectedBefore(file) && FileTypeManagerImpl.isDetectable(file);
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: Redetect file: " + file.getName() + "; shouldRedetect: " + shouldRedetect);
            }
            if (!shouldRedetect) continue;
            int id = ((VirtualFileWithId)file).getId();
            long flags = this.packedFlags.get(id);
            FileType before = (FileType)ObjectUtils.notNull((Object)FileTypeManagerImpl.textOrBinaryFromCachedFlags(file, flags), (Object)ObjectUtils.notNull((Object)file.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY), (Object)((Object)PlainTextFileType.INSTANCE)));
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: reDetect(" + file.getName() + ") prepare to redetect. flags: " + flags);
            }
            if ((after = this.getOrDetectByFile(file)) == null) {
                after = this.detectFromContentAndCache(file);
            } else {
                file.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, null);
                flags = 0L;
                this.packedFlags.set(id, flags);
            }
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: After redetect file: " + file.getName() + "; before: " + before.getName() + "; after: " + after.getName() + "; now getFileType()=" + file.getFileType().getName() + "; DETECTED_FROM_CONTENT_FILE_TYPE_KEY: " + file.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
            }
            if (before == after) continue;
            changed.add(file);
            LOG.debug(file + " type was re-detected. Was: " + before.getName() + "; now: " + after.getName());
        }
        if (!changed.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    FileContentUtilCore.reparseFiles((Collection)changed);
                }
            }, ApplicationManager.getApplication().getDisposed());
        }
    }

    private boolean wasAutoDetectedBefore(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "wasAutoDetectedBefore"));
        }
        if (file.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY) != null) {
            return true;
        }
        if (file instanceof VirtualFileWithId) {
            int id = Math.abs(((VirtualFileWithId)file).getId());
            return (this.packedFlags.get(id) & 6L) == 4L;
        }
        return false;
    }

    @NotNull
    public FileType getStdFileType(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getStdFileType"));
        }
        StandardFileType stdFileType = this.myStandardFileTypes.get(name);
        PlainTextFileType plainTextFileType = stdFileType != null ? stdFileType.fileType : PlainTextFileType.INSTANCE;
        if (plainTextFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getStdFileType"));
        }
        return plainTextFileType;
    }

    public void disposeComponent() {
    }

    public void initComponent() {
        if (!this.myUnresolvedMappings.isEmpty()) {
            for (StandardFileType pair : this.myStandardFileTypes.values()) {
                this.registerReDetectedMappings(pair);
            }
        }
        for (StandardFileType pair : this.myStandardFileTypes.values()) {
            this.bindUnresolvedMappings(pair.fileType);
        }
        boolean isAtLeastOneStandardFileTypeHasBeenRead = false;
        for (AbstractFileType fileType : this.mySchemesManager.loadSchemes()) {
            isAtLeastOneStandardFileTypeHasBeenRead |= this.myInitialAssociations.hasAssociationsFor((Object)fileType);
        }
        if (isAtLeastOneStandardFileTypeHasBeenRead) {
            this.restoreStandardFileExtensions();
        }
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFileName"));
        }
        FileType fileType = this.getFileTypeByFileName((CharSequence)fileName);
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFileName"));
        }
        return fileType;
    }

    @NotNull
    private FileType getFileTypeByFileName(@NotNull CharSequence fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFileName"));
        }
        FileType type = (FileType)this.myPatternsTable.findAssociatedFileType(fileName);
        FileType fileType = (FileType)ObjectUtils.notNull((Object)type, (Object)UnknownFileType.INSTANCE);
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFileName"));
        }
        return fileType;
    }

    public void cacheFileType(@NotNull VirtualFile file, @Nullable FileType fileType) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "cacheFileType"));
        }
        file.putUserData(FILE_TYPE_KEY, (Object)fileType);
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: Cached file type for " + file.getName() + " to " + (fileType == null ? null : fileType.getName()));
        }
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFile"));
        }
        FileType fileType = this.getOrDetectByFile(file);
        if (fileType == null) {
            fileType = file instanceof StubVirtualFile ? UnknownFileType.INSTANCE : this.getOrDetectFromContent(file);
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByFile"));
        }
        return fileType2;
    }

    @Nullable
    private FileType getOrDetectByFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getOrDetectByFile"));
        }
        FileType fileType = (FileType)file.getUserData(FILE_TYPE_KEY);
        if (fileType != null) {
            return fileType;
        }
        if (file instanceof LightVirtualFile && (fileType = ((LightVirtualFile)file).getAssignedFileType()) != null) {
            return fileType;
        }
        for (FileTypeIdentifiableByVirtualFile type : this.mySpecialFileTypes) {
            if (!type.isMyFileType(file)) continue;
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: Special file type for " + file.getName() + "; type: " + type.getName());
            }
            return type;
        }
        fileType = this.getFileTypeByFileName(file.getNameSequence());
        if (fileType == UnknownFileType.INSTANCE) {
            fileType = null;
        }
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: By name file type for " + file.getName() + "; type: " + (fileType == null ? null : fileType.getName()));
        }
        return fileType;
    }

    @NotNull
    private FileType getOrDetectFromContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getOrDetectFromContent"));
        }
        if (!FileTypeManagerImpl.isDetectable(file)) {
            FileType fileType = UnknownFileType.INSTANCE;
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getOrDetectFromContent"));
            }
            return fileType;
        }
        if (file instanceof VirtualFileWithId) {
            boolean autoDetectWasRun;
            int id = ((VirtualFileWithId)file).getId();
            if (id < 0) {
                FileType fileType = UnknownFileType.INSTANCE;
                if (fileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getOrDetectFromContent"));
                }
                return fileType;
            }
            long flags = this.packedFlags.get(id);
            if ((flags & 8L) == 0L) {
                flags = this.readFlagsFromCache(file);
                flags = BitUtil.set((long)flags, (long)8L, (boolean)true);
                this.packedFlags.set(id, flags);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: readFlagsFromCache(" + file.getName() + ") = " + flags);
                }
            }
            boolean bl = autoDetectWasRun = (flags & 4L) != 0L;
            if (autoDetectWasRun) {
                FileType type = FileTypeManagerImpl.textOrBinaryFromCachedFlags(file, flags);
                if (this.toLog()) {
                    FileTypeManagerImpl.log("F: autodetected getFileType(" + file.getName() + ") = " + (type == null ? null : type.getName()) + "; packedFlags.get(id):" + flags + "; DETECTED_FROM_CONTENT_FILE_TYPE_KEY: " + file.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                }
                if (type != null) {
                    FileType fileType = type;
                    if (fileType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getOrDetectFromContent"));
                    }
                    return fileType;
                }
            }
        }
        FileType fileType = (FileType)file.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY);
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: DETECTED_FROM_CONTENT_FILE_TYPE_KEY for " + file.getName() + " = " + (fileType == null ? null : fileType.getName()));
        }
        if (fileType == null) {
            fileType = this.detectFromContentAndCache(file);
        }
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: getFileType after detect run(" + file.getName() + ") = " + fileType.getName());
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getOrDetectFromContent"));
        }
        return fileType2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte readFlagsFromCache(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "readFlagsFromCache"));
        }
        DataInputStream stream = this.autoDetectedAttribute.readAttribute(file);
        boolean wasAutoDetectRun = false;
        byte status = 0;
        try {
            try {
                status = stream == null ? (byte)0 : stream.readByte();
                wasAutoDetectRun = stream != null;
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        status = BitUtil.set((byte)status, (byte)4, (boolean)wasAutoDetectRun);
        return (byte)(status & 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFlagsToCache(@NotNull VirtualFile file, int flags) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "writeFlagsToCache"));
        }
        DataOutputStream stream = this.autoDetectedAttribute.writeAttribute(file);
        try {
            try {
                stream.writeByte(flags & 3);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    void clearCaches() {
        this.packedFlags.clear();
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: clearCaches");
        }
    }

    private void clearPersistentAttributes() {
        int count = this.fileTypeChangedCount.incrementAndGet();
        this.autoDetectedAttribute = this.autoDetectedAttribute.newVersion(count);
        PropertiesComponent.getInstance().setValue("fileTypeChangedCounter", Integer.toString(count));
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: clearPersistentAttributes");
        }
    }

    @Nullable
    private static FileType textOrBinaryFromCachedFlags(@NotNull VirtualFile file, long flags) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "textOrBinaryFromCachedFlags"));
        }
        return BitUtil.isSet((long)flags, (long)1L) ? PlainTextFileType.INSTANCE : (BitUtil.isSet((long)flags, (long)2L) ? UnknownFileType.INSTANCE : null);
    }

    @Deprecated
    @NotNull
    public FileType detectFileTypeFromContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFileTypeFromContent"));
        }
        FileType fileType = file.getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFileTypeFromContent"));
        }
        return fileType;
    }

    private void cacheAutoDetectedFileType(@NotNull VirtualFile file, @NotNull FileType fileType) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "cacheAutoDetectedFileType"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "cacheAutoDetectedFileType"));
        }
        boolean wasAutodetectedAsText = fileType == PlainTextFileType.INSTANCE;
        boolean wasAutodetectedAsBinary = fileType == UnknownFileType.INSTANCE;
        int flags = BitUtil.set((int)0, (int)1, (boolean)wasAutodetectedAsText);
        flags = BitUtil.set((int)flags, (int)2, (boolean)wasAutodetectedAsBinary);
        this.writeFlagsToCache(file, flags);
        if (file instanceof VirtualFileWithId) {
            int id = Math.abs(((VirtualFileWithId)file).getId());
            flags = BitUtil.set((int)flags, (int)4, (boolean)true);
            flags = BitUtil.set((int)flags, (int)8, (boolean)true);
            this.packedFlags.set(id, (long)flags);
            if (wasAutodetectedAsText || wasAutodetectedAsBinary) {
                file.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, null);
                return;
            }
        }
        file.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, (Object)fileType);
        if (this.toLog()) {
            FileTypeManagerImpl.log("F: cacheAutoDetectedFileType(" + file.getName() + ") = " + flags + "; DETECTED_FROM_CONTENT_FILE_TYPE_KEY: " + file.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
        }
    }

    public FileType findFileTypeByName(@NotNull String fileTypeName) {
        if (fileTypeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeName", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "findFileTypeByName"));
        }
        FileType type = this.getStdFileType(fileTypeName);
        if (type == PlainTextFileType.INSTANCE && !fileTypeName.equals(type.getName())) {
            for (FileType fileType : this.mySchemesManager.getAllSchemes()) {
                if (!fileTypeName.equals(fileType.getName())) continue;
                return fileType;
            }
        }
        return type;
    }

    private static boolean isDetectable(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isDetectable"));
        }
        if (file.isDirectory() || !file.isValid() || file.is(VFileProperty.SPECIAL) || file.getLength() == 0L) {
            return false;
        }
        return file.getFileSystem() instanceof FileSystemInterface && !SingleRootFileViewProvider.isTooLargeForContentLoading(file);
    }

    private boolean processFirstBytes(final @NotNull InputStream stream, final int length, @NotNull Processor<ByteSequence> processor) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "processFirstBytes"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "processFirstBytes"));
        }
        final byte[] bytes = FileUtilRt.getThreadLocalBuffer();
        assert (bytes.length >= length) : "Cannot process more than " + bytes.length + " in one call, requested:" + length;
        int n = stream.read(bytes, 0, length);
        if (n <= 0) {
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: inputStream.read() returned " + n + "; retrying with read action. stream=" + FileTypeManagerImpl.streamInfo(stream));
            }
            n = (Integer)ApplicationManager.getApplication().runReadAction((ThrowableComputable)new ThrowableComputable<Integer, IOException>(){

                public Integer compute() throws IOException {
                    return stream.read(bytes, 0, length);
                }
            });
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: under read action inputStream.read() returned " + n + "; stream=" + FileTypeManagerImpl.streamInfo(stream));
            }
            if (n <= 0) {
                return false;
            }
        }
        return processor.process((Object)new ByteSequence(bytes, 0, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private FileType detectFromContentAndCache(final @NotNull VirtualFile file) {
        FileType fileType;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFromContentAndCache"));
        }
        long start = System.currentTimeMillis();
        try {
            InputStream inputStream = ((FileSystemInterface)file.getFileSystem()).getInputStream(file);
            if (this.toLog()) {
                FileTypeManagerImpl.log("F: detectFromContentAndCache: inputStream=" + FileTypeManagerImpl.streamInfo(inputStream));
            }
            final Ref result = new Ref((Object)UnknownFileType.INSTANCE);
            boolean r = false;
            try {
                r = this.processFirstBytes(inputStream, 8192, new Processor<ByteSequence>(){

                    public boolean process(ByteSequence byteSequence) {
                        CharSequence text;
                        boolean isText = FileTypeManagerImpl.guessIfText(file, byteSequence);
                        if (isText) {
                            byte[] bytes = Arrays.copyOf(byteSequence.getBytes(), byteSequence.getLength());
                            text = LoadTextUtil.getTextByBinaryPresentation(bytes, file, true, true, UnknownFileType.INSTANCE);
                        } else {
                            text = null;
                        }
                        Object[] detectors = (FileTypeRegistry.FileTypeDetector[])Extensions.getExtensions((ExtensionPointName)FileTypeRegistry.FileTypeDetector.EP_NAME);
                        if (FileTypeManagerImpl.this.toLog()) {
                            FileTypeManagerImpl.log("F: processFirstBytes. byteSequence.length=" + byteSequence.getLength() + "; isText=" + isText + "; text='" + (text == null ? null : StringUtil.first((CharSequence)text, (int)100, (boolean)true)) + "', detectors=" + Arrays.toString(detectors));
                        }
                        PlainTextFileType detected = null;
                        for (FileTypeRegistry.FileTypeDetector fileTypeDetector : detectors) {
                            try {
                                detected = fileTypeDetector.detect(file, byteSequence, text);
                            }
                            catch (Exception e) {
                                LOG.error("Detector " + fileTypeDetector + " (" + fileTypeDetector.getClass() + ") exception occurred:", (Throwable)e);
                            }
                            if (detected == null) continue;
                            if (!FileTypeManagerImpl.this.toLog()) break;
                            FileTypeManagerImpl.log("F: detector " + fileTypeDetector + " detected file " + file.getName() + " type as " + detected.getName());
                            break;
                        }
                        if (detected == null) {
                            PlainTextFileType plainTextFileType = detected = isText ? PlainTextFileType.INSTANCE : UnknownFileType.INSTANCE;
                            if (FileTypeManagerImpl.this.toLog()) {
                                FileTypeManagerImpl.log("F: no detector was able to detect file " + file.getName() + " type. assigned " + detected.getName());
                            }
                        }
                        result.set((Object)detected);
                        return true;
                    }
                });
            }
            finally {
                if (this.toLog()) {
                    byte[] buffer = new byte[50];
                    InputStream newStream = ((FileSystemInterface)file.getFileSystem()).getInputStream(file);
                    int n = newStream.read(buffer, 0, buffer.length);
                    FileTypeManagerImpl.log("F: detectFromContentAndCache run for file: " + file.getName() + "; result: " + ((FileType)result.get()).getName() + "; processor ret: " + r + "; stream: " + FileTypeManagerImpl.streamInfo(inputStream) + "; newStream: " + FileTypeManagerImpl.streamInfo(newStream) + "; read: " + n + "; buffer: " + Arrays.toString(buffer));
                    newStream.close();
                }
                inputStream.close();
            }
            FileType fileType2 = (FileType)result.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug(file + "; type=" + fileType2.getDescription() + "; " + this.counterAutoDetect);
            }
            this.cacheAutoDetectedFileType(file, fileType2);
            this.counterAutoDetect.incrementAndGet();
            long elapsed = System.currentTimeMillis() - start;
            this.elapsedAutoDetect.addAndGet(elapsed);
            fileType = fileType2;
        }
        catch (IOException ignored) {
            FileType fileType3 = UnknownFileType.INSTANCE;
            if (fileType3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFromContentAndCache"));
            }
            return fileType3;
        }
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "detectFromContentAndCache"));
        }
        return fileType;
    }

    private static Object streamInfo(InputStream stream) throws IOException {
        if (stream instanceof BufferedInputStream) {
            InputStream in = (InputStream)ReflectionUtil.getField(stream.getClass(), (Object)stream, InputStream.class, (String)"in");
            byte[] buf = (byte[])ReflectionUtil.getField(stream.getClass(), (Object)stream, byte[].class, (String)"buf");
            int count = (Integer)ReflectionUtil.getField(stream.getClass(), (Object)stream, Integer.TYPE, (String)"count");
            int pos = (Integer)ReflectionUtil.getField(stream.getClass(), (Object)stream, Integer.TYPE, (String)"pos");
            return "BufferedInputStream(buf=" + (buf == null ? null : Arrays.toString(Arrays.copyOf(buf, count))) + ", count=" + count + ", pos=" + pos + ", in=" + FileTypeManagerImpl.streamInfo(in) + ")";
        }
        if (stream instanceof FileInputStream) {
            String path = (String)ReflectionUtil.getField(stream.getClass(), (Object)stream, String.class, (String)"path");
            FileChannel channel = (FileChannel)ReflectionUtil.getField(stream.getClass(), (Object)stream, FileChannel.class, (String)"channel");
            boolean closed = (Boolean)ReflectionUtil.getField(stream.getClass(), (Object)stream, Boolean.TYPE, (String)"closed");
            int available = stream.available();
            File file = new File(path);
            return "FileInputStream(path=" + path + ", available=" + available + ", closed=" + closed + ", channel=" + channel + ", channel.size=" + (channel == null ? null : Long.valueOf(channel.size())) + ", file.exists=" + file.exists() + ", file.content='" + FileUtil.loadFile((File)file) + "')";
        }
        return stream;
    }

    private static boolean guessIfText(@NotNull VirtualFile file, @NotNull ByteSequence byteSequence) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "guessIfText"));
        }
        if (byteSequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "byteSequence", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "guessIfText"));
        }
        byte[] bytes = byteSequence.getBytes();
        Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessed = LoadTextUtil.guessFromContent(file, bytes, byteSequence.getLength());
        if (guessed == null) {
            return false;
        }
        file.setBOM((byte[])guessed.third);
        if (guessed.first != null) {
            return true;
        }
        CharsetToolkit.GuessedEncoding guess = (CharsetToolkit.GuessedEncoding)guessed.second;
        return guess != null && (guess == CharsetToolkit.GuessedEncoding.VALID_UTF8 || guess == CharsetToolkit.GuessedEncoding.SEVEN_BIT);
    }

    public boolean isFileOfType(@NotNull VirtualFile file, @NotNull FileType type) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isFileOfType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isFileOfType"));
        }
        if (type instanceof FileTypeIdentifiableByVirtualFile) {
            return ((FileTypeIdentifiableByVirtualFile)type).isMyFileType(file);
        }
        return this.getFileTypeByFileName(file.getNameSequence()) == type;
    }

    @NotNull
    public FileType getFileTypeByExtension(@NotNull String extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByExtension"));
        }
        FileType fileType = this.getFileTypeByFileName("IntelliJ_IDEA_RULES." + extension);
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByExtension"));
        }
        return fileType;
    }

    @Override
    public void registerFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "registerFileType"));
        }
        this.registerFileType(fileType, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void registerFileType(final @NotNull FileType type, final @NotNull List<FileNameMatcher> defaultAssociations) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "registerFileType"));
        }
        if (defaultAssociations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultAssociations", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "registerFileType"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                FileTypeManagerImpl.this.registerFileTypeWithoutNotification(type, defaultAssociations, true);
                FileTypeManagerImpl.this.fireFileTypesChanged();
            }
        });
    }

    @Override
    public void unregisterFileType(final @NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "unregisterFileType"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                FileTypeManagerImpl.this.unregisterFileTypeWithoutNotification(fileType);
                FileTypeManagerImpl.this.fireFileTypesChanged();
            }
        });
    }

    private void unregisterFileTypeWithoutNotification(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "unregisterFileTypeWithoutNotification"));
        }
        this.myPatternsTable.removeAllAssociations((Object)fileType);
        this.mySchemesManager.removeScheme((Scheme)fileType);
        if (fileType instanceof FileTypeIdentifiableByVirtualFile) {
            FileTypeIdentifiableByVirtualFile fakeFileType = (FileTypeIdentifiableByVirtualFile)fileType;
            this.mySpecialFileTypes = (FileTypeIdentifiableByVirtualFile[])ArrayUtil.remove((Object[])this.mySpecialFileTypes, (Object)fakeFileType, FileTypeIdentifiableByVirtualFile.ARRAY_FACTORY);
        }
    }

    @NotNull
    public FileType[] getRegisteredFileTypes() {
        List fileTypes = this.mySchemesManager.getAllSchemes();
        FileType[] fileTypeArray = fileTypes.toArray(new FileType[fileTypes.size()]);
        if (fileTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getRegisteredFileTypes"));
        }
        return fileTypeArray;
    }

    @Override
    @NotNull
    public String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getExtension"));
        }
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getExtension"));
            }
            return "";
        }
        String string = fileName.substring(index + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getExtension"));
        }
        return string;
    }

    @NotNull
    public String getIgnoredFilesList() {
        Set masks = this.myIgnoredPatterns.getIgnoreMasks();
        String string = masks.isEmpty() ? "" : StringUtil.join((Collection)masks, (String)";") + ";";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getIgnoredFilesList"));
        }
        return string;
    }

    public void setIgnoredFilesList(@NotNull String list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_LIST, "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "setIgnoredFilesList"));
        }
        this.fireBeforeFileTypesChanged();
        this.myIgnoredFileCache.clearCache();
        this.myIgnoredPatterns.setIgnoreMasks(list);
        this.fireFileTypesChanged();
    }

    @Override
    public boolean isIgnoredFilesListEqualToCurrent(@NotNull String list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_LIST, "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isIgnoredFilesListEqualToCurrent"));
        }
        THashSet tempSet = new THashSet();
        StringTokenizer tokenizer = new StringTokenizer(list, ";");
        while (tokenizer.hasMoreTokens()) {
            tempSet.add(tokenizer.nextToken());
        }
        return tempSet.equals(this.myIgnoredPatterns.getIgnoreMasks());
    }

    public boolean isFileIgnored(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isFileIgnored"));
        }
        return this.myIgnoredPatterns.isIgnored(name);
    }

    public boolean isFileIgnored(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isFileIgnored"));
        }
        return this.myIgnoredFileCache.isFileIgnored(file);
    }

    @NotNull
    public String[] getAssociatedExtensions(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getAssociatedExtensions"));
        }
        String[] stringArray = this.myPatternsTable.getAssociatedExtensions((Object)type);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getAssociatedExtensions"));
        }
        return stringArray;
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getAssociations"));
        }
        List list = this.myPatternsTable.getAssociations((Object)type);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getAssociations"));
        }
        return list;
    }

    public void associate(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "associate"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "associate"));
        }
        this.associate(type, matcher, true);
    }

    public void removeAssociation(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "removeAssociation"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "removeAssociation"));
        }
        this.removeAssociation(type, matcher, true);
    }

    @Override
    public void fireBeforeFileTypesChanged() {
        FileTypeEvent event = new FileTypeEvent((Object)this);
        ((FileTypeListener)this.myMessageBus.syncPublisher(TOPIC)).beforeFileTypesChanged(event);
    }

    @Override
    public void fireFileTypesChanged() {
        this.clearCaches();
        this.clearPersistentAttributes();
        ((FileTypeListener)this.myMessageBus.syncPublisher(TOPIC)).fileTypesChanged(new FileTypeEvent((Object)this));
    }

    public void addFileTypeListener(@NotNull FileTypeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "addFileTypeListener"));
        }
        MessageBusConnection connection = this.myMessageBus.connect();
        connection.subscribe(TOPIC, (Object)listener);
        this.myAdapters.put(listener, connection);
    }

    public void removeFileTypeListener(@NotNull FileTypeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "removeFileTypeListener"));
        }
        MessageBusConnection connection = this.myAdapters.remove(listener);
        if (connection != null) {
            connection.disconnect();
        }
    }

    public void loadState(Element state) {
        int savedVersion = StringUtilRt.parseInt((String)state.getAttributeValue(ATTRIBUTE_VERSION), (int)0);
        for (Element element : state.getChildren()) {
            if (element.getName().equals(ELEMENT_IGNORE_FILES)) {
                this.myIgnoredPatterns.setIgnoreMasks(element.getAttributeValue(ATTRIBUTE_LIST));
                continue;
            }
            if (!"extensionMap".equals(element.getName())) continue;
            this.readGlobalMappings(element);
        }
        if (savedVersion < 4) {
            if (savedVersion == 0) {
                this.addIgnore(".svn");
            }
            if (savedVersion < 2) {
                this.restoreStandardFileExtensions();
            }
            this.addIgnore("*.pyc");
            this.addIgnore("*.pyo");
            this.addIgnore(".git");
        }
        if (savedVersion < 5) {
            this.addIgnore("*.hprof");
        }
        if (savedVersion < 6) {
            this.addIgnore("_svn");
        }
        if (savedVersion < 7) {
            this.addIgnore(".hg");
        }
        if (savedVersion < 8) {
            this.addIgnore("*~");
        }
        if (savedVersion < 9) {
            this.addIgnore("__pycache__");
        }
        if (savedVersion < 11) {
            this.addIgnore("*.rbc");
        }
        if (savedVersion < 13) {
            this.unignoreMask("*.lib");
        }
        if (savedVersion < 14) {
            this.addIgnore(".tox");
        }
        if (savedVersion < 15) {
            this.unignoreMask(".bundle");
        }
        this.myIgnoredFileCache.clearCache();
        String counter = JDOMExternalizer.readString((Element)state, (String)"fileTypeChangedCounter");
        if (counter != null) {
            this.fileTypeChangedCount.set(StringUtilRt.parseInt((String)counter, (int)0));
            this.autoDetectedAttribute = this.autoDetectedAttribute.newVersion(this.fileTypeChangedCount.get());
        }
    }

    private void unignoreMask(@NotNull String maskToRemove) {
        if (maskToRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maskToRemove", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "unignoreMask"));
        }
        LinkedHashSet masks = new LinkedHashSet(this.myIgnoredPatterns.getIgnoreMasks());
        masks.remove(maskToRemove);
        this.myIgnoredPatterns.clearPatterns();
        for (String each : masks) {
            this.myIgnoredPatterns.addIgnoreMask(each);
        }
    }

    private void readGlobalMappings(@NotNull Element e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "readGlobalMappings"));
        }
        for (Pair<FileNameMatcher, String> association : AbstractFileType.readAssociations(e)) {
            FileType type = this.getFileTypeByName((String)association.getSecond());
            FileNameMatcher matcher = (FileNameMatcher)association.getFirst();
            if (type != null) {
                FileType newFileType;
                if (PlainTextFileType.INSTANCE == type && (newFileType = (FileType)this.myPatternsTable.findAssociatedFileType(matcher)) != null && newFileType != PlainTextFileType.INSTANCE && newFileType != UnknownFileType.INSTANCE) {
                    this.myRemovedMappings.put(matcher, (Pair<FileType, Boolean>)Pair.create((Object)newFileType, (Object)false));
                }
                this.associate(type, matcher, false);
                continue;
            }
            this.myUnresolvedMappings.put(matcher, (String)association.getSecond());
        }
        List<Trinity<FileNameMatcher, String, Boolean>> removedAssociations = AbstractFileType.readRemovedAssociations(e);
        for (Trinity<FileNameMatcher, String, Boolean> trinity : removedAssociations) {
            FileType type = this.getFileTypeByName((String)trinity.getSecond());
            FileNameMatcher matcher = (FileNameMatcher)trinity.getFirst();
            if (type != null) {
                this.removeAssociation(type, matcher, false);
                continue;
            }
            this.myUnresolvedRemovedMappings.put(matcher, (Trinity<String, String, Boolean>)Trinity.create((Object)trinity.getSecond(), (Object)this.myUnresolvedMappings.get(matcher), (Object)trinity.getThird()));
        }
    }

    private void addIgnore(@NonNls @NotNull String ignoreMask) {
        if (ignoreMask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoreMask", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "addIgnore"));
        }
        this.myIgnoredPatterns.addIgnoreMask(ignoreMask);
    }

    private void restoreStandardFileExtensions() {
        for (String name : FILE_TYPES_WITH_PREDEFINED_EXTENSIONS) {
            StandardFileType stdFileType = this.myStandardFileTypes.get(name);
            if (stdFileType == null) continue;
            FileType fileType = stdFileType.fileType;
            for (FileNameMatcher matcher : this.myPatternsTable.getAssociations((Object)fileType)) {
                FileType defaultFileType = (FileType)this.myInitialAssociations.findAssociatedFileType(matcher);
                if (defaultFileType == null || defaultFileType == fileType) continue;
                this.removeAssociation(fileType, matcher, false);
                this.associate(defaultFileType, matcher, false);
            }
            for (FileNameMatcher matcher : this.myInitialAssociations.getAssociations((Object)fileType)) {
                this.associate(fileType, matcher, false);
            }
        }
    }

    @NotNull
    public Element getState() {
        String ignoreFiles;
        Element state = new Element("state");
        Set masks = this.myIgnoredPatterns.getIgnoreMasks();
        if (masks.isEmpty()) {
            ignoreFiles = "";
        } else {
            Object[] strings = ArrayUtil.toStringArray((Collection)masks);
            Arrays.sort(strings);
            ignoreFiles = StringUtil.join((String[])strings, (String)";") + ";";
        }
        if (!ignoreFiles.equalsIgnoreCase(DEFAULT_IGNORED)) {
            state.addContent(new Element(ELEMENT_IGNORE_FILES).setAttribute(ATTRIBUTE_LIST, ignoreFiles));
        }
        Element map = new Element("extensionMap");
        ArrayList<FileType> notExternalizableFileTypes = new ArrayList<FileType>();
        for (FileType type : this.mySchemesManager.getAllSchemes()) {
            if (type instanceof AbstractFileType && !this.myDefaultTypes.contains(type)) continue;
            notExternalizableFileTypes.add(type);
        }
        if (!notExternalizableFileTypes.isEmpty()) {
            Collections.sort(notExternalizableFileTypes, new Comparator<FileType>(){

                @Override
                public int compare(@NotNull FileType o1, @NotNull FileType o2) {
                    if (o1 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$10", "compare"));
                    }
                    if (o2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$10", "compare"));
                    }
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (FileType type : notExternalizableFileTypes) {
                this.writeExtensionsMap(map, type, true);
            }
        }
        if (!this.myUnresolvedMappings.isEmpty()) {
            FileNameMatcher[] unresolvedMappingKeys = this.myUnresolvedMappings.keySet().toArray(new FileNameMatcher[this.myUnresolvedMappings.size()]);
            Arrays.sort(unresolvedMappingKeys, new Comparator<FileNameMatcher>(){

                @Override
                public int compare(@NotNull FileNameMatcher o1, @NotNull FileNameMatcher o2) {
                    if (o1 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$11", "compare"));
                    }
                    if (o2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$11", "compare"));
                    }
                    return o1.getPresentableString().compareTo(o2.getPresentableString());
                }
            });
            for (FileNameMatcher fileNameMatcher : unresolvedMappingKeys) {
                Element content = AbstractFileType.writeMapping(this.myUnresolvedMappings.get(fileNameMatcher), fileNameMatcher, true);
                if (content == null) continue;
                map.addContent(content);
            }
        }
        if (!map.getChildren().isEmpty()) {
            state.addContent(map);
        }
        if (!state.getChildren().isEmpty()) {
            state.setAttribute(ATTRIBUTE_VERSION, String.valueOf(15));
        }
        Element element = state;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getState"));
        }
        return element;
    }

    private void writeExtensionsMap(@NotNull Element map, @NotNull FileType type, boolean specifyTypeName) {
        Element content;
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "writeExtensionsMap"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "writeExtensionsMap"));
        }
        List associations = this.myPatternsTable.getAssociations((Object)type);
        THashSet defaultAssociations = new THashSet((Collection)this.myInitialAssociations.getAssociations((Object)type));
        for (FileNameMatcher matcher : associations) {
            if (defaultAssociations.contains(matcher)) {
                defaultAssociations.remove(matcher);
                continue;
            }
            if (!FileTypeManagerImpl.shouldSave(type) || (content = AbstractFileType.writeMapping(type.getName(), matcher, specifyTypeName)) == null) continue;
            map.addContent(content);
        }
        for (FileNameMatcher matcher : defaultAssociations) {
            content = AbstractFileType.writeRemovedMapping(type, matcher, specifyTypeName, this.isApproved(matcher));
            if (content == null) continue;
            map.addContent(content);
        }
    }

    private boolean isApproved(@NotNull FileNameMatcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "isApproved"));
        }
        Pair<FileType, Boolean> pair = this.myRemovedMappings.get(matcher);
        return pair != null && (Boolean)pair.getSecond() != false;
    }

    @Nullable
    private FileType getFileTypeByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeByName"));
        }
        return (FileType)this.mySchemesManager.findSchemeByName(name);
    }

    @NotNull
    private static List<FileNameMatcher> parse(@Nullable String semicolonDelimited) {
        if (semicolonDelimited == null) {
            List<FileNameMatcher> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "parse"));
            }
            return list;
        }
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimited, ";", false);
        ArrayList<FileNameMatcher> list = new ArrayList<FileNameMatcher>();
        while (tokenizer.hasMoreTokens()) {
            list.add((FileNameMatcher)new ExtensionFileNameMatcher(tokenizer.nextToken().trim()));
        }
        ArrayList<FileNameMatcher> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "parse"));
        }
        return arrayList;
    }

    private void registerFileTypeWithoutNotification(@NotNull FileType fileType, @NotNull List<FileNameMatcher> matchers, boolean addScheme) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "registerFileTypeWithoutNotification"));
        }
        if (matchers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchers", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "registerFileTypeWithoutNotification"));
        }
        if (addScheme) {
            this.mySchemesManager.addScheme((Scheme)fileType);
        }
        for (FileNameMatcher matcher : matchers) {
            this.myPatternsTable.addAssociation(matcher, (Object)fileType);
            this.myInitialAssociations.addAssociation(matcher, (Object)fileType);
        }
        if (fileType instanceof FileTypeIdentifiableByVirtualFile) {
            this.mySpecialFileTypes = (FileTypeIdentifiableByVirtualFile[])ArrayUtil.append((Object[])this.mySpecialFileTypes, (Object)((FileTypeIdentifiableByVirtualFile)fileType), FileTypeIdentifiableByVirtualFile.ARRAY_FACTORY);
        }
    }

    private void bindUnresolvedMappings(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "bindUnresolvedMappings"));
        }
        for (FileNameMatcher matcher : new THashSet(this.myUnresolvedMappings.keySet())) {
            String name = this.myUnresolvedMappings.get(matcher);
            if (!Comparing.equal((String)name, (String)fileType.getName())) continue;
            this.myPatternsTable.addAssociation(matcher, (Object)fileType);
            this.myUnresolvedMappings.remove(matcher);
        }
        for (FileNameMatcher matcher : new THashSet(this.myUnresolvedRemovedMappings.keySet())) {
            Trinity<String, String, Boolean> trinity = this.myUnresolvedRemovedMappings.get(matcher);
            if (!Comparing.equal((String)((String)trinity.getFirst()), (String)fileType.getName())) continue;
            this.removeAssociation(fileType, matcher, false);
            this.myUnresolvedRemovedMappings.remove(matcher);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private FileType loadFileType(@NotNull Element typeElement, boolean isDefault) {
        FileType type;
        if (typeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "loadFileType"));
        }
        String fileTypeName = typeElement.getAttributeValue(ATTRIBUTE_NAME);
        String fileTypeDescr = typeElement.getAttributeValue(ATTRIBUTE_DESCRIPTION);
        String iconPath = typeElement.getAttributeValue("icon");
        String extensionsStr = StringUtil.nullize((String)typeElement.getAttributeValue("extensions"));
        if (isDefault && extensionsStr != null) {
            extensionsStr = this.filterAlreadyRegisteredExtensions(extensionsStr);
        }
        FileType fileType = type = isDefault ? this.getFileTypeByName(fileTypeName) : null;
        if (type != null) {
            FileType fileType2 = type;
            if (fileType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "loadFileType"));
            }
            return fileType2;
        }
        Element element = typeElement.getChild("highlighting");
        if (element == null) {
            CustomFileTypeFactory factory;
            void var11_13;
            CustomFileTypeFactory[] customFileTypeFactoryArray = (CustomFileTypeFactory[])CustomFileTypeFactory.EP_NAME.getExtensions();
            int n = customFileTypeFactoryArray.length;
            boolean i = false;
            while (var11_13 < n && (type = (factory = customFileTypeFactoryArray[var11_13]).createFileType(typeElement)) == null) {
                ++var11_13;
            }
            if (type == null) {
                type = new UserBinaryFileType();
            }
        } else {
            SyntaxTable table = AbstractFileType.readSyntaxTable(element);
            type = new AbstractFileType(table);
            ((AbstractFileType)type).initSupport();
        }
        FileTypeManagerImpl.setFileTypeAttributes((UserFileType)type, fileTypeName, fileTypeDescr, iconPath);
        this.registerFileTypeWithoutNotification(type, FileTypeManagerImpl.parse(extensionsStr), isDefault);
        if (isDefault) {
            this.myDefaultTypes.add(type);
            if (type instanceof ExternalizableFileType) {
                ((ExternalizableFileType)type).markDefaultSettings();
            }
        } else {
            Element extensions = typeElement.getChild("extensionMap");
            if (extensions != null) {
                for (Pair<FileNameMatcher, String> pair : AbstractFileType.readAssociations(extensions)) {
                    this.associate(type, (FileNameMatcher)pair.getFirst(), false);
                }
                for (Trinity trinity : AbstractFileType.readRemovedAssociations(extensions)) {
                    this.removeAssociation(type, (FileNameMatcher)trinity.getFirst(), false);
                }
            }
        }
        FileType fileType3 = type;
        if (fileType3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "loadFileType"));
        }
        return fileType3;
    }

    @Nullable
    private String filterAlreadyRegisteredExtensions(@NotNull String semicolonDelimited) {
        if (semicolonDelimited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "semicolonDelimited", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "filterAlreadyRegisteredExtensions"));
        }
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimited, ";", false);
        StringBuilder builder = null;
        while (tokenizer.hasMoreTokens()) {
            String extension = tokenizer.nextToken().trim();
            if (this.getFileTypeByExtension(extension) != UnknownFileType.INSTANCE) continue;
            if (builder == null) {
                builder = new StringBuilder();
            } else if (builder.length() > 0) {
                builder.append(";");
            }
            builder.append(extension);
        }
        return builder == null ? null : builder.toString();
    }

    private static void setFileTypeAttributes(@NotNull UserFileType fileType, @Nullable String name, @Nullable String description, @Nullable String iconPath) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "setFileTypeAttributes"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)iconPath)) {
            fileType.setIcon(IconLoader.getIcon((String)iconPath));
        }
        if (description != null) {
            fileType.setDescription(description);
        }
        if (name != null) {
            fileType.setName(name);
        }
    }

    private static boolean shouldSave(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "shouldSave"));
        }
        return fileType != UnknownFileType.INSTANCE && !fileType.isReadOnly();
    }

    @NotNull
    public String getComponentName() {
        String string = FileTypeManagerImpl.getFileTypeComponentName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getComponentName"));
        }
        return string;
    }

    @NotNull
    public static String getFileTypeComponentName() {
        String string = PlatformUtils.isIdeaCommunity() ? "CommunityFileTypes" : "FileTypeManager";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getFileTypeComponentName"));
        }
        return string;
    }

    @NotNull
    FileTypeAssocTable getExtensionMap() {
        FileTypeAssocTable<FileType> fileTypeAssocTable = this.myPatternsTable;
        if (fileTypeAssocTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getExtensionMap"));
        }
        return fileTypeAssocTable;
    }

    void setPatternsTable(@NotNull Set<FileType> fileTypes, @NotNull FileTypeAssocTable<FileType> assocTable) {
        if (fileTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypes", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "setPatternsTable"));
        }
        if (assocTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assocTable", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "setPatternsTable"));
        }
        this.fireBeforeFileTypesChanged();
        for (FileType existing : this.getRegisteredFileTypes()) {
            if (fileTypes.contains(existing)) continue;
            this.mySchemesManager.removeScheme((Scheme)existing);
        }
        for (FileType fileType : fileTypes) {
            this.mySchemesManager.addScheme((Scheme)fileType);
            if (!(fileType instanceof AbstractFileType)) continue;
            ((AbstractFileType)fileType).initSupport();
        }
        this.myPatternsTable = assocTable.copy();
        this.fireFileTypesChanged();
    }

    public void associate(@NotNull FileType fileType, @NotNull FileNameMatcher matcher, boolean fireChange) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "associate"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "associate"));
        }
        if (!this.myPatternsTable.isAssociatedWith((Object)fileType, matcher)) {
            if (fireChange) {
                this.fireBeforeFileTypesChanged();
            }
            this.myPatternsTable.addAssociation(matcher, (Object)fileType);
            if (fireChange) {
                this.fireFileTypesChanged();
            }
        }
    }

    public void removeAssociation(@NotNull FileType fileType, @NotNull FileNameMatcher matcher, boolean fireChange) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "removeAssociation"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "removeAssociation"));
        }
        if (this.myPatternsTable.isAssociatedWith((Object)fileType, matcher)) {
            if (fireChange) {
                this.fireBeforeFileTypesChanged();
            }
            this.myPatternsTable.removeAssociation(matcher, (Object)fileType);
            if (fireChange) {
                this.fireFileTypesChanged();
            }
        }
    }

    @Nullable
    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getKnownFileTypeOrAssociate"));
        }
        FileType type = file.getFileType();
        if (type == UnknownFileType.INSTANCE) {
            type = FileTypeChooser.associateFileType(file.getName());
        }
        return type;
    }

    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getKnownFileTypeOrAssociate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getKnownFileTypeOrAssociate"));
        }
        return FileTypeChooser.getKnownFileTypeOrAssociate(file, project);
    }

    private void registerReDetectedMappings(@NotNull StandardFileType pair) {
        if (pair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "registerReDetectedMappings"));
        }
        FileType fileType = pair.fileType;
        if (fileType == PlainTextFileType.INSTANCE) {
            return;
        }
        for (FileNameMatcher matcher : pair.matchers) {
            this.registerReDetectedMapping(fileType, matcher);
            if (!(matcher instanceof ExtensionFileNameMatcher)) continue;
            ExtensionFileNameMatcher extMatcher = (ExtensionFileNameMatcher)matcher;
            this.registerReDetectedMapping(fileType, (FileNameMatcher)new ExactFileNameMatcher("." + extMatcher.getExtension()));
        }
    }

    private void registerReDetectedMapping(@NotNull FileType fileType, @NotNull FileNameMatcher matcher) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "registerReDetectedMapping"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "registerReDetectedMapping"));
        }
        String typeName = this.myUnresolvedMappings.get(matcher);
        if (typeName != null && !typeName.equals(fileType.getName())) {
            Trinity<String, String, Boolean> trinity = this.myUnresolvedRemovedMappings.get(matcher);
            this.myRemovedMappings.put(matcher, (Pair<FileType, Boolean>)Pair.create((Object)fileType, (Object)(trinity != null && (Boolean)trinity.third != false ? 1 : 0)));
            this.myUnresolvedMappings.remove(matcher);
        }
    }

    @NotNull
    Map<FileNameMatcher, Pair<FileType, Boolean>> getRemovedMappings() {
        Map<FileNameMatcher, Pair<FileType, Boolean>> map = this.myRemovedMappings;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl", "getRemovedMappings"));
        }
        return map;
    }

    void clearForTests() {
        for (StandardFileType fileType : this.myStandardFileTypes.values()) {
            this.myPatternsTable.removeAllAssociations((Object)fileType.fileType);
        }
        this.myStandardFileTypes.clear();
        this.myUnresolvedMappings.clear();
        this.mySchemesManager.clearAllSchemes();
    }

    public void dispose() {
        LOG.info("FileTypeManager: " + this.counterAutoDetect + " auto-detected files\nElapsed time on auto-detect: " + this.elapsedAutoDetect + " ms");
    }

    static {
        List strings = StringUtil.split((String)DEFAULT_IGNORED, (String)";");
        for (int i = 0; i < strings.size(); ++i) {
            String prev;
            String string = (String)strings.get(i);
            String string2 = prev = i == 0 ? "" : (String)strings.get(i - 1);
            assert (prev.compareTo(string) < 0) : "DEFAULT_IGNORED must be sorted, but got: '" + prev + "' >= '" + string + "'";
        }
        RE_DETECT_ASYNC = !ApplicationManager.getApplication().isUnitTestMode();
        FILE_TYPES_WITH_PREDEFINED_EXTENSIONS = new String[]{"JSP", "JSPX", "DTD", "HTML", "Properties", "XHTML"};
    }

    private static class StandardFileType {
        @NotNull
        private final FileType fileType;
        @NotNull
        private final List<FileNameMatcher> matchers;

        private StandardFileType(@NotNull FileType fileType, @NotNull List<FileNameMatcher> matchers) {
            if (fileType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$StandardFileType", "<init>"));
            }
            if (matchers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchers", "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$StandardFileType", "<init>"));
            }
            this.fileType = fileType;
            this.matchers = matchers;
        }
    }
}

