/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.colors.pages;

import com.intellij.ide.highlighter.custom.CustomFileHighlighter;
import com.intellij.ide.highlighter.custom.CustomHighlighterColors;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.intellij.util.PlatformIcons;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CustomColorsPage
implements ColorSettingsPage,
DisplayPrioritySortable {
    private static final AttributesDescriptor[] ATTRS = new AttributesDescriptor[]{new AttributesDescriptor(OptionsBundle.message((String)"options.custom.attribute.descriptor.keyword1", (Object[])new Object[0]), CustomHighlighterColors.CUSTOM_KEYWORD1_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.custom.attribute.descriptor.keyword2", (Object[])new Object[0]), CustomHighlighterColors.CUSTOM_KEYWORD2_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.custom.attribute.descriptor.keyword3", (Object[])new Object[0]), CustomHighlighterColors.CUSTOM_KEYWORD3_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.custom.attribute.descriptor.keyword4", (Object[])new Object[0]), CustomHighlighterColors.CUSTOM_KEYWORD4_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.custom.attribute.descriptor.number", (Object[])new Object[0]), CustomHighlighterColors.CUSTOM_NUMBER_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.custom.attribute.descriptor.string", (Object[])new Object[0]), CustomHighlighterColors.CUSTOM_STRING_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.custom.attribute.descriptor.line.comment", (Object[])new Object[0]), CustomHighlighterColors.CUSTOM_LINE_COMMENT_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.custom.attribute.descriptor.block.comment", (Object[])new Object[0]), CustomHighlighterColors.CUSTOM_MULTI_LINE_COMMENT_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.custom.attribute.descriptor.valid.string.escape", (Object[])new Object[0]), CustomHighlighterColors.CUSTOM_VALID_STRING_ESCAPE), new AttributesDescriptor(OptionsBundle.message((String)"options.custom.attribute.descriptor.invalid.string.escape", (Object[])new Object[0]), CustomHighlighterColors.CUSTOM_INVALID_STRING_ESCAPE)};
    @NonNls
    private static final SyntaxTable SYNTAX_TABLE = new SyntaxTable();

    @NotNull
    public String getDisplayName() {
        String string = OptionsBundle.message((String)"options.custom.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/colors/pages/CustomColorsPage", "getDisplayName"));
        }
        return string;
    }

    public Icon getIcon() {
        return PlatformIcons.CUSTOM_FILE_ICON;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        if (ATTRS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/colors/pages/CustomColorsPage", "getAttributeDescriptors"));
        }
        return ATTRS;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/colors/pages/CustomColorsPage", "getColorDescriptors"));
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        CustomFileHighlighter customFileHighlighter = new CustomFileHighlighter(SYNTAX_TABLE);
        if (customFileHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/colors/pages/CustomColorsPage", "getHighlighter"));
        }
        return customFileHighlighter;
    }

    @NotNull
    public String getDemoText() {
        if ("# Line comment\naKeyword1 variable = 123;\nanotherKeyword1 someString = \"SomeString\";\naKeyword2 variable = 123;\nanotherKeyword2 someString = \"SomeString\";\naKeyword3 variable = 123;\nanotherKeyword3 someString = \"SomeString\";\naKeyword4 variable = 123;\nanotherKeyword4 someString = \"SomeString \\n\\x  \\& \\g \";\n/* \n * Block comment\n */\n\n" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/colors/pages/CustomColorsPage", "getDemoText"));
        }
        return "# Line comment\naKeyword1 variable = 123;\nanotherKeyword1 someString = \"SomeString\";\naKeyword2 variable = 123;\nanotherKeyword2 someString = \"SomeString\";\naKeyword3 variable = 123;\nanotherKeyword3 someString = \"SomeString\";\naKeyword4 variable = 123;\nanotherKeyword4 someString = \"SomeString \\n\\x  \\& \\g \";\n/* \n * Block comment\n */\n\n";
    }

    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return null;
    }

    public DisplayPriority getPriority() {
        return DisplayPriority.COMMON_SETTINGS;
    }

    static {
        SYNTAX_TABLE.setLineComment("#");
        SYNTAX_TABLE.setStartComment("/*");
        SYNTAX_TABLE.setEndComment("*/");
        SYNTAX_TABLE.setHexPrefix("0x");
        SYNTAX_TABLE.setNumPostfixChars("dDlL");
        SYNTAX_TABLE.setHasStringEscapes(true);
        SYNTAX_TABLE.addKeyword1("aKeyword1");
        SYNTAX_TABLE.addKeyword1("anotherKeyword1");
        SYNTAX_TABLE.addKeyword2("aKeyword2");
        SYNTAX_TABLE.addKeyword2("anotherKeyword2");
        SYNTAX_TABLE.addKeyword3("aKeyword3");
        SYNTAX_TABLE.addKeyword3("anotherKeyword3");
        SYNTAX_TABLE.addKeyword4("aKeyword4");
        SYNTAX_TABLE.addKeyword4("anotherKeyword4");
    }
}

