/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.RecursiveFileHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import org.jetbrains.annotations.Nullable;

public class SwitchedFileHolder
extends RecursiveFileHolder<Pair<Boolean, String>> {
    public SwitchedFileHolder(Project project, FileHolder.HolderType holderType) {
        super(project, holderType);
    }

    public void takeFrom(SwitchedFileHolder holder) {
        this.myMap.clear();
        this.myMap.putAll(holder.myMap);
    }

    @Override
    public synchronized SwitchedFileHolder copy() {
        SwitchedFileHolder copyHolder = new SwitchedFileHolder(this.myProject, this.myHolderType);
        copyHolder.myMap.putAll(this.myMap);
        return copyHolder;
    }

    @Override
    protected boolean isFileDirty(VcsDirtyScope scope, VirtualFile file) {
        if (scope == null) {
            return true;
        }
        if (this.fileDropped(file)) {
            return true;
        }
        return scope.belongsTo(VcsUtil.getFilePath((VirtualFile)file));
    }

    public Map<VirtualFile, String> getFilesMapCopy() {
        HashMap<VirtualFile, String> result = new HashMap<VirtualFile, String>();
        for (VirtualFile vf : this.myMap.keySet()) {
            result.put(vf, (String)((Pair)this.myMap.get(vf)).getSecond());
        }
        return result;
    }

    public void addFile(VirtualFile file, String branch, boolean recursive) {
        this.myMap.put(file, new Pair((Object)recursive, (Object)branch));
    }

    public synchronized MultiMap<String, VirtualFile> getBranchToFileMap() {
        MultiMap result = new MultiMap();
        for (VirtualFile vf : this.myMap.keySet()) {
            result.putValue(((Pair)this.myMap.get(vf)).getSecond(), (Object)vf);
        }
        return result;
    }

    @Override
    public synchronized boolean containsFile(VirtualFile file) {
        VirtualFile floor = this.myMap.floorKey(file);
        if (floor == null) {
            return false;
        }
        NavigableMap floorMap = this.myMap.headMap(floor, true);
        for (VirtualFile parent : floorMap.keySet()) {
            if (!VfsUtil.isAncestor((VirtualFile)parent, (VirtualFile)file, (boolean)false)) continue;
            Pair value = (Pair)floorMap.get(parent);
            return parent.equals(file) || (Boolean)value.getFirst() != false;
        }
        return false;
    }

    @Nullable
    public String getBranchForFile(VirtualFile file) {
        VirtualFile floor = this.myMap.floorKey(file);
        if (floor == null) {
            return null;
        }
        SortedMap floorMap = this.myMap.headMap(floor);
        for (VirtualFile parent : floorMap.keySet()) {
            if (!VfsUtil.isAncestor((VirtualFile)parent, (VirtualFile)file, (boolean)false)) continue;
            return (String)((Pair)floorMap.get(parent)).getSecond();
        }
        return null;
    }

    public void calculateChildren() {
    }

    private static class MyOptimizeProcessor
    implements PairProcessor<Pair<Boolean, String>, Pair<Boolean, String>> {
        private static final MyOptimizeProcessor ourInstance = new MyOptimizeProcessor();

        private MyOptimizeProcessor() {
        }

        public static MyOptimizeProcessor getInstance() {
            return ourInstance;
        }

        public boolean process(Pair<Boolean, String> parentPair, Pair<Boolean, String> childPair) {
            return Boolean.TRUE.equals(parentPair.getFirst()) && ((String)parentPair.getSecond()).equals(childPair.getSecond());
        }
    }
}

