/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.PatchVirtualFileReader;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeGoToChangePopupAction;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.FilePatchStatus;
import com.intellij.openapi.vcs.changes.patch.MatchPatchPaths;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooserPanel;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeList;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.NullableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchDifferentiatedDialog
extends DialogWrapper {
    private final ZipperUpdater myLoadQueue;
    private final TextFieldWithBrowseButton myPatchFile;
    private final List<AbstractFilePatchInProgress> myPatches;
    private final List<ShelveChangesManager.ShelvedBinaryFilePatch> myBinaryShelvedPatches;
    private final MyChangeTreeList myChangesTreeList;
    @Nullable
    private final Collection<Change> myPreselectedChanges;
    private JComponent myCenterPanel;
    private final Project myProject;
    private final AtomicReference<FilePresentation> myRecentPathFileChange;
    private final MyUpdater myUpdater;
    private final Runnable myReset;
    private final ChangeListChooserPanel myChangeListChooser;
    private final ChangesLegendCalculator myInfoCalculator;
    private final CommitLegendPanel myCommitLegendPanel;
    private final ApplyPatchExecutor myCallback;
    private final List<ApplyPatchExecutor> myExecutors;
    private boolean myContainBasedChanges;
    private JLabel myPatchFileLabel;
    private PatchReader myReader;
    private VirtualFileAdapter myListener;
    private final boolean myCanChangePatchFile;
    private String myHelpId;

    public ApplyPatchDifferentiatedDialog(Project project, ApplyPatchExecutor callback, List<ApplyPatchExecutor> executors, @NotNull ApplyPatchMode applyPatchMode, @NotNull VirtualFile patchFile, List<ShelveChangesManager.ShelvedBinaryFilePatch> binaryShelvedPatches, @Nullable Collection<Change> preselectedChanges) {
        if (applyPatchMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applyPatchMode", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog", "<init>"));
        }
        if (patchFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchFile", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog", "<init>"));
        }
        this(project, callback, executors, applyPatchMode, patchFile, null, null, binaryShelvedPatches, preselectedChanges);
    }

    public ApplyPatchDifferentiatedDialog(Project project, ApplyPatchExecutor callback, List<ApplyPatchExecutor> executors, @NotNull ApplyPatchMode applyPatchMode, @NotNull VirtualFile patchFile) {
        if (applyPatchMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applyPatchMode", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog", "<init>"));
        }
        if (patchFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchFile", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog", "<init>"));
        }
        this(project, callback, executors, applyPatchMode, patchFile, null, null, null, null);
    }

    public ApplyPatchDifferentiatedDialog(Project project, ApplyPatchExecutor callback, List<ApplyPatchExecutor> executors, @NotNull ApplyPatchMode applyPatchMode, @NotNull List<TextFilePatch> patches, @Nullable LocalChangeList defaultList) {
        if (applyPatchMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applyPatchMode", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog", "<init>"));
        }
        if (patches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patches", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog", "<init>"));
        }
        this(project, callback, executors, applyPatchMode, null, patches, defaultList, null, null);
    }

    private ApplyPatchDifferentiatedDialog(Project project, ApplyPatchExecutor callback, List<ApplyPatchExecutor> executors, @NotNull ApplyPatchMode applyPatchMode, @Nullable VirtualFile patchFile, @Nullable List<TextFilePatch> patches, @Nullable LocalChangeList defaultList, @Nullable List<ShelveChangesManager.ShelvedBinaryFilePatch> binaryShelvedPatches, @Nullable Collection<Change> preselectedChanges) {
        if (applyPatchMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applyPatchMode", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog", "<init>"));
        }
        super(project, true);
        this.myHelpId = "reference.dialogs.vcs.patch.apply";
        this.myCallback = callback;
        this.myExecutors = executors;
        this.setModal(false);
        this.setTitle(applyPatchMode.getTitle());
        FileChooserDescriptor descriptor = ApplyPatchDifferentiatedDialog.createSelectPatchDescriptor();
        descriptor.setTitle(VcsBundle.message((String)"patch.apply.select.title", (Object[])new Object[0]));
        this.myProject = project;
        this.myPatches = new LinkedList<AbstractFilePatchInProgress>();
        this.myRecentPathFileChange = new AtomicReference();
        this.myBinaryShelvedPatches = binaryShelvedPatches;
        this.myPreselectedChanges = preselectedChanges;
        this.myChangesTreeList = new MyChangeTreeList(project, Collections.emptyList(), new Runnable(){

            @Override
            public void run() {
                NamedTrinity includedTrinity = new NamedTrinity();
                Collection includedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getIncludedChanges();
                HashSet<Couple> set = new HashSet<Couple>();
                for (AbstractFilePatchInProgress.PatchChange change : includedChanges) {
                    Object patch = change.getPatchInProgress().getPatch();
                    Couple pair = Couple.of((Object)patch.getBeforeName(), (Object)patch.getAfterName());
                    if (set.contains(pair)) continue;
                    set.add(pair);
                    ApplyPatchDifferentiatedDialog.acceptChange(includedTrinity, change);
                }
                ApplyPatchDifferentiatedDialog.this.myInfoCalculator.setIncluded(includedTrinity);
                ApplyPatchDifferentiatedDialog.this.myCommitLegendPanel.update();
            }
        }, new MyChangeNodeDecorator());
        this.myChangesTreeList.setDoubleClickHandler(new Runnable(){

            @Override
            public void run() {
                new MyShowDiff().showDiff();
            }
        });
        this.myUpdater = new MyUpdater();
        this.myPatchFile = new TextFieldWithBrowseButton();
        this.myPatchFile.addBrowseFolderListener(VcsBundle.message((String)"patch.apply.select.title", (Object[])new Object[0]), "", project, descriptor);
        this.myPatchFile.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ApplyPatchDifferentiatedDialog.this.setPathFileChangeDefault();
                ApplyPatchDifferentiatedDialog.this.queueRequest();
            }
        });
        this.myLoadQueue = new ZipperUpdater(500, Alarm.ThreadToUse.POOLED_THREAD, this.getDisposable());
        this.myCanChangePatchFile = applyPatchMode.isCanChangePatchFile();
        this.myReset = this.myCanChangePatchFile ? new Runnable(){

            @Override
            public void run() {
                ApplyPatchDifferentiatedDialog.this.reset();
            }
        } : EmptyRunnable.getInstance();
        this.myChangeListChooser = new ChangeListChooserPanel(project, new NullableConsumer<String>(){

            public void consume(@Nullable String errorMessage) {
                ApplyPatchDifferentiatedDialog.this.setOKActionEnabled(errorMessage == null);
                ApplyPatchDifferentiatedDialog.this.setErrorText(errorMessage);
            }
        });
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        this.myChangeListChooser.setChangeLists(changeListManager.getChangeListsCopy());
        this.myChangeListChooser.setDefaultSelection((ChangeList)changeListManager.getDefaultChangeList());
        this.myChangeListChooser.init();
        this.myInfoCalculator = new ChangesLegendCalculator();
        this.myCommitLegendPanel = new CommitLegendPanel(this.myInfoCalculator);
        this.init();
        if (patchFile != null && patchFile.isValid()) {
            this.init(patchFile);
        } else if (patches != null) {
            this.init(patches, defaultList);
        }
        this.myPatchFileLabel.setVisible(this.myCanChangePatchFile);
        this.myPatchFile.setVisible(this.myCanChangePatchFile);
        if (this.myCanChangePatchFile) {
            this.myListener = new VirtualFileAdapter(){

                public void contentsChanged(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$6", "contentsChanged"));
                    }
                    if (ApplyPatchDifferentiatedDialog.this.myRecentPathFileChange.get() != null && ((FilePresentation)ApplyPatchDifferentiatedDialog.this.myRecentPathFileChange.get()).getVf() != null && event.getFile().equals(((FilePresentation)ApplyPatchDifferentiatedDialog.this.myRecentPathFileChange.get()).getVf())) {
                        ApplyPatchDifferentiatedDialog.this.queueRequest();
                    }
                }
            };
            final VirtualFileManager fileManager = VirtualFileManager.getInstance();
            fileManager.addVirtualFileListener((VirtualFileListener)this.myListener);
            Disposer.register((Disposable)this.getDisposable(), (Disposable)new Disposable(){

                public void dispose() {
                    fileManager.removeVirtualFileListener((VirtualFileListener)ApplyPatchDifferentiatedDialog.this.myListener);
                }
            });
        }
    }

    private void queueRequest() {
        this.paintBusy(true);
        this.myLoadQueue.queue(this.myUpdater);
    }

    private void init(List<? extends FilePatch> patches, final LocalChangeList localChangeList) {
        final List<AbstractFilePatchInProgress> matchedPatches = new MatchPatchPaths(this.myProject).execute(patches);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (localChangeList != null) {
                    ApplyPatchDifferentiatedDialog.this.myChangeListChooser.setDefaultSelection((ChangeList)localChangeList);
                }
                ApplyPatchDifferentiatedDialog.this.myPatches.clear();
                ApplyPatchDifferentiatedDialog.this.myPatches.addAll(matchedPatches);
                ApplyPatchDifferentiatedDialog.this.updateTree(true);
            }
        });
    }

    public static FileChooserDescriptor createSelectPatchDescriptor() {
        return new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                return file.getFileType() == StdFileTypes.PATCH || file.getFileType() == FileTypes.PLAIN_TEXT;
            }
        };
    }

    @NotNull
    protected Action[] createActions() {
        if (this.myExecutors.isEmpty()) {
            Action[] actionArray = super.createActions();
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog", "createActions"));
            }
            return actionArray;
        }
        ArrayList<Action> actions = new ArrayList<Action>(4);
        actions.add(this.getOKAction());
        int i = 0;
        while (i < this.myExecutors.size()) {
            final ApplyPatchExecutor executor = this.myExecutors.get(i);
            final int finalI = i++;
            actions.add(new AbstractAction(executor.getName()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplyPatchDifferentiatedDialog.this.runExecutor(executor);
                    ApplyPatchDifferentiatedDialog.this.close(2 + finalI);
                }
            });
        }
        actions.add(this.getCancelAction());
        actions.add(this.getHelpAction());
        Action[] actionArray = actions.toArray(new Action[actions.size()]);
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog", "createActions"));
        }
        return actionArray;
    }

    private void runExecutor(ApplyPatchExecutor executor) {
        Collection<AbstractFilePatchInProgress> included = this.getIncluded();
        if (included.isEmpty()) {
            return;
        }
        MultiMap patchGroups = new MultiMap();
        for (AbstractFilePatchInProgress patchInProgress : included) {
            patchGroups.putValue((Object)patchInProgress.getBase(), (Object)patchInProgress);
        }
        LocalChangeList selected = this.getSelectedChangeList();
        FilePresentation presentation = this.myRecentPathFileChange.get();
        VirtualFile vf = presentation != null ? presentation.getVf() : null;
        executor.apply(patchGroups, selected, vf == null ? null : vf.getName(), this.myReader == null ? null : this.myReader.getAdditionalInfo(ApplyPatchDefaultExecutor.pathsFromGroups((MultiMap<VirtualFile, AbstractFilePatchInProgress>)patchGroups)));
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "vcs.ApplyPatchDifferentiatedDialog";
    }

    protected String getHelpId() {
        return this.myHelpId;
    }

    private void setPathFileChangeDefault() {
        this.myRecentPathFileChange.set(new FilePresentation(this.myPatchFile.getText()));
    }

    private void init(VirtualFile patchFile) {
        this.myPatchFile.setText(patchFile.getPresentableUrl());
        this.myRecentPathFileChange.set(new FilePresentation(patchFile));
        this.queueRequest();
    }

    public void setHelpId(String s) {
        this.myHelpId = s;
    }

    @Nullable
    private static PatchReader loadPatches(FilePresentation filePresentation) {
        PatchReader reader;
        VirtualFile patchFile = filePresentation.getVf();
        if (patchFile == null) {
            return null;
        }
        patchFile.refresh(false, false);
        if (!patchFile.isValid()) {
            return null;
        }
        try {
            reader = PatchVirtualFileReader.create(patchFile);
        }
        catch (IOException e) {
            return null;
        }
        try {
            reader.parseAllPatches();
        }
        catch (PatchSyntaxException e) {
            return null;
        }
        return reader;
    }

    private void reset() {
        this.myPatches.clear();
        this.myChangesTreeList.setChangesToDisplay(Collections.emptyList());
        this.myChangesTreeList.repaint();
        this.myContainBasedChanges = false;
        this.paintBusy(false);
    }

    protected JComponent createCenterPanel() {
        if (this.myCenterPanel == null) {
            this.myCenterPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0);
            this.myPatchFileLabel = new JLabel(VcsBundle.message((String)"patch.apply.file.name.field", (Object[])new Object[0]));
            this.myPatchFileLabel.setLabelFor((Component)this.myPatchFile);
            this.myCenterPanel.add((Component)this.myPatchFileLabel, gb);
            gb.fill = 2;
            ++gb.gridy;
            this.myCenterPanel.add((Component)this.myPatchFile, gb);
            DefaultActionGroup group = new DefaultActionGroup();
            AnAction[] treeActions = this.myChangesTreeList.getTreeActions();
            group.addAll(treeActions);
            group.add((AnAction)new MapDirectory());
            MyShowDiff diffAction = new MyShowDiff();
            diffAction.registerCustomShortcutSet(CommonShortcuts.getDiff(), this.getRootPane());
            group.add((AnAction)diffAction);
            group.add((AnAction)new StripUp());
            group.add((AnAction)new StripDown());
            group.add((AnAction)new ResetStrip());
            group.add((AnAction)new ZeroStrip());
            if (this.myCanChangePatchFile) {
                group.add(new AnAction("Refresh", "Refresh", AllIcons.Actions.Refresh){

                    public void actionPerformed(AnActionEvent e) {
                        ApplyPatchDifferentiatedDialog.this.queueRequest();
                    }
                });
            }
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("APPLY_PATCH", (ActionGroup)group, true);
            ++gb.gridy;
            gb.fill = 2;
            this.myCenterPanel.add((Component)toolbar.getComponent(), gb);
            ++gb.gridy;
            gb.weighty = 1.0;
            gb.fill = 1;
            this.myCenterPanel.add((Component)this.myChangesTreeList, gb);
            ++gb.gridy;
            gb.weighty = 0.0;
            gb.fill = 0;
            gb.insets.bottom = 4;
            this.myCenterPanel.add((Component)this.myCommitLegendPanel.getComponent(), gb);
            ++gb.gridy;
            gb.fill = 2;
            this.myCenterPanel.add((Component)this.myChangeListChooser, gb);
        }
        return this.myCenterPanel;
    }

    private void paintBusy(boolean requestPut) {
        if (requestPut) {
            this.myChangesTreeList.setPaintBusy(true);
        } else {
            this.myChangesTreeList.setPaintBusy(!this.myLoadQueue.isEmpty());
        }
    }

    private static boolean sameBase(List<AbstractFilePatchInProgress.PatchChange> selectedChanges) {
        VirtualFile base = null;
        for (AbstractFilePatchInProgress.PatchChange change : selectedChanges) {
            VirtualFile changeBase = change.getPatchInProgress().getBase();
            if (base == null) {
                base = changeBase;
                continue;
            }
            if (base.equals(changeBase)) continue;
            return false;
        }
        return true;
    }

    private void updateTree(boolean doInitCheck) {
        List<AbstractFilePatchInProgress> patchesToSelect = ApplyPatchDifferentiatedDialog.changes2patches(this.myChangesTreeList.getSelectedChanges());
        List<AbstractFilePatchInProgress.PatchChange> changes = this.getAllChanges();
        Collection<AbstractFilePatchInProgress.PatchChange> included = this.getIncluded(doInitCheck, changes);
        this.myChangesTreeList.setChangesToDisplay(changes);
        this.myChangesTreeList.setIncludedChanges(included);
        if (doInitCheck) {
            this.myChangesTreeList.expandAll();
        }
        this.myChangesTreeList.repaint();
        if (!doInitCheck && patchesToSelect != null) {
            ArrayList<AbstractFilePatchInProgress.PatchChange> toSelect = new ArrayList<AbstractFilePatchInProgress.PatchChange>(patchesToSelect.size());
            for (AbstractFilePatchInProgress.PatchChange change : changes) {
                if (!patchesToSelect.contains(change.getPatchInProgress())) continue;
                toSelect.add(change);
            }
            this.myChangesTreeList.select(toSelect);
        }
        this.myContainBasedChanges = false;
        for (AbstractFilePatchInProgress patch : this.myPatches) {
            if (!patch.baseExistsOrAdded()) continue;
            this.myContainBasedChanges = true;
            break;
        }
    }

    private List<AbstractFilePatchInProgress.PatchChange> getAllChanges() {
        return ObjectsConvertor.convert(this.myPatches, new Convertor<AbstractFilePatchInProgress, AbstractFilePatchInProgress.PatchChange>(){

            public AbstractFilePatchInProgress.PatchChange convert(AbstractFilePatchInProgress o) {
                return o.getChange();
            }
        });
    }

    private static void acceptChange(NamedTrinity trinity, AbstractFilePatchInProgress.PatchChange change) {
        AbstractFilePatchInProgress patchInProgress = change.getPatchInProgress();
        if (FilePatchStatus.ADDED.equals((Object)patchInProgress.getStatus())) {
            trinity.plusAdded();
        } else if (FilePatchStatus.DELETED.equals((Object)patchInProgress.getStatus())) {
            trinity.plusDeleted();
        } else {
            trinity.plusModified();
        }
    }

    private Collection<AbstractFilePatchInProgress.PatchChange> getIncluded(boolean doInitCheck, List<AbstractFilePatchInProgress.PatchChange> changes) {
        NamedTrinity totalTrinity = new NamedTrinity();
        NamedTrinity includedTrinity = new NamedTrinity();
        LinkedList<AbstractFilePatchInProgress.PatchChange> included = new LinkedList<AbstractFilePatchInProgress.PatchChange>();
        if (doInitCheck) {
            for (AbstractFilePatchInProgress.PatchChange change : changes) {
                ApplyPatchDifferentiatedDialog.acceptChange(totalTrinity, change);
                AbstractFilePatchInProgress abstractFilePatchInProgress = change.getPatchInProgress();
                if (!abstractFilePatchInProgress.baseExistsOrAdded() || this.myPreselectedChanges != null && !this.myPreselectedChanges.contains((Object)change)) continue;
                ApplyPatchDifferentiatedDialog.acceptChange(includedTrinity, change);
                included.add(change);
            }
        } else {
            AbstractFilePatchInProgress patch;
            Collection includedNow = this.myChangesTreeList.getIncludedChanges();
            HashSet<AbstractFilePatchInProgress> toBeIncluded = new HashSet<AbstractFilePatchInProgress>();
            for (AbstractFilePatchInProgress.PatchChange change : includedNow) {
                patch = change.getPatchInProgress();
                toBeIncluded.add(patch);
            }
            for (AbstractFilePatchInProgress.PatchChange change : changes) {
                patch = change.getPatchInProgress();
                ApplyPatchDifferentiatedDialog.acceptChange(totalTrinity, change);
                if (!toBeIncluded.contains(patch) || !patch.baseExistsOrAdded()) continue;
                ApplyPatchDifferentiatedDialog.acceptChange(includedTrinity, change);
                included.add(change);
            }
        }
        this.myInfoCalculator.setTotal(totalTrinity);
        this.myInfoCalculator.setIncluded(includedTrinity);
        this.myCommitLegendPanel.update();
        return included;
    }

    private static List<AbstractFilePatchInProgress> changes2patches(List<AbstractFilePatchInProgress.PatchChange> selectedChanges) {
        return ObjectsConvertor.convert(selectedChanges, new Convertor<AbstractFilePatchInProgress.PatchChange, AbstractFilePatchInProgress>(){

            public AbstractFilePatchInProgress convert(AbstractFilePatchInProgress.PatchChange o) {
                return o.getPatchInProgress();
            }
        });
    }

    private Collection<AbstractFilePatchInProgress> getIncluded() {
        return ObjectsConvertor.convert(this.myChangesTreeList.getIncludedChanges(), new Convertor<AbstractFilePatchInProgress.PatchChange, AbstractFilePatchInProgress>(){

            public AbstractFilePatchInProgress convert(AbstractFilePatchInProgress.PatchChange o) {
                return o.getPatchInProgress();
            }
        });
    }

    private LocalChangeList getSelectedChangeList() {
        return this.myChangeListChooser.getSelectedList(this.myProject);
    }

    protected void doOKAction() {
        super.doOKAction();
        this.runExecutor(this.myCallback);
    }

    private class MyChangeComparator
    implements Comparator<AbstractFilePatchInProgress.PatchChange> {
        private MyChangeComparator() {
        }

        @Override
        public int compare(AbstractFilePatchInProgress.PatchChange o1, AbstractFilePatchInProgress.PatchChange o2) {
            if (PropertiesComponent.getInstance((Project)ApplyPatchDifferentiatedDialog.this.myProject).isTrueValue("ChangesBrowser.SHOW_FLATTEN")) {
                return o1.getPatchInProgress().getIoCurrentBase().getName().compareTo(o2.getPatchInProgress().getIoCurrentBase().getName());
            }
            return FileUtil.compareFiles((File)o1.getPatchInProgress().getIoCurrentBase(), (File)o2.getPatchInProgress().getIoCurrentBase());
        }
    }

    private static class MyDiffRequestChain
    extends UserDataHolderBase
    implements DiffRequestChain,
    GoToChangePopupBuilder.Chain {
        private final List<DiffRequestProducer> myRequests;
        private final List<Change> myChanges;
        private int myIndex;

        public MyDiffRequestChain(@NotNull List<DiffRequestProducer> requests, @NotNull List<Change> changes, int index) {
            if (requests == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyDiffRequestChain", "<init>"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyDiffRequestChain", "<init>"));
            }
            this.myRequests = requests;
            this.myChanges = changes;
            this.myIndex = index >= 0 ? index : 0;
        }

        @NotNull
        public List<? extends DiffRequestProducer> getRequests() {
            List<DiffRequestProducer> list = this.myRequests;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyDiffRequestChain", "getRequests"));
            }
            return list;
        }

        public int getIndex() {
            return this.myIndex;
        }

        public void setIndex(int index) {
            assert (index >= 0 && index < this.myRequests.size());
            this.myIndex = index;
        }

        @Override
        @NotNull
        public AnAction createGoToChangeAction(@NotNull Consumer<Integer> onSelected) {
            if (onSelected == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSelected", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyDiffRequestChain", "createGoToChangeAction"));
            }
            ChangeGoToChangePopupAction.Fake<MyDiffRequestChain> fake = new ChangeGoToChangePopupAction.Fake<MyDiffRequestChain>(this, this.myIndex, onSelected){

                @Override
                @NotNull
                protected FilePath getFilePath(int index) {
                    FilePath filePath = ChangesUtil.getFilePath((Change)((Change)MyDiffRequestChain.this.myChanges.get(index)));
                    if (filePath == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyDiffRequestChain$1", "getFilePath"));
                    }
                    return filePath;
                }

                @Override
                @NotNull
                protected FileStatus getFileStatus(int index) {
                    FileStatus fileStatus = ((Change)MyDiffRequestChain.this.myChanges.get(index)).getFileStatus();
                    if (fileStatus == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyDiffRequestChain$1", "getFileStatus"));
                    }
                    return fileStatus;
                }
            };
            if (fake == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyDiffRequestChain", "createGoToChangeAction"));
            }
            return fake;
        }
    }

    private class MyShowDiff
    extends AnAction {
        private final MyChangeComparator myMyChangeComparator;

        private MyShowDiff() {
            super("Show Diff", "Show Diff", AllIcons.Actions.Diff);
            this.myMyChangeComparator = new MyChangeComparator();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(!ApplyPatchDifferentiatedDialog.this.myPatches.isEmpty() && ApplyPatchDifferentiatedDialog.this.myContainBasedChanges);
        }

        public void actionPerformed(AnActionEvent e) {
            this.showDiff();
        }

        private void showDiff() {
            if (ChangeListManager.getInstance((Project)ApplyPatchDifferentiatedDialog.this.myProject).isFreezedWithNotification(null)) {
                return;
            }
            if (ApplyPatchDifferentiatedDialog.this.myPatches.isEmpty() || !ApplyPatchDifferentiatedDialog.this.myContainBasedChanges) {
                return;
            }
            List changes = ApplyPatchDifferentiatedDialog.this.getAllChanges();
            Collections.sort(changes, this.myMyChangeComparator);
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            int selectedIdx = 0;
            ArrayList<DiffRequestProducer> diffRequestPresentableList = new ArrayList<DiffRequestProducer>(changes.size());
            ArrayList<Change> diffRequestChangeList = new ArrayList<Change>(changes.size());
            if (selectedChanges.isEmpty()) {
                selectedChanges = changes;
            }
            if (!selectedChanges.isEmpty()) {
                AbstractFilePatchInProgress.PatchChange c = (AbstractFilePatchInProgress.PatchChange)((Object)selectedChanges.get(0));
                for (AbstractFilePatchInProgress.PatchChange change : changes) {
                    AbstractFilePatchInProgress patchInProgress = change.getPatchInProgress();
                    if (!patchInProgress.baseExistsOrAdded()) continue;
                    diffRequestPresentableList.add(patchInProgress.getDiffRequestProducers(ApplyPatchDifferentiatedDialog.this.myProject, ApplyPatchDifferentiatedDialog.this.myReader));
                    diffRequestChangeList.add(change);
                    if (!change.equals((Object)c)) continue;
                    selectedIdx = diffRequestPresentableList.size() - 1;
                }
            }
            if (diffRequestPresentableList.isEmpty()) {
                return;
            }
            MyDiffRequestChain chain = new MyDiffRequestChain(diffRequestPresentableList, diffRequestChangeList, selectedIdx);
            DiffManager.getInstance().showDiff(ApplyPatchDifferentiatedDialog.this.myProject, (DiffRequestChain)chain, DiffDialogHints.DEFAULT);
        }
    }

    private class ResetStrip
    extends AnAction {
        private ResetStrip() {
            super("Reset Directories", "Reset Directories", AllIcons.Vcs.ResetStrip);
        }

        public void actionPerformed(AnActionEvent e) {
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            for (AbstractFilePatchInProgress.PatchChange change : selectedChanges) {
                change.getPatchInProgress().reset();
            }
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }
    }

    private class StripUp
    extends AnAction {
        private StripUp() {
            super("Strip Directory", "Strip Directory", AllIcons.Vcs.StripUp);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.isEnabled());
        }

        public void actionPerformed(AnActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            for (AbstractFilePatchInProgress.PatchChange change : selectedChanges) {
                change.getPatchInProgress().up();
            }
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }

        private boolean isEnabled() {
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.isEmpty()) {
                return false;
            }
            for (AbstractFilePatchInProgress.PatchChange change : selectedChanges) {
                if (change.getPatchInProgress().canUp()) continue;
                return false;
            }
            return true;
        }
    }

    private class StripDown
    extends AnAction {
        private StripDown() {
            super("Restore Directory", "Restore Directory", AllIcons.Vcs.StripDown);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.isEnabled());
        }

        public void actionPerformed(AnActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            for (AbstractFilePatchInProgress.PatchChange change : selectedChanges) {
                change.getPatchInProgress().down();
            }
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }

        private boolean isEnabled() {
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.isEmpty()) {
                return false;
            }
            for (AbstractFilePatchInProgress.PatchChange change : selectedChanges) {
                if (change.getPatchInProgress().canDown()) continue;
                return false;
            }
            return true;
        }
    }

    private class ZeroStrip
    extends AnAction {
        private ZeroStrip() {
            super("Remove Directories", "Remove Directories", AllIcons.Vcs.StripNull);
        }

        public void actionPerformed(AnActionEvent e) {
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            for (AbstractFilePatchInProgress.PatchChange change : selectedChanges) {
                change.getPatchInProgress().setZero();
            }
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }
    }

    private static class MyChangeNodeDecorator
    implements ChangeNodeDecorator {
        private MyChangeNodeDecorator() {
        }

        @Override
        public void decorate(Change change, SimpleColoredComponent component, boolean isShowFlatten) {
            if (change instanceof AbstractFilePatchInProgress.PatchChange) {
                AbstractFilePatchInProgress.PatchChange patchChange = (AbstractFilePatchInProgress.PatchChange)change;
                if (!isShowFlatten) {
                    Object filePatch = patchChange.getPatchInProgress().getPatch();
                    String patchPath = filePatch.getAfterName() == null ? filePatch.getBeforeName() : filePatch.getAfterName();
                    component.append("   ");
                    component.append("[" + patchPath + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
                if (patchChange.getPatchInProgress().getCurrentStrip() > 0) {
                    component.append(" stripped " + patchChange.getPatchInProgress().getCurrentStrip(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                }
                String text = FilePatchStatus.ADDED.equals((Object)patchChange.getPatchInProgress().getStatus()) ? "(Added)" : (FilePatchStatus.DELETED.equals((Object)patchChange.getPatchInProgress().getStatus()) ? "(Deleted)" : "(Modified)");
                component.append("   ");
                component.append(text, SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }

        @Override
        public List<Pair<String, ChangeNodeDecorator.Stress>> stressPartsOfFileName(Change change, String parentPath) {
            AbstractFilePatchInProgress.PatchChange patchChange;
            String basePath;
            String basePathCorrected;
            if (change instanceof AbstractFilePatchInProgress.PatchChange && parentPath.startsWith(basePathCorrected = (basePath = (patchChange = (AbstractFilePatchInProgress.PatchChange)change).getPatchInProgress().getBase().getPath()).trim().replace('/', File.separatorChar))) {
                return Arrays.asList(Pair.create((Object)basePathCorrected, (Object)((Object)ChangeNodeDecorator.Stress.BOLD)), Pair.create((Object)StringUtil.tail((String)parentPath, (int)basePathCorrected.length()), (Object)((Object)ChangeNodeDecorator.Stress.PLAIN)));
            }
            return null;
        }

        @Override
        public void preDecorate(Change change, ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
        }
    }

    private static class ChangesLegendCalculator
    implements CommitLegendPanel.InfoCalculator {
        private NamedTrinity myTotal = new NamedTrinity();
        private NamedTrinity myIncluded = new NamedTrinity();

        private ChangesLegendCalculator() {
        }

        public void setTotal(NamedTrinity trinity) {
            this.myTotal = trinity;
        }

        public void setIncluded(NamedTrinity trinity) {
            this.myIncluded = trinity;
        }

        @Override
        public int getNew() {
            return this.myTotal.getAdded();
        }

        @Override
        public int getModified() {
            return this.myTotal.getModified();
        }

        @Override
        public int getDeleted() {
            return this.myTotal.getDeleted();
        }

        @Override
        public int getIncludedNew() {
            return this.myIncluded.getAdded();
        }

        @Override
        public int getIncludedModified() {
            return this.myIncluded.getModified();
        }

        @Override
        public int getIncludedDeleted() {
            return this.myIncluded.getDeleted();
        }
    }

    private static class NamedTrinity {
        private int myAdded = 0;
        private int myModified = 0;
        private int myDeleted = 0;

        public void plusAdded() {
            ++this.myAdded;
        }

        public void plusModified() {
            ++this.myModified;
        }

        public void plusDeleted() {
            ++this.myDeleted;
        }

        public int getAdded() {
            return this.myAdded;
        }

        public int getModified() {
            return this.myModified;
        }

        public int getDeleted() {
            return this.myDeleted;
        }
    }

    private class MapPopup
    extends BaseListPopupStep<VirtualFile> {
        private final Runnable myNewBaseSelector;

        private MapPopup(List<? extends VirtualFile> aValues, Runnable newBaseSelector) {
            if (aValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aValues", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MapPopup", "<init>"));
            }
            super("Select base directory for a path", aValues);
            this.myNewBaseSelector = newBaseSelector;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public PopupStep onChosen(VirtualFile selectedValue, boolean finalChoice) {
            if (selectedValue == null) {
                this.myNewBaseSelector.run();
                return null;
            }
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.size() >= 1) {
                for (AbstractFilePatchInProgress.PatchChange patchChange : selectedChanges) {
                    AbstractFilePatchInProgress patch = patchChange.getPatchInProgress();
                    patch.setNewBase(selectedValue);
                }
                ApplyPatchDifferentiatedDialog.this.updateTree(false);
            }
            return null;
        }

        @NotNull
        public String getTextFor(VirtualFile value) {
            String string = value == null ? "Select base for a path" : value.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MapPopup", "getTextFor"));
            }
            return string;
        }
    }

    private class NewBaseSelector
    implements Runnable {
        private NewBaseSelector() {
        }

        @Override
        public void run() {
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            VirtualFile selectedFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)ApplyPatchDifferentiatedDialog.this.myProject, null);
            if (selectedFile == null) {
                return;
            }
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.size() >= 1) {
                for (AbstractFilePatchInProgress.PatchChange patchChange : selectedChanges) {
                    AbstractFilePatchInProgress patch = patchChange.getPatchInProgress();
                    patch.setNewBase(selectedFile);
                }
                ApplyPatchDifferentiatedDialog.this.updateTree(false);
            }
        }
    }

    private class MapDirectory
    extends AnAction {
        private final NewBaseSelector myNewBaseSelector;

        private MapDirectory() {
            super("Map base directory", "Map base directory", AllIcons.Vcs.MapBase);
            this.myNewBaseSelector = new NewBaseSelector();
        }

        public void actionPerformed(AnActionEvent e) {
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.size() >= 1 && ApplyPatchDifferentiatedDialog.sameBase(selectedChanges)) {
                AbstractFilePatchInProgress.PatchChange patchChange = (AbstractFilePatchInProgress.PatchChange)((Object)selectedChanges.get(0));
                AbstractFilePatchInProgress patch = patchChange.getPatchInProgress();
                List<VirtualFile> autoBases = patch.getAutoBasesCopy();
                if (autoBases.isEmpty() || autoBases.size() == 1 && autoBases.get(0).equals(patch.getBase())) {
                    this.myNewBaseSelector.run();
                } else {
                    autoBases.add(null);
                    MapPopup step = new MapPopup(autoBases, this.myNewBaseSelector);
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).showCenteredInCurrentWindow(ApplyPatchDifferentiatedDialog.this.myProject);
                }
            }
        }

        public void update(AnActionEvent e) {
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            e.getPresentation().setEnabled(selectedChanges.size() >= 1 && ApplyPatchDifferentiatedDialog.sameBase(selectedChanges));
        }
    }

    private static class MyChangeTreeList
    extends ChangesTreeList<AbstractFilePatchInProgress.PatchChange> {
        private MyChangeTreeList(Project project, Collection<AbstractFilePatchInProgress.PatchChange> initiallyIncluded, @Nullable Runnable inclusionListener, @Nullable ChangeNodeDecorator decorator) {
            super(project, initiallyIncluded, true, false, inclusionListener, decorator);
        }

        @Override
        protected DefaultTreeModel buildTreeModel(List<AbstractFilePatchInProgress.PatchChange> changes, ChangeNodeDecorator changeNodeDecorator) {
            TreeModelBuilder builder = new TreeModelBuilder(this.myProject, false);
            return builder.buildModel(ObjectsConvertor.convert(changes, new Convertor<AbstractFilePatchInProgress.PatchChange, Change>(){

                public Change convert(AbstractFilePatchInProgress.PatchChange o) {
                    return o;
                }
            }), changeNodeDecorator);
        }

        @Override
        protected List<AbstractFilePatchInProgress.PatchChange> getSelectedObjects(ChangesBrowserNode<AbstractFilePatchInProgress.PatchChange> node) {
            List<Change> under = node.getAllChangesUnder();
            return ObjectsConvertor.convert(under, new Convertor<Change, AbstractFilePatchInProgress.PatchChange>(){

                public AbstractFilePatchInProgress.PatchChange convert(Change o) {
                    return (AbstractFilePatchInProgress.PatchChange)o;
                }
            });
        }

        @Override
        protected AbstractFilePatchInProgress.PatchChange getLeadSelectedObject(ChangesBrowserNode node) {
            Object o = node.getUserObject();
            if (o instanceof AbstractFilePatchInProgress.PatchChange) {
                return (AbstractFilePatchInProgress.PatchChange)((Object)o);
            }
            return null;
        }
    }

    private static class FilePresentation {
        private final VirtualFile myVf;
        private final String myPath;

        private FilePresentation(VirtualFile vf) {
            this.myVf = vf;
            this.myPath = null;
        }

        private FilePresentation(String path) {
            this.myPath = path;
            this.myVf = null;
        }

        @Nullable
        public VirtualFile getVf() {
            if (this.myVf != null) {
                return this.myVf;
            }
            VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myPath);
            return file != null && !file.isDirectory() ? file : null;
        }
    }

    private class MyUpdater
    implements Runnable {
        private MyUpdater() {
        }

        @Override
        public void run() {
            FilePresentation filePresentation = (FilePresentation)ApplyPatchDifferentiatedDialog.this.myRecentPathFileChange.get();
            if (filePresentation == null || filePresentation.getVf() == null) {
                ApplicationManager.getApplication().invokeLater(ApplyPatchDifferentiatedDialog.this.myReset);
                return;
            }
            final VirtualFile file = filePresentation.getVf();
            final PatchReader patchReader = ApplyPatchDifferentiatedDialog.loadPatches(filePresentation);
            if (patchReader == null) {
                return;
            }
            ArrayList filePatches = ContainerUtil.newArrayList((Iterable)patchReader.getPatches());
            if (!ContainerUtil.isEmpty((Collection)ApplyPatchDifferentiatedDialog.this.myBinaryShelvedPatches)) {
                filePatches.addAll(ApplyPatchDifferentiatedDialog.this.myBinaryShelvedPatches);
            }
            final List<AbstractFilePatchInProgress> matchedPatches = new MatchPatchPaths(ApplyPatchDifferentiatedDialog.this.myProject).execute(filePatches);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplyPatchDifferentiatedDialog.this.myChangeListChooser.setDefaultName(file.getNameWithoutExtension().replace('_', ' ').trim());
                    ApplyPatchDifferentiatedDialog.this.myPatches.clear();
                    ApplyPatchDifferentiatedDialog.this.myPatches.addAll(matchedPatches);
                    ApplyPatchDifferentiatedDialog.this.myReader = patchReader;
                    ApplyPatchDifferentiatedDialog.this.updateTree(true);
                    ApplyPatchDifferentiatedDialog.this.paintBusy(false);
                }
            });
        }
    }
}

