/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.google.common.primitives.Ints;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnshelveChangesAction
extends DumbAwareAction {
    private final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.shelf.UnshelveChangesAction");

    public void actionPerformed(AnActionEvent e) {
        ChangeListChooser chooser;
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        final ShelvedChangeList[] changeLists = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY);
        List changes = (List)e.getData(ShelvedChangesViewManager.SHELVED_CHANGE_KEY);
        List binaryFiles = (List)e.getData(ShelvedChangesViewManager.SHELVED_BINARY_FILE_KEY);
        if (changes != null && binaryFiles != null && changes.size() == 0 && binaryFiles.size() == 0) {
            changes = null;
            binaryFiles = null;
        }
        this.LOG.assertTrue(changeLists != null);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        List allChangeLists = changeListManager.getChangeListsCopy();
        String defaultName = changeLists[0].DESCRIPTION;
        LocalChangeList list = null;
        if (changeLists.length == 1) {
            LocalChangeList sameNamedList = changeListManager.findChangeList(defaultName);
            list = sameNamedList != null ? sameNamedList : UnshelveChangesAction.tryToMatchWithExistingChangelist(changeListManager, defaultName);
        }
        if (list == null) {
            list = changeListManager.getDefaultChangeList();
        }
        if (!(chooser = new ChangeListChooser(project, allChangeLists, (ChangeList)list, VcsBundle.message((String)"unshelve.changelist.chooser.title", (Object[])new Object[0]), defaultName)).showAndGet()) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        final List finalBinaryFiles = binaryFiles;
        final List finalChanges = changes;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Unshelve Changes", true, BackgroundFromStartOption.getInstance()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/shelf/UnshelveChangesAction$1", "run"));
                }
                for (ShelvedChangeList changeList : changeLists) {
                    ShelveChangesManager.getInstance(project).unshelveChangeList(changeList, finalChanges, finalBinaryFiles, chooser.getSelectedList(), true);
                }
            }
        });
    }

    @Nullable
    private static LocalChangeList tryToMatchWithExistingChangelist(@NotNull ChangeListManager changeListManager, final @NotNull String defaultName) {
        if (changeListManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeListManager", "com/intellij/openapi/vcs/changes/shelf/UnshelveChangesAction", "tryToMatchWithExistingChangelist"));
        }
        if (defaultName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultName", "com/intellij/openapi/vcs/changes/shelf/UnshelveChangesAction", "tryToMatchWithExistingChangelist"));
        }
        List matched = ContainerUtil.findAll((Collection)changeListManager.getChangeListsCopy(), (Condition)new Condition<LocalChangeList>(){

            public boolean value(LocalChangeList list) {
                return defaultName.contains(list.getName().trim());
            }
        });
        return matched.isEmpty() ? null : Collections.max(matched, new Comparator<LocalChangeList>(){

            @Override
            public int compare(LocalChangeList o1, LocalChangeList o2) {
                return Ints.compare((int)o1.getName().trim().length(), (int)o2.getName().trim().length());
            }
        });
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ShelvedChangeList[] changes = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY);
        e.getPresentation().setEnabled(project != null && changes != null);
    }
}

