/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.CoreJarHandler;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CoreJarFileSystem
extends DeprecatedVirtualFileSystem {
    private final Map<String, CoreJarHandler> myHandlers = new HashMap<String, CoreJarHandler>();

    @NotNull
    public String getProtocol() {
        if ("jar" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "getProtocol"));
        }
        return "jar";
    }

    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "findFileByPath"));
        }
        Couple<String> pair = this.splitPath(path);
        return this.getHandler((String)pair.first).findFileByPath((String)pair.second);
    }

    @NotNull
    protected Couple<String> splitPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "splitPath"));
        }
        int separator = path.indexOf("!/");
        if (separator < 0) {
            throw new IllegalArgumentException("Path in JarFileSystem must contain a separator: " + path);
        }
        String localPath = path.substring(0, separator);
        String pathInJar = path.substring(separator + 2);
        Couple couple = Couple.of((Object)localPath, (Object)pathInJar);
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "splitPath"));
        }
        return couple;
    }

    @NotNull
    private CoreJarHandler getHandler(String localPath) {
        CoreJarHandler handler2 = this.myHandlers.get(localPath);
        if (handler2 == null) {
            handler2 = new CoreJarHandler(this, localPath);
            this.myHandlers.put(localPath, handler2);
        }
        CoreJarHandler coreJarHandler = handler2;
        if (coreJarHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "getHandler"));
        }
        return coreJarHandler;
    }

    public void refresh(boolean asynchronous) {
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem", "refreshAndFindFileByPath"));
        }
        return this.findFileByPath(path);
    }
}

