/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.FileWatcherNotificationSink;
import com.intellij.openapi.vfs.local.PluggableFileWatcher;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.SmartList;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeFileWatcherImpl
extends PluggableFileWatcher {
    private static final Logger LOG = Logger.getInstance(NativeFileWatcherImpl.class);
    private static final String PROPERTY_WATCHER_DISABLED = "idea.filewatcher.disabled";
    private static final String PROPERTY_WATCHER_EXECUTABLE_PATH = "idea.filewatcher.executable.path";
    private static final String ROOTS_COMMAND = "ROOTS";
    private static final String EXIT_COMMAND = "EXIT";
    private static final int MAX_PROCESS_LAUNCH_ATTEMPT_COUNT = 10;
    private ManagingFS myManagingFS;
    private File myExecutable;
    private volatile MyProcessHandler myProcessHandler;
    private volatile int myStartAttemptCount = 0;
    private volatile boolean myIsShuttingDown = false;
    private final AtomicInteger mySettingRoots = new AtomicInteger(0);
    private final Object myLock = new Object();
    private FileWatcherNotificationSink myNotificationSink;
    private volatile List<String> myRecursiveWatchRoots = ContainerUtil.emptyList();
    private volatile List<String> myFlatWatchRoots = ContainerUtil.emptyList();
    private volatile List<String> myManualWatchRoots = ContainerUtil.emptyList();
    private volatile List<Pair<String, String>> myMapping = ContainerUtil.emptyList();
    private final String[] myLastChangedPaths = new String[2];
    private int myLastChangedPathIndex;

    public void initialize(@NotNull ManagingFS managingFS, @NotNull FileWatcherNotificationSink notificationSink) {
        if (managingFS == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "managingFS", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl", "initialize"));
        }
        if (notificationSink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationSink", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl", "initialize"));
        }
        this.myManagingFS = managingFS;
        this.myNotificationSink = notificationSink;
        boolean disabled = Boolean.parseBoolean(System.getProperty(PROPERTY_WATCHER_DISABLED));
        this.myExecutable = NativeFileWatcherImpl.getExecutable();
        if (disabled) {
            LOG.info("Native file watcher is disabled");
        } else if (this.myExecutable == null) {
            LOG.info("Native file watcher is not supported on this platform");
        } else if (!this.myExecutable.exists()) {
            this.notifyOnFailure(ApplicationBundle.message((String)"watcher.exe.not.found", (Object[])new Object[0]), null);
        } else if (!this.myExecutable.canExecute()) {
            this.notifyOnFailure(ApplicationBundle.message((String)"watcher.exe.not.exe", (Object[])new Object[]{this.myExecutable}), new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl$1", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl$1", "hyperlinkUpdate"));
                    }
                    ShowFilePathAction.openFile(NativeFileWatcherImpl.this.myExecutable);
                }
            });
        } else {
            try {
                this.startupProcess(false);
                LOG.info("Native file watcher is operational.");
            }
            catch (IOException e) {
                LOG.warn(e.getMessage());
                this.notifyOnFailure(ApplicationBundle.message((String)"watcher.failed.to.start", (Object[])new Object[0]), null);
            }
        }
    }

    public void dispose() {
        this.myIsShuttingDown = true;
        this.shutdownProcess();
    }

    public boolean isOperational() {
        return this.myProcessHandler != null;
    }

    public boolean isSettingRoots() {
        return this.isOperational() && this.mySettingRoots.get() > 0;
    }

    @NotNull
    public List<String> getManualWatchRoots() {
        List<String> list = this.myManualWatchRoots;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl", "getManualWatchRoots"));
        }
        return list;
    }

    public void setWatchRoots(@NotNull List<String> recursive, @NotNull List<String> flat) {
        if (recursive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recursive", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl", "setWatchRoots"));
        }
        if (flat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flat", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl", "setWatchRoots"));
        }
        this.setWatchRoots(recursive, flat, false);
    }

    public boolean isWatched(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl", "isWatched"));
        }
        return this.isOperational() && !this.checkWatchable(file.getPresentableUrl(), true, true).isEmpty();
    }

    @Nullable
    private static File getExecutable() {
        String execPath = System.getProperty(PROPERTY_WATCHER_EXECUTABLE_PATH);
        if (execPath != null) {
            return new File(execPath);
        }
        String execName = NativeFileWatcherImpl.getExecutableName(false);
        if (execName == null) {
            return null;
        }
        return FileUtil.findFirstThatExist((String[])new String[]{FileUtil.join((String[])new String[]{PathManager.getBinPath(), execName}), FileUtil.join((String[])new String[]{PathManager.getHomePath(), "community", "bin", NativeFileWatcherImpl.getExecutableName(true)}), FileUtil.join((String[])new String[]{PathManager.getBinPath(), NativeFileWatcherImpl.getExecutableName(true)})});
    }

    @Nullable
    private static String getExecutableName(boolean withSubDir) {
        if (SystemInfo.isWindows) {
            return (withSubDir ? "win" + File.separator : "") + "fsnotifier.exe";
        }
        if (SystemInfo.isMac) {
            return (withSubDir ? "mac" + File.separator : "") + "fsnotifier";
        }
        if (SystemInfo.isLinux) {
            return (withSubDir ? "linux" + File.separator : "") + ("arm".equals(SystemInfo.OS_ARCH) ? (SystemInfo.is32Bit ? "fsnotifier-arm" : null) : (SystemInfo.isAMD64 ? "fsnotifier64" : "fsnotifier"));
        }
        return null;
    }

    private void notifyOnFailure(String cause, @Nullable NotificationListener listener) {
        this.myNotificationSink.notifyUserOnFailure(cause, listener);
    }

    private void startupProcess(boolean restart) throws IOException {
        if (this.myIsShuttingDown) {
            return;
        }
        if (ShutDownTracker.isShutdownHookRunning()) {
            this.myIsShuttingDown = true;
            return;
        }
        if (this.myStartAttemptCount++ > 10) {
            this.notifyOnFailure(ApplicationBundle.message((String)"watcher.failed.to.start", (Object[])new Object[0]), null);
            return;
        }
        if (restart) {
            this.shutdownProcess();
        }
        LOG.info("Starting file watcher: " + this.myExecutable);
        ProcessBuilder processBuilder = new ProcessBuilder(this.myExecutable.getAbsolutePath());
        Process process = processBuilder.start();
        this.myProcessHandler = new MyProcessHandler(process);
        this.myProcessHandler.addProcessListener((ProcessListener)new MyProcessAdapter());
        this.myProcessHandler.startNotify();
        if (restart) {
            List<String> recursive = this.myRecursiveWatchRoots;
            List<String> flat = this.myFlatWatchRoots;
            if (recursive.size() + flat.size() > 0) {
                this.setWatchRoots(recursive, flat, true);
            }
        }
    }

    private void shutdownProcess() {
        MyProcessHandler processHandler2 = this.myProcessHandler;
        if (processHandler2 != null) {
            if (!processHandler2.isProcessTerminated()) {
                boolean forceQuite = true;
                try {
                    this.writeLine(EXIT_COMMAND);
                    boolean bl = forceQuite = !processHandler2.waitFor(500L);
                    if (forceQuite) {
                        LOG.warn("File watcher is still alive. Doing a force quit.");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (forceQuite) {
                    processHandler2.destroyProcess();
                }
            }
            this.myProcessHandler = null;
        }
    }

    private synchronized void setWatchRoots(List<String> recursive, List<String> flat, boolean restart) {
        if (this.myProcessHandler == null || this.myProcessHandler.isProcessTerminated()) {
            return;
        }
        if (ApplicationManager.getApplication().isDisposeInProgress()) {
            flat = Collections.emptyList();
            recursive = flat;
        }
        if (!restart && this.myRecursiveWatchRoots.equals(recursive) && this.myFlatWatchRoots.equals(flat)) {
            return;
        }
        this.mySettingRoots.incrementAndGet();
        this.myMapping = ContainerUtil.emptyList();
        this.myRecursiveWatchRoots = recursive;
        this.myFlatWatchRoots = flat;
        try {
            this.writeLine(ROOTS_COMMAND);
            for (String path : recursive) {
                this.writeLine(path);
            }
            for (String path : flat) {
                this.writeLine("|" + path);
            }
            this.writeLine("#");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private void writeLine(String line) throws IOException {
        MyProcessHandler processHandler2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("<< " + line);
        }
        if ((processHandler2 = this.myProcessHandler) != null) {
            processHandler2.writeLine(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetChangedPaths() {
        Object object = this.myLock;
        synchronized (object) {
            this.myLastChangedPathIndex = 0;
            for (int i = 0; i < this.myLastChangedPaths.length; ++i) {
                this.myLastChangedPaths[i] = null;
            }
        }
    }

    @NotNull
    private Collection<String> checkWatchable(String reportedPath, boolean isExact, boolean fastPath) {
        if (reportedPath == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl", "checkWatchable"));
            }
            return list;
        }
        List<String> flatWatchRoots = this.myFlatWatchRoots;
        List<String> recursiveWatchRoots = this.myRecursiveWatchRoots;
        if (flatWatchRoots.isEmpty() && recursiveWatchRoots.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl", "checkWatchable"));
            }
            return list;
        }
        List<Pair<String, String>> mapping = this.myMapping;
        SmartList affectedPaths = new SmartList((Object)reportedPath);
        for (Pair<String, String> map : mapping) {
            if (FileUtil.startsWith((String)reportedPath, (String)((String)map.first))) {
                affectedPaths.add((String)map.second + reportedPath.substring(((String)map.first).length()));
                continue;
            }
            if (!FileUtil.startsWith((String)reportedPath, (String)((String)map.second))) continue;
            affectedPaths.add((String)map.first + reportedPath.substring(((String)map.second).length()));
        }
        SmartList changedPaths = new SmartList();
        block1: for (String path : affectedPaths) {
            String parentPath;
            if (fastPath && !changedPaths.isEmpty()) break;
            for (String root : flatWatchRoots) {
                if (FileUtil.namesEqual((String)path, (String)root)) {
                    changedPaths.add(path);
                    continue block1;
                }
                if (!isExact || (parentPath = new File(path).getParent()) == null || !FileUtil.namesEqual((String)parentPath, (String)root)) continue;
                changedPaths.add(path);
                continue block1;
            }
            for (String root : recursiveWatchRoots) {
                if (FileUtil.startsWith((String)path, (String)root)) {
                    changedPaths.add(path);
                    continue block1;
                }
                if (isExact || (parentPath = new File(root).getParent()) == null || !FileUtil.namesEqual((String)path, (String)parentPath)) continue;
                changedPaths.add(root);
                continue block1;
            }
        }
        SmartList smartList = changedPaths;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl", "checkWatchable"));
        }
        return smartList;
    }

    private void notifyOnAnyEvent() {
        this.myNotificationSink.notifyOnAnyEvent();
    }

    public void startup() throws IOException {
        Application app = ApplicationManager.getApplication();
        assert (app != null && app.isUnitTestMode()) : app;
        this.myIsShuttingDown = false;
        this.myStartAttemptCount = 0;
        this.startupProcess(false);
    }

    public void shutdown() throws InterruptedException {
        Application app = ApplicationManager.getApplication();
        assert (app != null && app.isUnitTestMode()) : app;
        MyProcessHandler processHandler2 = this.myProcessHandler;
        if (processHandler2 != null) {
            this.myIsShuttingDown = true;
            this.shutdownProcess();
            long t = System.currentTimeMillis();
            while (!processHandler2.isProcessTerminated()) {
                if (System.currentTimeMillis() - t > 5000L) {
                    throw new InterruptedException("Timed out waiting watcher process to terminate");
                }
                TimeoutUtil.sleep((long)100L);
            }
        }
    }

    private class MyProcessAdapter
    extends ProcessAdapter {
        private WatcherOp myLastOp = null;
        private final List<String> myLines = ContainerUtil.newArrayList();

        private MyProcessAdapter() {
        }

        public void processTerminated(ProcessEvent event) {
            LOG.warn("Watcher terminated with exit code " + event.getExitCode());
            NativeFileWatcherImpl.this.myProcessHandler = null;
            try {
                NativeFileWatcherImpl.this.startupProcess(true);
            }
            catch (IOException e) {
                NativeFileWatcherImpl.this.shutdownProcess();
                LOG.warn("Watcher terminated and attempt to restart has failed. Exiting watching thread.", (Throwable)e);
            }
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            if (outputType == ProcessOutputTypes.STDERR) {
                LOG.warn(event.getText().trim());
            }
            if (outputType != ProcessOutputTypes.STDOUT) {
                return;
            }
            String line = event.getText().trim();
            if (LOG.isDebugEnabled()) {
                LOG.debug(">> " + line);
            }
            if (this.myLastOp == null) {
                WatcherOp watcherOp;
                try {
                    watcherOp = WatcherOp.valueOf(line);
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Illegal watcher command: " + line);
                    return;
                }
                if (watcherOp == WatcherOp.GIVEUP) {
                    NativeFileWatcherImpl.this.notifyOnFailure(ApplicationBundle.message((String)"watcher.gave.up", (Object[])new Object[0]), null);
                    NativeFileWatcherImpl.this.myIsShuttingDown = true;
                } else if (watcherOp == WatcherOp.RESET) {
                    this.reset();
                } else {
                    this.myLastOp = watcherOp;
                }
            } else if (this.myLastOp == WatcherOp.MESSAGE) {
                NativeFileWatcherImpl.this.notifyOnFailure(line, NotificationListener.URL_OPENING_LISTENER);
                this.myLastOp = null;
            } else if (this.myLastOp == WatcherOp.REMAP || this.myLastOp == WatcherOp.UNWATCHEABLE) {
                if ("#".equals(line)) {
                    if (this.myLastOp == WatcherOp.REMAP) {
                        this.processRemap();
                    } else {
                        NativeFileWatcherImpl.this.mySettingRoots.decrementAndGet();
                        this.processUnwatchable();
                    }
                    this.myLines.clear();
                    this.myLastOp = null;
                } else {
                    this.myLines.add(line);
                }
            } else {
                String path = line.replace('\u0000', '\n');
                this.processChange(path, this.myLastOp);
                this.myLastOp = null;
            }
        }

        private void processRemap() {
            HashSet pairs = ContainerUtil.newHashSet();
            for (int i = 0; i < this.myLines.size() - 1; i += 2) {
                String pathA = this.preparePathForMapping(this.myLines.get(i));
                String pathB = this.preparePathForMapping(this.myLines.get(i + 1));
                pairs.add(Pair.create((Object)pathA, (Object)pathB));
            }
            NativeFileWatcherImpl.this.myMapping = ContainerUtil.newArrayList((Iterable)pairs);
            NativeFileWatcherImpl.this.notifyOnAnyEvent();
        }

        private String preparePathForMapping(String path) {
            String localPath = FileUtil.toSystemDependentName((String)path);
            return localPath.endsWith(File.separator) ? localPath : localPath + File.separator;
        }

        private void processUnwatchable() {
            NativeFileWatcherImpl.this.myManualWatchRoots = Collections.unmodifiableList(ContainerUtil.newArrayList(this.myLines));
            NativeFileWatcherImpl.this.notifyOnAnyEvent();
        }

        private void reset() {
            VirtualFile[] localRoots;
            ArrayList<String> urls = new ArrayList<String>();
            for (VirtualFile root : localRoots = NativeFileWatcherImpl.this.myManagingFS.getLocalRoots()) {
                urls.add(root.getPresentableUrl());
            }
            NativeFileWatcherImpl.this.myNotificationSink.notifyPathsRecursive(urls);
            NativeFileWatcherImpl.this.notifyOnAnyEvent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processChange(String path, WatcherOp op) {
            boolean exactPath;
            Collection paths;
            int length;
            if (SystemInfo.isWindows && op == WatcherOp.RECDIRTY && path.length() == 3 && Character.isLetter(path.charAt(0))) {
                VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path);
                if (root != null) {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyPathsRecursive((Collection)ContainerUtil.list((Object[])new String[]{root.getPresentableUrl()}));
                }
                NativeFileWatcherImpl.this.notifyOnAnyEvent();
                return;
            }
            if (op == WatcherOp.CHANGE) {
                Object root = NativeFileWatcherImpl.this.myLock;
                synchronized (root) {
                    for (int i = 0; i < NativeFileWatcherImpl.this.myLastChangedPaths.length; ++i) {
                        String lastChangedPath;
                        int last = NativeFileWatcherImpl.this.myLastChangedPathIndex - i - 1;
                        if (last < 0) {
                            last += NativeFileWatcherImpl.this.myLastChangedPaths.length;
                        }
                        if ((lastChangedPath = NativeFileWatcherImpl.this.myLastChangedPaths[last]) == null || !lastChangedPath.equals(path)) continue;
                        return;
                    }
                    ((NativeFileWatcherImpl)NativeFileWatcherImpl.this).myLastChangedPaths[((NativeFileWatcherImpl)NativeFileWatcherImpl.this).myLastChangedPathIndex++] = path;
                    if (NativeFileWatcherImpl.this.myLastChangedPathIndex == NativeFileWatcherImpl.this.myLastChangedPaths.length) {
                        NativeFileWatcherImpl.this.myLastChangedPathIndex = 0;
                    }
                }
            }
            if ((length = path.length()) > 1 && path.charAt(length - 1) == '/') {
                path = path.substring(0, length - 1);
            }
            if ((paths = NativeFileWatcherImpl.this.checkWatchable(path, exactPath = op != WatcherOp.DIRTY && op != WatcherOp.RECDIRTY, false)).isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Not watchable, filtered: " + path);
                }
                return;
            }
            switch (op) {
                case STATS: 
                case CHANGE: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyDirtyPaths(paths);
                    break;
                }
                case CREATE: 
                case DELETE: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyPathsCreatedOrDeleted(paths);
                    break;
                }
                case DIRTY: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyDirtyDirectories(paths);
                    break;
                }
                case RECDIRTY: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyPathsRecursive(paths);
                    break;
                }
                default: {
                    LOG.error("Unexpected op: " + (Object)((Object)op));
                }
            }
            NativeFileWatcherImpl.this.notifyOnAnyEvent();
        }
    }

    private static enum WatcherOp {
        GIVEUP,
        RESET,
        UNWATCHEABLE,
        REMAP,
        MESSAGE,
        CREATE,
        DELETE,
        STATS,
        CHANGE,
        DIRTY,
        RECDIRTY;

    }

    private static class MyProcessHandler
    extends OSProcessHandler {
        private final BufferedWriter myWriter;

        private MyProcessHandler(@NotNull Process process) {
            if (process == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl$MyProcessHandler", "<init>"));
            }
            super(process, null, null);
            this.myWriter = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
        }

        private void writeLine(String line) throws IOException {
            this.myWriter.write(line);
            this.myWriter.newLine();
            this.myWriter.flush();
        }

        protected boolean useNonBlockingRead() {
            return false;
        }
    }
}

