/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ProjectGroup;
import com.intellij.ide.ProjectGroupActionGroup;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.UniqueNameBuilder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.BottomLineBorder;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenColors;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ListUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecentProjectPanel
extends JPanel {
    protected final JBList myList;
    protected final UniqueNameBuilder<ReopenProjectAction> myPathShortener;
    protected AnAction removeRecentProjectAction;
    private int myHoverIndex = -1;
    private final int closeButtonInset = JBUI.scale((int)7);
    private Icon currentIcon = AllIcons.Welcome.Project.Remove;
    private static final Logger LOG = Logger.getInstance((String)("#" + RecentProjectPanel.class.getName()));
    private final JPanel myCloseButtonForEditor = new JPanel(){
        {
            this.setPreferredSize(new Dimension(RecentProjectPanel.this.currentIcon.getIconWidth(), RecentProjectPanel.this.currentIcon.getIconHeight()));
            this.setOpaque(true);
        }

        @Override
        protected void paintComponent(Graphics g) {
            RecentProjectPanel.this.currentIcon.paintIcon(this, g, 0, 0);
        }
    };

    private boolean rectInListCoordinatesContains(Rectangle listCellBounds, Point p) {
        int realCloseButtonInset = UIUtil.isRetina((Graphics2D)((Graphics2D)this.myList.getGraphics())) ? this.closeButtonInset * 2 : this.closeButtonInset;
        Rectangle closeButtonRect = new Rectangle(this.myCloseButtonForEditor.getX() - realCloseButtonInset, this.myCloseButtonForEditor.getY() - realCloseButtonInset, this.myCloseButtonForEditor.getWidth() + realCloseButtonInset * 2, this.myCloseButtonForEditor.getHeight() + realCloseButtonInset * 2);
        Rectangle rectInListCoordinates = new Rectangle(new Point(closeButtonRect.x + listCellBounds.x, closeButtonRect.y + listCellBounds.y), closeButtonRect.getSize());
        return rectInListCoordinates.contains(p);
    }

    public RecentProjectPanel(@Nullable Disposable parentDisposable) {
        super(new BorderLayout());
        AnAction[] recentProjectActions = RecentProjectsManager.getInstance().getRecentProjectsActions(false, this.isUseGroups());
        this.myPathShortener = new UniqueNameBuilder(SystemProperties.getUserHome(), File.separator, 40);
        for (AnAction action : recentProjectActions) {
            if (!(action instanceof ReopenProjectAction)) continue;
            ReopenProjectAction item = (ReopenProjectAction)action;
            this.myPathShortener.addPath((Object)item, item.getProjectPath());
        }
        this.myList = this.createList(recentProjectActions, this.getPreferredScrollableViewportSize());
        this.myList.setCellRenderer(this.createRenderer(this.myPathShortener));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                Rectangle cellBounds;
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel$2", "onClick"));
                }
                int selectedIndex = RecentProjectPanel.this.myList.getSelectedIndex();
                if (selectedIndex >= 0 && (cellBounds = RecentProjectPanel.this.myList.getCellBounds(selectedIndex, selectedIndex)).contains(event.getPoint())) {
                    Object selection = RecentProjectPanel.this.myList.getSelectedValue();
                    if (Registry.is((String)"removable.welcome.screen.projects") && RecentProjectPanel.this.rectInListCoordinatesContains(cellBounds, event.getPoint())) {
                        RecentProjectPanel.this.removeRecentProjectAction.actionPerformed(null);
                    } else if (selection != null) {
                        ((AnAction)selection).actionPerformed(AnActionEvent.createFromInputEvent((AnAction)((AnAction)selection), (InputEvent)event, (String)"WelcomeScreen"));
                    }
                }
                return true;
            }
        }.installOn((Component)this.myList);
        this.myList.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selection = RecentProjectPanel.this.myList.getSelectedValue();
                if (selection != null) {
                    ((AnAction)selection).actionPerformed(AnActionEvent.createFromInputEvent((AnAction)((AnAction)selection), null, (String)"WelcomeScreen"));
                }
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
        this.removeRecentProjectAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                int rc;
                Object[] selection = RecentProjectPanel.this.myList.getSelectedValues();
                if (selection != null && selection.length > 0 && (rc = Messages.showOkCancelDialog((Component)RecentProjectPanel.this, (String)("Remove '" + StringUtil.join((Object[])selection, (Function)new Function<Object, String>(){

                    public String fun(Object action) {
                        return ((AnAction)action).getTemplatePresentation().getText();
                    }
                }, (String)"'\n'") + "' from recent projects list?"), (String)"Remove Recent Project", (Icon)Messages.getQuestionIcon())) == 0) {
                    for (Object projectAction : selection) {
                        RecentProjectPanel.removeRecentProjectElement(projectAction);
                    }
                    ListUtil.removeSelectedItems((JList)RecentProjectPanel.this.myList);
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel$4", "update"));
                }
                e.getPresentation().setEnabled(!ListWithFilter.isSearchActive((JList)RecentProjectPanel.this.myList));
            }
        };
        this.removeRecentProjectAction.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DELETE", "BACK_SPACE"}), (JComponent)this.myList, parentDisposable);
        this.addMouseMotionListener();
        this.myList.setSelectedIndex(0);
        JBScrollPane scroll = new JBScrollPane((Component)this.myList);
        scroll.setBorder(null);
        JBList list = recentProjectActions.length == 0 ? this.myList : ListWithFilter.wrap((JList)this.myList, (JScrollPane)scroll, (Function)new Function<Object, String>(){

            public String fun(Object o) {
                if (o instanceof ReopenProjectAction) {
                    ReopenProjectAction item = (ReopenProjectAction)((Object)o);
                    String home = SystemProperties.getUserHome();
                    String path = item.getProjectPath();
                    if (FileUtil.startsWith((String)path, (String)home)) {
                        path = path.substring(home.length());
                    }
                    return item.getProjectName() + " " + path;
                }
                if (o instanceof ProjectGroupActionGroup) {
                    return ((ProjectGroupActionGroup)((Object)o)).getGroup().getName();
                }
                return o.toString();
            }
        });
        this.add((Component)list, "Center");
        JPanel title = this.createTitle();
        if (title != null) {
            this.add((Component)title, "North");
        }
        this.setBorder(new LineBorder(WelcomeScreenColors.BORDER_COLOR));
    }

    protected static void removeRecentProjectElement(Object element) {
        RecentProjectsManager manager = RecentProjectsManager.getInstance();
        if (element instanceof ReopenProjectAction) {
            manager.removePath(((ReopenProjectAction)((Object)element)).getProjectPath());
        } else if (element instanceof ProjectGroupActionGroup) {
            ProjectGroup group = ((ProjectGroupActionGroup)((Object)element)).getGroup();
            for (String path : group.getProjects()) {
                manager.removePath(path);
            }
            manager.removeGroup(group);
        }
    }

    protected boolean isUseGroups() {
        return false;
    }

    protected Dimension getPreferredScrollableViewportSize() {
        return JBUI.size((int)250, (int)400);
    }

    protected void addMouseMotionListener() {
        MouseAdapter mouseAdapter = new MouseAdapter(){
            boolean myIsEngaged = false;

            @Override
            public void mouseMoved(MouseEvent e) {
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (focusOwner == null) {
                    RecentProjectPanel.this.myList.requestFocus();
                }
                if (RecentProjectPanel.this.myList.getSelectedIndices().length > 1) {
                    return;
                }
                if (this.myIsEngaged && !UIUtil.isSelectionButtonDown((MouseEvent)e) && !(focusOwner instanceof JRootPane)) {
                    Point point = e.getPoint();
                    int index = RecentProjectPanel.this.myList.locationToIndex(point);
                    RecentProjectPanel.this.myList.setSelectedIndex(index);
                    Rectangle cellBounds = RecentProjectPanel.this.myList.getCellBounds(index, index);
                    if (cellBounds != null && cellBounds.contains(point)) {
                        RecentProjectPanel.this.myList.setCursor(Cursor.getPredefinedCursor(12));
                        if (RecentProjectPanel.this.rectInListCoordinatesContains(cellBounds, point)) {
                            RecentProjectPanel.this.currentIcon = AllIcons.Welcome.Project.Remove_hover;
                        } else {
                            RecentProjectPanel.this.currentIcon = AllIcons.Welcome.Project.Remove;
                        }
                        RecentProjectPanel.this.myHoverIndex = index;
                        RecentProjectPanel.this.myList.repaint(cellBounds);
                    } else {
                        RecentProjectPanel.this.myList.setCursor(Cursor.getPredefinedCursor(0));
                        RecentProjectPanel.this.myHoverIndex = -1;
                        RecentProjectPanel.this.myList.repaint();
                    }
                } else {
                    this.myIsEngaged = true;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RecentProjectPanel.this.myHoverIndex = -1;
                RecentProjectPanel.this.currentIcon = AllIcons.Welcome.Project.Remove;
                RecentProjectPanel.this.myList.repaint();
            }
        };
        this.myList.addMouseMotionListener((MouseMotionListener)mouseAdapter);
        this.myList.addMouseListener((MouseListener)mouseAdapter);
    }

    protected JBList createList(AnAction[] recentProjectActions, Dimension size) {
        return new MyList(size, (Object[])recentProjectActions);
    }

    protected ListCellRenderer createRenderer(UniqueNameBuilder<ReopenProjectAction> pathShortener) {
        return new RecentProjectItemRenderer(pathShortener);
    }

    @Nullable
    protected JPanel createTitle() {
        JPanel title = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, JBUI.scale((int)28));
            }
        };
        title.setBorder(new BottomLineBorder());
        JLabel titleLabel = new JLabel("Recent Projects");
        title.add(titleLabel);
        titleLabel.setHorizontalAlignment(0);
        titleLabel.setForeground(WelcomeScreenColors.CAPTION_FOREGROUND);
        title.setBackground(WelcomeScreenColors.CAPTION_BACKGROUND);
        return title;
    }

    protected class RecentProjectItemRenderer
    extends JPanel
    implements ListCellRenderer {
        protected final JLabel myName;
        protected final JLabel myPath;
        protected boolean myHovered;
        protected JPanel myCloseThisItem;
        private final UniqueNameBuilder<ReopenProjectAction> myShortener;

        protected RecentProjectItemRenderer(UniqueNameBuilder<ReopenProjectAction> pathShortener) {
            super((LayoutManager)new VerticalFlowLayout());
            this.myName = new JLabel();
            this.myPath = new JLabel();
            this.myCloseThisItem = RecentProjectPanel.this.myCloseButtonForEditor;
            this.myShortener = pathShortener;
            this.myPath.setFont((Font)JBUI.Fonts.label((float)(SystemInfo.isMac ? 10.0f : 11.0f)));
            this.setFocusable(true);
            this.layoutComponents();
        }

        protected void layoutComponents() {
            this.add(this.myName);
            this.add(this.myPath);
        }

        protected Color getListBackground(boolean isSelected, boolean hasFocus) {
            return UIUtil.getListBackground((boolean)isSelected);
        }

        protected Color getListForeground(boolean isSelected, boolean hasFocus) {
            return UIUtil.getListForeground((boolean)isSelected);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.myHovered = RecentProjectPanel.this.myHoverIndex == index;
            Color fore = this.getListForeground(isSelected, list.hasFocus());
            Color back = this.getListBackground(isSelected, list.hasFocus());
            this.myName.setForeground(fore);
            this.myPath.setForeground(isSelected ? fore : UIUtil.getInactiveTextColor());
            this.setBackground(back);
            if (value instanceof ReopenProjectAction) {
                ReopenProjectAction item = (ReopenProjectAction)((Object)value);
                this.myName.setText(item.getTemplatePresentation().getText());
                this.myPath.setText(this.getTitle2Text(item, this.myPath, JBUI.scale((int)40)));
            } else if (value instanceof ProjectGroupActionGroup) {
                ProjectGroupActionGroup group = (ProjectGroupActionGroup)((Object)value);
                this.myName.setText(group.getGroup().getName());
                this.myPath.setText("");
            }
            return this;
        }

        protected String getTitle2Text(ReopenProjectAction action, JComponent pathLabel, int leftOffset) {
            String fullText = action.getProjectPath();
            if (fullText == null || fullText.length() == 0) {
                return " ";
            }
            fullText = FileUtil.getLocationRelativeToUserHome((String)fullText, (boolean)false);
            try {
                FontMetrics fm = pathLabel.getFontMetrics(pathLabel.getFont());
                int maxWidth = RecentProjectPanel.this.getWidth() - leftOffset;
                if (maxWidth > 0 && fm.stringWidth(fullText) > maxWidth) {
                    int left = 1;
                    int right = 1;
                    int center = fullText.length() / 2;
                    String s = fullText.substring(0, center - left) + "..." + fullText.substring(center + right);
                    while (fm.stringWidth(s) > maxWidth) {
                        if (left == right) {
                            ++left;
                        } else {
                            ++right;
                        }
                        if (center - left < 0 || center + right >= fullText.length()) {
                            return "";
                        }
                        s = fullText.substring(0, center - left) + "..." + fullText.substring(center + right);
                    }
                    return s;
                }
            }
            catch (Exception e) {
                LOG.error("Path label font: " + pathLabel.getFont());
                LOG.error("Panel width: " + RecentProjectPanel.this.getWidth());
                LOG.error((Throwable)e);
            }
            return fullText;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.min(size.width, JBUI.scale((int)245)), size.height);
        }

        @Override
        @NotNull
        public Dimension getSize() {
            Dimension dimension = this.getPreferredSize();
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel$RecentProjectItemRenderer", "getSize"));
            }
            return dimension;
        }
    }

    private static class MyList
    extends JBList {
        private final Dimension mySize;
        private Point myMousePoint;

        private MyList(Dimension size, Object ... listData) {
            if (listData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listData", "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel$MyList", "<init>"));
            }
            super(listData);
            this.mySize = size;
            this.setEmptyText("  No Project Open Yet  ");
            this.setSelectionMode(2);
            MouseHandler handler2 = new MouseHandler();
            this.addMouseListener(handler2);
            this.addMouseMotionListener(handler2);
        }

        public Rectangle getCloseIconRect(int index) {
            Rectangle bounds = this.getCellBounds(index, index);
            Icon icon = AllIcons.Welcome.Project.Remove;
            return new Rectangle(bounds.width - icon.getIconWidth() - 10, bounds.y + 10, icon.getIconWidth(), icon.getIconHeight());
        }

        public void paint(Graphics g) {
            int index;
            super.paint(g);
            if (this.myMousePoint != null && (index = this.locationToIndex(this.myMousePoint)) != -1) {
                Rectangle iconRect = this.getCloseIconRect(index);
                Icon icon = iconRect.contains(this.myMousePoint) ? AllIcons.Welcome.Project.Remove_hover : AllIcons.Welcome.Project.Remove;
                icon.paintIcon((Component)((Object)this), g, iconRect.x, iconRect.y);
            }
        }

        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.mySize == null ? super.getPreferredScrollableViewportSize() : this.mySize;
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MyList.this.myMousePoint = e.getPoint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MyList.this.myMousePoint = null;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                MyList.this.myMousePoint = e.getPoint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MyList list = MyList.this;
                Point point = e.getPoint();
                int index = list.locationToIndex(point);
                if (index != -1 && MyList.this.getCloseIconRect(index).contains(point)) {
                    e.consume();
                    Object element = MyList.this.getModel().getElementAt(index);
                    RecentProjectPanel.removeRecentProjectElement(element);
                    ListUtil.removeSelectedItems((JList)((Object)MyList.this));
                }
            }
        }
    }
}

