/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.inspectionsTree;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ui.InspectionsAggregationUtil;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.ToolDescriptors;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.profile.codeInspection.ui.inspectionsTree.MultiScopeSeverityIcon;
import com.intellij.profile.codeInspection.ui.inspectionsTree.ScopesAndSeveritiesHintTable;
import com.intellij.profile.codeInspection.ui.table.ScopesAndSeveritiesTable;
import com.intellij.profile.codeInspection.ui.table.ThreeStateCheckBoxRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.IconTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionsConfigTreeTable
extends TreeTable {
    private static final Logger LOG = Logger.getInstance(InspectionsConfigTreeTable.class);
    private static final int TREE_COLUMN = 0;
    private static final int SEVERITIES_COLUMN = 1;
    private static final int IS_ENABLED_COLUMN = 2;

    public static int getAdditionalPadding() {
        return SystemInfo.isMac ? 10 : 0;
    }

    public static InspectionsConfigTreeTable create(InspectionsConfigTreeTableSettings settings, Disposable parentDisposable) {
        return new InspectionsConfigTreeTable(new InspectionsConfigTreeTableModel(settings, parentDisposable));
    }

    public InspectionsConfigTreeTable(final InspectionsConfigTreeTableModel model) {
        super((TreeTableModel)model);
        TableColumn severitiesColumn = this.getColumnModel().getColumn(1);
        severitiesColumn.setCellRenderer(new IconTableCellRenderer<Icon>(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, false, focus, row, column);
                Color bg = selected ? (focus || table.hasFocus() ? table.getSelectionBackground() : UIUtil.getTreeUnfocusedSelectionBackground()) : table.getBackground();
                component.setBackground(bg);
                ((JLabel)component).setText("");
                return component;
            }

            @Override
            @Nullable
            protected Icon getIcon(@NotNull Icon value, JTable table, int row) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionsConfigTreeTable$1", "getIcon"));
                }
                return value;
            }
        });
        severitiesColumn.setMaxWidth(20);
        TableColumn isEnabledColumn = this.getColumnModel().getColumn(2);
        isEnabledColumn.setMaxWidth(20 + InspectionsConfigTreeTable.getAdditionalPadding());
        isEnabledColumn.setCellRenderer(new ThreeStateCheckBoxRenderer());
        isEnabledColumn.setCellEditor(new ThreeStateCheckBoxRenderer());
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point point = e.getPoint();
                int column = InspectionsConfigTreeTable.this.columnAtPoint(point);
                if (column != 1) {
                    return;
                }
                int row = InspectionsConfigTreeTable.this.rowAtPoint(point);
                Object maybeIcon = InspectionsConfigTreeTable.this.getModel().getValueAt(row, column);
                if (maybeIcon instanceof MultiScopeSeverityIcon) {
                    Object component;
                    MultiScopeSeverityIcon icon = (MultiScopeSeverityIcon)maybeIcon;
                    LinkedHashMap<String, HighlightDisplayLevel> scopeToAverageSeverityMap = icon.getScopeToAverageSeverityMap();
                    if (scopeToAverageSeverityMap.size() == 1 && icon.getDefaultScopeName().equals(ContainerUtil.getFirstItem(scopeToAverageSeverityMap.keySet()))) {
                        HighlightDisplayLevel level = (HighlightDisplayLevel)ContainerUtil.getFirstItem(scopeToAverageSeverityMap.values());
                        JLabel label = new JLabel();
                        label.setIcon(level.getIcon());
                        label.setText(SingleInspectionProfilePanel.renderSeverity(level.getSeverity()));
                        component = label;
                    } else {
                        component = new ScopesAndSeveritiesHintTable(scopeToAverageSeverityMap, icon.getDefaultScopeName());
                    }
                    IdeTooltipManager.getInstance().show(new IdeTooltip((Component)((Object)InspectionsConfigTreeTable.this), point, (JComponent)component, new Object[0]), false);
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                InspectionConfigTreeNode node;
                TreePath path = InspectionsConfigTreeTable.this.getTree().getPathForRow(InspectionsConfigTreeTable.this.getTree().getLeadSelectionRow());
                if (path != null && (node = (InspectionConfigTreeNode)path.getLastPathComponent()).isLeaf()) {
                    model.swapInspectionEnableState();
                }
                return true;
            }
        }.installOn((Component)((Object)this));
        this.setTransferHandler(new TransferHandler(){

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent c) {
                final TreePath path = InspectionsConfigTreeTable.this.getTree().getPathForRow(InspectionsConfigTreeTable.this.getTree().getLeadSelectionRow());
                if (path != null) {
                    return new TextTransferable(StringUtil.join((Collection)ContainerUtil.mapNotNull((Object[])path.getPath(), (Function)new NullableFunction<Object, String>(){

                        @Nullable
                        public String fun(Object o) {
                            return o == path.getPath()[0] ? null : o.toString();
                        }
                    }), (String)" | "));
                }
                return null;
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        });
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                model.swapInspectionEnableState();
                InspectionsConfigTreeTable.this.updateUI();
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
        this.getEmptyText().setText("No enabled inspections available");
    }

    private static class MultiColoredHighlightSeverityIconSink {
        private final Map<String, SeverityAndOccurrences> myScopeToAverageSeverityMap = new HashMap<String, SeverityAndOccurrences>();
        private String myDefaultScopeName;

        private MultiColoredHighlightSeverityIconSink() {
        }

        public Icon constructIcon(InspectionProfileImpl inspectionProfile) {
            Map<String, HighlightSeverity> computedSeverities = this.computeSeverities(inspectionProfile);
            if (computedSeverities == null) {
                return null;
            }
            boolean allScopesHasMixedSeverity = true;
            for (HighlightSeverity severity : computedSeverities.values()) {
                if (severity.equals((Object)ScopesAndSeveritiesTable.MIXED_FAKE_SEVERITY)) continue;
                allScopesHasMixedSeverity = false;
                break;
            }
            return allScopesHasMixedSeverity ? ScopesAndSeveritiesTable.MIXED_FAKE_LEVEL.getIcon() : new MultiScopeSeverityIcon(computedSeverities, this.myDefaultScopeName, inspectionProfile);
        }

        @Nullable
        private Map<String, HighlightSeverity> computeSeverities(InspectionProfileImpl inspectionProfile) {
            if (this.myScopeToAverageSeverityMap.isEmpty()) {
                return null;
            }
            HashMap<String, HighlightSeverity> result = new HashMap<String, HighlightSeverity>();
            Map.Entry entry = (Map.Entry)ContainerUtil.getFirstItem(this.myScopeToAverageSeverityMap.entrySet());
            result.put((String)entry.getKey(), ((SeverityAndOccurrences)entry.getValue()).getPrimarySeverity());
            if (this.myScopeToAverageSeverityMap.size() == 1) {
                return result;
            }
            SeverityAndOccurrences defaultSeveritiesAndOccurrences = this.myScopeToAverageSeverityMap.get(this.myDefaultScopeName);
            if (defaultSeveritiesAndOccurrences == null) {
                for (Map.Entry<String, SeverityAndOccurrences> e : this.myScopeToAverageSeverityMap.entrySet()) {
                    HighlightSeverity primarySeverity = e.getValue().getPrimarySeverity();
                    if (primarySeverity == null) continue;
                    result.put(e.getKey(), primarySeverity);
                }
                return result;
            }
            int allInspectionsCount = defaultSeveritiesAndOccurrences.getOccurrencesSize();
            Map<String, HighlightSeverity> allScopes = defaultSeveritiesAndOccurrences.getOccurrences();
            for (String currentScope : this.myScopeToAverageSeverityMap.keySet()) {
                SeverityAndOccurrences currentSeverityAndOccurrences = this.myScopeToAverageSeverityMap.get(currentScope);
                if (currentSeverityAndOccurrences == null) continue;
                HighlightSeverity currentSeverity = currentSeverityAndOccurrences.getPrimarySeverity();
                if (currentSeverity == ScopesAndSeveritiesTable.MIXED_FAKE_SEVERITY || currentSeverityAndOccurrences.getOccurrencesSize() == allInspectionsCount || this.myDefaultScopeName.equals(currentScope)) {
                    result.put(currentScope, currentSeverity);
                    continue;
                }
                HashSet toolsToCheck = ContainerUtil.newHashSet(allScopes.keySet());
                toolsToCheck.removeAll(currentSeverityAndOccurrences.getOccurrences().keySet());
                boolean doContinue = false;
                Map<String, HighlightSeverity> lowerScopeOccurrences = this.myScopeToAverageSeverityMap.get(this.myDefaultScopeName).getOccurrences();
                for (String toolName : toolsToCheck) {
                    HighlightSeverity currentToolSeverity = lowerScopeOccurrences.get(toolName);
                    if (currentToolSeverity == null || currentSeverity.equals((Object)currentToolSeverity)) continue;
                    result.put(currentScope, ScopesAndSeveritiesTable.MIXED_FAKE_SEVERITY);
                    doContinue = true;
                    break;
                }
                if (doContinue) continue;
                result.put(currentScope, currentSeverity);
            }
            return result;
        }

        public void put(@NotNull ScopeToolState defaultState, @NotNull List<ScopeToolState> nonDefault) {
            if (defaultState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultState", "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionsConfigTreeTable$MultiColoredHighlightSeverityIconSink", "put"));
            }
            if (nonDefault == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nonDefault", "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionsConfigTreeTable$MultiColoredHighlightSeverityIconSink", "put"));
            }
            this.putOne(defaultState);
            if (this.myDefaultScopeName == null) {
                this.myDefaultScopeName = defaultState.getScopeName();
            }
            for (ScopeToolState scopeToolState : nonDefault) {
                this.putOne(scopeToolState);
            }
        }

        private void putOne(ScopeToolState state) {
            if (!state.isEnabled()) {
                return;
            }
            Icon icon = state.getLevel().getIcon();
            String scopeName = state.getScopeName();
            if (icon instanceof HighlightDisplayLevel.ColoredIcon) {
                SeverityAndOccurrences severityAndOccurrences = this.myScopeToAverageSeverityMap.get(scopeName);
                String inspectionName = state.getTool().getShortName();
                if (severityAndOccurrences == null) {
                    this.myScopeToAverageSeverityMap.put(scopeName, new SeverityAndOccurrences().incOccurrences(inspectionName, state.getLevel().getSeverity()));
                } else {
                    severityAndOccurrences.incOccurrences(inspectionName, state.getLevel().getSeverity());
                }
            }
        }
    }

    private static class SeverityAndOccurrences {
        private HighlightSeverity myPrimarySeverity;
        private final Map<String, HighlightSeverity> myOccurrences = new HashMap<String, HighlightSeverity>();

        private SeverityAndOccurrences() {
        }

        public void setSeverityToMixed() {
            this.myPrimarySeverity = ScopesAndSeveritiesTable.MIXED_FAKE_SEVERITY;
        }

        public SeverityAndOccurrences incOccurrences(String toolName, HighlightSeverity severity) {
            if (this.myPrimarySeverity == null) {
                this.myPrimarySeverity = severity;
            } else if (!Comparing.equal((Object)severity, (Object)this.myPrimarySeverity)) {
                this.myPrimarySeverity = ScopesAndSeveritiesTable.MIXED_FAKE_SEVERITY;
            }
            this.myOccurrences.put(toolName, severity);
            return this;
        }

        public HighlightSeverity getPrimarySeverity() {
            return this.myPrimarySeverity;
        }

        public int getOccurrencesSize() {
            return this.myOccurrences.size();
        }

        public Map<String, HighlightSeverity> getOccurrences() {
            return this.myOccurrences;
        }
    }

    private static class InspectionsConfigTreeTableModel
    extends DefaultTreeModel
    implements TreeTableModel {
        private final InspectionsConfigTreeTableSettings mySettings;
        private final Runnable myUpdateRunnable;
        private TreeTable myTreeTable;
        private Alarm myUpdateAlarm;

        public InspectionsConfigTreeTableModel(final InspectionsConfigTreeTableSettings settings, Disposable parentDisposable) {
            super(settings.getRoot());
            this.mySettings = settings;
            this.myUpdateRunnable = new Runnable(){

                @Override
                public void run() {
                    settings.updateRightPanel();
                    ((AbstractTableModel)InspectionsConfigTreeTableModel.this.myTreeTable.getModel()).fireTableDataChanged();
                }
            };
            this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, parentDisposable);
        }

        public int getColumnCount() {
            return 3;
        }

        @Nullable
        public String getColumnName(int column) {
            return null;
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return TreeTableModel.class;
                }
                case 1: {
                    return Icon.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            throw new IllegalArgumentException();
        }

        @Nullable
        public Object getValueAt(Object node, int column) {
            if (column == 0) {
                return null;
            }
            InspectionConfigTreeNode treeNode = (InspectionConfigTreeNode)node;
            List<HighlightDisplayKey> inspectionsKeys = InspectionsAggregationUtil.getInspectionsKeys(treeNode);
            if (column == 1) {
                MultiColoredHighlightSeverityIconSink sink = new MultiColoredHighlightSeverityIconSink();
                for (HighlightDisplayKey selectedInspectionsNode : inspectionsKeys) {
                    String toolId = selectedInspectionsNode.toString();
                    if (!this.mySettings.getInspectionProfile().getTools(toolId, this.mySettings.getProject()).isEnabled()) continue;
                    sink.put(this.mySettings.getInspectionProfile().getToolDefaultState(toolId, this.mySettings.getProject()), this.mySettings.getInspectionProfile().getNonDefaultTools(toolId, this.mySettings.getProject()));
                }
                return sink.constructIcon(this.mySettings.getInspectionProfile());
            }
            if (column == 2) {
                return this.isEnabled(inspectionsKeys);
            }
            throw new IllegalArgumentException();
        }

        @Nullable
        private Boolean isEnabled(List<HighlightDisplayKey> selectedInspectionsNodes) {
            Boolean isPreviousEnabled = null;
            for (HighlightDisplayKey key : selectedInspectionsNodes) {
                ToolsImpl tools = this.mySettings.getInspectionProfile().getTools(key.toString(), this.mySettings.getProject());
                for (ScopeToolState state : tools.getTools()) {
                    boolean enabled = state.isEnabled();
                    if (isPreviousEnabled == null) {
                        isPreviousEnabled = enabled;
                        continue;
                    }
                    if (isPreviousEnabled.equals(enabled)) continue;
                    return null;
                }
            }
            return isPreviousEnabled;
        }

        public boolean isCellEditable(Object node, int column) {
            return column == 2;
        }

        public void setValueAt(Object aValue, Object node, int column) {
            LOG.assertTrue(column == 2);
            if (aValue == null) {
                return;
            }
            boolean doEnable = (Boolean)aValue;
            InspectionProfileImpl profile = this.mySettings.getInspectionProfile();
            for (InspectionConfigTreeNode aNode : InspectionsAggregationUtil.getInspectionsNodes((InspectionConfigTreeNode)node)) {
                this.setToolEnabled(doEnable, profile, aNode.getKey());
                aNode.dropCache();
                this.mySettings.onChanged(aNode);
            }
            this.updateRightPanel();
        }

        public void swapInspectionEnableState() {
            int[] selectedRows;
            LOG.assertTrue(this.myTreeTable != null);
            Boolean state = null;
            com.intellij.util.containers.HashSet tools = new com.intellij.util.containers.HashSet();
            ArrayList<InspectionConfigTreeNode> nodes = new ArrayList<InspectionConfigTreeNode>();
            for (TreePath selectionPath : this.myTreeTable.getTree().getSelectionPaths()) {
                InspectionConfigTreeNode node = (InspectionConfigTreeNode)selectionPath.getLastPathComponent();
                InspectionsConfigTreeTableModel.collectInspectionFromNodes(node, (Set<HighlightDisplayKey>)tools, nodes);
            }
            for (int selectedRow : selectedRows = this.myTreeTable.getSelectedRows()) {
                Boolean value = (Boolean)this.myTreeTable.getValueAt(selectedRow, 2);
                if (state == null) {
                    state = value;
                    continue;
                }
                if (state.equals(value)) continue;
                state = null;
                break;
            }
            boolean newState = !Boolean.TRUE.equals(state);
            InspectionProfileImpl profile = this.mySettings.getInspectionProfile();
            for (HighlightDisplayKey tool : tools) {
                this.setToolEnabled(newState, profile, tool);
            }
            for (InspectionConfigTreeNode node : nodes) {
                node.dropCache();
                this.mySettings.onChanged(node);
            }
            this.updateRightPanel();
        }

        private void updateRightPanel() {
            if (this.myTreeTable != null && !this.myUpdateAlarm.isDisposed()) {
                this.myUpdateAlarm.cancelAllRequests();
                this.myUpdateAlarm.addRequest(this.myUpdateRunnable, 10, ModalityState.stateForComponent((Component)this.myTreeTable));
            }
        }

        private void setToolEnabled(boolean newState, InspectionProfileImpl profile, HighlightDisplayKey tool) {
            String toolId = tool.toString();
            if (newState) {
                profile.enableTool(toolId, this.mySettings.getProject());
            } else {
                profile.disableTool(toolId, this.mySettings.getProject());
            }
            for (ScopeToolState scopeToolState : profile.getTools(toolId, this.mySettings.getProject()).getTools()) {
                scopeToolState.setEnabled(newState);
            }
        }

        private static void collectInspectionFromNodes(InspectionConfigTreeNode node, Set<HighlightDisplayKey> tools, List<InspectionConfigTreeNode> nodes) {
            if (node == null) {
                return;
            }
            nodes.add(node);
            ToolDescriptors descriptors = node.getDescriptors();
            if (descriptors == null) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    InspectionsConfigTreeTableModel.collectInspectionFromNodes((InspectionConfigTreeNode)node.getChildAt(i), tools, nodes);
                }
            } else {
                HighlightDisplayKey key = descriptors.getDefaultDescriptor().getKey();
                tools.add(key);
            }
        }

        public void setTree(JTree tree) {
            this.myTreeTable = ((TreeTableTree)tree).getTreeTable();
        }
    }

    public static abstract class InspectionsConfigTreeTableSettings {
        private final TreeNode myRoot;
        private final Project myProject;

        public InspectionsConfigTreeTableSettings(TreeNode root, Project project) {
            this.myRoot = root;
            this.myProject = project;
        }

        public TreeNode getRoot() {
            return this.myRoot;
        }

        public Project getProject() {
            return this.myProject;
        }

        protected abstract InspectionProfileImpl getInspectionProfile();

        protected abstract void onChanged(InspectionConfigTreeNode var1);

        public abstract void updateRightPanel();
    }
}

