/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightPsiFileImpl
extends PsiElementBase
implements PsiFileEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.LightPsiFileImpl");
    private PsiFile myOriginalFile;
    private boolean myExplicitlySetAsValid;
    private boolean myInvalidated;
    private final FileViewProvider myViewProvider;
    private final PsiManagerImpl myManager;
    private final Language myLanguage;

    public LightPsiFileImpl(@NotNull FileViewProvider provider, @NotNull Language language) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/LightPsiFileImpl", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/source/LightPsiFileImpl", "<init>"));
        }
        this.myOriginalFile = null;
        this.myExplicitlySetAsValid = false;
        this.myInvalidated = false;
        this.myViewProvider = provider;
        this.myManager = (PsiManagerImpl)provider.getManager();
        this.myLanguage = language;
    }

    public VirtualFile getVirtualFile() {
        return this.getViewProvider().isEventSystemEnabled() ? this.getViewProvider().getVirtualFile() : null;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        return true;
    }

    @Override
    public boolean isValid() {
        if (this.myInvalidated) {
            return false;
        }
        if (!this.getViewProvider().isPhysical() || this.myExplicitlySetAsValid) {
            return true;
        }
        return this.getViewProvider().getVirtualFile().isValid();
    }

    public void setIsValidExplicitly(boolean b) {
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode());
        this.myExplicitlySetAsValid = b;
    }

    public String getText() {
        return this.getViewProvider().getContents().toString();
    }

    public long getModificationStamp() {
        return this.getViewProvider().getModificationStamp();
    }

    public void subtreeChanged() {
        this.clearCaches();
        this.getViewProvider().rootChanged((PsiFile)this);
    }

    public abstract void clearCaches();

    protected LightPsiFileImpl clone() {
        FileViewProvider provider = this.getViewProvider().clone();
        LightPsiFileImpl clone = (LightPsiFileImpl)provider.getPsi(this.getLanguage());
        this.copyCopyableDataTo((UserDataHolderBase)clone);
        if (this.getViewProvider().isEventSystemEnabled()) {
            clone.myOriginalFile = this;
        } else if (this.myOriginalFile != null) {
            clone.myOriginalFile = this.myOriginalFile;
        }
        return clone;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getViewProvider().getVirtualFile().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/LightPsiFileImpl", "getName"));
        }
        return string;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/LightPsiFileImpl", "setName"));
        }
        this.checkSetName(name);
        this.subtreeChanged();
        return PsiFileImplUtil.setName(this, name);
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            return;
        }
        PsiFileImplUtil.checkSetName(this, name);
    }

    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    public PsiDirectory getContainingDirectory() {
        VirtualFile parentFile = this.getViewProvider().getVirtualFile().getParent();
        if (parentFile == null) {
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Nullable
    public PsiDirectory getParentDirectory() {
        return this.getContainingDirectory();
    }

    @Override
    public PsiFile getContainingFile() {
        return this;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            throw new IncorrectOperationException();
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    @NotNull
    public PsiFile getOriginalFile() {
        LightPsiFileImpl lightPsiFileImpl = this.myOriginalFile == null ? this : this.myOriginalFile;
        if (lightPsiFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/LightPsiFileImpl", "getOriginalFile"));
        }
        return lightPsiFileImpl;
    }

    public void setOriginalFile(PsiFile originalFile) {
        this.myOriginalFile = originalFile.getOriginalFile();
    }

    @NotNull
    public PsiFile[] getPsiRoots() {
        PsiFile[] psiFileArray = new PsiFile[]{this};
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/LightPsiFileImpl", "getPsiRoots"));
        }
        return psiFileArray;
    }

    @Override
    public boolean isPhysical() {
        return this.getViewProvider().isEventSystemEnabled();
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/LightPsiFileImpl", "getLanguage"));
        }
        return language;
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myViewProvider;
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/LightPsiFileImpl", "getViewProvider"));
        }
        return fileViewProvider;
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        Project project = manager.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/LightPsiFileImpl", "getProject"));
        }
        return project;
    }

    @Override
    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/LightPsiFileImpl", "acceptChildren"));
        }
        PsiElement child = this.getFirstChild();
        while (child != null) {
            PsiElement nextSibling = child.getNextSibling();
            child.accept(visitor);
            child = nextSibling;
        }
    }

    @Override
    public final synchronized PsiElement copy() {
        return this.clone();
    }

    @Override
    public final void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/LightPsiFileImpl", "checkAdd"));
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    @Override
    @NotNull
    public synchronized PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences((PsiElement)this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/LightPsiFileImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope((PsiElement)this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/LightPsiFileImpl", "getUseScope"));
        }
        return globalSearchScope;
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiNavigationSupport.getInstance().getDescriptor((PsiElement)this).navigate(requestFocus);
    }

    public synchronized PsiElement findElementAt(int offset) {
        return this.getViewProvider().findElementAt(offset);
    }

    @Override
    public synchronized PsiReference findReferenceAt(int offset) {
        return this.getViewProvider().findReferenceAt(offset);
    }

    @NotNull
    public char[] textToCharArray() {
        char[] cArray = CharArrayUtil.fromSequence((CharSequence)this.getViewProvider().getContents());
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/LightPsiFileImpl", "textToCharArray"));
        }
        return cArray;
    }

    @Override
    public boolean isContentsLoaded() {
        return true;
    }

    @Override
    public void onContentReload() {
    }

    @Override
    public boolean isWritable() {
        return this.getViewProvider().getVirtualFile().isWritable();
    }

    @NotNull
    public abstract PsiElement[] getChildren();

    @Override
    public PsiElement getFirstChild() {
        PsiElement[] children = this.getChildren();
        return children.length == 0 ? null : children[0];
    }

    @Override
    public PsiElement getLastChild() {
        PsiElement[] children = this.getChildren();
        return children.length == 0 ? null : children[children.length - 1];
    }

    public TextRange getTextRange() {
        return new TextRange(0, this.getTextLength());
    }

    public int getStartOffsetInParent() {
        return 0;
    }

    public int getTextLength() {
        return this.getViewProvider().getContents().length();
    }

    public int getTextOffset() {
        return 0;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/LightPsiFileImpl", "textMatches"));
        }
        return this.textMatches(element.getText());
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/LightPsiFileImpl", "textMatches"));
        }
        return text.equals(this.getViewProvider().getContents());
    }

    @Override
    public boolean textContains(char c) {
        return this.getText().indexOf(c) >= 0;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/LightPsiFileImpl", "add"));
        }
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/LightPsiFileImpl", "addBefore"));
        }
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/LightPsiFileImpl", "addAfter"));
        }
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public final PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/psi/impl/source/LightPsiFileImpl", "addRangeBefore"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "com/intellij/psi/impl/source/LightPsiFileImpl", "addRangeBefore"));
        }
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public final PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/source/LightPsiFileImpl", "replace"));
        }
        throw new IncorrectOperationException("Not implemented");
    }

    public FileASTNode getNode() {
        return null;
    }

    public abstract LightPsiFileImpl copyLight(FileViewProvider var1);

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    public void markInvalidated() {
        this.myInvalidated = true;
    }
}

