/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.classpath;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.util.ui.classpath.ChooseLibrariesDialogBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseLibrariesFromTablesDialog
extends ChooseLibrariesDialogBase {
    @Nullable
    private final Project myProject;
    private final boolean myShowCustomLibraryTables;

    protected ChooseLibrariesFromTablesDialog(@NotNull String title, @NotNull Project project, boolean showCustomLibraryTables) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/util/ui/classpath/ChooseLibrariesFromTablesDialog", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/ui/classpath/ChooseLibrariesFromTablesDialog", "<init>"));
        }
        super(project, title);
        this.myShowCustomLibraryTables = showCustomLibraryTables;
        this.myProject = project;
    }

    protected ChooseLibrariesFromTablesDialog(@NotNull JComponent parentComponent, @NotNull String title, @Nullable Project project, boolean showCustomLibraryTables) {
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "com/intellij/util/ui/classpath/ChooseLibrariesFromTablesDialog", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/util/ui/classpath/ChooseLibrariesFromTablesDialog", "<init>"));
        }
        super(parentComponent, title);
        this.myShowCustomLibraryTables = showCustomLibraryTables;
        this.myProject = project;
    }

    public static ChooseLibrariesFromTablesDialog createDialog(@NotNull String title, @NotNull Project project, boolean showCustomLibraryTables) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/util/ui/classpath/ChooseLibrariesFromTablesDialog", "createDialog"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/ui/classpath/ChooseLibrariesFromTablesDialog", "createDialog"));
        }
        ChooseLibrariesFromTablesDialog dialog = new ChooseLibrariesFromTablesDialog(title, project, showCustomLibraryTables);
        dialog.init();
        return dialog;
    }

    @Override
    @NotNull
    protected Project getProject() {
        if (this.myProject != null) {
            Project project = this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/classpath/ChooseLibrariesFromTablesDialog", "getProject"));
            }
            return project;
        }
        Project project = super.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/classpath/ChooseLibrariesFromTablesDialog", "getProject"));
        }
        return project;
    }

    @Override
    protected JComponent createNorthPanel() {
        return null;
    }

    @Override
    protected void collectChildren(Object element, List<Object> result) {
        if (element instanceof Application) {
            for (LibraryTable table : ChooseLibrariesFromTablesDialog.getLibraryTables(this.myProject, this.myShowCustomLibraryTables)) {
                if (!this.hasLibraries(table)) continue;
                result.add(table);
            }
        } else if (element instanceof LibraryTable) {
            Collections.addAll(result, this.getLibraries((LibraryTable)element));
        }
    }

    public static List<LibraryTable> getLibraryTables(Project project, boolean showCustomLibraryTables) {
        ArrayList<LibraryTable> tables = new ArrayList<LibraryTable>();
        LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
        if (project != null) {
            tables.add(registrar.getLibraryTable(project));
        }
        tables.add(registrar.getLibraryTable());
        if (showCustomLibraryTables) {
            for (LibraryTable table : registrar.getCustomLibraryTables()) {
                tables.add(table);
            }
        }
        return tables;
    }

    private boolean hasLibraries(LibraryTable table) {
        Library[] libraries;
        for (Library library : libraries = this.getLibraries(table)) {
            if (!this.acceptsElement(library)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int getLibraryTableWeight(@NotNull LibraryTable libraryTable) {
        if (libraryTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryTable", "com/intellij/util/ui/classpath/ChooseLibrariesFromTablesDialog", "getLibraryTableWeight"));
        }
        if (libraryTable.getTableLevel().equals("module")) {
            return 0;
        }
        if (this.isProjectLibraryTable(libraryTable)) {
            return 1;
        }
        if (ChooseLibrariesFromTablesDialog.isApplicationLibraryTable(libraryTable)) {
            return 2;
        }
        return 3;
    }

    private static boolean isApplicationLibraryTable(LibraryTable libraryTable) {
        return libraryTable.equals(LibraryTablesRegistrar.getInstance().getLibraryTable());
    }

    private boolean isProjectLibraryTable(LibraryTable libraryTable) {
        LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
        return this.myProject != null && libraryTable.equals(registrar.getLibraryTable(this.myProject));
    }

    @Override
    protected boolean isAutoExpandLibraryTable(@NotNull LibraryTable libraryTable) {
        if (libraryTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryTable", "com/intellij/util/ui/classpath/ChooseLibrariesFromTablesDialog", "isAutoExpandLibraryTable"));
        }
        return ChooseLibrariesFromTablesDialog.isApplicationLibraryTable(libraryTable) || this.isProjectLibraryTable(libraryTable);
    }

    @NotNull
    protected Library[] getLibraries(@NotNull LibraryTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/util/ui/classpath/ChooseLibrariesFromTablesDialog", "getLibraries"));
        }
        Library[] libraryArray = table.getLibraries();
        if (libraryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/classpath/ChooseLibrariesFromTablesDialog", "getLibraries"));
        }
        return libraryArray;
    }
}

