/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.EvaluationInputComponent;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionInputComponent
extends EvaluationInputComponent {
    private final XDebuggerExpressionEditor myExpressionEditor;
    private final JPanel myMainPanel;

    public ExpressionInputComponent(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSourcePosition sourcePosition, @Nullable XExpression expression, Disposable parentDisposable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/evaluate/ExpressionInputComponent", "<init>"));
        }
        if (editorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorsProvider", "com/intellij/xdebugger/impl/evaluate/ExpressionInputComponent", "<init>"));
        }
        super(XDebuggerBundle.message((String)"xdebugger.dialog.title.evaluate.expression", (Object[])new Object[0]));
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myExpressionEditor = new XDebuggerExpressionEditor(project, editorsProvider, "evaluateExpression", sourcePosition, expression != null ? expression : XExpressionImpl.EMPTY_EXPRESSION, false);
        this.myMainPanel.add((Component)this.myExpressionEditor.getComponent(), "Center");
        FixedSizeButton historyButton = new FixedSizeButton(this.myExpressionEditor.getComponent());
        historyButton.setIcon(AllIcons.General.MessageHistory);
        historyButton.setToolTipText(XDebuggerBundle.message((String)"xdebugger.evaluate.history.hint", (Object[])new Object[0]));
        historyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressionInputComponent.this.showHistory();
            }
        });
        this.myMainPanel.add((Component)historyButton, "East");
        JBLabel help = new JBLabel(XDebuggerBundle.message((String)"xdebugger.evaluate.addtowatches.hint", (Object[])new Object[0]), 4);
        help.setBorder((Border)JBUI.Borders.empty((int)2, (int)0, (int)6, (int)0));
        help.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        help.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.myMainPanel.add((Component)help, "South");
        if (expression != null) {
            this.myExpressionEditor.setExpression(expression);
        }
        this.myExpressionEditor.selectAll();
        new AnAction("XEvaluateDialog.ShowHistory"){

            public void actionPerformed(AnActionEvent e) {
                ExpressionInputComponent.this.showHistory();
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(LookupManager.getActiveLookup(ExpressionInputComponent.this.myExpressionEditor.getEditor()) == null);
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DOWN"}), (JComponent)this.myMainPanel, parentDisposable);
    }

    private void showHistory() {
        List<XExpression> expressions = this.myExpressionEditor.getRecentExpressions();
        if (!expressions.isEmpty()) {
            ListPopupImpl popup = new ListPopupImpl((ListPopupStep)new BaseListPopupStep<XExpression>(null, expressions){

                public PopupStep onChosen(XExpression selectedValue, boolean finalChoice) {
                    ExpressionInputComponent.this.myExpressionEditor.setExpression(selectedValue);
                    ExpressionInputComponent.this.myExpressionEditor.requestFocusInEditor();
                    return FINAL_CHOICE;
                }
            }){

                @Override
                protected ListCellRenderer getListElementRenderer() {
                    return new ColoredListCellRenderer<XExpression>(){

                        protected void customizeCellRenderer(JList list, XExpression value, int index, boolean selected, boolean hasFocus) {
                            this.append(value.getExpression());
                        }
                    };
                }
            };
            popup.getList().setFont(EditorUtil.getEditorFont());
            popup.showUnderneathOf(this.myExpressionEditor.getEditorComponent());
        }
    }

    @Override
    public void addComponent(JPanel contentPanel, JPanel resultPanel) {
        contentPanel.add((Component)resultPanel, "Center");
        contentPanel.add((Component)this.myMainPanel, "North");
    }

    @Override
    @NotNull
    protected XDebuggerEditorBase getInputEditor() {
        XDebuggerExpressionEditor xDebuggerExpressionEditor = this.myExpressionEditor;
        if (xDebuggerExpressionEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/evaluate/ExpressionInputComponent", "getInputEditor"));
        }
        return xDebuggerExpressionEditor;
    }
}

