/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import gnu.trove.THashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PointlessArithmeticExpressionInspection
extends BaseInspection {
    private static final Set<IElementType> arithmeticTokens = new THashSet(9);
    public boolean m_ignoreExpressionsContainingConstants = true;

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("pointless.boolean.expression.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreExpressionsContainingConstants");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("pointless.arithmetic.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", this.calculateReplacementExpression((PsiExpression)infos[0]));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection", "buildErrorString"));
        }
        return string;
    }

    @NonNls
    String calculateReplacementExpression(PsiExpression expression) {
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
        PsiExpression[] operands = polyadicExpression.getOperands();
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        PsiExpression fromTarget = null;
        PsiExpression untilTarget = null;
        PsiExpression previousOperand = null;
        String replacement = "";
        int length = operands.length;
        for (int i = 0; i < length; ++i) {
            PsiExpression operand = operands[i];
            if (tokenType.equals(JavaTokenType.PLUS) && this.isZero(operand) || tokenType.equals(JavaTokenType.MINUS) && this.isZero(operand) && i > 0 || tokenType.equals(JavaTokenType.ASTERISK) && this.isOne(operand) || tokenType.equals(JavaTokenType.DIV) && this.isOne(operand) && i > 0) {
                fromTarget = i == length - 1 ? polyadicExpression.getTokenBeforeOperand(operand) : operand;
                break;
            }
            if ((tokenType.equals(JavaTokenType.MINUS) && i == 1 || tokenType.equals(JavaTokenType.DIV)) && EquivalenceChecker.expressionsAreEquivalent(previousOperand, operand)) {
                fromTarget = previousOperand;
                untilTarget = operand;
                replacement = PsiType.LONG.equals((Object)polyadicExpression.getType()) ? (tokenType.equals(JavaTokenType.DIV) ? "1L" : "0L") : (tokenType.equals(JavaTokenType.DIV) ? "1" : "0");
                break;
            }
            if (tokenType.equals(JavaTokenType.ASTERISK) && this.isZero(operand) || tokenType.equals(JavaTokenType.PERC) && (this.isOne(operand) || EquivalenceChecker.expressionsAreEquivalent(previousOperand, operand))) {
                fromTarget = operands[0];
                untilTarget = operands[length - 1];
                replacement = PsiType.LONG.equals((Object)polyadicExpression.getType()) ? "0L" : "0";
                break;
            }
            previousOperand = operand;
        }
        return PointlessArithmeticExpressionInspection.getText(polyadicExpression, fromTarget, untilTarget, replacement).trim();
    }

    public static String getText(PsiPolyadicExpression expression, PsiElement fromTarget, PsiElement untilTarget, @NotNull @NonNls String replacement) {
        if (replacement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection", "getText"));
        }
        StringBuilder result = new StringBuilder();
        boolean stop2 = false;
        boolean longTypeSeen = false;
        for (PsiElement child : expression.getChildren()) {
            if (child == fromTarget) {
                stop2 = true;
                result.append(replacement);
                continue;
            }
            if (child == untilTarget) {
                stop2 = false;
                continue;
            }
            if (child instanceof PsiComment || !stop2) {
                if (child instanceof PsiExpression) {
                    PsiExpression childExpression = (PsiExpression)child;
                    longTypeSeen |= TypeConversionUtil.isLongType((PsiType)childExpression.getType());
                }
                result.append(child.getText());
                continue;
            }
            if (!(child instanceof PsiJavaToken) || untilTarget != null) continue;
            stop2 = false;
        }
        if (!longTypeSeen && TypeConversionUtil.isLongType((PsiType)expression.getType()) && replacement.isEmpty()) {
            result.insert(0, "(long)");
        }
        return result.toString();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new PointlessArithmeticFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessArithmeticVisitor();
    }

    boolean isZero(PsiExpression expression) {
        if (this.m_ignoreExpressionsContainingConstants && PsiUtil.deparenthesizeExpression((PsiExpression)expression) instanceof PsiReferenceExpression) {
            return false;
        }
        return ExpressionUtils.isZero(expression);
    }

    boolean isOne(PsiExpression expression) {
        if (this.m_ignoreExpressionsContainingConstants && PsiUtil.deparenthesizeExpression((PsiExpression)expression) instanceof PsiReferenceExpression) {
            return false;
        }
        return ExpressionUtils.isOne(expression);
    }

    static {
        arithmeticTokens.add(JavaTokenType.PLUS);
        arithmeticTokens.add(JavaTokenType.MINUS);
        arithmeticTokens.add(JavaTokenType.ASTERISK);
        arithmeticTokens.add(JavaTokenType.DIV);
        arithmeticTokens.add(JavaTokenType.PERC);
        arithmeticTokens.add(JavaTokenType.GT);
        arithmeticTokens.add(JavaTokenType.LT);
        arithmeticTokens.add(JavaTokenType.LE);
        arithmeticTokens.add(JavaTokenType.GE);
    }

    private class PointlessArithmeticVisitor
    extends BaseInspectionVisitor {
        private PointlessArithmeticVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection$PointlessArithmeticVisitor", "visitPolyadicExpression"));
            }
            super.visitPolyadicExpression(expression);
            PsiType expressionType = expression.getType();
            if (expressionType == null || PsiType.DOUBLE.equals((Object)expressionType) || PsiType.FLOAT.equals((Object)expressionType)) {
                return;
            }
            if (!arithmeticTokens.contains(expression.getOperationTokenType())) {
                return;
            }
            if (ExpressionUtils.hasStringType((PsiExpression)expression) || PsiUtilCore.hasErrorElementChild((PsiElement)expression)) {
                return;
            }
            PsiExpression[] operands = expression.getOperands();
            IElementType tokenType = expression.getOperationTokenType();
            boolean isPointless = tokenType.equals(JavaTokenType.PLUS) ? this.additionExpressionIsPointless(operands) : (tokenType.equals(JavaTokenType.MINUS) ? this.subtractionExpressionIsPointless(operands) : (tokenType.equals(JavaTokenType.ASTERISK) ? this.multiplyExpressionIsPointless(operands) : (tokenType.equals(JavaTokenType.DIV) || tokenType.equals(JavaTokenType.PERC) ? this.divideExpressionIsPointless(operands) : false)));
            if (!isPointless) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private boolean subtractionExpressionIsPointless(PsiExpression[] expressions) {
            PsiExpression previousExpression = null;
            for (int i = 0; i < expressions.length; ++i) {
                PsiExpression expression = expressions[i];
                if (previousExpression != null && (PointlessArithmeticExpressionInspection.this.isZero(expression) || this.areExpressionsIdenticalWithoutSideEffects(previousExpression, expression, i))) {
                    return true;
                }
                previousExpression = expression;
            }
            return false;
        }

        private boolean additionExpressionIsPointless(PsiExpression[] expressions) {
            for (PsiExpression expression : expressions) {
                if (!PointlessArithmeticExpressionInspection.this.isZero(expression)) continue;
                return true;
            }
            return false;
        }

        private boolean multiplyExpressionIsPointless(PsiExpression[] expressions) {
            for (PsiExpression expression : expressions) {
                if (!PointlessArithmeticExpressionInspection.this.isZero(expression) && !PointlessArithmeticExpressionInspection.this.isOne(expression)) continue;
                return true;
            }
            return false;
        }

        private boolean divideExpressionIsPointless(PsiExpression[] expressions) {
            PsiExpression previousExpression = null;
            for (int i = 0; i < expressions.length; ++i) {
                PsiExpression expression = expressions[i];
                if (previousExpression != null && (PointlessArithmeticExpressionInspection.this.isOne(expression) || this.areExpressionsIdenticalWithoutSideEffects(previousExpression, expression, i))) {
                    return true;
                }
                previousExpression = expression;
            }
            return false;
        }

        private boolean areExpressionsIdenticalWithoutSideEffects(PsiExpression expression1, PsiExpression expression2, int index) {
            return index == 1 && EquivalenceChecker.expressionsAreEquivalent(expression1, expression2) && !SideEffectChecker.mayHaveSideEffects(expression1);
        }
    }

    private class PointlessArithmeticFix
    extends InspectionGadgetsFix {
        private PointlessArithmeticFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection$PointlessArithmeticFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection$PointlessArithmeticFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiExpression expression = (PsiExpression)descriptor.getPsiElement();
            String newExpression = PointlessArithmeticExpressionInspection.this.calculateReplacementExpression(expression);
            PsiReplacementUtil.replaceExpression(expression, newExpression);
        }
    }
}

