/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.net.NetUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import kotlin.ArraysKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"O\u0004)i2m\\7qCJ,g*Y7f\u0003:$\u0007K]8kK\u000e$()Y:f!\u0006$\bNC\u0006qe>TWm\u0019;OC6,'BB*ue&twM\u0003\u0004l_Rd\u0017N\u001c\u0006\baJ|'.Z2u\u0015\u001d\u0001&o\u001c6fGRT1aY8n\u0015!Ig\u000e^3mY&T'bB8qK:\f\u0007/\u001b\u0006\b\u0005>|G.Z1o\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\u0013\u0005VLG\u000e^%o/\u0016\u00147+\u001a:wKJ\\EOC\u0007gS:$\u0017J\u001c3fq\u001aKG.\u001a\u0006\bE\u0006\u001cX\rZ5s\u0015-1\u0016N\u001d;vC24\u0015\u000e\\3\u000b\u0007Y47OC\u0007jg>;h\u000eS8ti:\u000bW.\u001a\u0006\u0005Q>\u001cH\u000f\u0018\u0006\u0003!\rQa\u0001\u0003\u0001\u0011\u0005a\u0001!B\u0001\t\u0007\u0015\u0011A!\u0001E\u0004\u000b\t!\u0019\u0001\u0003\u0003\u0006\u0005\u0011\u0011\u0001BA\u0003\u0004\t\u000bA)\u0001\u0004\u0001\u0006\u0007\u0011\u0001\u0001\u0012\u0002\u0007\u0001\u000b\u0005AQ!\u0002\u0002\u0005\t!-QA\u0001C\u0005\u0011\u0005)!\u0001\"\u0002\t\u0006\u0015\u0011AA\u0001\u0005\t\u000b\r!a\u0001c\u0004\r\u0001\u0015\u0011AA\u0002E\b\u000b\u0005\"1\u0001\u0007\u0001\u001e\u0010\u0011\u0001\u0001\u0012A\u0007\u0004\u000b\u0005A\t\u0001'\u0001Q\u0007\u0001iz\u0001\u0002\u0001\t\u00055\u0019Q!\u0001\u0005\u00041\r\u00016\u0011A\u0011\u0004\u000b\u0005A9\u0001g\u0002R\u0007\u001d!\u0001!C\u0001\u0005\u00025\t\u0001\"B\u0007\u0002\u0011\u0017A6ABC\u0018\t\rAj!h\u0004\u0005\u0001!9QbA\u0003\u0002\u0011\u001bAj\u0001U\u0002\u0001C\u0011)\u0011\u0001#\u0004\r\u0002a5\u0011kA\u0003\u0005\u000e%\t\u0001bB\u0007\u0002\u0011\u001dA6ABC\u0017\t\rA\n\"h\u0004\u0005\u0001!IQbA\u0003\u0002\u0011\u0003A\n\u0001U\u0002\u0001C\r)\u0011\u0001c\u0002\u0019\bE\u001bQ\u0001\"\u0005\n\u0003\u0011\u0005Q\"\u0001\u0005\u00061\u000e1\u0001"})
public final class BuiltInWebServerKt {
    public static final boolean compareNameAndProjectBasePath(@NotNull String projectName, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String basePath = project.getBasePath();
        return basePath != null && basePath.length() > projectName.length() && StringsKt.endsWith$default((String)basePath, (String)projectName, (boolean)false, (int)2) && basePath.charAt(basePath.length() - projectName.length() - 1) == '/';
    }

    @Nullable
    public static final VirtualFile findIndexFile(@NotNull VirtualFile basedir) {
        Intrinsics.checkParameterIsNotNull((Object)basedir, (String)"basedir");
        VirtualFile[] children = basedir.getChildren();
        if (children == null || ArraysKt.isEmpty((Object[])children)) {
            return null;
        }
        String[] stringArray = new String[]{"index.", "default."};
        for (int i = 0; i < stringArray.length; ++i) {
            String indexNamePrefix = stringArray[i];
            VirtualFile index = null;
            String preferredName = indexNamePrefix + "html";
            for (int j = 0; j < children.length; ++j) {
                VirtualFile child = children[j];
                if (child.isDirectory()) continue;
                String name = child.getName();
                if (Intrinsics.areEqual((Object)name, (Object)preferredName)) {
                    return child;
                }
                if (index != null || !StringsKt.startsWith$default((String)name, (String)indexNamePrefix, (boolean)false, (int)2)) continue;
                index = child;
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    public static final boolean isOwnHostName(@NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        try {
            block7: {
                block6: {
                    InetAddress address = InetAddress.getByName(host);
                    if (Intrinsics.areEqual((Object)host, (Object)address.getHostAddress())) break block6;
                    String string = address.getCanonicalHostName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"address.canonicalHostName");
                    if (!StringsKt.equals((String)host, (String)string, (boolean)true)) break block7;
                }
                return true;
            }
            String localHostName = InetAddress.getLocalHost().getHostName();
            return StringsKt.equals((String)localHostName, (String)host, (boolean)true) || StringsKt.endsWith$default((String)host, (String)".local", (boolean)false, (int)2) && StringsKt.regionMatches((String)localHostName, (int)0, (String)host, (int)0, (int)(host.length() - ".local".length()), (boolean)true);
        }
        catch (UnknownHostException ignored) {
            return false;
        }
    }
}

