/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServer;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.io.Responses;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"K\u0006)YB)\u001a4bk2$x+\u001a2TKJ4XM\u001d)bi\"D\u0015M\u001c3mKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\tck&dG/\u00138XK\n\u001cVM\u001d<fe*!r+\u001a2TKJ4XM\u001d)bi\"D\u0015M\u001c3mKJTa\u0001P5oSRt$b\u00029s_\u000e,7o\u001d\u0006\u0005a\u0006$\bN\u0003\u0004TiJLgn\u001a\u0006\u0007W>$H.\u001b8\u000b\u000fA\u0014xN[3di*9\u0001K]8kK\u000e$(bA2p[*A\u0011N\u001c;fY2L'NC\u0004pa\u0016t\u0017\r]5\u000b\u000fI,\u0017/^3ti*ya)\u001e7m\u0011R$\bOU3rk\u0016\u001cHO\u0003\u0002j_*)a.\u001a;us*9\u0001.\u00198eY\u0016\u0014(\"B2pI\u0016\u001c'\u0002\u00025uiBTqaY8oi\u0016DHOC\u000bDQ\u0006tg.\u001a7IC:$G.\u001a:D_:$X\r\u001f;\u000b\u000f\rD\u0017M\u001c8fY*Y\u0001O]8kK\u000e$h*Y7f\u00159!WmY8eK\u0012\u0014\u0016m\u001e)bi\"TA\"[:DkN$x.\u001c%pgRTqAQ8pY\u0016\fgN\u0003\u0003kCZ\f'\u0002\u00027b]\u001e4\u001bA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\r!\u0011\u0001\u0003\u0001\r\u0001\u0015\u0019A!\u0001\u0005\u0003\u0019\u0001)\u0011\u0001#\u0003\u0006\u0007\u0011\u0015\u0001\u0002\u0002\u0007\u0001\u000b\u0005Aa!\u0002\u0002\u0005\b!5QA\u0001\u0003\u0005\u0011\u001d)!\u0001\"\u0003\t\u000b\u0015\u0019A!\u0002E\u0006\u0019\u0001)\u0011\u0001#\u0005\u0006\u0005\u00111\u0001\"C\u0003\u0003\t\u001bA\u0019\"\u0002\u0002\u0005\u000f!QQA\u0001C\b\u0011+)1\u0001\u0002\u0005\t\u00111\u0001QA\u0001C\u0007\u00111)1\u0001B\u0005\t\u00181\u0001Qa\u0001C\u0003\u00119a\u0001!B\u0001\t\u001e\u0015\u0011AQ\u0003\u0005\u0010\u000b\t!1\u0002\u0003\u0003\u0006\u0005\u0011)\u00012B\u0003\u0003\t!A\u0001\"\u0002\u0002\u0005\u0013!]A!\u0001G\u00023\r)\u0011\u0001\u0003\u0002\u0019\u00055*\u000e\u0001B\u0006\u0019\u0007u=A\u0001\u0001E\u0004\u001b\r)\u0011\u0001C\u0002\u0019\u0007A\u001b\u0001!h\u0004\u0005\u0001!)QbA\u0003\u0002\u0011\u0017AZ\u0001UB\u0001;\u001f!\u0001\u0001c\u0004\u000e\u0007\u0015\t\u0001\u0012\u0003M\t!\u000e\tQt\u0002\u0003\u0001\u0011-i1!B\u0001\t\u0014aM\u0001ka\u0001\u001e\u0012\u0011\u0001\u0001\u0012D\u0007\u0005\u000b\u0005A1\u0001$\u0001\u0019\u0007A\u001b!!h\u0004\u0005\u0001!iQbA\u0003\u0002\u0011\rA2\u0001UB\u0003;\u001f!\u0001\u0001c\u0007\u000e\u0007\u0015\t\u0001B\u0003\r\u000b!\u000e\u0019\u0011eA\u0003\u0002\u0011)A\"\"U\u0002\u0012\t\rI\u0011\u0001\"\u0001\u000e\u0003!]Q\"\u0001\u0005\r\u001b\u0005AI\"D\u0001\t\u001b5\t\u0001rC\u0007\u0002\u0011/i\u0011\u0001\"\u00016\u0019\u0015YAa9\u0001\u0019\u0006\u0005\u001aQ!\u0001E\u00021\u0007\t6a\u0001C\u0003\u0013\u0005!\u0001\u0001"})
public final class DefaultWebServerPathHandler
extends WebServerPathHandler {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(DefaultWebServerPathHandler.class);
    }

    @Override
    public boolean process(@NotNull String path, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context, @Nullable String projectName, @NotNull String decodedRawPath, boolean isCustomHost) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)decodedRawPath, (String)"decodedRawPath");
        Channel channel = context.channel();
        WebServerPathToFileManager pathToFileManager = WebServerPathToFileManager.Companion.getInstance(project);
        PathInfo pathInfo = (PathInfo)pathToFileManager.getPathToInfoCache().getIfPresent((Object)path);
        boolean indexUsed = false;
        if (pathInfo == null || !pathInfo.getIsValid()) {
            boolean isDirectory;
            boolean bl;
            pathInfo = pathToFileManager.doFindByRelativePath(path);
            if (pathInfo == null) {
                if (StringsKt.isEmpty((String)path)) {
                    Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, "Index file doesn't exist.", (HttpRequest)request);
                    return true;
                }
                return false;
            }
            VirtualFile virtualFile = pathInfo.getFile();
            if (virtualFile == null) {
                File file = pathInfo.getIoFile();
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                bl = file.isDirectory();
            } else {
                bl = isDirectory = virtualFile.isDirectory();
            }
            if (isDirectory) {
                if (!WebServerPathHandler.endsWithSlash(decodedRawPath)) {
                    WebServerPathHandler.redirectToDirectory((HttpRequest)request, channel, isCustomHost ? path : projectName + '/' + path);
                    return true;
                }
                if (virtualFile == null) {
                    LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                    File file = pathInfo.getIoFile();
                    if (file == null) {
                        Intrinsics.throwNpe();
                    }
                    virtualFile = localFileSystem.refreshAndFindFileByIoFile(file);
                }
                VirtualFile virtualFile2 = virtualFile = virtualFile == null ? (VirtualFile)null : BuiltInWebServerKt.findIndexFile(virtualFile);
                if (virtualFile == null) {
                    Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, "Index file doesn't exist.", (HttpRequest)request);
                    return true;
                }
                indexUsed = true;
            }
            pathToFileManager.getPathToInfoCache().put((Object)path, (Object)pathInfo);
        } else if (!StringsKt.endsWith$default((String)path, (String)pathInfo.getName(), (boolean)false, (int)2)) {
            if (WebServerPathHandler.endsWithSlash(decodedRawPath)) {
                indexUsed = true;
            } else {
                String string = PathUtilRt.getFileName((String)PathUtilRt.getParentPath((String)pathInfo.getPath()));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtilRt.getFileName(P\u2026arentPath(pathInfo.path))");
                if (StringsKt.endsWith$default((String)path, (String)string, (boolean)false, (int)2)) {
                    WebServerPathHandler.redirectToDirectory((HttpRequest)request, channel, isCustomHost ? path : projectName + '/' + path);
                    return true;
                }
            }
        }
        StringBuilder canonicalRequestPath = new StringBuilder();
        canonicalRequestPath.append('/');
        if (!isCustomHost) {
            canonicalRequestPath.append(projectName).append('/');
        }
        canonicalRequestPath.append(path);
        if (indexUsed) {
            canonicalRequestPath.append('/').append(pathInfo.getName());
        }
        WebServerFileHandler[] webServerFileHandlerArray = (WebServerFileHandler[])WebServerFileHandler.EP_NAME.getExtensions();
        for (int i = 0; i < webServerFileHandlerArray.length; ++i) {
            WebServerFileHandler fileHandler = webServerFileHandlerArray[i];
            try {
                if (!fileHandler.process(pathInfo, canonicalRequestPath, project, request, channel, isCustomHost)) continue;
                return true;
            }
            catch (Throwable e) {
                BuiltInWebServer.Companion.getLOG().error(e);
            }
        }
        return false;
    }
}

