/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import java.io.File;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.DefaultWebServerRootsProvider;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.FileResolver$$TImpl;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u007f\u0004)iB)\u001a4bk2$x+\u001a2TKJ4XM\u001d*p_R\u001c\bK]8wS\u0012,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b!\t,\u0018\u000e\u001c;J]^+'mU3sm\u0016\u0014(BF,fEN+'O^3s%>|Go\u001d)s_ZLG-\u001a:\u000b\rqJg.\u001b;?\u0015-9W\r\u001e)bi\"LeNZ8\u000b\t\u0019LG.\u001a\u0006\f-&\u0014H/^1m\r&dWMC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\b_B,g.\u00199j\u0015\r1hm\u001d\u0006\baJ|'.Z2u\u0015\u001d\u0001&o\u001c6fGRT\u0001\u0002U1uQ&sgm\u001c\u0006\be\u0016\u001cx\u000e\u001c<f\u0015\u0011\u0001\u0018\r\u001e5\u000b\rM#(/\u001b8h\u0015\u0019Yw\u000e\u001e7j]*!!.\u0019<b\u0015\u0011a\u0017M\\4\u000b\u0013\r{W\u000e]1oS>t'\u0002\u0004*p_R\u0004&o\u001c<jI\u0016\u0014(1\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0019A!\u0001\u0005\u0001\u0019\u0001)1\u0001B\u0001\t\u00051\u0001Q!\u0001E\u0005\u000b\t!)\u0001C\u0003\u0006\u0005\u0011\u0019\u00012B\u0003\u0003\t\u000fAa!B\u0002\u0005\t!!A\u0002A\u0003\u0003\t\u000fAi!B\u0002\u0005\u000b!9A\u0002A\u0003\u0004\t\u0005Ay\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001rB\u0003\u0003\t\u0011AA!\u0002\u0002\u0005\u000b!9Q!\u0001E\n\u000b\r!\u0001\u0002C\u0005\r\u0001\u0015\t\u0001BC\u0003\u0003\t%A)\"\u0002\u0002\u0005\u0014!IAa\u0001G\u0002!-I2!B\u0001\t\u0005a\u0011Q$AF\f[\u0003\"1\u0002G\u0002\u001e\u0010\u0011\u0001\u0001rA\u0007\u0004\u000b\u0005AI\u0001'\u0003Q\u0007\u0001iz\u0001\u0002\u0001\t\u000e5\u0019Q!\u0001E\u00061\u0017\u00016\u0011A\u0011\u0005\u000b\u0005Aa\u0001$\u0001\u0019\rE\u001bq\u0001B\u0002\n\u0003!5Q\"\u0001\u0005\b\u001b\u0005Ay!,\u0011\u0005\u0017aAQt\u0002\u0003\u0001\u0011#i1!B\u0001\t\u0012aE\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001RB\u0007\u0004\u000b\u0005AY\u0001g\u0003Q\u0007\u0003\tC!B\u0001\t\r1\u0005\u0001DB)\u0004\u000f\u0011A\u0011\"\u0001E\u0007\u001b\u0005A!\"D\u0001\t\u0010UbQa\u0003\u0003d\u0002a\u0015\u0011eA\u0003\u0002\u0011\u0007A\u001a!U\u0002\u0004\t\u000bI\u0011\u0001\u0002\u0001"})
public final class DefaultWebServerRootsProvider
extends WebServerRootsProvider {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final Companion.ORDER_ROOT_TYPES.1 ORDER_ROOT_TYPES;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(DefaultWebServerRootsProvider.class);
        Companion companion = Companion = new Companion(null);
        ORDER_ROOT_TYPES = new NotNullLazyValue<OrderRootType[]>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(Companion.ORDER_ROOT_TYPES.1.class);
            }

            @NotNull
            protected OrderRootType[] compute() {
                OrderRootType javaDocRootType = org.jetbrains.builtInWebServer.DefaultWebServerRootsProvider$Companion.access$getJavadocOrderRootType$0(DefaultWebServerRootsProvider.Companion);
                return javaDocRootType == null ? new OrderRootType[]{OrderRootType.DOCUMENTATION, OrderRootType.SOURCES, OrderRootType.CLASSES} : new OrderRootType[]{javaDocRootType, OrderRootType.DOCUMENTATION, OrderRootType.SOURCES, OrderRootType.CLASSES};
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PathInfo resolve(@NotNull String path, @NotNull Project project) {
        PathInfo result;
        Module module;
        Module module2;
        int index;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String effectivePath = path;
        if (PlatformUtils.isIntelliJ() && (index = StringsKt.indexOf$default((String)effectivePath, (char)'/', (int)0, (boolean)false, (int)6)) > 0) {
            String string = project.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
            if (!StringsKt.regionMatches((String)effectivePath, (int)0, (String)string, (int)0, (int)index, (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0)) {
                String moduleName = StringsKt.substring((String)effectivePath, (int)0, (int)index);
                AccessToken token = ReadAction.start();
                try {
                    module2 = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
                }
                finally {
                    token.finish();
                }
                module = module2;
                if (module != null && !module.isDisposed()) {
                    effectivePath = StringsKt.substring((String)effectivePath, (int)(index + 1));
                    FileResolver resolver = WebServerPathToFileManager.Companion.getInstance(project).getResolver(effectivePath);
                    ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                    RootProvider[] rootProviderArray = RootProvider.values();
                    for (int i = 0; i < rootProviderArray.length; ++i) {
                        RootProvider rootProvider = rootProviderArray[i];
                        ModuleRootManager moduleRootManager2 = moduleRootManager;
                        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager2, (String)"moduleRootManager");
                        PathInfo result2 = DefaultWebServerRootsProvider.Companion.findByRelativePath(effectivePath, rootProvider.getRoots(moduleRootManager2), resolver, moduleName);
                        if (result2 == null) continue;
                        return result2;
                    }
                    result = DefaultWebServerRootsProvider.Companion.findInModuleLibraries(effectivePath, module, resolver);
                    if (result != null) {
                        return result;
                    }
                }
            }
        }
        AccessToken token = ReadAction.start();
        try {
            module = ModuleManager.getInstance((Project)project).getModules();
        }
        finally {
            token.finish();
        }
        Module modules = module;
        FileResolver resolver = WebServerPathToFileManager.Companion.getInstance(project).getResolver(effectivePath);
        module2 = RootProvider.values();
        for (int i = 0; i < ((RootProvider[])module2).length; ++i) {
            RootProvider rootProvider = module2[i];
            Module module3 = modules;
            Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"modules");
            result = DefaultWebServerRootsProvider.Companion.findByRelativePath(project, effectivePath, (Module[])module3, rootProvider, resolver);
            if (result == null) continue;
            return result;
        }
        Module module4 = modules;
        Intrinsics.checkExpressionValueIsNotNull((Object)module4, (String)"modules");
        return DefaultWebServerRootsProvider.Companion.findInLibraries(project, (Module[])module4, effectivePath, resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public PathInfo getPathInfo(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        AccessToken token = ReadAction.start();
        try {
            boolean isLibrary;
            DirectoryIndex directoryIndex = DirectoryIndex.getInstance(project);
            DirectoryInfo info = directoryIndex.getInfoForFile(file);
            if (!info.isExcluded() && !info.isInProject()) {
                PathInfo pathInfo = Intrinsics.areEqual((Object)file.getFileSystem(), (Object)JarFileSystem.getInstance()) ? DefaultWebServerRootsProvider.Companion.getInfoForDocJar(file, project) : (PathInfo)null;
                return pathInfo;
            }
            VirtualFile root = info.getSourceRoot();
            if (root == null) {
                root = info.getContentRoot();
                if (root == null) {
                    void value;
                    root = info.getLibraryClassRoot();
                    isLibrary = true;
                    boolean bl = root != null;
                    if (PreconditionsKt.getASSERTIONS_ENABLED() && value == false) {
                        String string = file.getPresentableUrl();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.presentableUrl");
                        String message = string;
                        throw (Throwable)((Object)new AssertionError((Object)message));
                    }
                } else {
                    isLibrary = false;
                }
            } else {
                isLibrary = info.isInLibrarySource();
            }
            Module module = info.getModule();
            if (isLibrary && module == null) {
                OrderEntry[] orderEntryArray = directoryIndex.getOrderEntries(info);
                for (int i = 0; i < orderEntryArray.length; ++i) {
                    OrderEntry entry = orderEntryArray[i];
                    if (!(entry instanceof ModuleLibraryOrderEntryImpl)) continue;
                    module = ((ModuleLibraryOrderEntryImpl)entry).getOwnerModule();
                    break;
                }
            }
            File file2 = null;
            VirtualFile virtualFile = root;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root!!");
            PathInfo pathInfo = new PathInfo(file2, file, virtualFile, DefaultWebServerRootsProvider.Companion.getModuleNameQualifier(project, module), isLibrary);
            return pathInfo;
        }
        finally {
            token.finish();
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"w\u0004)a!k\\8u!J|g/\u001b3fe*iB)\u001a4bk2$x+\u001a2TKJ4XM\u001d*p_R\u001c\bK]8wS\u0012,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b!\t,\u0018\u000e\u001c;J]^+'mU3sm\u0016\u0014(\u0002B#ok6Taa[8uY&t'B\u0002\u001fj]&$hH\u0003\u0003kCZ\f'\u0002\u00027b]\u001eTaa\u0015;sS:<'\u0002C4fiJ{w\u000e^:\u000b\u0017I|w\u000e^'b]\u0006<WM\u001d\u0006\u0012\u001b>$W\u000f\\3S_>$X*\u00198bO\u0016\u0014(bA2p[*A\u0011N\u001c;fY2L'NC\u0004pa\u0016t\u0017\r]5\u000b\u000bI|w\u000e^:\u000b\u000b\u0005\u0013(/Y=\u000b\u0017YK'\u000f^;bY\u001aKG.\u001a\u0006\u0004m\u001a\u001c(BB*P+J\u001bUIC\u0004D\u001f:#VI\u0014+\u000b\u0011\u0015C6\tT+E\u000b\u0012c(B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0007\u0011\t\u0001\u0012\u0001\u0007\u0001\u000b\r!\u0019\u0001\u0003\u0001\r\u0001\u0015\t\u0001bA\u0003\u0004\t\u000bA)\u0001\u0004\u0001\u0006\u0003!!QA\u0001C\u0004\u0011\u0013)!\u0001\u0002\u0003\t\u000b\u0015\t\u0001bB\u0003\u0003\t\u0015Ay!\u0002\u0002\u0005\f!AQA\u0001\u0003\u0007\u0011#)1\u0001\"\u0004\t\u000e1\u0001Qa\u0001C\u0003\u0011%a\u0001!\u0002\u0002\u0005\r!QQa\u0001\u0003\t\u0011'a\u0001!\u0002\u0002\u0005\u0011!MQA\u0001C\u0007\u0011\u001b!\u0011\u0019\u0001\u0007\u00033!)\u0011\u0001C\u0002\n\t%\u0019Q!\u0001\u0005\u00031\tA2!L\u000e\u0005'a-Qt\u0002\u0003\u0001\u0011\u0019i1!B\u0001\t\u000fa9\u0001k\u0001\u0001\"\u0011\u0015\t\u0001rB\u0005\u0005\u0013\r)\u0011\u0001#\u0005\u0019\u0012a=\u0011k\u0001\u0004\u0005\f%\u0011\u0001\"\u0003G\u0001\u001b\u0005A\u0019\"mA\u000b\u0017/)\u0004#B\b\u0005C\u0004A:!I\u0002\u0006\u0003!\u0011\u0001DA)\u0004\u000f\u0011\u001d\u0011\"\u0001\u0003\u0001\u001b\u0005AI!D\u0001\u0005\u0006\u0001"})
    private static final abstract class RootProvider
    extends Enum<RootProvider> {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final /* enum */ RootProvider SOURCE;
        public static final /* enum */ RootProvider CONTENT;
        public static final /* enum */ RootProvider EXCLUDED;
        private static final /* synthetic */ RootProvider[] $VALUES;

        static {
            $kotlinClass = Reflection.createKotlinClass(RootProvider.class);
            RootProvider[] rootProviderArray = new RootProvider[3];
            RootProvider[] rootProviderArray2 = rootProviderArray;
            rootProviderArray[0] = SOURCE = new SOURCE("SOURCE", 0);
            rootProviderArray[1] = CONTENT = new CONTENT("CONTENT", 1);
            rootProviderArray[2] = EXCLUDED = new EXCLUDED("EXCLUDED", 2);
            $VALUES = rootProviderArray;
        }

        @NotNull
        public abstract VirtualFile[] getRoots(@NotNull ModuleRootManager var1);

        public static RootProvider[] values() {
            return (RootProvider[])$VALUES.clone();
        }

        public static RootProvider valueOf(String string) {
            return Enum.valueOf(RootProvider.class, string);
        }

        @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"[\u0004)11kT+S\u0007\u0016SABU8piB\u0013xN^5eKJTQ\u0004R3gCVdGoV3c'\u0016\u0014h/\u001a:S_>$8\u000f\u0015:pm&$WM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015A\u0011W/\u001b7u\u0013:<VMY*feZ,'O\u0003\u0005hKR\u0014vn\u001c;t\u0015-\u0011xn\u001c;NC:\fw-\u001a:\u000b#5{G-\u001e7f%>|G/T1oC\u001e,'OC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\b_B,g.\u00199j\u0015\u0015\u0011xn\u001c;t\u0015\u0015\t%O]1z\u0015\u0019Yw\u000e\u001e7j]*Ya+\u001b:uk\u0006dg)\u001b7f\u0015\r1hm\u001d\u0006\u0018W>$H.\u001b8/UZlg\u0006\u00157bi\u001a|'/\u001c+za\u0016d'B\u0001\t\u0004\u0015\u0011A\u0001\u0001\u0005\u0003\u000b\t!\t\u0001#\u0002\u0006\u0007\u0011\t\u0001\"\u0001\u0007\u0001\u000b\r!\u0019\u0001#\u0001\r\u0001\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)\u0011\u0001#\u0003\u0006\u0005\u0011\u0019\u0001\"B\u0003\u0003\t\u000fAY!\u0002\u0002\u0005\t!1Qa\u0001C\u0005\u0011\u0011a\u0001!B\u0001\t\u000f\u0015\u0019A1\u0002E\u0007\u0019\u0001)!\u0001\u0002\u0003\t\u0011\u0015\u0019AQ\u0002E\b\u0019\u0001)!\u0001\"\u0004\t\u0010\u0015\u0011A\u0011\u0002\u0005\u0005\t\r\bARA\r\u0004\u000b\u0005A!\u0001\u0007\u0002.e\u0011Y\u0001dAO\b\t\u0001A9!D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0001\u0005zR!\u0001\u0005\u0007\u0013)I\u0011\"B\u0001\t\u000fAEQ\u0003B\u0003\u0002\u0011\u001da\t\u0001G\u0004\u0019\u000fAEQcD\u0003\u0002\u0011\u0019I1\u0002\"\u0001\n\u0013\u0015\t\u0001b\u0002I\t+\u0011)\u0011\u0001C\u0004\r\u0002a9\u0001d\u0002\r\u00071\u0019\t6A\u0002\u0003\u0004\u0013\tAy\u0001$\u0001\u000e\u0003!AQ\u0007\u0001"})
        public static final class SOURCE
        extends RootProvider {
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(SOURCE.class);
            }

            @Override
            @NotNull
            public VirtualFile[] getRoots(@NotNull ModuleRootManager rootManager) {
                Intrinsics.checkParameterIsNotNull((Object)rootManager, (String)"rootManager");
                return rootManager.getSourceRoots();
            }

            SOURCE() {
            }
        }

        @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\\\u0004)91i\u0014(U\u000b:#&\u0002\u0004*p_R\u0004&o\u001c<jI\u0016\u0014(\"\b#fM\u0006,H\u000e^,fEN+'O^3s%>|Go\u001d)s_ZLG-\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*\u0001\"-^5mi&sw+\u001a2TKJ4XM\u001d\u0006\tO\u0016$(k\\8ug*Y!o\\8u\u001b\u0006t\u0017mZ3s\u0015Eiu\u000eZ;mKJ{w\u000e^'b]\u0006<WM\u001d\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u000f=\u0004XM\\1qS*)!o\\8ug*)\u0011I\u001d:bs*11n\u001c;mS:T1BV5siV\fGNR5mK*\u0019aOZ:\u000b/-|G\u000f\\5o])4XN\f)mCR4wN]7UsB,GN\u0003\u0002\u0011\u0007)!\u0001\u0002\u0001\t\u0005\u0015\u0011A\u0011\u0001E\u0003\u000b\r!\u0011\u0001C\u0001\r\u0001\u0015\u0019A1\u0001E\u0001\u0019\u0001)1\u0001\u0002\u0002\t\u00011\u0001Q!\u0001E\u0005\u000b\t!1\u0001C\u0003\u0006\u0005\u0011\u001d\u00012B\u0003\u0003\t\u0011Aa!B\u0002\u0005\n!!A\u0002A\u0003\u0002\u0011\u001d)1\u0001b\u0003\t\u000e1\u0001QA\u0001\u0003\u0005\u0011!)1\u0001\"\u0004\t\u00101\u0001QA\u0001C\u0007\u0011\u001f)!\u0001\"\u0003\t\t\u0011\u0019\u000f\u0001$\u0002\u001a\u0007\u0015\t\u0001B\u0001\r\u0003[I\"1\u0002G\u0002\u001e\u0010\u0011\u0001\u0001rA\u0007\u0004\u000b\u0005AQ\u0001G\u0003Q\u0007\u0001\ts$B\u0001\t\r%Q\u0011\"C\u0003\u0002\u0011\u001d\u0001\n\"\u0006\u0003\u0006\u0003!9A\u0012\u0001\r\b1\u001d\u0001\n\"F\b\u0006\u0003!1\u0011b\u0003C\u0001\u0013%)\u0011\u0001C\u0004\u0011\u0012U!Q!\u0001\u0005\b\u0019\u0003Ar\u0001G\u0004\u0019\ra1\u0011k\u0001\u0004\u0005\u0007%\u0011\u0001r\u0002G\u0001\u001b\u0005A\u0001\"\u000e\u0001"})
        public static final class CONTENT
        extends RootProvider {
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(CONTENT.class);
            }

            @Override
            @NotNull
            public VirtualFile[] getRoots(@NotNull ModuleRootManager rootManager) {
                Intrinsics.checkParameterIsNotNull((Object)rootManager, (String)"rootManager");
                return rootManager.getContentRoots();
            }

            CONTENT() {
            }
        }

        @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"]\u0004)AQ\tW\"M+\u0012+EI\u0003\u0007S_>$\bK]8wS\u0012,'OC\u000fEK\u001a\fW\u000f\u001c;XK\n\u001cVM\u001d<feJ{w\u000e^:Qe>4\u0018\u000eZ3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NT\u0001CY;jYRLenV3c'\u0016\u0014h/\u001a:\u000b\u0011\u001d,GOU8piNT1B]8pi6\u000bg.Y4fe*\tRj\u001c3vY\u0016\u0014vn\u001c;NC:\fw-\u001a:\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\u001dy\u0007/\u001a8ba&TQA]8piNTQ!\u0011:sCfTaa[8uY&t'b\u0003,jeR,\u0018\r\u001c$jY\u0016T1A\u001e4t\u0015]Yw\u000e\u001e7j]:Rg/\u001c\u0018QY\u0006$hm\u001c:n)f\u0004X\r\u001c\u0006\u0003!\rQA\u0001\u0003\u0001\u0011\t)!\u0001\"\u0001\t\u0006\u0015\u0019A!\u0001\u0005\u0002\u0019\u0001)1\u0001b\u0001\t\u00021\u0001Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0001\t\n\u0015\u0011Aa\u0001\u0005\u0006\u000b\t!9\u0001c\u0003\u0006\u0005\u0011!\u0001BB\u0003\u0004\t\u0013AA\u0001\u0004\u0001\u0006\u0003!9Qa\u0001C\u0006\u0011\u001ba\u0001!\u0002\u0002\u0005\t!AQa\u0001C\u0007\u0011\u001fa\u0001!\u0002\u0002\u0005\u000e!=QA\u0001C\u0005\u0011\u0011!1\u001d\u0001G\u00033\r)\u0011\u0001\u0003\u0002\u0019\u00055\u0012Da\u0003\r\u0004;\u001f!\u0001\u0001c\u0002\u000e\u0007\u0015\t\u0001\"\u0002\r\u0006!\u000e\u0001\u0011eH\u0003\u0002\u0011\u0019I!\"C\u0005\u0006\u0003!9\u0001\u0013C\u000b\u0005\u000b\u0005Aq\u0001$\u0001\u0019\u000fa9\u0001\u0013C\u000b\u0010\u000b\u0005Aa!C\u0006\u0005\u0002%IQ!\u0001\u0005\b!#)B!B\u0001\t\u000f1\u0005\u0001d\u0002\r\b1\u0019Ab!U\u0002\u0007\t\rI!\u0001c\u0004\r\u00025\t\u0001\u0002C\u001b\u0001"})
        public static final class EXCLUDED
        extends RootProvider {
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(EXCLUDED.class);
            }

            @Override
            @NotNull
            public VirtualFile[] getRoots(@NotNull ModuleRootManager rootManager) {
                Intrinsics.checkParameterIsNotNull((Object)rootManager, (String)"rootManager");
                return rootManager.getExcludeRoots();
            }

            EXCLUDED() {
            }
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"+\f)I1i\\7qC:LwN\u001c\u0006\u001e\t\u00164\u0017-\u001e7u/\u0016\u00147+\u001a:wKJ\u0014vn\u001c;t!J|g/\u001b3fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(\u0002\u00052vS2$\u0018J\\,fEN+'O^3s\u0015\r\te.\u001f\u0006\u0007W>$H.\u001b8\u000b!=\u0013F)\u0012*`%>{Ek\u0018+Z!\u0016\u001b&B\u000f#fM\u0006,H\u000e^,fEN+'O^3s%>|Go\u001d)s_ZLG-\u001a:%\u0007>l\u0007/\u00198j_:$sJ\u0015#F%~\u0013vj\u0014+`)f\u0003Vi\u0015\u00132\u0015M9W\r^(S\t\u0016\u0013vLU(P)~#\u0016\fU#T\u0015I1\u0017N\u001c3CsJ+G.\u0019;jm\u0016\u0004\u0016\r\u001e5\u000b\u000fA\u0014xN[3di*9\u0001K]8kK\u000e$(bA2p[*A\u0011N\u001c;fY2L'NC\u0004pa\u0016t\u0017\r]5\u000b\tA\fG\u000f\u001b\u0006\u0007'R\u0014\u0018N\\4\u000b\u000f5|G-\u001e7fg*)\u0011I\u001d:bs*1Qj\u001c3vY\u0016Ta!\\8ek2,'\u0002\u0004:p_R\u0004&o\u001c<jI\u0016\u0014(\u0002\u0004*p_R\u0004&o\u001c<jI\u0016\u0014(\u0002\u0003:fg>dg/\u001a:\u000b\u0019\u0019KG.\u001a*fg>dg/\u001a:\u000b\u0011A\u000bG\u000f[%oM>TAA[1wC*!A.\u00198h\u0015)\"UMZ1vYR<VMY*feZ,'OU8piN\u0004&o\u001c<jI\u0016\u0014HEU8piB\u0013xN^5eKJTQA]8piNT1BV5siV\fGNR5mK*\u0019aOZ:\u000b\u00155|G-\u001e7f\u001d\u0006lWMC\bgS:$\u0017J\u001c'jEJ\f'/[3t\u001551\u0017N\u001c3J]2K'M]1ss*yA.\u001b2sCJLh)\u001b7f\u001d\u0006lWM\u0003\u0007sK2\fG/\u001b<f!\u0006$\bNC\u0004mS\n\u0014\u0018M]=\u000b\u000f1K'M]1ss*IA.\u001b2sCJLWm\u001d\u0006\u0016M&tG-\u00138N_\u0012,H.\u001a'jEJ\f'/[3t\u0015\u0019\u0011Xm];mi*\u0019!+\u001a4\u000b\tU$\u0018\u000e\u001c\u0006\b\u0005>|G.Z1o\u0015A9W\r^%oM>4uN\u001d#pG*\u000b'O\u0003\u0003gS2,'bF4fi*\u000bg/\u00193pG>\u0013H-\u001a:S_>$H+\u001f9f\u00155y%\u000fZ3s%>|G\u000fV=qK*1r-\u001a;N_\u0012,H.\u001a(b[\u0016\fV/\u00197jM&,'O%\u0002\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)1\u0001B\u0001\t\u00021\u0001Qa\u0001C\u0002\u0011\u0001a\u0001!B\u0001\t\u0007\u0015\u0019AQ\u0001E\u0003\u0019\u0001)!\u0001\u0003\u0003\r\u0003\u0015\u0011A!\u0001\u0005\u0005\u000b\u0005Ai!\u0002\u0002\u0005\n!9QA\u0001\u0003\u0006\u0011\u001f)!\u0001b\u0003\t\f\u0015\u0019AA\u0002\u0005\u0007\u0019\u0001)1\u0001\"\u0002\t\u00121\u0001Qa\u0001C\u0003\u0011'a\u0001!\u0002\u0002\u0005\f!UQa\u0001\u0003\t\u0011)a\u0001!B\u0002\u0005\u0004!]A\u0002A\u0003\u0004\t\u0005AI\u0002\u0004\u0001\u0006\u0007\u0011\t\u0001\"\u0004\u0007\u0001\u000b\t!\u0011\u0001C\u0007\u0006\u0005\u00111\u0001BB\u0003\u0002\u00117)!\u0001b\u0006\t\u001d\u0015\u0011A\u0001\u0004E\t\u000b\t!\u0001\u0002\u0003\u0006\u0006\u0005\u0011\t\u0001RD\u0003\u0003\t\u0005AI\"\u0002\u0002\u0005\f!\u0001Ra\u0001C\u000f\u0011?a\u0001!\u0002\u0002\u0005\u001e!}QA\u0001C\u0006\u0011=)!\u0001\u0002\t\t)\u0015\u0019A\u0011\u0005E\u0014\u0019\u0001)!\u0001\"\t\t(\u0015\u0011A1\u0002\u0005\u0017\u000b\r!!\u0003c\u000b\r\u0001\u0015\u0019AQ\u0001E\u0017\u0019\u0001)!\u0001\u0002\n\t,\u0015\u0019A\u0001\u0005E\u0019\u0019\u0001)!\u0001\u0002\t\t2\u0011\u0019\u001d\u0001\u0004\u0002\u001a\u0007\u0015\t\u0001b\u0001\r\u0004[E!\u0011\r\u0002M\u0004C\r)\u0011\u0001c\u0002\u0019\bU\u001b\u0011\"\u0002\u0003\u0005\b%\t\u0001\u0002\u0002G\u0001\u001b\r!I!C\u0001\t\t52\r\u0001B\u0001\u0019\u000bu=A\u0001\u0001E\u0006\u001b\r)\u0011\u0001#\u0004\u0019\u000eA\u001b\u0001!h\u0004\u0005\u0001!AQbA\u0003\u0002\u0011\u001dAr\u0001UB\u0001;3!\u0001\u0001C\u0005\u000e\u0011\u0015\t\u0001rB\u0005\u0005\u0013\r)\u0011\u0001#\u0005\u0019\u0012a=\u0001kA\u0001\u001e\u0010\u0011\u0001\u0001bC\u0007\u0004\u000b\u0005A\u0011\u0002G\u0005Q\u0007\u0007iz\u0001\u0002\u0001\t\u00195\u0019Q!\u0001E\n1'\u00016AA\u0011\u0005\u000b\u0005A!\u0002$\u0001\u0019\u0015E\u001ba\u0002B\u0003\n\u0003!UQ\"\u0001\u0005\f\u001b\u0005AI\"\u0004\u0002\t\u001b1\u0005Q\"\u0001E\u000e\u001b\u0005Aa\",\u001f\u0005\u0003a)Qt\u0002\u0003\u0001\u0011!i1!B\u0001\t\u000fa9\u0001k\u0001\u0001\u001e\u001a\u0011\u0001\u0001bD\u0007\t\u000b\u0005Ay!\u0003\u0003\n\u0007\u0015\t\u0001b\u0004\r\u00101\u001f\u00016\u0011AO\b\t\u0001AA\"D\u0002\u0006\u0003!M\u00014\u0003)\u0004\u0003uEA\u0001\u0001E\u0011\u001b\u0011)\u0011\u0001C\u0004\r\u0002a9\u0001ka\u0001\"\t\u0015\t\u0001B\u0003G\u00011)\t6\u0001\u0004\u0003\u0006\u0013\u0005A)\"D\u0001\t\u001a5\u0011\u0001r\u0004G\u0001\u001b\u0005Aa\"D\u0001\t\u001a5^D!\u0001\r\u0012;\u001f!\u0001\u0001c\u0003\u000e\u0007\u0015\t\u0001R\u0002M\u0007!\u000e\u0001Q\u0014\u0004\u0003\u0001\u0011%i\u0001\"B\u0001\t\u0010%!\u0011bA\u0003\u0002\u0011#A\n\u0002g\u0004Q\u0007\u0003iz\u0001\u0002\u0001\t\u00115\u0019Q!\u0001\u0005\b1\u001d\u00016!AO\b\t\u0001AA\"D\u0002\u0006\u0003!M\u00014\u0003)\u0004\u0004\u0005\"Q!\u0001\u0005\u000b\u0019\u0003A\"\"U\u0002\r\tEI\u0011\u0001#\u0006\u000e\u0003!YQB\u0001\u0005\u000e\u0019\u0003i\u0011\u0001#\u0007\u000e\u0003!qQ6\u000e\u0003\u00021Giz\u0001\u0002\u0001\t%5\u0019Q!\u0001\u0005\b1\u001d\u00016\u0001AO\b\t\u0001A)#D\u0002\u0006\u0003!9\u0001d\u0002)\u0004\u0002u=A\u0001\u0001\u0005\u0014\u001b\r)\u0011\u0001C\t\u0019#A\u001b\u0011!h\u0004\u0005\u0001!aQbA\u0003\u0002\u0011'A\u001a\u0002UB\u0002C\u0011)\u0011\u0001\u0003\u0006\r\u0002aQ\u0011kA\u0006\u0005$%\t\u0001RC\u0007\u0002\u00113i\u0011\u0001#\u0007\u000e\u0003!\rR\"\u0001\u0005\u000f[-\"\u0011\u0001'\u000b\u001e\u0010\u0011\u0001\u0001\u0002C\u0007\u0004\u000b\u0005Aq\u0001G\u0004Q\u0007\u0001iz\u0001\u0002\u0001\t\u00165\u0019Q!\u0001E\t1#\u00016\u0011AO\b\t\u0001AA\"D\u0002\u0006\u0003!M\u00014\u0003)\u0004\u0003\u0005\"Q!\u0001\u0005\u000b\u0019\u0003A\"\"U\u0002\n\tSI\u0011\u0001#\u0006\u000e\u0003!eQ\"\u0001\u0005\u000e\u001b\u0005Aa\"\fc\u0001\t\u0005AJ#h\u0004\u0005\u0001!aQbA\u0003\u0002\u0011'A\u001a\u0002U\u0002\u0001;\u001f!\u0001\u0001\u0003\n\u000e\u0007\u0015\t\u0001b\u0002\r\b!\u000e\u0005Qt\u0002\u0003\u0001\u0011Ki1!B\u0001\t\u000fa9\u0001kA\u0001\u001e\u001a\u0011\u0001\u0001\"F\u0007\t\u000b\u0005A)#\u0003\u0003\n\u0007\u0015\t\u0001B\u0003\r\u000b1K\u000161AO\b\t\u0001A)\"D\u0002\u0006\u0003!E\u0001\u0014\u0003)\u0004\u0005\u0005\u001aQ!\u0001\u0005\u00141M\t6!\u0004C\u0015\u0013\u0005!\t!D\u0001\t\u001d5\t\u0001\u0012D\u0007\u0002\u00113i\u0011\u0001c\n\u000e\u0003!iQ\u0016\t\u0003\u00021]iz\u0001\u0002\u0001\t05\u0019Q!\u0001\u0005\u00101=\u00016\u0001AO\b\t\u0001AY!D\u0002\u0006\u0003!5\u0001T\u0002)\u0004\u0002\u0005\"Q!\u0001\u0005\u000b\u0019\u0003A\"\"U\u0002\b\t]I\u0011\u0001#\u0006\u000e\u0003!}Q\"\u0001\u0005\f[/!\u0011\u0001\u0007\r\"\t\u0015\t\u0001\u0002\u0006G\u00011Q\t6a\u0001\u0003\u0019\u0013\u0005AI#l\u0011\u0005\u0003aIRt\u0002\u0003\u0001\u0011\u0017i1!B\u0001\t\u000ea5\u0001k\u0001\u0001\u001e\u0012\u0011\u0001\u0001RC\u0007\u0005\u000b\u0005A\t\u0002$\u0001\u0019\u0012A\u001b\t!\t\u0003\u0006\u0003!9A\u0012\u0001\r\b#\u000e9A!G\u0005\u0002\u00113i\u0011\u0001C\u0006\u000e\u0003!iQ\u0007\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        private final ORDER_ROOT_TYPES.1 getORDER_ROOT_TYPES() {
            return ORDER_ROOT_TYPES;
        }

        private final OrderRootType getJavadocOrderRootType() {
            try {
                return JavadocOrderRootType.getInstance();
            }
            catch (Throwable e) {
                return null;
            }
        }

        private final PathInfo findInModuleLibraries(String path, Module module, FileResolver resolver) {
            int index = StringsKt.indexOf$default((String)path, (char)'/', (int)0, (boolean)false, (int)6);
            if (index <= 0) {
                return null;
            }
            Ref result = Ref.create();
            String string = StringsKt.substring((String)path, (int)0, (int)index);
            String string2 = StringsKt.substring((String)path, (int)(index + 1));
            Ref ref = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)ref, (String)"result");
            this.findInModuleLibraries(resolver, string, string2, (Ref<PathInfo>)ref, module);
            return (PathInfo)result.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final PathInfo findInLibraries(Project project, Module[] modules, String path, FileResolver resolver) {
            int index = StringsKt.indexOf$default((String)path, (char)'/', (int)0, (boolean)false, (int)6);
            if (index < 0) {
                return null;
            }
            String libraryFileName = StringsKt.substring((String)path, (int)0, (int)index);
            String relativePath = StringsKt.substring((String)path, (int)(index + 1));
            AccessToken token = ReadAction.start();
            try {
                int n;
                Ref result = Ref.create();
                Module[] moduleArray = modules;
                for (n = 0; n < moduleArray.length; ++n) {
                    Module module = moduleArray[n];
                    if (module.isDisposed()) continue;
                    Ref ref = result;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ref, (String)"result");
                    if (!Companion.findInModuleLibraries(resolver, libraryFileName, relativePath, (Ref<PathInfo>)ref, module)) continue;
                    PathInfo pathInfo = (PathInfo)result.get();
                    return pathInfo;
                }
                moduleArray = LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries();
                for (n = 0; n < moduleArray.length; ++n) {
                    Module library;
                    Module module = library = moduleArray[n];
                    Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"library");
                    PathInfo pathInfo = Companion.findInLibrary(libraryFileName, relativePath, (Library)module, resolver);
                    if (pathInfo == null) continue;
                    PathInfo pathInfo2 = pathInfo;
                    return pathInfo2;
                }
                Unit unit = Unit.INSTANCE$;
            }
            finally {
                token.finish();
            }
            return null;
        }

        private final boolean findInModuleLibraries(FileResolver resolver, String libraryFileName, String relativePath, Ref<PathInfo> result, Module module) {
            ModuleRootManager.getInstance((Module)module).orderEntries().forEachLibrary((Processor)new Processor<Library>(result, libraryFileName, relativePath, resolver){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ Ref $result;
                final /* synthetic */ String $libraryFileName;
                final /* synthetic */ String $relativePath;
                final /* synthetic */ FileResolver $resolver;

                static {
                    $kotlinClass = Reflection.createKotlinClass(findInModuleLibraries.1.class);
                }

                public boolean process(@NotNull Library library) {
                    Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
                    this.$result.set((Object)org.jetbrains.builtInWebServer.DefaultWebServerRootsProvider$Companion.access$findInLibrary$3(DefaultWebServerRootsProvider.Companion, this.$libraryFileName, this.$relativePath, library, this.$resolver));
                    return this.$result.isNull();
                }
                {
                    this.$result = $captured_local_variable$0;
                    this.$libraryFileName = $captured_local_variable$1;
                    this.$relativePath = $captured_local_variable$2;
                    this.$resolver = $captured_local_variable$3;
                }
            });
            return !result.isNull();
        }

        private final PathInfo findInLibrary(String libraryFileName, String relativePath, Library library, FileResolver resolver) {
            OrderRootType[] orderRootTypeArray = (OrderRootType[])this.getORDER_ROOT_TYPES().getValue();
            for (int i = 0; i < orderRootTypeArray.length; ++i) {
                OrderRootType rootType = orderRootTypeArray[i];
                VirtualFile[] virtualFileArray = library.getFiles(rootType);
                for (int j = 0; j < virtualFileArray.length; ++j) {
                    VirtualFile root = virtualFileArray[j];
                    if (!StringUtil.equalsIgnoreCase((CharSequence)root.getNameSequence(), (CharSequence)libraryFileName)) continue;
                    VirtualFile virtualFile = root;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root");
                    PathInfo pathInfo = FileResolver$$TImpl.resolve$default(resolver, relativePath, virtualFile, null, true, 4);
                    if (pathInfo == null) {
                        continue;
                    }
                    PathInfo result = pathInfo;
                    return result;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final PathInfo getInfoForDocJar(VirtualFile file, Project project) {
            OrderRootType orderRootType = this.getJavadocOrderRootType();
            if (orderRootType == null) {
                return null;
            }
            OrderRootType javaDocRootType = orderRootType;
            @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.LOCAL_CLASS, data={"^\u0006)IE)\u001a4bk2$x+\u001a2TKJ4XM\u001d*p_R\u001c\bK]8wS\u0012,'\u000fJ\"p[B\fg.[8oI\u001d,G/\u00138g_\u001a{'\u000fR8d\u0015\u0006\u0014H\u0005T5ce\u0006\u0014\u0018\u0010\u0015:pG\u0016\u001c8o\u001c:\u000b\u0013A\u0013xnY3tg>\u0014(bA2p[*A\u0011N\u001c;fY2L'N\u0003\u0003vi&d'b\u0002'jEJ\f'/\u001f\u0006\b_B,g.\u00199j\u0015\u0015\u0011xn\u001c;t\u0015%a\u0017N\u0019:be&,7O\u0003\u0004=S:LGO\u0010\u0006\u000e\u001fJ$WM\u001d*p_R$\u0016\u0010]3\u000b\u0007Y47OC\u0006WSJ$X/\u00197GS2,'b\u00029s_*,7\r\u001e\u0006\b!J|'.Z2u\u0015\u0019iw\u000eZ;mK*1Qj\u001c3vY\u0016T\u0011bZ3u\u001b>$W\u000f\\3\u000b\u0013M,G/T8ek2,'B\u0002:fgVdGO\u0003\u0005QCRD\u0017J\u001c4p\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NT\u0001CY;jYRLenV3c'\u0016\u0014h/\u001a:\u000b\u0013\u001d,GOU3tk2$(\"C:fiJ+7/\u001e7u\u0015\u001d\u0001(o\\2fgNTq\u0001\\5ce\u0006\u0014\u0018PC\u0004C_>dW-\u00198\u000b\r-|G\u000f\\5o5\u0007QA\u0001\u0005\u0001\u0019\u0005)\u0011\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!B\u0002\u0005\u0004!\u0005A\u0002A\u0003\u0003\t\u0005A1!\u0002\u0002\u0005\u0006!\u001dQA\u0001\u0003\u0004\u0011\u0011)1\u0001b\u0002\t\u00061\u0001QA\u0001\u0003\u0004\u0011\u0015)!\u0001\"\u0002\t\f\u0015\u0011A!\u0002\u0005\u0007\u000b\t!)\u0001#\u0004\u0006\u0005\u00111\u0001bB\u0003\u0003\t\u000bAy!B\u0002\u0005\u000f!AA\u0002A\u0003\u0003\t\u001dA\u0001\"B\u0001\t\u0016\u0015\u0011A\u0011\u0003\u0005\f\u000b\t!\u0011\u0002c\u0006\u0006\u0007\u0011M\u0001B\u0003\u0007\u0001\u000b\t!\u0019\u0002\u0003\u0006\u0006\u0003!uQa\u0001\u0003\f\u00119a\u0001!\u0002\u0002\u0005\b!\u0015A!\u0002\u0007\u00013!)\u0011\u0001\u0003\u0002\n\t%\u0019Q!\u0001\u0005\u00051\u0011A\"!L\f\u0005\u00074Az!\t\u0003\u0006\u0003!=A\u0012\u0001M\b+\u000eqQa\u0001C\b\u0013\u0005A\u0001\"D\u0002\u0005\u0012%\t\u0001\u0002C\t\u0006\t%I\u0011\u0001\u0002\u0001\u000e\u0003!AQf\u0006\u0003D\u001aaM\u0011\u0005B\u0003\u0002\u0011)a\t\u0001\u0007\u0006V\u00079)1\u0001b\u0005\n\u0003!UQb\u0001\u0003\r\u0013\u0005A)\"E\u0003\u0005\u001a%\tA\u0001A\u0007\u0002\u0011+iS\u0003B\u0006\u0019\u001bu=A\u0001\u0001E\u000e\u001b\r)\u0011\u0001\u0003\u0003\u0019\tA\u001b\u0001!I\u0002\u0006\u0003!]\u0001tC)\u0004\u000b\u0011i\u0011\"\u0001C\u0001\u001b\u0005AA\"\u000e\n\u0006#\u0011\u0019\u000f\u0001'\u0003\"\u0007\u0015\t\u0001\u0002\u0001\r\u0001#\u000eIA\u0011B\u0005\u0002\t\u0001i\u0011\u0001#\u0003\u000e\u0003!-Q\"\u0001E\u0007"})
            public final class LibraryProcessor
            implements Processor<Library> {
                public static final /* synthetic */ KClass $kotlinClass;
                @Nullable
                private PathInfo result;
                @Nullable
                private Module module;
                final /* synthetic */ OrderRootType $javaDocRootType;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ Project $project;

                static {
                    $kotlinClass = Reflection.createKotlinClass(LibraryProcessor.class);
                }

                @Nullable
                public final PathInfo getResult() {
                    return this.result;
                }

                public final void setResult(@Nullable PathInfo pathInfo) {
                    this.result = pathInfo;
                }

                @Nullable
                public final Module getModule() {
                    return this.module;
                }

                public final void setModule(@Nullable Module module) {
                    this.module = module;
                }

                public boolean process(@NotNull Library library) {
                    Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
                    VirtualFile[] virtualFileArray = library.getFiles(this.$javaDocRootType);
                    for (int i = 0; i < virtualFileArray.length; ++i) {
                        VirtualFile root = virtualFileArray[i];
                        if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)this.$file, (boolean)false)) continue;
                        File file = null;
                        VirtualFile virtualFile = root;
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root");
                        this.result = new PathInfo(file, this.$file, virtualFile, org.jetbrains.builtInWebServer.DefaultWebServerRootsProvider$Companion.access$getModuleNameQualifier$5(DefaultWebServerRootsProvider.Companion, this.$project, this.module), true);
                        return false;
                    }
                    return true;
                }

                public LibraryProcessor(OrderRootType $captured_local_variable$0, VirtualFile $captured_local_variable$1, Project $captured_local_variable$2) {
                    this.$javaDocRootType = $captured_local_variable$0;
                    this.$file = $captured_local_variable$1;
                    this.$project = $captured_local_variable$2;
                }
            }
            LibraryProcessor processor = new LibraryProcessor(javaDocRootType, file, project);
            AccessToken token = ReadAction.start();
            try {
                int n;
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                Module[] moduleArray = moduleManager.getModules();
                for (n = 0; n < moduleArray.length; ++n) {
                    Module module = moduleArray[n];
                    if (module.isDisposed()) continue;
                    processor.setModule(module);
                    ModuleRootManager.getInstance((Module)module).orderEntries().forEachLibrary((Processor)processor);
                    if (processor.getResult() == null) continue;
                    PathInfo pathInfo = processor.getResult();
                    return pathInfo;
                }
                processor.setModule(null);
                moduleArray = LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries();
                for (n = 0; n < moduleArray.length; ++n) {
                    Module library;
                    Module module = library = moduleArray[n];
                    Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"library");
                    if (processor.process((Library)module)) continue;
                    PathInfo pathInfo = processor.getResult();
                    return pathInfo;
                }
                Unit unit = Unit.INSTANCE$;
            }
            finally {
                token.finish();
            }
            return null;
        }

        private final String getModuleNameQualifier(Project project, Module module) {
            if (module != null && PlatformUtils.isIntelliJ()) {
                String string = module.getName();
                String string2 = project.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.name");
                if (!StringsKt.equals((String)string, (String)string2, (boolean)true)) {
                    String string3 = module.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"module.name");
                    if (!BuiltInWebServerKt.compareNameAndProjectBasePath(string3, project)) {
                        return module.getName();
                    }
                }
            }
            return null;
        }

        private final PathInfo findByRelativePath(String path, VirtualFile[] roots, FileResolver resolver, String moduleName) {
            for (int i = 0; i < roots.length; ++i) {
                VirtualFile root = roots[i];
                PathInfo pathInfo = FileResolver$$TImpl.resolve$default(resolver, path, root, moduleName, false, 8);
                if (pathInfo == null) {
                    continue;
                }
                PathInfo result = pathInfo;
                return result;
            }
            return null;
        }

        private final PathInfo findByRelativePath(Project project, String path, Module[] modules, RootProvider rootProvider, FileResolver resolver) {
            for (int i = 0; i < modules.length; ++i) {
                ModuleRootManager moduleRootManager;
                Module module = modules[i];
                if (module.isDisposed()) continue;
                ModuleRootManager moduleRootManager2 = moduleRootManager = ModuleRootManager.getInstance((Module)module);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager2, (String)"moduleRootManager");
                PathInfo result = this.findByRelativePath(path, rootProvider.getRoots(moduleRootManager2), resolver, null);
                if (result == null) continue;
                result.setModuleName(this.getModuleNameQualifier(project, module));
                return result;
            }
            return null;
        }

        private Companion() {
        }

        @Nullable
        public static final /* synthetic */ OrderRootType access$getJavadocOrderRootType$0(Companion $this) {
            return $this.getJavadocOrderRootType();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

