/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.StringsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"Y\b)Qr+\u001a2TKJ4XM\u001d)bi\"$vNR5mK6\u000bg.Y4fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(\u0002\u00052vS2$\u0018J\\,fEN+'O^3s\u0015\r\te.\u001f\u0006\u0007W>$H.\u001b8\u000b\rqJg.\u001b;?\u0015-\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8\u000b\u0017\u0005\u0003\b\u000f\\5dCRLwN\u001c\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u000f=\u0004XM\\1qS*9\u0001O]8kK\u000e$(b\u0002)s_*,7\r\u001e\u0006\u0010a\u0006$\b\u000eV8J]\u001a|7)Y2iK*)1)Y2iK*1qm\\8hY\u0016TaaY8n[>t'\"B2bG\",'BB*ue&twMC\fl_Rd\u0017N\u001c\u0018km6t\u0003\u000b\\1uM>\u0014X\u000eV=qK*A\u0001+\u0019;i\u0013:4wN\u0003\nhKR\u0004\u0016\r\u001e5U_&sgm\\\"bG\",'\"\u0006<jeR,\u0018\r\u001c$jY\u0016$v\u000eU1uQ&sgm\u001c\u0006\f-&\u0014H/^1m\r&dWMC\u0002wMNT!b\u00197fCJ\u001c\u0015m\u00195f\u0015\u0011)f.\u001b;\u000b)\u0011|g)\u001b8e\u0005f\u0014V\r\\1uSZ,\u0007+\u0019;i\u0015\u0011\u0001\u0018\r\u001e5\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twMC\bgS:$g+\u001b:uk\u0006dg)\u001b7f\u0015-\u0019\u0017m\u00195f%\u0016\u001cX\u000f\u001c;\u000b\u000f\t{w\u000e\\3b]*9q-\u001a;QCRD'\u0002\u00024jY\u0016T1bZ3u!\u0006$\b.\u00138g_*)1\r[5mI*Yq-\u001a;SKN|GN^3s\u001511\u0015\u000e\\3SKN|GN^3s\u0015%\u0019u.\u001c9b]&|g\u000ev\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)1\u0001B\u0001\t\u00011\u0001Q!\u0001E\u0003\u000b\r!!\u0001\u0003\u0002\r\u0001\u0015\t\u0001\u0012B\u0003\u0003\t\rAQ!\u0002\u0002\u0005\b!-QA\u0001\u0003\u0005\u0011\u000f)1\u0001\"\u0003\t\t1\u0001QA\u0001\u0003\u0005\u0011\u0019)1\u0001b\u0003\t\u000e1\u0001QA\u0001C\u0005\u0011\u0011)!\u0001b\u0003\t\u000e\u0015\u0011Aa\u0001\u0005\t\u000b\t!y\u0001#\u0005\u0006\u0005\u0011A\u0001\"C\u0003\u0004\t#Ay\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u00012\u0003\u0007\u0001\u000b\r!\u0011\u0001#\u0006\r\u0001\u0015\u0011A\u0011\u0003E\b\u000b\t!A\u0001#\u0007\u0006\u0007\u0011Y\u0001\u0002\u0004\u0007\u0001\u000b\r!!\u0001c\u0007\r\u0001\u0015\u0011A!\u0001E\u000b\u000b\u0005Aq\"\u0002\u0002\u0005\u001b!}QA\u0001C\u000e\u0011')1\u0001\u0002\u0002\t#1\u0001QA\u0001\u0003\f\u00111)1\u0001B\u0001\t)1\u0001QA\u0001\u0003\u0002\u0011Q!1\u0001d\u0001\u0011*e\u0019Q!\u0001E\u00031\u000bi\n\u0011F\u0017C\u0002\u0011\u0019G\u0001G\u0004\"k\u0015\t\u0001\"C\u0005\u000b\u0013%)\u0011\u0001c\u0005\u0011\u0015U!Q!\u0001E\n\u0019\u0003A\u001a\u0002g\u0005\n\u0015%IQ!\u0001\u0005\u000b!))B!B\u0001\t\u00151\u0005\u0001D\u0003\r\u000b!))\"$B\u0001\t\u0013%Q\u0011\"C\u0003\u0002\u0011'\u0001\"\"\u0006\u0003\u0006\u0003!MA\u0012\u0001M\n1'I!\"C\u0005\u0006\u0003!Q\u0001CC\u000b\u0005\u000b\u0005A!\u0002$\u0001\u0019\u0015aQA\u0012\u0001\r\n1%)6\u0001C\u0003\u0004\t\u001dI\u0011\u0001#\u0006\u000e\u0007\u0011Y\u0011\"\u0001E\u000b[1!\u0011\r\u0002\r\u0007C\r)\u0011\u0001\u0003\u0004\u0019\rU\u001bA!B\u0002\u0005\r%\t\u0001bB\u0017?\t\u0005$\u0001tC\u00116\u000b\u0005A\u0011\"\u0003\u0006\n\u0013\u0015\t\u0001r\u0003\t\u000b+\u0011)\u0011\u0001c\u0006\r\u0002a]\u0001tC\u0005\u000b\u0013%)\u0011\u0001\u0003\u0006\u0011\u0015U!Q!\u0001\u0005\u000b\u0019\u0003A\"\u0002\u0007\u0006\u0011\u0015UQR!\u0001\u0005\n\u0013)I\u0011\"B\u0001\t\u0018AQQ\u0003B\u0003\u0002\u0011/a\t\u0001g\u0006\u0019\u0018%Q\u0011\"C\u0003\u0002\u0011)\u0001\"\"\u0006\u0003\u0006\u0003!QA\u0012\u0001\r\u000b1)a\t\u0001G\u0005\u0019\u0013U\u001bA!B\u0002\u0005\u0018%\t\u0001RCW\u000b\t\u0005AR\"I\u0002\u0006\u0003!a\u0001\u0004D)\u0004\u0007\u0011i\u0011\"\u0001\u0003\u0001[Y!\u0001\u0001\u0007\b\u001e\u0010\u0011\u0001\u0001RD\u0007\u0004\u000b\u0005A\u0019\u0002g\u0005Q\u0007\u0001\tC!B\u0001\t\u00151\u0005\u0001DC)\u0004\u000b\u0011q\u0011\"\u0001E\r\u001b\u0005Aa\",\u0011\u0005\ba\u0001Rt\u0002\u0003\u0001\u0011;i1!B\u0001\t\u0014aM\u0001k\u0001\u0001\u001e\u0010\u0011\t\u0001\u0012E\u0007\u0004\u000b\u0005Ai\u0002'\bQ\u0007\u0003\tC!B\u0001\t\u00181\u0005\u0001tC)\u0004\u000f\u0011\u0001\u0012\"\u0001\u0005\u0010\u001b\u0005Aa\"D\u0001\u0005\u000252Ba\u0001M\u0012;\u001f!\u0001\u0001\u0003\n\u000e\u0007\u0015\t\u0001r\u0003M\f!\u000e\u0001\u0011\u0005B\u0003\u0002\u0011'a\t\u0001g\u0005R\u0007\u0015!\u0019#C\u0001\t\u001d5\t\u0001bD\u0017\u0017\t\u0005A*#h\u0004\u0005\u0001!\u0019RbA\u0003\u0002\u0011/A:\u0002U\u0002\u0001C\u0011)\u0011\u0001\u0003\u0006\r\u0002aQ\u0011kA\u0003\u0005&%\t\u0001\u0012D\u0007\u0002\u0011=i\u000b\u0005B\u0002\u0019&u=A\u0001\u0001E\u000f\u001b\r)\u0011\u0001c\u0005\u0019\u0014A\u001b\u0001!h\u0004\u0005\u0003!\u0005RbA\u0003\u0002\u0011;Aj\u0002UB\u0001C\u0011)\u0011\u0001\u0003\u0006\r\u0002aQ\u0011kA\u0004\u0005&%\t\u0001\u0012D\u0007\u0002\u00119i\u0011\u0001\"\u0001.+\u0011\u0019\u0001tEO\b\t\u0001Ai\"D\u0002\u0006\u0003!M\u00014\u0003)\u0004\u0001\u0005\u001aQ!\u0001E\u00101?\t6!\u0002C\u0014\u0013\u0005A\u0001#D\u0001\t\u001dU\nS\u0001\t\u0003d\u0002a\u0019Qt\u0002\u0003\u0001\u0011\u000fi1!B\u0001\t\u000ba)\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001BB\u0007\u0004\u000b\u0005Aa\u0001\u0007\u0004Q\u0007\u0003\t3!B\u0001\t\u0004a\r\u0011kA\u0004\u0005\u0007%\tA\u0001A\u0007\u0002\u0011\u001bi\u0011\u0001C\u0004"})
public final class WebServerPathToFileManager {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final Companion.RELATIVE_PATH_RESOLVER.1 RELATIVE_PATH_RESOLVER;
    private static final Companion.EMPTY_PATH_RESOLVER.1 EMPTY_PATH_RESOLVER;
    private final Cache<String, PathInfo> pathToInfoCache;
    private final Cache<VirtualFile, PathInfo> virtualFileToPathInfo;
    private final Project project;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(WebServerPathToFileManager.class);
        Companion companion = Companion = new Companion(null);
        RELATIVE_PATH_RESOLVER = new FileResolver(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(Companion.RELATIVE_PATH_RESOLVER.1.class);
            }

            @Nullable
            public PathInfo resolve(@NotNull String path, @NotNull VirtualFile root, @Nullable String moduleName, boolean isLibrary) {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
                if (root.isInLocalFileSystem() && Intrinsics.areEqual((Object)root.getFileSystem(), (Object)LocalFileSystem.getInstance())) {
                    File file = new File(root.getPath(), path);
                    if (file.exists()) {
                        return new PathInfo(file, (VirtualFile)null, root, moduleName, isLibrary);
                    }
                    return null;
                }
                VirtualFile virtualFile = root.findFileByRelativePath(path);
                if (virtualFile == null) {
                    return null;
                }
                VirtualFile file = virtualFile;
                return new PathInfo((File)null, file, root, moduleName, isLibrary);
            }
        };
        EMPTY_PATH_RESOLVER = new FileResolver(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(Companion.EMPTY_PATH_RESOLVER.1.class);
            }

            @Nullable
            public PathInfo resolve(@NotNull String path, @NotNull VirtualFile root, @Nullable String moduleName, boolean isLibrary) {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
                VirtualFile virtualFile = BuiltInWebServerKt.findIndexFile(root);
                if (virtualFile == null) {
                    return null;
                }
                VirtualFile file = virtualFile;
                return new PathInfo((File)null, file, root, moduleName, isLibrary);
            }
        };
    }

    public final Cache<String, PathInfo> getPathToInfoCache() {
        return this.pathToInfoCache;
    }

    private final void clearCache() {
        this.pathToInfoCache.invalidateAll();
        this.virtualFileToPathInfo.invalidateAll();
    }

    @JvmOverloads
    @Nullable
    public final VirtualFile findVirtualFile(@NotNull String path, boolean cacheResult) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        PathInfo pathInfo = this.getPathInfo(path, cacheResult);
        if (pathInfo == null) {
            return null;
        }
        PathInfo pathInfo2 = pathInfo;
        VirtualFile virtualFile = pathInfo2.getFile();
        if (virtualFile == null) {
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            File file = pathInfo2.getIoFile();
            if (file == null) {
                Intrinsics.throwNpe();
            }
            return localFileSystem.findFileByIoFile(file);
        }
        return virtualFile;
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ VirtualFile findVirtualFile$default(WebServerPathToFileManager webServerPathToFileManager, String string, boolean bl, int n) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return webServerPathToFileManager.findVirtualFile(string, bl);
    }

    @JvmOverloads
    @Nullable
    public VirtualFile findVirtualFile(@NotNull String string) {
        return WebServerPathToFileManager.findVirtualFile$default(this, string, false, 2);
    }

    @Nullable
    public final PathInfo getPathInfo(@NotNull String path, boolean cacheResult) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        PathInfo pathInfo = (PathInfo)this.pathToInfoCache.getIfPresent((Object)path);
        if (pathInfo == null || !pathInfo.getIsValid()) {
            pathInfo = this.doFindByRelativePath(path);
            if (cacheResult && pathInfo != null && pathInfo.getIsValid()) {
                this.pathToInfoCache.put((Object)path, (Object)pathInfo);
            }
        }
        return pathInfo;
    }

    @Nullable
    public static /* synthetic */ PathInfo getPathInfo$default(WebServerPathToFileManager webServerPathToFileManager, String string, boolean bl, int n) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return webServerPathToFileManager.getPathInfo(string, bl);
    }

    @Nullable
    public final String getPath(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        PathInfo pathInfo = this.getPathInfo(file);
        return pathInfo != null ? pathInfo.getPath() : null;
    }

    private final PathInfo getPathInfo(VirtualFile child) {
        PathInfo result = (PathInfo)this.virtualFileToPathInfo.getIfPresent((Object)child);
        if (result == null) {
            WebServerRootsProvider[] webServerRootsProviderArray = (WebServerRootsProvider[])WebServerRootsProvider.EP_NAME.getExtensions();
            for (int i = 0; i < webServerRootsProviderArray.length; ++i) {
                WebServerRootsProvider infoProvider = webServerRootsProviderArray[i];
                result = infoProvider.getPathInfo(child, this.project);
                if (result == null) continue;
                this.virtualFileToPathInfo.put((Object)child, (Object)result);
                break;
            }
        }
        return result;
    }

    @Nullable
    public final PathInfo doFindByRelativePath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        WebServerRootsProvider[] webServerRootsProviderArray = (WebServerRootsProvider[])WebServerRootsProvider.EP_NAME.getExtensions();
        for (int i = 0; i < webServerRootsProviderArray.length; ++i) {
            WebServerRootsProvider rootsProvider = webServerRootsProviderArray[i];
            PathInfo result = rootsProvider.resolve(path, this.project);
            if (result == null) continue;
            if (result.getFile() != null) {
                this.virtualFileToPathInfo.put((Object)result.getFile(), (Object)result);
            }
            return result;
        }
        return null;
    }

    @NotNull
    public final FileResolver getResolver(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return StringsKt.isEmpty((String)path) ? (FileResolver)WebServerPathToFileManager.Companion.getEMPTY_PATH_RESOLVER() : (FileResolver)WebServerPathToFileManager.Companion.getRELATIVE_PATH_RESOLVER();
    }

    public WebServerPathToFileManager(@NotNull Application application, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.pathToInfoCache = CacheBuilder.newBuilder().maximumSize(512L).expireAfterAccess(10L, TimeUnit.MINUTES).build();
        this.virtualFileToPathInfo = CacheBuilder.newBuilder().maximumSize(512L).expireAfterAccess(11L, TimeUnit.MINUTES).build();
        application.getMessageBus().connect((Disposable)this.project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(1.class);
            }

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                block0: for (VFileEvent vFileEvent : events) {
                    if (vFileEvent instanceof VFileContentChangeEvent) {
                        VirtualFile file = ((VFileContentChangeEvent)vFileEvent).getFile();
                        WebServerRootsProvider[] webServerRootsProviderArray = (WebServerRootsProvider[])WebServerRootsProvider.EP_NAME.getExtensions();
                        for (int i = 0; i < webServerRootsProviderArray.length; ++i) {
                            WebServerRootsProvider rootsProvider = webServerRootsProviderArray[i];
                            if (!rootsProvider.isClearCacheOnFileContentChanged(file)) continue;
                            this.clearCache();
                            continue block0;
                        }
                        continue;
                    }
                    this.clearCache();
                    break;
                }
            }
        });
        this.project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(2.class);
            }

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.clearCache();
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final WebServerPathToFileManager getInstance(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return Companion.getInstance(project);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"i\u0006)I1i\\7qC:LwN\u001c\u0006\u001b/\u0016\u00147+\u001a:wKJ\u0004\u0016\r\u001e5U_\u001aKG.Z'b]\u0006<WM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015A\u0011W/\u001b7u\u0013:<VMY*feZ,'OC\u0002B]fTaa[8uY&t'bE#N!RKv\fU!U\u0011~\u0013ViU(M-\u0016\u0013&BO,fEN+'O^3s!\u0006$\b\u000eV8GS2,W*\u00198bO\u0016\u0014HeQ8na\u0006t\u0017n\u001c8%\u000b6\u0003F+W0Q\u0003RCuLU#T\u001f23VI\u0015\u00132\u0015Y9W\r^#N!RKv\fU!U\u0011~\u0013ViU(M-\u0016\u0013&B\u0006*F\u0019\u0006#\u0016JV#`!\u0006#\u0006j\u0018*F'>ce+\u0012*\u000b{]+'mU3sm\u0016\u0014\b+\u0019;i)>4\u0015\u000e\\3NC:\fw-\u001a:%\u0007>l\u0007/\u00198j_:$#+\u0012'B)&3Vi\u0018)B)\"{&+R*P\u0019Z+%\u000bJ\u0019\u000b3\u001d,GOU#M\u0003RKe+R0Q\u0003RCuLU#T\u001f23VI\u0015\u0006\fO\u0016$\u0018J\\:uC:\u001cWMC\u0004qe>TWm\u0019;\u000b\u000fA\u0013xN[3di*\u00191m\\7\u000b\u0011%tG/\u001a7mS*Tqa\u001c9f]\u0006\u0004\u0018N\u001c\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0019A!\u0001E\u0001\u0019\u0001)1\u0001b\u0001\t\u00011\u0001Q!\u0001\u0005\u0004\u000b\r!)\u0001#\u0002\r\u0001\u0015\u0011\u0001\u0002\u0002\u0007\u0002\u000b\t!\u0011\u0001\u0003\u0003\u0006\u0005!-A\"A\u0003\u0003\t\u0005AY!B\u0001\t\u0011\u0015\u0011A1\u0002E\t\u000b\t!a\u0001C\u0005\u0006\u0005\u00115\u0001bB\u0003\u0004\t\u001dAy\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001\u0012A\u0003\u0003\t\u001dAy\u0001Bb\u0002\u0019\tI2!B\u0001\t\u0007a\u0019Q&\u0005\u0003b\ta\u001d\u0011eA\u0003\u0002\u0011\u000fA:!V\u0002\n\u000b\u0011!9!C\u0001\t\t1\u0005Qb\u0001C\u0005\u0013\u0005AA!L\t\u0005C\u0012AR!I\u0002\u0006\u0003!%\u0001\u0014B+\u0004\u0013\u0015!A!B\u0005\u0002\u0011\u0015a\t!D\u0002\u0005\r%\t\u0001\"B\u0017\u0016\t\u000fAj!h\u0004\u0005\u0001!9QbA\u0003\u0002\u0011\u001fAz\u0001U\u0002\u0001C\r)\u0011\u0001c\u0001\u0019\u0004E\u001bQ\u0001\"\u0004\n\u0003!AQ\"\u0001E\tk\u0001\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        private final RELATIVE_PATH_RESOLVER.1 getRELATIVE_PATH_RESOLVER() {
            return RELATIVE_PATH_RESOLVER;
        }

        private final EMPTY_PATH_RESOLVER.1 getEMPTY_PATH_RESOLVER() {
            return EMPTY_PATH_RESOLVER;
        }

        @JvmStatic
        @NotNull
        public final WebServerPathToFileManager getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            WebServerPathToFileManager webServerPathToFileManager = (WebServerPathToFileManager)ServiceManager.getService((Project)project, WebServerPathToFileManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)webServerPathToFileManager, (String)"ServiceManager.getServic\u2026oFileManager::class.java)");
            return webServerPathToFileManager;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

