/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.Breakpoint$$TImpl;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.util.concurrency.Promise;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0016\n)q!I]3bWB|\u0017N\u001c;CCN,'bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\tI\u0016\u0014WoZ4fe*\tAJC\u0002B]fTaa[8uY&t'B\u0003\"sK\u0006\\\u0007o\\5oi*1A(\u001b8jizRa\u0001^1sO\u0016$(\u0002\u0005\"sK\u0006\\\u0007o\\5oiR\u000b'oZ3u\u0015\u0011a\u0017N\\3\u000b\u0007%sGO\u0003\u0004d_2,XN\u001c\u0006\nG>tG-\u001b;j_:Taa\u0015;sS:<'bB3oC\ndW\r\u001a\u0006\b\u0005>|G.Z1o\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\u0010C\u000e$X/\u00197M_\u000e\fG/[8og*YQ*\u001e;bE2,G*[:u\u0015\u0011)H/\u001b7\u000b\t1K7\u000f\u001e\u0006\u0013O\u0016$\u0018i\u0019;vC2dunY1uS>t7OC\u0005hKR\u001cu\u000e\\;n]*)a/\u00197vK*aq-\u001a;D_:$\u0017\u000e^5p]*a1/\u001a;D_:$\u0017\u000e^5p]*)A-\u001b:us*Aq-\u001a;ESJ$\u0018P\u0003\u0005tKR$\u0015N\u001d;z\u0015)9W\r^#oC\ndW\r\u001a\u0006\u000bg\u0016$XI\\1cY\u0016$'BC5t%\u0016\u001cx\u000e\u001c<fI*iq-\u001a;JgJ+7o\u001c7wK\u0012TqaZ3u\u0019&tWMC\u0004tKRd\u0015N\\3\u000b\u0013\u001d,G\u000fV1sO\u0016$(\"\u00024mkND'\"\u00052sK\u0006\\\u0007o\\5oi6\u000bg.Y4fe*\t\"I]3bWB|\u0017N\u001c;NC:\fw-\u001a:\u000b\u000fA\u0013x.\\5tK*Y1m\u001c8dkJ\u0014XM\\2z\u0015!A\u0017m\u001d5D_\u0012,'BD5t-6\u0014VmZ5ti\u0016\u0014X\r\u001a\u0006\u0012g\u0016$\u0018i\u0019;vC2dunY1uS>t'\u0002B+oSRTaa\u00142kK\u000e$(BE:fi\u0006\u001bG/^1m\u0019>\u001c\u0017\r^5p]N$\u001cA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\r!\u0011\u0001\u0003\u0001\r\u0001\u0015\t\u0001bA\u0003\u0004\t\tA)\u0001\u0004\u0001\u0006\u0007\u0011\t\u0001r\u0001\u0007\u0001\u000b\r!\u0011\u0001C\u0003\r\u0001\u0015\u0019AA\u0001\u0005\u0007\u0019\u0001)1\u0001\u0002\u0002\t\u00101\u0001Qa\u0001\u0003\u0003\u0011#a\u0001!\u0002\u0002\u0005\u0003!)Q!\u0001\u0005\n\u000b\t!a\u0001c\u0005\u0006\u0005\u00115\u0001rB\u0003\u0004\t\tA)\u0002\u0004\u0001\u0006\u0005\u00111\u0001bC\u0003\u0003\t!A9\"B\u0002\u0005\u0003!%B\u0002A\u0003\u0003\t\u0003A1\"\u0002\u0002\u0005\u0014!-Ra\u0001\u0003\u000b\u0011Ua\u0001!\u0002\u0002\u0005\u0015!)RA\u0001\u0003\u0002\u0011S)1\u0001\u0002\u0002\t01\u0001QA\u0001C\u0007\u0011a)1\u0001\u0002\u0002\t\u00181\u0001Aa\u0005G\u0002+\u0019!\u0001\u0001\u0003\u0002\u0016\u0007\u0015\t\u0001R\u0001M\u00033\r)\u0011\u0001C\u0002\u0019\u000752Ba\u0019\u0003\u0019\u0015\u0005JQ!\u0001E\b\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001M\b+\u000eAQa\u0001\u0003\u000b\u0013\u0005A\t\"D\u0002\u0005\u0019%\t\u0001\u0012C\u0017\u0011\t\r$\u0001TB\u0011\u0004\u000b\u0005AA\u0001\u0007\u0003V\u0007!)1\u0001\"\u0004\n\u0003\u0011\u0015Qb\u0001C\r\u0013\u0005!)!l\u0011\u0005\u00174Ar!(\u0005\u0005\u0001!iQ\u0002B\u0003\u0002\u0011\u0013a\t\u0001'\u0003Q\u0007\u0001\tC!B\u0001\t\n1\u0005\u0001\u0014\u0002\u0015,+\u000eqQa\u0001\u0003\b\u0013\u0005Aq!D\u0002\u0005\u001c%\t\u0001bB\t\u0006\t9I\u0011\u0001\u0002\u0001\u000e\u0003!9Q\u0006\u0007CC\u001aau\u0011eA\u0003\u0002\u0011\u0015AR\u0001\n\u0002)\u0005U\u001ba\"B\u0002\u0005\u001e%\tA\u0011A\u0007\u0004\t=I\u0011\u0001\"\u0001\u0012\u000b\u0011}\u0011\"\u0001\u0003\u0001\u001b\u0005!\t!l\u0010\u0005\u00174A\u0002\"h\u0004\u0005\u0001!iQbA\u0003\u0002\u0011\u0015AR\u0001U\u0002\u0001C\r)\u0011\u0001C\u0003\u0019\u000b!ZSk\u0001\b\u0006\u0007\u0011A\u0011\"\u0001C\u0001\u001b\r!\u0001#C\u0001\u0005\u0002E)A\u0011E\u0005\u0002\t\u0001i\u0011\u0001\"\u0001.\u001b\u0011YG\u0001G\t\"\u0007\u0015\t\u0001\"\u0002\r\u0006I-*6\u0001B\u0007\u0004\tGI\u0011\u0001\"\u0001.-\u0011YM\u0002g\u0003\"\u0007\u0015\t\u0001\u0002\u0002\r\u0005+\u000eqQa\u0001C\u0006\u0013\u0005!)!D\u0002\u0005%%\tAQA\t\u0006\tKI\u0011\u0001\u0002\u0001\u000e\u0003\u0011\u0015Q\u0006\u0005\u0003l\ta%\u0011eA\u0003\u0002\u0011\u000fA:!V\u0002\t\u000b\r!I!C\u0001\t\f5\u0019AaE\u0005\u0002\u0011\u0017is\u0003B\n\u0019(u=A\u0001\u0001\u0005\u0015\u001b\r)\u0011\u0001C\u0005\u0019\u0013A\u001b\u0001!I\u0003\u0006\u0003!U\u0011\"\u0001C\u00021+\t6!\u0002C\u0014\u0013\u0005A1\"D\u0001\t\u00185VAa\u0003\r\u0017C\r)\u0011\u0001\u0003\u0003\u0019\tE\u001b1\u0001\u0002\f\n\u0003\u0011\u0015QV\u0003\u0003\u00141[\t3!B\u0001\t\u000ba)\u0011kA\u0002\u0005.%\tA\u0011A\u0017\u0018\t\rAr#h\u0005\u0005\u0001!iQ\"B\u0003\u0003\t\u0003A\u0001\u0001$\u0001\u001d\u0001A\u001b\u0001!I\u0002\u0006\u0003!a\u0001\u0004D)\u0004\u000b\u00119\u0012\"\u0001\u0003\u0001\u001b\u0005AI\"\f\u000f\u0005\u0007aERT\u0004\u0003\u0001\u00115i!\"B\u0001\t\u001b%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\r\u0002ai\u0001k\u0001\u0001\"\u0007\u0015\t\u0001\u0002\u0004\r\r#\u000e)A\u0011G\u0005\u0002\t\u0001i\u0011\u0001#\u00056\u001f\u0004)Y\u001a\u0001\u0003d\u0002E1A\u0001\u0001\u0005\u0003+\r)\u0011\u0001#\u0002\u0019\u0006a!Qt\u0002\u0003\u0001\u0011\u0013i1!B\u0001\t\ba\u001d\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u00012B\u0007\u0004\u000b\u0005AA\u0001\u0007\u0003Q\u0007\u0003iz\u0001\u0002\u0001\t\u000e5\u0019Q!\u0001\u0005\u00051\u0011\u00016!AO\t\t\u0001Aq!\u0004\u0003\u0006\u0003!%A\u0012\u0001M\u0005!\u000e\rQt\u0002\u0003\u0001\u0011!i1!B\u0001\t\u000ba)\u0001k\u0001\u0002\"\u0013\u0015\t\u00012A\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u00014A)\u0004\u001b\u0011!\u0011\"\u0001\u0003\u0001\u001b\u0005AY!D\u0001\u0005\u00065\tAQA\u0007\u0002\u0011\u001di\u0011\u0001\"\u0001"})
public abstract class BreakpointBase<L>
implements Breakpoint {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final List<L> actualLocations;
    private volatile boolean dirty;
    @Nullable
    private String condition;
    private boolean enabled;
    @NotNull
    private final BreakpointTarget target;
    private int line;
    private final int column;

    static {
        $kotlinClass = Reflection.createKotlinClass(BreakpointBase.class);
    }

    @NotNull
    public final List<L> getActualLocations() {
        return this.actualLocations;
    }

    protected final boolean getDirty() {
        return this.dirty;
    }

    protected final void setDirty(boolean bl) {
        this.dirty = bl;
    }

    @Override
    public boolean getIsResolved() {
        return !this.actualLocations.isEmpty();
    }

    @Override
    @Nullable
    public String getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(@Nullable String value) {
        if (Intrinsics.areEqual((Object)this.getCondition(), (Object)value) ^ true) {
            this.condition = value;
            this.dirty = true;
        }
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean value) {
        if (value != this.getEnabled()) {
            this.enabled = value;
            this.dirty = true;
        }
    }

    public final void setActualLocations(@Nullable List<? extends L> value) {
        this.actualLocations.clear();
        if (!ContainerUtil.isEmpty((Collection)value)) {
            List<? extends L> list = value;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            this.actualLocations.addAll((Collection)list);
        }
    }

    public final void setActualLocation(@Nullable L value) {
        this.actualLocations.clear();
        if (value != null) {
            this.actualLocations.add(value);
        }
    }

    public abstract boolean isVmRegistered();

    public int hashCode() {
        int result = this.getLine();
        result *= 31 + this.column;
        result *= 31 + (this.getEnabled() ? 1 : 0);
        if (this.getCondition() != null) {
            String string = this.getCondition();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            result *= 31 + string.hashCode();
        }
        return result *= 31 + this.getTarget().hashCode();
    }

    @NotNull
    public abstract Promise<?> flush(@NotNull BreakpointManager var1);

    @Override
    @NotNull
    public BreakpointTarget getTarget() {
        return this.target;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public final int getColumn() {
        return this.column;
    }

    public BreakpointBase(@NotNull BreakpointTarget target, int line, int column, @Nullable String condition, boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.target = target;
        this.line = line;
        this.column = column;
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ContainerUtil.createLockFreeCopyOnWriteList<L>()");
        this.actualLocations = list;
        this.condition = condition;
        this.enabled = enabled;
    }

    @Override
    public boolean isActualLineCorrect() {
        return Breakpoint$$TImpl.isActualLineCorrect(this);
    }
}

