/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.SocketConnectionListener;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkListener;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.PropertyMetadata;
import kotlin.PropertyMetadataImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ContextDependentAsyncResultConsumer;
import org.jetbrains.debugger.DebugProcessImpl;
import org.jetbrains.debugger.DebugProcessImpl$WhenMappings;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextManager;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.frame.SuspendContextImpl;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0010 )\u0001B)\u001a2vOB\u0013xnY3tg&k\u0007\u000f\u001c\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015!!WMY;hO\u0016\u0014(\"A\"\u000b\u0019Yk7i\u001c8oK\u000e$\u0018n\u001c8\u000b\u0015\r|gN\\3di&|gNC\u0007Y\t\u0016\u0014Wo\u001a)s_\u000e,7o\u001d\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u0013a$WMY;hO\u0016\u0014(B\u0002\u001fj]&$hHC\u0004tKN\u001c\u0018n\u001c8\u000b\u001ba#UMY;h'\u0016\u001c8/[8o\u0015=)G-\u001b;peN\u0004&o\u001c<jI\u0016\u0014(\u0002\u0007-EK\n,xmZ3s\u000b\u0012LGo\u001c:t!J|g/\u001b3fe*QQM^1mk\u0006$\u0018n\u001c8\u000b)Ml\u0017M\u001d;Ti\u0016\u0004\u0018J\u001c;p\u0011\u0006tG\r\\3s\u0015UA6+\\1siN#X\r]%oi>D\u0015M\u001c3mKJT\u0001b\u001d;faBLgn\u001a\u0006\u0010Kb,7-\u001e;j_:\u0014Vm];mi*yQ\t_3dkRLwN\u001c*fgVdGOC\u0005fq\u0016\u001cW\u000f^5p]*\u0019rL\u0019:fC.\u0004x.\u001b8u\u0011\u0006tG\r\\3sg*)\u0011I\u001d:bs*11n\u001c;mS:T!\u0003\u0017\"sK\u0006\\\u0007o\\5oi\"\u000bg\u000e\u001a7fe*Y!M]3bWB|\u0017N\u001c;t\u0015qy&M]3bWB|\u0017N\u001c;IC:$G.\u001a:tI\u0011,G.Z4bi\u0016TA\u0001T1{s*1r-\u001a;`EJ,\u0017m\u001b9pS:$\b*\u00198eY\u0016\u00148OC\u0007hKR\u001cuN\u001c8fGRLwN\u001c\u0006\u001eI&\u001c\u0018M\u00197f\t>tu\u000e^*uKBLe\u000e^8MS\n\u0014\u0018M]5fg*9!i\\8mK\u0006t'\u0002I4fi\u0012K7/\u00192mK\u0012{gj\u001c;Ti\u0016\u0004\u0018J\u001c;p\u0019&\u0014'/\u0019:jKNT\u0001e]3u\t&\u001c\u0018M\u00197f\t>tu\u000e^*uKBLe\u000e^8MS\n\u0014\u0018M]5fg*\u0011r-\u001a;Fq\u0016\u001cW\u000f^5p]J+7/\u001e7u\u0015-I7OR8sG\u0016\u001cF/\u001a9\u000b\u001d\u001d,G/S:G_J\u001cWm\u0015;fa*q1/\u001a;Jg\u001a{'oY3Ti\u0016\u0004(\"\u00047bgR\u001c\u0015\r\u001c7Ge\u0006lWMC\u0005DC2dgI]1nK*\u0001r-\u001a;MCN$8)\u00197m\rJ\fW.\u001a\u0006\u0011g\u0016$H*Y:u\u0007\u0006dGN\u0012:b[\u0016T\u0001\u0002\\1tiN#X\r\u001d\u0006\u000b'R,\u0007/Q2uS>t'bC4fi2\u000b7\u000f^*uKBT1b]3u\u0019\u0006\u001cHo\u0015;fa*!\u0003O]8dKN\u001c(I]3bWB|\u0017N\u001c;D_:$\u0017\u000e^5p]N\fE/\u00133f'&$WMC\u0014hKR\u0004&o\\2fgN\u0014%/Z1la>Lg\u000e^\"p]\u0012LG/[8og\u0006#\u0018\nZ3TS\u0012,'bJ:fiB\u0013xnY3tg\n\u0013X-Y6q_&tGoQ8oI&$\u0018n\u001c8t\u0003RLE-Z*jI\u0016T!C]3bYB\u0013xnY3tg\"\u000bg\u000e\u001a7fe*q\u0001K]8dKN\u001c\b*\u00198eY\u0016\u0014(b\u00029s_\u000e,7o\u001d\u0006\u0016O\u0016$(+Z1m!J|7-Z:t\u0011\u0006tG\r\\3s\u00159\u0011X\r]3biN#X\r]%oi>TQ\"\u0011;p[&\u001c'i\\8mK\u0006t'\u0002\u00026bm\u0006TA!\u001e;jY*Q1m\u001c8dkJ\u0014XM\u001c;\u000b\r\u0005$x.\\5d\u0015E9W\r\u001e*fa\u0016\fGo\u0015;fa&sGo\u001c\u0006\u000fkJdGk\u001c$jY\u0016\u001c\u0015m\u00195f\u00155\u0019uN\\2veJ,g\u000e^'ba*\u0019QK\u001d7\u000b\u0017YK'\u000f^;bY\u001aKG.\u001a\u0006\b_B,g.\u00199j\u0015\r1hm\u001d\u0006\u0012O\u0016$XK\u001d7U_\u001aKG.Z\"bG\",'B\u0001<n\u0015\t1VNC\u0003hKR4VNC\tce\u0016\f7\u000e]8j]R\u0014V-Y2iK\u0012T!B\u0019:fC.\u0004x.\u001b8u\u0015-A&I]3bWB|\u0017N\u001c;\u000b-\u00154\u0018\r\\;bi\u0016$Gj\\4FqB\u0014Xm]:j_:Taa\u0015;sS:<'BD:vgB,g\u000eZ\"p]R,\u0007\u0010\u001e\u0006\u00101N+8\u000f]3oI\u000e{g\u000e^3yi*)aM]1nK*!QK\\5u\u0015\u0011a\u0017M\\4\u000b/\rDWmY6DC:\u0004VM\u001d4pe6\u001cu.\\7b]\u0012\u001c(BC2p]RLg.^3W[*Q1\u000f^3q\u0003\u000e$\u0018n\u001c8\u000b1\r\u0014X-\u0019;f\u0005J,\u0017m\u001b9pS:$\b*\u00198eY\u0016\u00148OC\ne_\u001e+G\u000f\u0015:pG\u0016\u001c8\u000fS1oI2,'OC\u000bhKR\u0014%/Z1la>Lg\u000e\u001e%b]\u0012dWM]:\u000b/-|G\u000f\\5o])4XN\f)mCR4wN]7UsB,'\u0002I4fi\u000e+(O]3oiN#\u0018\r^3IsB,'\u000f\\5oW2K7\u000f^3oKJT\u0011\u0003S=qKJd\u0017N\\6MSN$XM\\3s\u0015\u0015Q\u0017M^1y\u0015\u0015\u0019x/\u001b8h\u0015\u0015)g/\u001a8u\u0015!qU\u000f\u001c7bE2,'bC1o]>$\u0018\r^5p]NTacZ3u\u0007V\u0014(/\u001a8u'R\fG/Z'fgN\fw-\u001a\u0006\b\u001d>$h*\u001e7m\u0015I9W\r^#eSR|'o\u001d)s_ZLG-\u001a:\u000b3\u001d,G\u000fT8dCRLwN\\:G_J\u0014%/Z1la>Lg\u000e\u001e\u0006\u001012Kg.\u001a\"sK\u0006\\\u0007o\\5oi*YrN\u001c7z'>,(oY3NCB\u0004X\r\u001a\"sK\u0006\\\u0007o\\5oiNTA\u0001T5ti*AAj\\2bi&|gNC\fhKR\u001cV.\u0019:u'R,\u0007/\u00138u_\"\u000bg\u000e\u001a7fe*!\u0012n\u001d,bYV,7oQ;ti>l7k\u001c:uK\u0012T!#[:W[N#X\r](vi\u000e{'O]3di*\t\u0002O]8dKN\u001c(I]3bWB|\u0017N\u001c;\u000b\u001dM+8\u000f]3oI\u000e{g\u000e^3yi*y\u0001pU;ta\u0016tGmQ8oi\u0016DHO\u0003\nTkN\u0004XM\u001c3D_:$X\r\u001f;J[Bd'\u0002\u000b9s_\u000e,7o\u001d\"sK\u0006\\\u0007o\\5oi2{w-\u0012=qe\u0016\u001c8/[8o\u0003:$7+^:qK:$'B\u0002:fgVlWM\u0003\ttCZ,'+Z:pYZ,GMR5mK*\u0019QO\u001d7\u000b\t\u0019LG.\u001a\u0006\u000bg\u0016$xJ^3sY\u0006L(BE:uCJ$hi\u001c:dKN#X\r]%oi>TAb\u001d;beR\u0004\u0016-^:j]\u001eTQb\u001d;beR\u001cF/\u001a9J]R|'\u0002D:uCJ$8\u000b^3q\u001fV$(\"D:uCJ$8\u000b^3q\u001fZ,'OC\nva\u0012\fG/\u001a'bgR\u001c\u0015\r\u001c7Ge\u0006lWM%\u0003\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)1\u0001B\u0001\t\u00011\u0001QA\u0001\u0003\u0002\u0011\r)1\u0001\u0002\u0002\t\u00061\u0001Q!\u0001\u0005\u0005\u000b\t!1\u0001#\u0003\u0006\u0005\u0011\u001d\u0001\"B\u0003\u0004\t\u0011A9\u0001\u0004\u0001\u0006\u0007\u0011!\u0001R\u0002\u0007\u0001\u000b\t!A\u0001\u0003\u0005\u0006\u0007\u0011-\u0001r\u0002\u0007\u0001\u000b\t!A\u0001c\u0005\u0006\u0007\u00115\u0001\"\u0003\u0007\u0001\u000b\t!9\u0001C\u0006\u0006\u0007\u0011=\u0001R\u0003\u0007\u0001\u000b\t!A\u0001#\u0004\u0006\u0005\u0011\u0011\u0001RA\u0003\u0003\t\u0017Ay!\u0002\u0002\u0005\u000e!IQA\u0001C\b\u0011+)\u0011\u0001#\u0007\u0006\u0007\u0011Y\u0001\u0002\u0004\u0007\u0001\u000b\t!A\u0001c\u0007\u0006\u0007\u0011a\u0001\"\u0004\u0007\u0001\u000b\t!1\u0002#\b\u0006\u0005\u0011a\u0001\"D\u0003\u0004\t-A\t\u0003\u0004\u0001\u0006\u0007\u0011\t\u0001\u0012\u0006\u0007\u0001\u000b\t!\u0011\u0001#\u000b\u0006\u0007\u0011\t\u0001R\u0006\u0007\u0001\u000b\t!\u0011\u0001#\f\u0006\u0005\u0011=\u0001RG\u0003\u0004\tCA!\u0004\u0004\u0001\u0006\u0005\u0011\u0005\u0002BG\u0003\u0002\u0011s)!\u0001\u0002\n\t;\u0015\u0011AQ\u0005E\u001e\u000b\t!1\u0003\u0003\u0010\u0006\u0007\u0011\u001d\u0002\u0002\b\u0007\u0001\u000b\t!9\u0003\u0003\u000f\u0006\u0007\u0011\u0019\u0002r\b\u0007\u0001\u000b\t!9\u0001C\u000f\u0006\u0007\u0011-\u0002\u0002\t\u0007\u0001\u000b\t!9\u0001C\u0011\u0006\u0005\u00115\u00022I\u0003\u0004\t]A\t\u0005\u0004\u0001\u0006\u0005\u0011\u0019\u0002rH\u0003\u0004\t\u0005A1\u0005\u0004\u0001\u0006\u0005\u0011\t\u0001bI\u0003\u0004\t1AQ\u0005\u0004\u0001\u0006\u0007\u0011Y\u0001B\n\u0007\u0001\u000b\t!A\u0001c\u0014\u0006\u0007\u0011U\u0002b\n\u0007\u0001\u000b\r!1\u0002\u0003\u0015\r\u0001\u0015\u0011A\u0001\u0004\u0005&\u000b\t!!\u0003#\u0015\u0006\u0005\u0011e\u0002BJ\u0003\u0003\tkAq%B\u0001\t\\\u0015\u0011AA\b\u0005/\u000b\t!i\u0004#\u0018\u0006\u0007\u0011y\u0002\"\f\u0007\u0001\u000b\t!\t\u0001c\u0018\u0006\u0007\u0011\u0001\u0003b\f\u0007\u0001\u000b\t!q\u0004C\u0017\u0006\u0007\u0011\u0001\u0003\u0012\r\u0007\u0001\u000b\r!A\u0002\u0003\u001a\r\u0001\u0015\u0019Aa\u0003\u00054\u0019\u0001)1\u0001B\u0001\th1\u0001QA\u0001C\u0013\u0011M*!\u0001\u0002\u0007\te\u0015\u0019A!\u0001\u00057\u0019\u0001)!\u0001B\u0001\tP\u0015\u0019A!\n\u00058\u0019\u0001)!\u0001B\u0001\tm\u0015\u0011A!\n\u00058\u000b\t!Y\u0003\u0003\u0011\u0006\u0005\u00119\u0002\u0012\t\u0003\u0014\u0019\u0007)\u0002\u0002\u0002\u0001\t\u0005U)Q!\u0001E\u0003\u0013\u0005!\u0019\u0001'\u0002\u001a\u0007\u0015\t\u0001\u0012\u0002M\u0005[e!\u0011\r\u0002M\fC))\u0011\u0001c\u0006\n\r%)Q!\u0001E\r\u0013\u0005!\u0019\u0001'\u0007\u0019\u0018\u0011\nSkA\u0005\u0006\u0007\u0011q\u0011\"\u0001\u0005\u000e\u001b\u0011!q\"\u0003\u0002\t\u001c1\u0005Q&\u0005\u0003d\ta\u0019\u0011\u0005B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001V\u0007!)1\u0001B\u0002\n\u0003!IQb\u0001C\u0010\u0013\u0005A\u0011\"\f\r\u0005\u00064A\u0002#I\u0002\u0006\u0003!q\u0001D\u0004\u0013\u0003Q\t)6AD\u0003\u0004\tAI\u0011\u0001\"\u0001\u000e\u0007\u0011\t\u0012\"\u0001C\u0001#\u0015!\u0019#C\u0001\u0005\u00015\tA\u0011A\u0017\r\t\u0005$\u0001dB\u0011\u0004\u000b\u0005Aa\u0001\u0007\u0004V\u0007\u0011)1\u0001B\u0004\n\u0003!MQ&\u0005\u0003c\taQ\u0011\u0005B\u0003\u0002\u0011!a\t\u0001\u0007\u0005V\u0007!)1\u0001\u0002\u0006\n\u0003!UQb\u0001\u0003\u0013\u0013\u0005A)\"\f\r\u0005\u00064A*#I\u0002\u0006\u0003!q\u0001D\u0004\u0013\u0003Q\t)6AD\u0003\u0004\tKI\u0011\u0001\"\u0001\u000e\u0007\u0011\u0019\u0012\"\u0001C\u0001#\u0015!9#C\u0001\u0005\u00015\tA\u0011A\u0017\u001a\t\u000bg\u0001\u0004F\u0011\u0005\u000b\u0005Ai\u0002$\u0001\u0019\u001e\u0011\u0012\u0001FA+\u0004\u001d\u0015\u0019A\u0001F\u0005\u0002\u0011=i1\u0001B\u000b\n\u0003!y\u0011#\u0002C\u0016\u0013\u0005!\u0001!D\u0001\t\u001f5JBQ1\u0007\u0019-\u0005\"Q!\u0001E\u0010\u0019\u0003Az\u0002\n\u0002)\u0005U\u001ba\"B\u0002\u0005-%\t\u0001\u0002E\u0007\u0004\t]I\u0011\u0001\u0003\t\u0012\u000b\u0011=\u0012\"\u0001\u0003\u0001\u001b\u0005A\u0001#\f\f\u0005\u00074A\u0002$I\u0002\u0006\u0003!q\u0001DD+\u0004\u001d\u0015\u0019A\u0001G\u0005\u0002\t\u0003i1\u0001\"\r\n\u0003\u0011\u0005\u0011#\u0002\u0003\u001a\u0013\u0005!\u0001!D\u0001\u0005\u00025rAA\u0019\u0003\u00194\u0005\"Q!\u0001\u0005\u0012\u0019\u0003A\u0012\u0003\n\u0012V\u0007\u0011i1\u0001B\u000e\n\u0003!\rR\u0006\u0005\u0003c\ta]\u0012eA\u0003\u0002\u0011QAB#V\u0002\t\u000b\r!9$C\u0001\t*5\u0019AQH\u0005\u0002\u0011Sis\u0002B1\u00051#\tc!B\u0001\t\u000f%\tA1\u0001G\u00011\u001d)6\u0001B\u0003\u0004\t#I\u0011\u0001\u0003\u0006.5\u0011\u0011G\u0001G\u0010\"\u001b\u0015\t\u0001\"F\u0005\u0005\u0013\r)\u0011\u0001\u0003\f\u0019-%!\u0011bA\u0003\u0002\u0011_Az\u0003G\u000bV\u0007!)1\u0001B\u0010\n\u0003!ARb\u0001\u0003#\u0013\u0005A\u0001$\f\b\u0005G\u0012A*%\t\u0003\u0006\u0003!EB\u0012\u0001M\u0019I\r*6\u0001B\u0007\u0004\t\u000fJ\u0011\u0001C\r.[\u0011\t\u0001\u0004JO\n\t\u0001AI%D\u0003\u0006\u0003!M\u0012\"\u0001C\u00021g\u00016\u0001AO\t\t\u0001AY%\u0004\u0003\u0006\u0003!QB\u0012\u0001\r\u001b!\u000e\u0005Qt\u0002\u0003\u0001\u0011\u001bj1!B\u0001\t7aY\u0002kA\u0001\"\u0007\u0015\t\u0001r\u0007M\u001c#\u000eIA\u0001J\u0005\u0002\t\u0001i\u0011\u0001\u0003\u000f\u000e\u0003!iR\"\u0001E\u001e[+!1\u0001G\u0015\"\u0007\u0015\t\u0001B\u0004\r\u000f#\u000e\u0019A!K\u0005\u0002\t\u0003iS\u0003\u0002\u0002\u0019Tu=A\u0001\u0001\u0005+\u001b\r)\u0011\u0001c\b\u0019 A\u001b\u0001!I\u0002\u0006\u0003!]\u0002tG)\u0004\u000b\u0011M\u0013\"\u0001\u0003\u0001\u001b\u0005A\u0001#,\n\u0005%aU\u0013EC\u0003\u0002\u0011/Ia!C\u0003\u0006\u0003!e\u0011\"\u0001C\u000213A:\"U\u0002\u0005\t+J!\u0001c\u0007\r\u00025VAA\u0003\r,C\r)\u0011\u0001C\t\u0019#E\u001b1\u0001B\u0016\n\u0003!\rR\u0016\r\u0003\u00041/\n\u0003&B\u0001\t\u0018%q\u0011\"D\u0003\u0002\u00113I\u0011\u0001b\u0001\u0011YU1Q!\u0001E\r\u0013\u0005!\u0019\u0001$\u0001\u0019\u001aae\u0001\u0003L\u000b\u0015\u000b\u0005A9\"C\b\u0005\u0002%iQ!\u0001E\r\u0013\u0005!\u0019\u0001\u0005\u0017\u0016\r\u0015\t\u0001\u0012D\u0005\u0002\t\u0007a\t\u0001'\u0007\u0019\u001a1\u0005\u0001t\u0003M\f#\u000e!AqK\u0005\u0003\u00117a\t!\f\b\u0005\u0007ae\u0013UB\u0003\u0002\u0011\u007fa\t\u0001g\u0010R\u0007\u0005!\t%U\u0002\u0004\t3J\u0011\u0001C\u0011.\u001b\u0011\u0019\u0001\u0004MQ\u0006\u000b\u0005A!\u0004\u0007\u000eR\u0007\u0005!\u0019%U\u0002\u0004\tAJ\u0011\u0001C\u000f.\u0016\u0011\u0019\u0001$M\u0011\u0004\u000b\u0005Aa\u0001\u0007\u0004R\u0007\r!\u0011'C\u0001\t\u001456Ca\u0005M2;'!\u0001\u0001#\u0013\u000e\u000b\u0015\t\u0001BI\u0005\u0002\t\u0007A\"\u0005U\u0002\u0001;\u001f!\u0001\u0001#\u001a\u000e\u0007\u0015\t\u0001B\u0004\r\u000f!\u000e\u0005\u0011\u0005C\u0003\u0002\u0011\u000bJA!C\u0002\u0006\u0003!\u0019\u0003d\tM##\u000e9A1M\u0005\u0002\u0011\u000fj\u0011\u0001\u0003\u0013\u000e\u0003\u0011\u0005Q6\u0004\u0003\u00041Q\nc!B\u0001\t\u000f%\tA1\u0001G\u00011\u001d\t6a\u0001\u00035\u0013\u0005A!\",\u0006\u0005\u0007a%\u0014eA\u0003\u0002\u00119Ab\"U\u0002\u0004\tSJ\u0011\u0001\"\u0001.\u0016\u0011Q\u0001$N\u0011\u0004\u000b\u0005Aa\u0002\u0007\bR\u0007\r!Q'C\u0001\u0005\u00025bCA\u0001M6;\u001f!\u0001\u0001#\u0014\u000e\u0007\u0015\t\u0001\u0012\nM%!\u000e\u0001Q4\u0003\u0003\u0001\u0011\u0013jQ!B\u0001\t4%\tA1\u0001M\u001a!\u000e\u0005Qt\u0002\u0003\u0001\u0011[j1!B\u0001\tLa-\u0003kA\u0001\"\u0007\u0015\t\u0001r\u0007M\u001c#\u000eIA1N\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0014\u000e\u0003!aR\"\u0001E'[1\"\u0011\u0001g\u001c\u001e\u0014\u0011\u0001\u0001\u0012J\u0007\u0006\u000b\u0005A\u0019$C\u0001\u0005\u0004aM\u0002k\u0001\u0001\u001e\u0010\u0011\u0001\u0001RN\u0007\u0004\u000b\u0005AY\u0005g\u0013Q\u0007\u0003iz\u0001\u0002\u0001\tN5\u0019Q!\u0001E%1\u0013\u00026!A\u0011\u0004\u000b\u0005A9\u0004g\u000eR\u0007%!y'C\u0001\u0005\u00015\t\u0001\u0002H\u0007\u0002\u0011\u001bj\u0011\u0001\u0003\u0014.\u0016\u0011\u0019\u0001\u0004O\u0011\u0004\u000b\u0005A9\u0004g\u000eR\u0007\r!\u0001(C\u0001\u0005\u00015~Ba\u0001M9;\u001f!\u0001\u0001C\u001d\u000e\u0007\u0015\t\u0001B\u0006\r\u0017!\u000e\u0001Qt\u0002\u0003\u0001\u0011gj1!B\u0001\t0a=\u0002k!\u0001\"\u0007\u0015\t\u0001r\u0007M\u001c#\u000e9A\u0011O\u0005\u0002\t\u0001i\u0011\u0001C\u0014\u000e\u0003!=SV\u0003\u0003\u00031i\n3!B\u0001\t8a]\u0012kA\u0002\u0005u%\tA\u0001AW\u000b\t\rA*(I\u0002\u0006\u0003!]\u0002tG)\u0004\u0007\u0011U\u0014\"\u0001\u0003\u0001[+!1\u0001G\u001e\"\u0007\u0015\t\u0001r\u0007M\u001c#\u000e\u0019AaO\u0005\u0002\t\u0001i+\u0002B\u0002\u0019x\u0005\u001aQ!\u0001E\u001c1o\t6a\u0001C<\u0013\u0005!\u0001!,\u0006\u0005\u0007aa\u0014eA\u0003\u0002\u0011oA:$U\u0002\u0004\tqJ\u0011\u0001\u0002\u0001.\u0016\u0011\u0019\u0001\u0014P\u0011\u0004\u000b\u0005A9\u0004g\u000eR\u0007\r!I(C\u0001\u0005\u00015VA!\u0001\r>C\r)\u0011\u0001c\u000e\u00198E\u001b1\u0001B\u001f\n\u0003\u0011\u0001Q'6\u0001\u0006(\u0004!1\u001dA\t\t\t\u0001A!!F\u0003\u0006\u0003!\u0015\u0011\"\u0001C\u00021\u000bAZ!h\u0004\u0005\u0001!1QbA\u0003\u0002\u0011\u0015AR\u0001U\u0002\u0001;#!\u0001\u0001C\u0002\u000e\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001\u00016\u0011AO\b\t\u0001Aq!D\u0002\u0006\u0003!1\u0001D\u0002)\u0004\u0003uUA\u0001\u0001E\t\u001b\u0019)\u0011\u0001C\u0004\n\u0003\u0011\rA\u0012\u0001\r\b!\u000e\rQ\u0014\u0003\u0003\u0001\u0011)iA!B\u0001\t\u00111\u0005\u0001\u0004\u0003)\u0004\u0005\u0005JQ!\u0001E\u0002\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001M\u0002#\u000eiA1B\u0005\u0002\t\u0001i\u0011\u0001#\u0005\u000e\u0003!IQ\"\u0001E\n\u001b\u0005A!\"D\u0001\t\u0016\u0001"})
public abstract class DebugProcessImpl<C extends VmConnection<?>>
extends XDebugProcess {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final AtomicBoolean repeatStepInto;
    @Nullable
    private volatile StepAction lastStep;
    @Nullable
    private volatile CallFrame lastCallFrame;
    private volatile boolean isForceStep;
    private volatile boolean disableDoNotStepIntoLibraries;
    @NotNull
    private final ConcurrentMap<Url, VirtualFile> urlToFileCache;
    private boolean processBreakpointConditionsAtIdeSide;
    private final Lazy<? extends XBreakpointHandler<?>[]> _breakpointHandlers$delegate;
    @NotNull
    private final C connection;
    private final XDebuggerEditorsProvider editorsProvider;
    private final XSmartStepIntoHandler<?> smartStepIntoHandler;
    @Nullable
    private final ExecutionResult executionResult;
    private static final /* synthetic */ PropertyMetadata[] $propertyMetadata;

    static {
        $kotlinClass = Reflection.createKotlinClass(DebugProcessImpl.class);
        $propertyMetadata = new PropertyMetadata[]{new PropertyMetadataImpl("_breakpointHandlers")};
    }

    @NotNull
    protected final AtomicBoolean getRepeatStepInto() {
        return this.repeatStepInto;
    }

    @Nullable
    protected final StepAction getLastStep() {
        return this.lastStep;
    }

    protected final void setLastStep(@Nullable StepAction stepAction) {
        this.lastStep = stepAction;
    }

    @Nullable
    protected final CallFrame getLastCallFrame() {
        return this.lastCallFrame;
    }

    protected final void setLastCallFrame(@Nullable CallFrame callFrame) {
        this.lastCallFrame = callFrame;
    }

    protected final boolean getIsForceStep() {
        return this.isForceStep;
    }

    protected final void setIsForceStep(boolean bl) {
        this.isForceStep = bl;
    }

    protected final boolean getDisableDoNotStepIntoLibraries() {
        return this.disableDoNotStepIntoLibraries;
    }

    protected final void setDisableDoNotStepIntoLibraries(boolean bl) {
        this.disableDoNotStepIntoLibraries = bl;
    }

    @NotNull
    protected final ConcurrentMap<Url, VirtualFile> getUrlToFileCache() {
        return this.urlToFileCache;
    }

    public final boolean getProcessBreakpointConditionsAtIdeSide() {
        return this.processBreakpointConditionsAtIdeSide;
    }

    public final void setProcessBreakpointConditionsAtIdeSide(boolean bl) {
        this.processBreakpointConditionsAtIdeSide = bl;
    }

    private final XBreakpointHandler<?>[] get_breakpointHandlers() {
        return (XBreakpointHandler[])LazyKt.get(this._breakpointHandlers$delegate, (Object)((Object)this), (PropertyMetadata)$propertyMetadata[0]);
    }

    @Nullable
    protected final ProcessHandler getRealProcessHandler() {
        ExecutionResult executionResult = this.executionResult;
        return executionResult != null ? executionResult.getProcessHandler() : null;
    }

    @Nullable
    public final XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.smartStepIntoHandler;
    }

    public final XBreakpointHandler<?>[] getBreakpointHandlers() {
        XBreakpointHandler[] xBreakpointHandlerArray;
        switch (DebugProcessImpl$WhenMappings.$EnumSwitchMapping$1[((VmConnection)this.connection).getState().getStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                xBreakpointHandlerArray = XBreakpointHandler.EMPTY_ARRAY;
                break;
            }
            default: {
                xBreakpointHandlerArray = this.get_breakpointHandlers();
            }
        }
        return xBreakpointHandlerArray;
    }

    @NotNull
    public final XDebuggerEditorsProvider getEditorsProvider() {
        return this.editorsProvider;
    }

    @Nullable
    public final Vm getVm() {
        return ((VmConnection)this.connection).getVm();
    }

    @NotNull
    protected abstract XBreakpointHandler<?>[] createBreakpointHandlers();

    private final void updateLastCallFrame() {
        Object object = this.getVm();
        this.lastCallFrame = object != null && (object = object.getSuspendContextManager()) != null && (object = object.getContext()) != null ? object.getTopFrame() : null;
    }

    public final boolean checkCanPerformCommands() {
        return this.getVm() != null;
    }

    public final boolean isValuesCustomSorted() {
        return true;
    }

    public final void startStepOver() {
        this.updateLastCallFrame();
        this.continueVm(StepAction.OVER);
    }

    public final void startForceStepInto() {
        this.isForceStep = true;
        this.startStepInto();
    }

    public final void startStepInto() {
        this.updateLastCallFrame();
        this.continueVm(StepAction.IN);
    }

    public final void startStepOut() {
        if (this.isVmStepOutCorrect()) {
            this.lastCallFrame = null;
        } else {
            this.updateLastCallFrame();
        }
        this.continueVm(StepAction.OUT);
    }

    protected boolean isVmStepOutCorrect() {
        return true;
    }

    public final void resume() {
        this.continueVm(StepAction.CONTINUE);
    }

    protected final void continueVm(@NotNull StepAction stepAction) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stepAction), (String)"stepAction");
        Vm vm = this.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        SuspendContextManager<? extends CallFrame> suspendContextManager = vm.getSuspendContextManager();
        if (stepAction == StepAction.CONTINUE) {
            if (suspendContextManager.getContext() == null) {
                return;
            }
            this.lastStep = null;
            this.lastCallFrame = null;
            this.urlToFileCache.clear();
            this.disableDoNotStepIntoLibraries = false;
        } else {
            this.lastStep = stepAction;
        }
        suspendContextManager.continueVm(stepAction, 1);
    }

    protected final void setOverlay() {
        Vm vm = this.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        vm.getSuspendContextManager().setOverlayMessage("Paused in debugger");
    }

    protected final void processBreakpoint(@NotNull SuspendContext suspendContext, @NotNull XBreakpoint<?> breakpoint, @NotNull SuspendContextImpl xSuspendContext) {
        String condition;
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull((Object)((Object)xSuspendContext), (String)"xSuspendContext");
        XExpression xExpression = breakpoint.getConditionExpression();
        String string = condition = xExpression != null ? xExpression.getExpression() : null;
        if (!this.processBreakpointConditionsAtIdeSide || condition == null) {
            this.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
        } else {
            xSuspendContext.evaluateExpression(condition).done((Consumer)new ContextDependentAsyncResultConsumer<String>(this, breakpoint, xSuspendContext, suspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;
                final /* synthetic */ SuspendContext $suspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpoint.1.class);
                }

                protected void consume(@NotNull String evaluationResult, @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)evaluationResult, (String)"evaluationResult");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    if (Intrinsics.areEqual((Object)"false", (Object)evaluationResult)) {
                        this.this$0.resume();
                    } else {
                        DebugProcessImpl.access$processBreakpointLogExpressionAndSuspend$0(this.this$0, this.$breakpoint, this.$xSuspendContext, this.$suspendContext);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$xSuspendContext = $captured_local_variable$2;
                    this.$suspendContext = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            }).rejected((Consumer)new ContextDependentAsyncResultConsumer<Throwable>(this, breakpoint, xSuspendContext, suspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;
                final /* synthetic */ SuspendContext $suspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpoint.2.class);
                }

                protected void consume(@NotNull Throwable failure, @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)failure, (String)"failure");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    DebugProcessImpl.access$processBreakpointLogExpressionAndSuspend$0(this.this$0, this.$breakpoint, this.$xSuspendContext, this.$suspendContext);
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$xSuspendContext = $captured_local_variable$2;
                    this.$suspendContext = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            });
        }
    }

    private final void processBreakpointLogExpressionAndSuspend(XBreakpoint<?> breakpoint, SuspendContextImpl xSuspendContext, SuspendContext suspendContext) {
        String logExpression;
        XExpression xExpression = breakpoint.getLogExpressionObject();
        String string = logExpression = xExpression != null ? xExpression.getExpression() : null;
        if (logExpression == null) {
            this.breakpointReached(breakpoint, null, xSuspendContext);
        } else {
            xSuspendContext.evaluateExpression(logExpression).done((Consumer)new ContextDependentAsyncResultConsumer<String>(this, breakpoint, xSuspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpointLogExpressionAndSuspend.1.class);
                }

                protected void consume(@NotNull String logResult, @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)logResult, (String)"logResult");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    DebugProcessImpl.access$breakpointReached$1(this.this$0, this.$breakpoint, logResult, this.$xSuspendContext);
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$xSuspendContext = $captured_local_variable$2;
                    super($super_call_param$3);
                }
            }).rejected((Consumer)new ContextDependentAsyncResultConsumer<Throwable>(this, breakpoint, logExpression, xSuspendContext, suspendContext){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ String $logExpression;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;

                static {
                    $kotlinClass = Reflection.createKotlinClass(processBreakpointLogExpressionAndSuspend.2.class);
                }

                protected void consume(@NotNull Throwable logResult, @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)logResult, (String)"logResult");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    DebugProcessImpl.access$breakpointReached$1(this.this$0, this.$breakpoint, "Failed to evaluate expression: " + this.$logExpression, this.$xSuspendContext);
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$logExpression = $captured_local_variable$2;
                    this.$xSuspendContext = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            });
        }
    }

    private final void breakpointReached(XBreakpoint<?> breakpoint, String evaluatedLogExpression, XSuspendContext suspendContext) {
        if (this.getSession().breakpointReached(breakpoint, evaluatedLogExpression, suspendContext)) {
            this.setOverlay();
        } else {
            this.resume();
        }
    }

    public final void startPausing() {
        ((VmConnection)this.connection).getVm().getSuspendContextManager().suspend().rejected((Consumer)new RejectErrorReporter(this.getSession(), "Cannot pause"));
    }

    @NotNull
    public final String getCurrentStateMessage() {
        return ((VmConnection)this.connection).getState().getMessage();
    }

    @Nullable
    public final HyperlinkListener getCurrentStateHyperlinkListener() {
        return ((VmConnection)this.connection).getState().getMessageLinkListener();
    }

    @NotNull
    protected ProcessHandler doGetProcessHandler() {
        ExecutionResult executionResult = this.executionResult;
        if (executionResult == null || (executionResult = executionResult.getProcessHandler()) == null) {
            executionResult = (ProcessHandler)new DefaultDebugProcessHandler(){
                public static final /* synthetic */ KClass $kotlinClass;

                static {
                    $kotlinClass = Reflection.createKotlinClass(doGetProcessHandler.1.class);
                }

                public boolean isSilentlyDestroyOnClose() {
                    return true;
                }
            };
        }
        return executionResult;
    }

    public final void saveResolvedFile(@NotNull Url url, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.urlToFileCache.putIfAbsent(url, file);
    }

    @NotNull
    public abstract List<Location> getLocationsForBreakpoint(@NotNull XLineBreakpoint<?> var1, boolean var2);

    @NotNull
    public final C getConnection() {
        return this.connection;
    }

    @Nullable
    protected final ExecutionResult getExecutionResult() {
        return this.executionResult;
    }

    public DebugProcessImpl(@NotNull XDebugSession session, @NotNull C connection, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSmartStepIntoHandler<?> smartStepIntoHandler, @Nullable ExecutionResult executionResult) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)editorsProvider, (String)"editorsProvider");
        super(session);
        this.connection = connection;
        this.editorsProvider = editorsProvider;
        this.smartStepIntoHandler = smartStepIntoHandler;
        this.executionResult = executionResult;
        this.repeatStepInto = new AtomicBoolean();
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap<Url, VirtualFile>()");
        this.urlToFileCache = concurrentMap;
        this._breakpointHandlers$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<XBreakpointHandler<?>[]>(this){
            final /* synthetic */ DebugProcessImpl this$0;

            @NotNull
            public final XBreakpointHandler<?>[] invoke() {
                return this.this$0.createBreakpointHandlers();
            }
            {
                this.this$0 = debugProcessImpl;
                super(0);
            }
        }));
        ((VmConnection)this.connection).addListener(new SocketConnectionListener(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(1.class);
            }

            @Override
            public void statusChanged(@NotNull ConnectionStatus status) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                switch (DebugProcessImpl$WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                    case 1: 
                    case 2: {
                        if (Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ConnectionStatus.DETACHED)) && this.getRealProcessHandler() != null) {
                            this.getProcessHandler().detachProcess();
                        }
                        this.getSession().stop();
                        break;
                    }
                    case 3: {
                        this.getSession().reportError(status.getStatusText());
                        this.getSession().stop();
                        break;
                    }
                    default: {
                        this.getSession().rebuildViews();
                    }
                }
            }
        });
    }

    public static final /* synthetic */ void access$processBreakpointLogExpressionAndSuspend$0(DebugProcessImpl<C> $this, @NotNull XBreakpoint<?> breakpoint, @NotNull SuspendContextImpl xSuspendContext, @NotNull SuspendContext suspendContext) {
        super.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
    }

    public static final /* synthetic */ void access$breakpointReached$1(DebugProcessImpl<C> $this, @NotNull XBreakpoint<?> breakpoint, @Nullable String evaluatedLogExpression, @NotNull XSuspendContext suspendContext) {
        super.breakpointReached(breakpoint, evaluatedLogExpression, suspendContext);
    }
}

